/*****************************************************************************************
 * X2Engine Open Source Edition is a customer relationship management program developed by
 * X2Engine, Inc. Copyright (C) 2011-2014 X2Engine Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY X2ENGINE, X2ENGINE DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact X2Engine, Inc. P.O. Box 66752, Scotts Valley,
 * California 95067, USA. or at email address contact@x2engine.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * X2Engine" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by X2Engine".
 *****************************************************************************************/

DROP TABLE IF EXISTS x2_timezones,x2_timezone_points;
/*&*/
CREATE TABLE x2_timezones (
	id						INT(11)			NOT NULL,
	name					VARCHAR(40)		NOT NULL,
	PRIMARY KEY (`id`)
) COLLATE = utf8_general_ci;
/*&*/
CREATE TABLE x2_timezone_points (
	lat						FLOAT			NOT NULL,
	lon						FLOAT			NOT NULL,
	tz_id					INT				NOT NULL,
	INDEX (lat),
	INDEX (lon)
) COLLATE = utf8_general_ci;
/*&*/
INSERT INTO `x2_timezones` VALUES (1,"Africa/Abidjan"),(2,"Africa/Accra"),(3,"Africa/Addis_Ababa"),(4,"Africa/Algiers"),(5,"Africa/Asmara"),(6,"Africa/Bamako"),(7,"Africa/Bangui"),(8,"Africa/Banjul"),(9,"Africa/Bissau"),(10,"Africa/Blantyre"),(11,"Africa/Brazzaville"),(12,"Africa/Bujumbura"),(13,"Africa/Cairo"),(14,"Africa/Casablanca"),(15,"Africa/Ceuta"),(16,"Africa/Conakry"),(17,"Africa/Dakar"),(18,"Africa/Dar_es_Salaam"),(19,"Africa/Djibouti"),(20,"Africa/Douala"),(21,"Africa/El_Aaiun"),(22,"Africa/Freetown"),(23,"Africa/Gaborone"),(24,"Africa/Harare"),(25,"Africa/Johannesburg"),(26,"Africa/Juba"),(27,"Africa/Kampala"),(28,"Africa/Khartoum"),(29,"Africa/Kigali"),(30,"Africa/Kinshasa"),(31,"Africa/Lagos"),(32,"Africa/Libreville"),(33,"Africa/Lome"),(34,"Africa/Luanda"),(35,"Africa/Lubumbashi"),(36,"Africa/Lusaka"),(37,"Africa/Malabo"),(38,"Africa/Maputo"),(39,"Africa/Maseru"),(40,"Africa/Mbabane"),(41,"Africa/Mogadishu"),(42,"Africa/Monrovia"),(43,"Africa/Nairobi"),(44,"Africa/Ndjamena"),(45,"Africa/Niamey"),(46,"Africa/Nouakchott"),(47,"Africa/Ouagadougou"),(48,"Africa/Porto-Novo"),(49,"Africa/Sao_Tome"),(50,"Africa/Tripoli"),(51,"Africa/Tunis"),(52,"Africa/Windhoek"),(53,"America/Anchorage"),(54,"America/Anguilla"),(55,"America/Antigua"),(56,"America/Araguaina"),(57,"America/Argentina/Buenos_Aires"),(58,"America/Argentina/Catamarca"),(59,"America/Argentina/Cordoba"),(60,"America/Argentina/Jujuy"),(61,"America/Argentina/La_Rioja"),(62,"America/Argentina/Mendoza"),(63,"America/Argentina/Rio_Gallegos"),(64,"America/Argentina/Salta"),(65,"America/Argentina/San_Juan"),(66,"America/Argentina/San_Luis"),(67,"America/Argentina/Tucuman"),(68,"America/Argentina/Ushuaia"),(69,"America/Aruba"),(70,"America/Asuncion"),(71,"America/Bahia"),(72,"America/Barbados"),(73,"America/Belem"),(74,"America/Belize"),(75,"America/Boa_Vista"),(76,"America/Bogota"),(77,"America/Boise"),(78,"America/Campo_Grande"),(79,"America/Cancun"),(80,"America/Caracas"),(81,"America/Cayenne"),(82,"America/Cayman"),(83,"America/Chicago"),(84,"America/Chihuahua"),(85,"America/Costa_Rica"),(86,"America/Cuiaba"),(87,"America/Curacao"),(88,"America/Dawson_Creek"),(89,"America/Denver"),(90,"America/Detroit"),(91,"America/Dominica"),(92,"America/Edmonton"),(93,"America/Eirunepe"),(94,"America/El_Salvador"),(95,"America/Fortaleza"),(96,"America/Glace_Bay"),(97,"America/Godthab"),(98,"America/Grand_Turk"),(99,"America/Grenada"),(100,"America/Guadeloupe"),(101,"America/Guatemala"),(102,"America/Guayaquil"),(103,"America/Guyana"),(104,"America/Halifax"),(105,"America/Havana"),(106,"America/Hermosillo"),(107,"America/Indiana/Indianapolis"),(108,"America/Indiana/Vincennes"),(109,"America/Jamaica"),(110,"America/Juneau"),(111,"America/Kentucky/Louisville"),(112,"America/La_Paz"),(113,"America/Lima"),(114,"America/Los_Angeles"),(115,"America/Lower_Princes"),(116,"America/Maceio"),(117,"America/Managua"),(118,"America/Manaus"),(119,"America/Marigot"),(120,"America/Martinique"),(121,"America/Matamoros"),(122,"America/Mazatlan"),(123,"America/Merida"),(124,"America/Mexico_City"),(125,"America/Miquelon"),(126,"America/Moncton"),(127,"America/Monterrey"),(128,"America/Montevideo"),(129,"America/Montreal"),(130,"America/Montserrat"),(131,"America/Nassau"),(132,"America/New_York"),(133,"America/North_Dakota/New_Salem"),(134,"America/Ojinaga"),(135,"America/Panama"),(136,"America/Paramaribo"),(137,"America/Phoenix"),(138,"America/Port-au-Prince"),(139,"America/Porto_Velho"),(140,"America/Port_of_Spain"),(141,"America/Puerto_Rico"),(142,"America/Recife"),(143,"America/Regina"),(144,"America/Rio_Branco"),(145,"America/Santarem"),(146,"America/Santa_Isabel"),(147,"America/Santiago"),(148,"America/Santo_Domingo"),(149,"America/Sao_Paulo"),(150,"America/St_Barthelemy"),(151,"America/St_Johns"),(152,"America/St_Kitts"),(153,"America/St_Lucia"),(154,"America/St_Thomas"),(155,"America/St_Vincent"),(156,"America/Tegucigalpa"),(157,"America/Thunder_Bay"),(158,"America/Tijuana"),(159,"America/Toronto"),(160,"America/Tortola"),(161,"America/Vancouver"),(162,"America/Whitehorse"),(163,"America/Winnipeg"),(164,"America/Yellowknife"),(165,"Arctic/Longyearbyen"),(166,"Asia/Aden"),(167,"Asia/Almaty"),(168,"Asia/Amman"),(169,"Asia/Aqtau"),(170,"Asia/Aqtobe"),(171,"Asia/Ashgabat"),(172,"Asia/Baghdad"),(173,"Asia/Bahrain"),(174,"Asia/Baku"),(175,"Asia/Bangkok"),(176,"Asia/Beirut"),(177,"Asia/Bishkek"),(178,"Asia/Brunei"),(179,"Asia/Choibalsan"),(180,"Asia/Chongqing"),(181,"Asia/Colombo"),(182,"Asia/Damascus"),(183,"Asia/Dhaka"),(184,"Asia/Dili"),(185,"Asia/Dubai"),(186,"Asia/Dushanbe"),(187,"Asia/Gaza"),(188,"Asia/Harbin"),(189,"Asia/Hebron"),(190,"Asia/Hong_Kong"),(191,"Asia/Hovd"),(192,"Asia/Ho_Chi_Minh"),(193,"Asia/Irkutsk"),(194,"Asia/Jakarta"),(195,"Asia/Jayapura"),(196,"Asia/Jerusalem"),(197,"Asia/Kabul"),(198,"Asia/Kamchatka"),(199,"Asia/Karachi"),(200,"Asia/Kashgar"),(201,"Asia/Kathmandu"),(202,"Asia/Kolkata"),(203,"Asia/Krasnoyarsk"),(204,"Asia/Kuala_Lumpur"),(205,"Asia/Kuching"),(206,"Asia/Kuwait"),(207,"Asia/Macau"),(208,"Asia/Magadan"),(209,"Asia/Makassar"),(210,"Asia/Manila"),(211,"Asia/Muscat"),(212,"Asia/Nicosia"),(213,"Asia/Novokuznetsk"),(214,"Asia/Novosibirsk"),(215,"Asia/Omsk"),(216,"Asia/Oral"),(217,"Asia/Phnom_Penh"),(218,"Asia/Pontianak"),(219,"Asia/Pyongyang"),(220,"Asia/Qatar"),(221,"Asia/Qyzylorda"),(222,"Asia/Rangoon"),(223,"Asia/Riyadh"),(224,"Asia/Sakhalin"),(225,"Asia/Samarkand"),(226,"Asia/Seoul"),(227,"Asia/Shanghai"),(228,"Asia/Singapore"),(229,"Asia/Taipei"),(230,"Asia/Tashkent"),(231,"Asia/Tbilisi"),(232,"Asia/Tehran"),(233,"Asia/Thimphu"),(234,"Asia/Tokyo"),(235,"Asia/Ulaanbaatar"),(236,"Asia/Urumqi"),(237,"Asia/Vientiane"),(238,"Asia/Vladivostok"),(239,"Asia/Yakutsk"),(240,"Asia/Yekaterinburg"),(241,"Asia/Yerevan"),(242,"Atlantic/Azores"),(243,"Atlantic/Bermuda"),(244,"Atlantic/Canary"),(245,"Atlantic/Cape_Verde"),(246,"Atlantic/Faroe"),(247,"Atlantic/Madeira"),(248,"Atlantic/Reykjavik"),(249,"Atlantic/South_Georgia"),(250,"Atlantic/Stanley"),(251,"Atlantic/St_Helena"),(252,"Australia/Adelaide"),(253,"Australia/Brisbane"),(254,"Australia/Broken_Hill"),(255,"Australia/Darwin"),(256,"Australia/Hobart"),(257,"Australia/Melbourne"),(258,"Australia/Perth"),(259,"Australia/Sydney"),(260,"Europe/Amsterdam"),(261,"Europe/Andorra"),(262,"Europe/Athens"),(263,"Europe/Belgrade"),(264,"Europe/Berlin"),(265,"Europe/Bratislava"),(266,"Europe/Brussels"),(267,"Europe/Bucharest"),(268,"Europe/Budapest"),(269,"Europe/Chisinau"),(270,"Europe/Copenhagen"),(271,"Europe/Dublin"),(272,"Europe/Gibraltar"),(273,"Europe/Guernsey"),(274,"Europe/Helsinki"),(275,"Europe/Isle_of_Man"),(276,"Europe/Istanbul"),(277,"Europe/Jersey"),(278,"Europe/Kaliningrad"),(279,"Europe/Kiev"),(280,"Europe/Lisbon"),(281,"Europe/Ljubljana"),(282,"Europe/London"),(283,"Europe/Luxembourg"),(284,"Europe/Madrid"),(285,"Europe/Malta"),(286,"Europe/Mariehamn"),(287,"Europe/Minsk"),(288,"Europe/Monaco"),(289,"Europe/Moscow"),(290,"Europe/Oslo"),(291,"Europe/Paris"),(292,"Europe/Podgorica"),(293,"Europe/Prague"),(294,"Europe/Riga"),(295,"Europe/Rome"),(296,"Europe/Samara"),(297,"Europe/San_Marino"),(298,"Europe/Sarajevo"),(299,"Europe/Simferopol"),(300,"Europe/Skopje"),(301,"Europe/Sofia"),(302,"Europe/Stockholm"),(303,"Europe/Tallinn"),(304,"Europe/Tirane"),(305,"Europe/Uzhgorod"),(306,"Europe/Vaduz"),(307,"Europe/Vatican"),(308,"Europe/Vienna"),(309,"Europe/Vilnius"),(310,"Europe/Volgograd"),(311,"Europe/Warsaw"),(312,"Europe/Zagreb"),(313,"Europe/Zaporozhye"),(314,"Europe/Zurich"),(315,"Indian/Antananarivo"),(316,"Indian/Christmas"),(317,"Indian/Cocos"),(318,"Indian/Comoro"),(319,"Indian/Kerguelen"),(320,"Indian/Mahe"),(321,"Indian/Maldives"),(322,"Indian/Mauritius"),(323,"Indian/Mayotte"),(324,"Indian/Reunion"),(325,"Pacific/Apia"),(326,"Pacific/Auckland"),(327,"Pacific/Efate"),(328,"Pacific/Fiji"),(329,"Pacific/Funafuti"),(330,"Pacific/Guadalcanal"),(331,"Pacific/Guam"),(332,"Pacific/Honolulu"),(333,"Pacific/Majuro"),(334,"Pacific/Niue"),(335,"Pacific/Norfolk"),(336,"Pacific/Noumea"),(337,"Pacific/Pago_Pago"),(338,"Pacific/Palau"),(339,"Pacific/Pitcairn"),(340,"Pacific/Pohnpei"),(341,"Pacific/Port_Moresby"),(342,"Pacific/Rarotonga"),(343,"Pacific/Saipan"),(344,"Pacific/Tahiti"),(345,"Pacific/Tarawa"),(346,"Pacific/Tongatapu"),(347,"Pacific/Wallis");
/*&*/
INSERT INTO `x2_timezone_points` VALUES (0.741892,0.0267758,261),(0.741901,0.026548,261),(0.446189,0.969621,185),(0.450112,0.976393,185),(0.442115,0.983353,185),(0.440838,0.965249,185),(0.447145,0.982148,185),(0.442569,0.96697,185),(0.420804,0.920322,185),(0.438364,0.983343,185),(0.422224,0.973205,185),(0.443508,0.967524,185),(0.441361,0.975317,185),(0.427024,0.948877,185),(0.641165,1.21361,197),(0.581246,1.08468,197),(0.63997,1.1476,197),(0.595286,1.12234,197),(0.632079,1.15074,197),(0.625696,1.15954,197),(0.632938,1.18709,197),(0.647972,1.21877,197),(0.653077,1.15268,197),(0.649615,1.20044,197),(0.627351,1.19931,197),(0.603666,1.20346,197),(0.629451,1.20661,197),(0.626947,1.13069,197),(0.60513,1.22539,197),(0.640694,1.17131,197),(0.551416,1.1235,197),(0.581119,1.08127,197),(0.641041,1.20178,197),(0.581884,1.22034,197),(0.64049,1.18156,197),(0.550288,1.0959,197),(0.64023,1.20629,197),(0.601808,1.09234,197),(0.551757,1.14686,197),(0.60263,1.20728,197),(0.600855,1.22961,197),(0.61293,1.20843,197),(0.599489,1.08559,197),(0.623617,1.11322,197),(0.58562,1.19427,197),(0.555379,1.12696,197),(0.586386,1.20822,197),(0.647808,1.23185,197),(0.565042,1.08414,197),(0.605048,1.06581,197),(0.611103,1.20727,197),(0.592845,1.20338,197),(0.641519,1.16758,197),(0.630599,1.19919,197),(0.647268,1.21265,197),(0.611447,1.24543,197),(0.608651,1.24175,197),(0.64495,1.13662,197),(0.595608,1.23408,197),(0.598045,1.17539,197),(0.298742,-1.07949,55),(0.317947,-1.10057,54),(0.69596,0.349158,304),(0.734381,0.35643,304),(0.708928,0.362694,304),(0.699455,0.35149,304),(0.717548,0.350501,304),(0.726236,0.349221,304),(0.706277,0.34016,304),(0.721301,0.345905,304),(0.73423,0.340559,304),(0.70935,0.342972,304),(0.714572,0.343917,304),(0.729262,0.342846,304),(0.726678,0.344058,304),(0.712099,0.347611,304),(0.724472,0.345449,304),(0.718824,0.341333,304),(0.71064,0.341503,304),(0.710766,0.341319,304),(0.721223,0.339316,304),(0.710451,0.348232,304),(0.684301,0.809933,241),(0.68963,0.808753,241),(0.688778,0.802336,241),(0.697459,0.777448,241),(0.695194,0.780248,241),(0.701293,0.776909,241),(0.701021,0.773087,241),(0.712656,0.77261,241),(0.707703,0.784502,241),(0.699312,0.775553,241),(0.712174,0.776565,241),(0.70431,0.78756,241),(0.706814,0.781318,241),(0.700828,0.768611,241),(0.711993,0.765244,241),(0.703352,0.774264,241),(0.702799,0.77888,241),(-0.168612,0.3559,34),(-0.146942,0.362063,34),(-0.186877,0.387893,34),(-0.132798,0.262869,34),(-0.107074,0.215879,34),(-0.126208,0.224565,34),(-0.10938,0.248537,34),(-0.166507,0.285204,34),(-0.154232,0.230982,34),(-0.149723,0.238486,34),(-0.0968658,0.21293,34),(-0.195582,0.241618,34),(-0.265222,0.212096,34),(-0.255839,0.308766,34),(-0.205658,0.347611,34),(-0.260354,0.235489,34),(-0.225264,0.266221,34),(-0.215514,0.236415,34),(-0.21613,0.295542,34),(-0.222985,0.2747,34),(-0.216969,0.236444,34),(-0.212058,0.301651,34),(-0.20973,0.305142,34),(-0.240564,0.256272,34),(-0.224318,0.271583,34),(-0.219497,0.23397,34),(-0.595125,-1.03024,57),(-0.497201,-1.03594,59),(-0.556154,-1.03021,59),(-0.650378,-0.994367,57),(-0.600848,-1.02241,57),(-0.651386,-1.03207,57),(-0.464549,-0.944805,59),(-0.498281,-0.978096,59),(-0.540139,-1.04348,59),(-0.464643,-0.94437,59),(-0.480103,-1.02197,59),(-0.491015,-1.02568,59),(-0.533683,-1.04601,59),(-0.493123,-1.02322,59),(-0.603593,-1.01898,57),(-0.479277,-1.02946,59),(-0.508763,-1.04109,59),(-0.606051,-1.0167,57),(-0.467678,-0.96035,59),(-0.446789,-0.952488,59),(-0.45405,-0.954225,59),(-0.460914,-0.954601,59),(-0.477646,-0.975571,59),(-0.606497,-1.02428,57),(-0.449115,-1.03164,59),(-0.518592,-0.996407,59),(-0.47974,-0.962024,59),(-0.672777,-1.02515,57),(-0.604817,-1.02311,57),(-0.528025,-1.00594,59),(-0.463668,-0.95569,59),(-0.604782,-1.03726,57),(-0.50932,-1.01367,59),(-0.663265,-1.00457,57),(-0.603365,-1.03158,57),(-0.609494,-1.0115,57),(-0.536599,-1.04101,59),(-0.471997,-0.963893,59),(-0.576122,-1.02132,59),(-0.578429,-1.03515,59),(-0.508589,-1.03433,59),(-0.489565,-0.977966,59),(-0.463166,-1.03571,59),(-0.479646,-0.974404,59),(-0.456884,-1.0154,59),(-0.478537,-1.03016,59),(-0.540261,-1.02596,59),(-0.523851,-1.03895,59),(-0.476448,-0.945947,59),(-0.633785,-1.00669,57),(-0.519963,-1.01324,59),(-0.479627,-1.02685,59),(-0.547911,-1.01266,59),(-0.566926,-1.01643,59),(-0.603424,-1.02013,57),(-0.536697,-1.01194,59),(-0.596357,-1.02903,57),(-0.604113,-1.01887,57),(-0.479669,-1.02862,59),(-0.641879,-1.04473,57),(-0.508198,-1.04123,59),(-0.472919,-0.95812,59),(-0.678918,-1.22268,64),(-0.468039,-1.13999,67),(-0.682424,-1.17053,64),(-0.549662,-1.19622,65),(-0.566061,-1.10388,59),(-0.565618,-1.10375,59),(-0.55756,-1.13777,59),(-0.579934,-1.05295,59),(-0.548455,-1.1257,59),(-0.481254,-1.05968,59),(-0.546193,-1.12217,59),(-0.712329,-1.0995,64),(-0.569299,-1.0499,59),(-0.514162,-1.05091,59),(-0.588971,-1.08156,59),(-0.61841,-1.05021,57),(-0.95644,-1.19206,68),(-0.545079,-1.12253,59),(-0.459731,-1.05474,59),(-0.669752,-1.05208,57),(-0.754837,-1.13979,58),(-0.479963,-1.13203,59),(-0.392985,-1.11354,64),(-0.466562,-1.13899,67),(-0.540075,-1.07445,59),(-0.552619,-1.06055,59),(-0.485116,-1.12157,59),(-0.639081,-1.12196,64),(-0.550475,-1.19546,65),(-0.552106,-1.05941,59),(-0.422275,-1.13965,60),(-0.403734,-1.1227,64),(-0.604193,-1.19258,62),(-0.422915,-1.13213,60),(-0.581819,-1.05113,57),(-0.46817,-1.13835,67),(-0.700931,-1.24527,64),(-0.577373,-1.19499,62),(-0.581108,-1.15778,66),(-0.537372,-1.05753,59),(-0.550433,-1.19619,65),(-0.527798,-1.19986,65),(-0.556693,-1.07966,59),(-0.548522,-1.08355,59),(-0.496888,-1.14817,58),(-0.710906,-1.13355,64),(-0.432596,-1.14165,64),(-0.598094,-1.09454,59),(-0.575031,-1.05836,59),(-0.561525,-1.119,59),(-0.552442,-1.11544,59),(-0.900985,-1.20808,63),(-0.578239,-1.12312,59),(-0.543929,-1.12264,59),(-0.75573,-1.13625,58),(-0.545421,-1.07315,59),(-0.468955,-1.05098,59),(-0.678512,-1.08339,57),(-0.746463,-1.13514,58),(-0.46749,-1.05486,59),(-0.552978,-1.197,65),(-0.680097,-1.1909,64),(-0.591491,-1.05721,57),(-0.57593,-1.0606,59),(-0.553827,-1.05634,59),(-0.423355,-1.13816,60),(-0.643899,-1.05283,57),(-0.618621,-1.06261,57),(-0.679834,-1.18786,64),(-0.536019,-1.08208,59),(-0.474161,-1.14316,67),(-0.574053,-1.20126,62),(-0.570684,-1.08397,59),(-0.46995,-1.04806,59),(-0.608535,-1.0739,57),(-0.415501,-1.13076,60),(-0.472804,-1.06608,59),(-0.51332,-1.16676,61),(-0.542595,-1.12556,59),(-0.547052,-1.12286,59),(-0.595622,-1.10638,59),(-0.603602,-1.06366,57),(-0.437787,-1.12021,64),(-0.54073,-1.11866,59),(-0.57346,-1.05972,59),(-0.576485,-1.05838,59),(-0.68126,-1.17955,64),(-0.476766,-1.0696,59),(-0.622325,-1.11277,64),(-0.394372,-1.11374,64),(-0.559016,-1.06851,59),(-0.583976,-1.07308,59),(-0.472184,-1.1415,67),(-0.748746,-1.24471,58),(-0.548885,-1.06346,59),(-0.405073,-1.11869,64),(-0.561647,-1.12431,59),(-0.732457,-1.2482,64),(-0.559664,-1.05834,59),(-0.530935,-1.12312,59),(-0.679751,-1.20792,64),(-0.536278,-1.13104,59),(-0.559007,-1.05255,59),(-0.54533,-1.12514,59),(-0.653707,-1.08094,57),(-0.558028,-1.06325,59),(-0.548269,-1.12017,59),(-0.800524,-1.1781,58),(-0.679525,-1.18665,64),(-0.677576,-1.18792,64),(-0.609044,-1.04749,57),(-0.549488,-1.19613,65),(-0.508972,-1.17805,61),(-0.474981,-1.06793,59),(-0.604611,-1.05547,57),(-0.677703,-1.18912,64),(-0.552428,-1.19173,65),(-0.661115,-1.18326,64),(-0.452857,-1.05801,59),(-0.57673,-1.06758,59),(-0.573459,-1.06733,59),(-0.572863,-1.05974,59),(-0.572754,-1.07154,59),(-0.810519,-1.17859,63),(-0.56943,-1.09412,59),(-0.471777,-1.13976,67),(-0.675785,-1.08686,57),(-0.578662,-1.05607,59),(-0.548386,-1.10043,59),(-0.496732,-1.09667,59),(-0.552448,-1.12449,59),(-0.680283,-1.18381,64),(-0.468039,-1.13679,67),(-0.548683,-1.196,65),(-0.47881,-1.14518,67),(-0.604073,-1.02069,57),(-0.587752,-1.14245,66),(-0.718126,-1.24456,64),(-0.249199,-2.97932,337),(0.817522,0.25908,308),(0.834267,0.283616,308),(0.841397,0.285747,308),(0.840667,0.244928,308),(0.844739,0.272271,308),(0.813503,0.24183,308),(0.841712,0.24844,308),(0.838017,0.284371,308),(0.832795,0.279877,308),(0.838504,0.251699,308),(0.816814,0.235619,308),(0.840085,0.287398,308),(0.841249,0.272853,308),(0.834257,0.227661,308),(0.827754,0.22424,308),(0.83926,0.2843,308),(0.827747,0.168573,308),(0.843106,0.24934,308),(0.842639,0.248767,308),(0.826995,0.263545,308),(0.830486,0.212348,308),(0.8449,0.272518,308),(0.843085,0.284929,308),(0.813755,0.249674,308),(0.828064,0.266919,308),(0.824889,0.198872,308),(0.832231,0.228638,308),(0.821468,0.269653,308),(0.824372,0.167552,308),(0.827577,0.169874,308),(0.829086,0.170119,308),(0.842231,0.227651,308),(0.837853,0.283313,308),(0.839903,0.259566,308),(0.837147,0.227756,308),(-0.576529,2.40096,252),(-0.362545,2.04459,258),(-0.557672,2.02216,258),(-0.612957,2.43078,252),(-0.361724,2.43469,253),(-0.613192,2.41757,252),(-0.567702,2.01972,258),(-0.562522,2.02076,258),(-0.536621,2.12012,258),(-0.55996,2.02458,258),(-0.502288,2.0004,258),(-0.603928,2.42163,252),(-0.217488,2.28362,255),(-0.581668,2.01832,258),(-0.413599,2.33671,255),(-0.610919,2.05715,258),(-0.60962,2.419,252),(-0.630444,2.56368,257),(-0.669888,2.48688,257),(-0.61306,2.57181,259),(-0.666633,2.55763,257),(-0.336262,2.56224,253),(-0.441277,2.66803,253),(-0.481023,2.6521,253),(-0.556952,2.66082,259),(-0.542631,2.63421,259),(-0.591106,2.63907,259),(-0.48874,2.67786,253),(-0.48142,2.67123,253),(-0.65585,2.52595,257),(-0.570952,2.65406,259),(-0.48811,2.67734,253),(-0.518363,2.66948,259),(-0.634959,2.53769,257),(-0.660914,2.5304,257),(-0.408064,2.62682,253),(-0.660052,2.53076,257),(-0.61706,2.60459,259),(-0.588758,2.63341,259),(-0.548572,2.66876,259),(-0.580915,2.60229,259),(-0.608845,2.62847,259),(-0.661567,2.53322,257),(-0.574687,2.649,259),(-0.488507,2.67622,253),(-0.661771,2.53422,257),(-0.660289,2.45706,252),(-0.590406,2.63952,259),(-0.667007,2.53131,257),(-0.465682,2.67244,253),(-0.59665,2.4812,257),(-0.657699,2.52349,257),(-0.659979,2.53009,257),(-0.44577,2.6652,253),(-0.591958,2.63836,259),(-0.592539,2.63952,259),(-0.369197,2.60343,253),(-0.591667,2.63428,259),(-0.502891,2.67519,259),(-0.723243,2.56798,256),(-0.588521,2.62336,259),(-0.588219,2.63718,259),(-0.748386,2.57138,256),(-0.598448,2.54907,259),(-0.65807,2.53253,257),(-0.590503,2.63574,259),(-0.606529,2.61312,259),(-0.488697,2.67787,253),(-0.416219,2.63992,253),(-0.665552,2.51938,257),(-0.665793,2.51957,257),(-0.665552,2.53305,257),(-0.561671,2.66193,259),(-0.589445,2.63688,259),(-0.594576,2.63574,259),(-0.630772,2.5264,257),(-0.592539,2.63719,259),(-0.562746,2.59364,259),(-0.718673,2.55432,256),(-0.474617,2.67081,253),(-0.594285,2.63807,259),(-0.66497,2.53567,257),(-0.656244,2.52985,257),(-0.528769,2.67233,259),(-0.600812,2.63359,259),(-0.573028,2.64166,259),(-0.588758,2.63545,259),(-0.589619,2.6363,259),(-0.594285,2.63777,259),(-0.615813,2.60278,259),(-0.660468,2.53194,257),(-0.467697,2.67276,253),(-0.295363,2.5441,253),(-0.472716,2.6695,253),(-0.71656,2.5465,256),(-0.433997,2.65897,253),(-0.465731,2.67135,253),(-0.659153,2.53015,257),(-0.557837,2.46894,254),(-0.479406,2.67084,253),(-0.58934,2.63399,259),(-0.641551,2.51817,257),(-0.583231,2.61067,259),(-0.492409,2.67971,259),(-0.655654,2.51065,257),(-0.53247,2.64716,259),(-0.629626,2.56431,259),(-0.479675,2.67064,253),(-0.591958,2.63967,259),(-0.589049,2.64068,259),(-0.217922,2.28609,255),(-0.476773,2.67089,253),(-0.452116,2.67195,253),(-0.548075,2.66864,259),(-0.589865,2.63762,259),(-0.661177,2.5255,257),(-0.482395,2.67226,253),(-0.480066,2.67214,253),(-0.590232,2.63551,259),(-0.661211,2.53588,257),(-0.590212,2.63545,259),(-0.609315,2.4209,252),(-0.559517,2.02315,258),(-0.589759,2.62968,259),(-0.660781,2.53169,257),(-0.659575,2.53237,257),(-0.661282,2.53172,257),(-0.661025,2.53147,257),(-0.661504,2.53106,257),(-0.661831,2.53177,257),(-0.481943,2.66668,253),(-0.658774,2.52725,257),(-0.662823,2.53524,257),(-0.490045,2.67709,253),(0.218585,-1.2222,69),(0.218748,-1.22144,69),(0.218457,-1.22086,69),(1.0489,0.347928,286),(0.69495,0.81599,174),(0.696014,0.844722,174),(0.693924,0.815927,174),(0.691039,0.854872,174),(0.687209,0.859526,174),(0.684324,0.792593,174),(0.67639,0.852604,174),(0.695879,0.838804,174),(0.684337,0.846343,174),(0.688678,0.84727,174),(0.671183,0.853029,174),(0.697048,0.853964,174),(0.697974,0.819037,174),(0.726644,0.81408,174),(0.706441,0.871645,174),(0.708923,0.822925,174),(0.708376,0.808364,174),(0.723674,0.851826,174),(0.70719,0.831723,174),(0.704153,0.819064,174),(0.708424,0.866881,174),(0.705055,0.872204,174),(0.712613,0.803181,174),(0.709152,0.848952,174),(0.718935,0.823282,174),(0.705855,0.871758,174),(0.698297,0.846051,174),(0.723042,0.845244,174),(0.721913,0.84675,174),(0.698844,0.854243,174),(0.717214,0.791788,174),(0.709011,0.864961,174),(0.711465,0.821344,174),(0.70743,0.872733,174),(0.706723,0.875089,174),(0.703782,0.867918,174),(0.70953,0.83323,174),(0.704667,0.874153,174),(0.710048,0.809144,174),(0.707171,0.874653,174),(0.706019,0.874159,174),(0.704667,0.822516,174),(0.705888,0.869273,174),(0.704723,0.87078,174),(0.705574,0.872379,174),(0.708085,0.844755,174),(0.709476,0.828614,174),(0.699053,0.828358,174),(0.705491,0.872044,174),(0.771465,0.312483,298),(0.767751,0.317267,298),(0.788626,0.275863,298),(0.777342,0.325802,298),(0.745465,0.320157,298),(0.771896,0.308327,298),(0.765303,0.32038,298),(0.785048,0.291715,298),(0.756484,0.310809,298),(0.783278,0.321623,298),(0.780216,0.319572,298),(0.76215,0.331187,298),(0.780717,0.315677,298),(0.784821,0.278259,298),(0.768944,0.304574,298),(0.783178,0.328267,298),(0.783347,0.281895,298),(0.781187,0.335354,298),(0.782203,0.276998,298),(0.781486,0.299945,298),(0.761858,0.313475,298),(0.228638,-1.04051,72),(0.454367,1.54403,183),(0.364142,1.61097,183),(0.416959,1.57788,183),(0.43457,1.60347,183),(0.411694,1.57336,183),(0.434878,1.56963,183),(0.430798,1.53868,183),(0.396332,1.5546,183),(0.426733,1.56585,183),(0.434296,1.5833,183),(0.417535,1.58332,183),(0.392945,1.59619,183),(0.421788,1.56381,183),(0.403182,1.58563,183),(0.425279,1.54636,183),(0.394089,1.57036,183),(0.459604,1.54562,183),(0.389129,1.60534,183),(0.447937,1.55203,183),(0.412134,1.57957,183),(0.395089,1.57554,183),(0.419752,1.56876,183),(0.453241,1.56544,183),(0.431969,1.57778,183),(0.43226,1.57487,183),(0.420624,1.57254,183),(0.427412,1.6017,183),(0.391925,1.56828,183),(0.398329,1.58002,183),(0.388967,1.57008,183),(0.452257,1.56115,183),(0.405618,1.59037,183),(0.409487,1.59148,183),(0.449422,1.55771,183),(0.417152,1.55547,183),(0.408575,1.55575,183),(0.403369,1.55492,183),(0.437979,1.55372,183),(0.421206,1.5548,183),(0.425519,1.59546,183),(0.400927,1.57494,183),(0.426419,1.58054,183),(0.401624,1.59525,183),(0.402108,1.5842,183),(0.389384,1.56715,183),(0.413825,1.57791,183),(0.446035,1.56506,183),(0.401858,1.59717,183),(0.389867,1.58366,183),(0.403308,1.60518,183),(0.437006,1.60014,183),(0.401683,1.56101,183),(0.419284,1.55321,183),(0.419794,1.58784,183),(0.387382,1.60953,183),(0.402176,1.56436,183),(0.427931,1.5945,183),(0.422653,1.58738,183),(0.448096,1.5543,183),(0.404133,1.56199,183),(0.399677,1.56911,183),(0.431678,1.56789,183),(0.424115,1.574,183),(0.393312,1.60429,183),(0.396482,1.56228,183),(0.405235,1.57692,183),(0.432892,1.55248,183),(0.416923,1.58769,183),(0.400454,1.58528,183),(0.399867,1.55705,183),(0.405822,1.58572,183),(0.411898,1.56789,183),(0.447278,1.54704,183),(0.387925,1.58324,183),(0.389879,1.60277,183),(0.406822,1.57476,183),(0.420333,1.56411,183),(0.392615,1.58343,183),(0.385306,1.60657,183),(0.374441,1.60514,183),(0.398106,1.56319,183),(0.395973,1.58204,183),(0.396276,1.57726,183),(0.404388,1.55707,183),(0.418879,1.55771,183),(0.423242,1.56934,183),(0.433714,1.55974,183),(0.451349,1.54223,183),(0.429196,1.54062,183),(0.40441,1.57445,183),(0.436661,1.5711,183),(0.426549,1.58446,183),(0.398626,1.60293,183),(0.392507,1.57189,183),(0.395975,1.60188,183),(0.449906,1.55145,183),(0.893954,0.0755141,266),(0.886849,0.0582675,266),(0.887841,0.0665061,266),(0.889955,0.0936926,266),(0.8948,0.0822567,266),(0.889824,0.0778555,266),(0.891264,0.0705165,266),(0.892603,0.0547475,266),(0.888087,0.0780682,266),(0.896962,0.0802059,266),(0.891172,0.0760997,266),(0.886627,0.0552688,266),(0.89021,0.0677783,266),(0.891697,0.0857906,266),(0.88629,0.0530325,266),(0.885182,0.0803092,266),(0.885101,0.0768189,266),(0.88818,0.0598222,266),(0.877098,0.077457,266),(0.885538,0.0994675,266),(0.888864,0.0773073,266),(0.882946,0.102318,266),(0.895747,0.0863015,266),(0.884718,0.0733195,266),(0.883261,0.0591548,266),(0.891263,0.05412,266),(0.886288,0.0953794,266),(0.886757,0.0861809,266),(0.890106,0.0580683,266),(0.891255,0.0888121,266),(0.887041,0.0787873,266),(0.892351,0.0735433,266),(0.893781,0.0704502,266),(0.895911,0.0762931,266),(0.883378,0.1003,266),(0.882771,0.0710574,266),(0.88692,0.090521,266),(0.886265,0.0740639,266),(0.892999,0.0723212,266),(0.893853,0.0567143,266),(0.891286,0.0791453,266),(0.893943,0.0719728,266),(0.885693,0.0760534,266),(0.882851,0.0960132,266),(0.894525,0.0785866,266),(0.894325,0.0799947,266),(0.883632,0.0965591,266),(0.880486,0.0666517,266),(0.889298,0.0823211,266),(0.88568,0.0628406,266),(0.889185,0.0545012,266),(0.885096,0.0789812,266),(0.886801,0.0977613,266),(0.893431,0.07968,266),(0.880356,0.0674622,266),(0.891411,0.0748474,266),(0.891049,0.0808546,266),(0.887567,0.047588,266),(0.881482,0.0762512,266),(0.881534,0.0627224,266),(0.892392,0.0952866,266),(0.88618,0.0791439,266),(0.885089,0.0985553,266),(0.887529,0.0629874,266),(0.892811,0.0563965,266),(0.894017,0.0508214,266),(0.883107,0.0755462,266),(0.887112,0.0702769,266),(0.892927,0.0815083,266),(0.894099,0.094993,266),(0.880814,0.0849532,266),(0.885667,0.0559621,266),(0.893032,0.0776893,266),(0.880606,0.0740925,266),(0.880591,0.0689805,266),(0.893467,0.0893019,266),(0.893352,0.0492317,266),(0.890021,0.0653837,266),(0.886579,0.054497,266),(0.889059,0.0755125,266),(0.890567,0.0781492,266),(0.876623,0.0932732,266),(0.881446,0.0739302,266),(0.893737,0.0601285,266),(0.889515,0.0993881,266),(0.891829,0.100946,266),(0.884328,0.080537,266),(0.8902,0.0751022,266),(0.894145,0.0927379,266),(0.891927,0.0696978,266),(0.891801,0.06688,266),(0.894341,0.0841793,266),(0.892409,0.0797689,266),(0.883725,0.097171,266),(0.888016,0.0820467,266),(0.885075,0.0669472,266),(0.889529,0.0695678,266),(0.890199,0.0721619,266),(0.888254,0.0985553,266),(0.881157,0.0730918,266),(0.887116,0.0569827,266),(0.888195,0.0792996,266),(0.892424,0.0776158,266),(0.89215,0.0460369,266),(0.896227,0.0570141,266),(0.894327,0.086682,266),(0.895594,0.0774122,266),(0.896827,0.0781133,266),(0.888616,0.056091,266),(0.88752,0.0503648,266),(0.881722,0.0913303,266),(0.890716,0.0937991,266),(0.897104,0.0830836,266),(0.893192,0.0758946,266),(0.890757,0.0921557,266),(0.888142,0.0678957,266),(0.883849,0.101116,266),(0.884256,0.0981479,266),(0.893199,0.0843427,266),(0.888523,0.0815167,266),(0.891094,0.0939413,266),(0.891433,0.0825239,266),(0.888915,0.0931624,266),(0.88756,0.0577591,266),(0.891832,0.0722051,266),(0.885473,0.0739067,266),(0.888483,0.0698294,266),(0.888968,0.0763081,266),(0.886164,0.0677577,266),(0.890991,0.0648681,266),(0.889507,0.0960074,266),(0.882464,0.0820111,266),(0.893008,0.0870774,266),(0.879747,0.0679986,266),(0.881103,0.0794135,266),(0.883401,0.0991455,266),(0.883136,0.0950281,266),(0.891956,0.064647,266),(0.883624,0.105356,266),(0.898194,0.0777357,266),(0.893382,0.0620733,266),(0.892851,0.0775806,266),(0.891785,0.0786974,266),(0.879573,0.0659371,266),(0.887465,0.0743461,266),(0.890685,0.0499834,266),(0.88993,0.0881499,266),(0.888507,0.094575,266),(0.891157,0.0663049,266),(0.890619,0.071577,266),(0.888112,0.0711398,266),(0.889799,0.0616269,266),(0.880759,0.0763529,266),(0.879892,0.0672945,266),(0.882836,0.0983336,266),(0.879705,0.079033,266),(0.880142,0.0689407,266),(0.879844,0.0775708,266),(0.887508,0.0759005,266),(0.893764,0.0562736,266),(0.896231,0.0809534,266),(0.8952,0.0783971,266),(0.883307,0.0723715,266),(0.884596,0.0762332,266),(0.880242,0.0662248,266),(0.891814,0.0740655,266),(0.891731,0.0763006,266),(0.895582,0.0546684,266),(0.879848,0.0726876,266),(0.887906,0.0963143,266),(0.893816,0.074287,266),(0.890983,0.091212,266),(0.886032,0.0750526,266),(0.89569,0.0847015,266),(0.893057,0.0902382,266),(0.883649,0.0659387,266),(0.888549,0.0732752,266),(0.867138,0.10152,266),(0.893956,0.0768549,266),(0.884224,0.0963472,266),(0.881206,0.0889268,266),(0.889894,0.0844207,266),(0.891692,0.0601603,266),(0.889002,0.0704328,266),(0.213783,-0.0107483,47),(0.226311,-0.0395609,47),(0.228158,-0.0535711,47),(0.240274,-0.0360702,47),(0.2056,-0.00645283,47),(0.214966,-0.0430515,47),(0.194948,-0.019984,47),(0.237064,-0.0422645,47),(0.215821,-0.0267713,47),(0.222239,-0.0674861,47),(0.203568,-0.0187284,47),(0.193732,-0.0366519,47),(0.212571,-0.0061378,47),(0.213803,-0.0413062,47),(0.23258,-0.0267859,47),(0.210584,-0.0233438,47),(0.212751,-0.0329092,47),(0.228493,-0.018927,47),(0.200713,-0.0613775,47),(0.230519,-0.0411711,47),(0.205949,-0.00960908,47),(0.210525,0.00624444,47),(0.244964,-0.000602139,47),(0.246112,-0.0284127,47),(0.210714,0.0312131,47),(0.217584,-0.0605048,47),(0.220968,-0.0330255,47),(0.22109,-0.0100501,47),(0.195078,-0.0750125,47),(0.185587,-0.0831941,47),(0.179754,-0.0567377,47),(0.191099,-0.0861175,47),(0.741474,0.462512,301),(0.754157,0.411243,301),(0.76777,0.3992,301),(0.733514,0.418804,301),(0.751909,0.447311,301),(0.754273,0.487238,301),(0.755015,0.464069,301),(0.748646,0.431374,301),(0.760382,0.485783,301),(0.761366,0.442509,301),(0.728966,0.457276,301),(0.740592,0.447536,301),(0.737693,0.403462,301),(0.745212,0.407083,301),(0.7258,0.430956,301),(0.745008,0.459531,301),(0.769981,0.475893,301),(0.755215,0.469893,301),(0.750942,0.438315,301),(0.725475,0.406371,301),(0.738856,0.411025,301),(0.765438,0.453276,301),(0.7598,0.462803,301),(0.738274,0.435751,301),(0.7566,0.457858,301),(0.735656,0.431969,301),(0.757764,0.429642,301),(0.722566,0.405207,301),(0.73362,0.424115,301),(0.74351,0.402007,301),(0.736529,0.424697,301),(0.741765,0.422079,301),(0.741474,0.454077,301),(0.757691,0.405353,301),(0.752819,0.431387,301),(0.764697,0.405547,301),(0.737993,0.396035,301),(0.72693,0.442732,301),(0.731996,0.446271,301),(0.731875,0.45204,301),(0.743801,0.443314,301),(0.744383,0.470948,301),(0.744092,0.432842,301),(0.725475,0.414225,301),(0.752722,0.448579,301),(0.748305,0.442165,301),(0.733911,0.446804,301),(0.736529,0.44215,301),(0.755146,0.420624,301),(0.741871,0.479404,301),(0.748746,0.415097,301),(0.733329,0.403171,301),(0.754612,0.403622,301),(0.745256,0.475602,301),(0.733329,0.434005,301),(0.456486,0.883495,173),(0.456816,0.882225,173),(0.457601,0.882225,173),(0.455798,0.881512,173),(0.454983,0.881459,173),(0.458275,0.883345,173),(0.457544,0.882843,173),(0.456055,0.882351,173),(-0.0721659,0.520178,12),(-0.068919,0.517043,12),(-0.0590305,0.512505,12),(-0.0570409,0.516755,12),(-0.059802,0.522391,12),(-0.0606745,0.527938,12),(-0.0507454,0.520642,12),(-0.0510003,0.517129,12),(-0.0496564,0.529557,12),(-0.0685548,0.523459,12),(0.155099,0.0453353,48),(0.185375,0.0221048,48),(0.140369,0.0433887,48),(0.138371,0.0344804,48),(0.117569,0.0464024,48),(0.113385,0.0454412,48),(0.121825,0.0465113,48),(0.162964,0.0459076,48),(0.111057,0.0363912,48),(0.173487,0.0560382,48),(0.179842,0.0240789,48),(0.207139,0.0590492,48),(0.115867,0.0299628,48),(0.128514,0.0453747,48),(0.194328,0.0512884,48),(0.118973,0.031125,48),(0.169446,0.0290768,48),(0.135263,0.0381063,48),(0.12603,0.0408437,48),(0.111096,0.0422078,48),(0.111834,0.0328467,48),(0.125284,0.0360707,48),(0.178517,0.0464842,48),(0.157222,0.0290667,48),(0.197195,0.0425609,48),(0.121009,0.0293797,48),(0.116334,0.0375487,48),(0.112548,0.041114,48),(0.125365,0.0347528,48),(0.312347,-1.09694,150),(0.563593,-1.13059,243),(0.0837758,2.00102,178),(0.0805761,1.9952,178),(0.0799942,1.99288,178),(0.0862243,2.00622,178),(-0.384635,-1.11142,112),(-0.305433,-1.10247,112),(-0.385484,-1.14484,112),(-0.303687,-1.1141,112),(-0.370882,-1.10828,112),(-0.374373,-1.14697,112),(-0.25889,-1.13272,112),(-0.375865,-1.12974,112),(-0.332194,-1.13905,112),(-0.313868,-1.10625,112),(-0.310669,-1.10247,112),(-0.285652,-1.06378,112),(-0.2586,-1.16675,112),(-0.191695,-1.15366,112),(-0.306305,-1.14901,112),(-0.341798,-1.14761,112),(-0.313868,-1.17199,112),(-0.302524,-1.10392,112),(-0.31313,-1.1404,112),(-0.321432,-1.16297,112),(-0.287979,-1.18944,112),(-0.318814,-1.16675,112),(-0.189137,-1.14077,112),(-0.31096,-1.10043,112),(-0.303504,-1.15465,112),(-0.192452,-1.20025,112),(-0.349939,-1.10857,112),(-0.0604271,-0.783139,95),(-0.141687,-0.615951,142),(-0.0208858,-0.805295,73),(-0.126706,-0.609251,95),(-0.0149807,-0.840231,73),(-0.0621725,-0.717195,95),(-0.163562,-0.632522,116),(-0.0562045,-0.785461,95),(-0.0933751,-0.704822,95),(-0.0732068,-0.706451,95),(-0.0618381,-0.766476,95),(-0.111832,-0.728597,95),(-0.159921,-0.628876,116),(-0.0800378,-0.748121,95),(-0.0917705,-0.77927,95),(-0.065731,-0.866949,73),(-0.00319971,-0.873537,73),(-0.135471,-0.702805,142),(-0.0572081,-0.685371,95),(-0.139743,-0.629308,142),(-0.0422176,-0.840415,73),(-0.08891,-0.747641,95),(-0.0742686,-0.766907,95),(-0.130992,-0.616421,142),(-0.0651395,-0.71544,95),(-0.0888228,-0.747035,95),(-0.10472,-0.703077,95),(-0.152827,-0.61261,142),(-0.132485,-0.655187,142),(-0.136713,-0.624038,142),(-0.11797,-0.667206,95),(-0.0125083,-0.846892,73),(-0.117897,-0.62029,95),(-0.0643348,-0.704235,95),(-0.149938,-0.612892,142),(-0.140911,-0.650387,142),(-0.139486,-0.668432,142),(-0.09753,-0.687165,95),(-0.166912,-0.625254,116),(-0.157346,-0.745246,95),(-0.170713,-0.629952,116),(-0.0283907,-0.82874,73),(-0.0705405,-0.776235,95),(-0.162636,-0.620658,116),(-0.0441519,-0.773229,95),(-0.139665,-0.611185,142),(-0.130531,-0.650562,142),(-0.0447143,-0.76889,95),(-0.106024,-0.615015,95),(-0.113359,-0.762748,95),(-0.0629579,-0.680126,95),(-0.115972,-0.907484,73),(-0.0973166,-0.774669,95),(-0.109665,-0.658862,95),(-0.0470511,-0.782281,95),(-0.124161,-0.610482,95),(-0.0426394,-0.95484,145),(-0.0613581,-0.742579,95),(-0.0756066,-0.700866,95),(-0.163683,-0.650053,116),(-0.133227,-0.823795,95),(-0.0639955,-0.79203,95),(-0.0389402,-0.790634,95),(-0.138885,-0.631892,142),(-0.108724,-0.628716,95),(-0.0107095,-0.82652,73),(-0.140921,-0.682758,142),(-0.0862242,-0.662803,95),(-0.165428,-0.625759,116),(-0.151285,-0.613495,142),(-0.148605,-0.617459,142),(-0.140567,-0.60879,142),(-0.0907426,-0.685788,95),(-0.0867671,-0.680945,95),(-0.0923279,-0.776497,95),(-0.00101805,-0.893289,73),(-0.157865,-0.617817,116),(-0.0337819,-0.886996,73),(-0.142094,-0.617774,142),(-0.118164,-0.659764,95),(-0.0745837,-0.729145,95),(-0.0685576,-0.727962,95),(-0.0440066,-0.786838,95),(-0.0629772,-0.79139,95),(-0.167503,-0.627562,116),(-0.123516,-0.723735,95),(-0.164037,-0.706873,142),(-0.160275,-0.667918,142),(-0.145871,-0.640473,142),(-0.0661965,-0.685396,95),(-0.0574941,-0.788428,95),(-0.0772259,-0.723589,95),(-0.0951932,-0.693196,95),(-0.164168,-0.666973,71),(-0.138594,-0.60865,142),(-0.1226,-0.650659,95),(-0.103246,-0.615452,95),(-0.0506969,-0.72914,95),(-0.045873,-0.990227,118),(-0.116724,-0.639794,95),(-0.0600296,-0.683267,95),(-0.0517782,-0.82874,73),(-0.0595157,-0.681212,95),(-0.151553,-0.621192,142),(-0.0695369,-0.674051,95),(-0.0728239,-0.671263,95),(-0.137576,-0.699557,142),(-0.108986,-0.679171,95),(-0.0308148,-0.975048,145),(-0.139782,-0.608339,142),(-0.122614,-0.735327,95),(-0.0334667,-0.968973,145),(-0.0821469,-0.707959,95),(-0.113063,-0.618438,95),(-0.135118,-0.614841,142),(-0.101142,-0.614521,95),(-0.162432,-0.627329,116),(-0.141696,-0.612475,142),(-0.0891282,-0.669726,95),(-0.137697,-0.647866,95),(-0.0350424,-0.943685,145),(-0.100235,-0.69163,95),(-0.0328801,-0.851178,73),(-0.090539,-0.651779,95),(-0.0451023,-0.864064,73),(-0.0590551,-1.00738,118),(-0.159727,-0.620174,116),(-0.12322,-0.616441,95),(-0.169476,-0.626486,116),(-0.157293,-0.614749,116),(-0.0676607,-0.674143,95),(-0.0936999,-0.857267,73),(-0.119356,-0.613066,95),(-0.168701,-0.623698,116),(-0.0892736,-0.639392,95),(0.000678759,-0.891277,73),(-0.102247,-0.617042,95),(-0.089807,-0.664937,95),(-0.13744,-0.618724,142),(-0.117868,-0.680058,95),(-0.151209,-0.633904,142),(-0.0756309,-0.788307,95),(-0.138511,-0.615932,142),(-0.125892,-0.686181,95),(-0.0830147,-0.743084,95),(-0.12418,-0.608475,95),(-0.0966476,-0.625172,95),(-0.0843673,-0.659405,95),(-0.10281,-0.67408,95),(-0.142773,-0.610889,142),(-0.0896178,-0.860913,73),(-0.0548567,-1.02004,118),(-0.127487,-0.665848,95),(-0.135724,-0.608984,142),(-0.0609895,-0.690777,95),(-0.0592103,-0.774204,95),(-0.0643445,-0.690908,95),(-0.0746322,-0.977098,145),(-0.0692798,-0.672441,95),(-0.127908,-0.616668,95),(-0.122755,-0.705986,95),(-0.133552,-0.70073,142),(-0.075437,-0.710538,95),(-0.146588,-0.61198,142),(-0.0964537,-0.828886,95),(-0.110993,-0.68589,95),(-0.0344703,-0.854508,73),(-0.0197028,-0.831126,73),(-0.136732,-0.609231,142),(-0.11172,-0.678274,95),(-0.0715585,-0.671661,95),(-0.0727268,-0.711178,95),(-0.119637,-0.619417,95),(-0.0705064,-0.674347,95),(-0.143136,-0.620721,142),(-0.0544592,-0.71255,95),(-0.101568,-0.805271,95),(-0.131957,-0.610909,142),(-0.139655,-0.615975,142),(-0.155165,-0.636919,142),(-0.149827,-0.617614,142),(-0.0648777,-0.672703,95),(-0.118105,-0.750884,95),(-0.150118,-0.673149,142),(-0.0678933,-0.671089,95),(-0.0995808,-0.616227,95),(-0.100938,-0.754855,95),(-0.068097,-0.737116,95),(-0.12275,-0.625827,95),(-0.145895,-0.614768,142),(-0.0782489,-0.775799,95),(-0.0935205,-0.744844,95),(-0.163862,-0.663211,116),(-0.141153,-0.656995,142),(-0.0319104,-0.7831,95),(-0.109272,-0.637356,95),(-0.150389,-0.627446,142),(-0.12626,-0.687824,95),(-0.0903789,-0.709956,95),(-0.0720821,-0.770112,95),(-0.132398,-0.612712,142),(-0.144125,-0.859832,56),(-0.105171,-0.772294,95),(-0.0742929,-0.750715,95),(-0.0777593,-0.765948,95),(-0.0653045,-0.75678,95),(-0.143786,-0.618923,142),(-0.0983395,-0.618293,95),(-0.0652074,-0.674623,95),(-0.110722,-0.658804,95),(-0.151262,-0.623374,142),(-0.0225826,-0.836473,73),(-0.0721355,-0.667448,95),(-0.144571,-0.627902,142),(-0.137023,-0.615311,142),(-0.127981,-0.828498,95),(-0.0304803,-0.821342,73),(-0.0208712,-0.823461,73),(-0.076077,-0.686118,95),(-0.111352,-0.613115,95),(-0.123472,-0.704696,95),(-0.0842607,-0.735981,95),(-0.170727,-0.634442,116),(-0.126197,-0.626244,95),(-0.0506533,-0.712812,95),(-0.0391729,-0.863865,73),(-0.169588,-0.636173,116),(-0.120258,-0.672917,95),(-0.112719,-0.647478,95),(-0.1486,-0.686089,142),(-0.144571,-0.611447,142),(-0.121843,-0.607966,95),(-0.101879,-0.765041,95),(-0.150501,-0.648492,142),(-0.0293603,-0.881047,73),(-0.130783,-0.680455,95),(-0.142172,-0.634796,142),(-0.018389,-0.816213,73),(-0.160042,-0.640182,142),(-0.0894918,-0.693458,95),(-0.143699,-0.624774,142),(-0.0237607,-0.842029,73),(-0.145483,-0.635722,142),(-0.116792,-0.620174,95),(-0.025409,-0.846562,73),(-0.0729499,-0.665504,95),(-0.124355,-0.609682,95),(-0.0755485,-0.678666,95),(-0.153909,-0.614118,142),(-0.0479431,-0.747461,95),(-0.0740795,-0.738177,95),(-0.0959931,-0.789761,95),(-0.0262817,-0.848681,73),(-0.127603,-0.685987,95),(-0.131467,-0.803472,95),(-0.0749038,-0.781762,95),(-0.0178315,-0.813934,73),(-0.16584,-0.628716,116),(-0.0865004,-0.648162,95),(-0.146937,-0.646712,142),(-0.132228,-0.706829,142),(-0.0602769,-0.781558,95),(-0.170213,-0.639857,116),(-0.125509,-0.841375,56),(-0.0796162,-0.659206,95),(-0.0680921,-0.670051,95),(-0.0988584,-0.659715,95),(-0.0238335,-0.844254,73),(-0.146312,-0.618763,142),(-0.0879307,-0.741067,95),(-0.0559087,-0.911173,145),(-0.0265871,-0.917723,145),(-0.0338885,-0.955364,145),(-0.124936,-0.621861,95),(-0.159024,-0.64792,142),(-0.151975,-0.620125,142),(-0.135278,-0.656927,142),(-0.0973313,-0.644177,95),(-0.106383,-0.688576,95),(-0.0503625,-0.700226,95),(-0.138085,-0.609168,142),(-0.0299858,-0.853161,73),(-0.188874,-0.745799,71),(-0.469091,-0.914625,149),(-0.356445,-0.87219,149),(-0.410967,-0.827945,149),(-0.393102,-0.769763,149),(-0.259463,-0.712783,71),(-0.354641,-0.704027,149),(-0.366699,-0.747709,149),(-0.364304,-0.842941,149),(-0.401944,-0.819873,149),(-0.354821,-0.703237,149),(-0.471384,-0.892765,149),(-0.362224,-0.748431,149),(-0.355878,-0.70679,149),(-0.525014,-0.890525,149),(-0.343689,-0.766607,149),(-0.50503,-0.899707,149),(-0.220493,-0.716167,71),(-0.416678,-0.869222,149),(-0.516729,-0.910921,149),(-0.313931,-0.818695,149),(-0.391022,-0.762054,149),(-0.405115,-0.817309,149),(-0.273086,-0.979697,86),(-0.307144,-0.7807,149),(-0.376143,-0.792908,149),(-0.381044,-0.818448,149),(-0.370495,-0.88782,149),(-0.400912,-0.820232,149),(-0.388258,-0.762714,149),(-0.233355,-0.681954,71),(-0.497632,-0.888964,149),(-0.519318,-0.996379,149),(-0.254697,-0.685643,71),(-0.253504,-0.857669,149),(-0.4578,-0.891626,149),(-0.285492,-0.818666,149),(-0.266919,-0.681992,71),(-0.414802,-0.930697,149),(-0.330192,-0.842596,149),(-0.344673,-0.83657,149),(-0.408999,-0.786639,149),(-0.248079,-0.689803,71),(-0.2498,-0.686322,71),(-0.368614,-0.749493,149),(-0.507551,-0.939613,149),(-0.324495,-0.850063,149),(-0.382833,-0.881629,149),(-0.191341,-0.676955,71),(-0.496837,-0.855332,149),(-0.290588,-0.863744,149),(-0.386009,-0.754142,149),(-0.372919,-0.794343,149),(-0.47919,-0.94129,149),(-0.362175,-0.901957,78),(-0.484736,-0.946667,149),(-0.515168,-0.886239,149),(-0.378683,-0.78982,149),(-0.400698,-0.794988,149),(-0.523332,-0.874997,149),(-0.511997,-0.867899,149),(-0.431334,-0.937993,149),(-0.195196,-0.663196,116),(-0.341779,-0.744286,149),(-0.468155,-0.859953,149),(-0.475452,-0.848817,149),(-0.403205,-0.832779,149),(-0.513966,-0.904192,149),(-0.391167,-0.749891,149),(-0.311672,-0.724404,149),(-0.393266,-0.910495,149),(-0.424532,-0.883408,149),(-0.401886,-0.79509,149),(-0.407631,-0.835261,149),(-0.410729,-0.859478,149),(-0.373607,-0.846567,149),(-0.520103,-0.905205,149),(-0.5175,-0.886288,149),(-0.206773,-0.711944,71),(-0.535351,-0.897026,149),(-0.396718,-0.745503,149),(-0.359998,-0.866542,149),(-0.378824,-0.825095,149),(-0.275898,-0.737106,149),(-0.412353,-0.816669,149),(-0.410894,-0.808276,149),(-0.398318,-0.824964,149),(-0.410182,-0.828299,149),(-0.502975,-0.916477,149),(-0.394294,-0.812082,149),(-0.223984,-0.682424,71),(-0.187419,-0.659928,116),(-0.395332,-0.739874,149),(-0.365331,-0.959257,78),(-0.339743,-0.77225,149),(-0.368924,-0.837588,149),(-0.203578,-0.680809,71),(-0.394658,-0.815079,149),(-0.370209,-0.830699,149),(-0.351311,-0.703503,149),(-0.396956,-0.76284,149),(-0.182586,-0.701438,71),(-0.291611,-0.856836,149),(-0.216746,-0.729029,71),(-0.460985,-0.856486,149),(-0.222311,-0.67664,71),(-0.349682,-0.770471,149),(-0.487713,-0.923682,149),(-0.409168,-0.90537,149),(-0.400029,-0.741944,149),(-0.52069,-0.892736,149),(-0.517282,-0.890239,149),(-0.418234,-0.809692,149),(-0.526401,-0.934891,149),(-0.218384,-0.671869,71),(-0.365069,-0.820154,149),(-0.516385,-0.896673,149),(-0.41469,-0.792549,149),(-0.410661,-0.822666,149),(-0.398619,-0.734832,149),(-0.393547,-0.836255,149),(-0.410981,-0.813954,149),(-0.442407,-0.946628,149),(-0.231692,-0.875506,149),(-0.451589,-0.879345,149),(-0.326658,-0.695669,149),(-0.505641,-0.891306,149),(-0.396733,-0.847716,149),(-0.495819,-0.959247,149),(-0.288416,-0.879161,149),(-0.547427,-0.907193,149),(-0.386004,-0.786348,149),(-0.519415,-0.892687,149),(-0.445665,-0.858814,149),(-0.404558,-0.800878,149),(-0.363373,-0.861834,149),(-0.376914,-0.818361,149),(-0.492765,-0.85812,149),(-0.359213,-0.835222,149),(-0.493822,-0.871472,149),(-0.375944,-0.750676,149),(-0.398003,-0.756988,149),(-0.368885,-0.772512,149),(-0.383434,-0.81678,149),(-0.377694,-0.716477,149),(-0.522886,-0.902723,149),(-0.337042,-0.803705,149),(-0.382091,-0.795788,149),(-0.52947,-0.948063,149),(-0.458033,-0.848894,149),(-0.220391,-0.675093,71),(-0.278356,-0.783032,149),(-0.377796,-0.728622,149),(-0.192243,-0.649374,116),(-0.384278,-0.835853,149),(-0.4123,-0.81247,149),(-0.500221,-0.977462,149),(-0.413536,-0.812713,149),(-0.458154,-0.861819,149),(-0.37449,-0.760135,149),(-0.418195,-0.808674,149),(-0.216949,-0.685066,71),(-0.350588,-0.790523,149),(-0.365583,-0.783983,149),(-0.394551,-0.818899,149),(-0.375934,-0.736185,149),(-0.22635,-0.685241,71),(-0.406574,-0.874012,149),(-0.493914,-0.947069,149),(-0.413013,-0.812247,149),(-0.381151,-0.900769,149),(-0.483248,-0.851347,149),(-0.218981,-0.675651,71),(-0.509491,-0.957614,149),(-0.585015,-0.931448,149),(-0.374771,-0.826641,149),(-0.486438,-0.95088,149),(-0.388375,-0.797674,149),(-0.378916,-0.828648,149),(-0.337959,-0.742962,149),(-0.539147,-0.96923,149),(-0.409178,-0.81887,149),(-0.233782,-0.771237,71),(-0.518086,-0.939108,149),(-0.345047,-0.765351,149),(-0.196451,-0.687218,71),(-0.406933,-0.806715,149),(-0.310906,-0.883083,149),(-0.391943,-0.82956,149),(-0.35275,-0.888823,149),(-0.518668,-0.915003,149),(-0.399661,-0.866251,149),(-0.380952,-0.824644,149),(-0.284106,-0.68111,71),(-0.470555,-0.880116,149),(-0.397125,-0.827524,149),(-0.226389,-0.672141,71),(-0.412751,-0.830311,149),(-0.404931,-0.825313,149),(-0.282225,-0.738105,149),(-0.346715,-0.827984,149),(-0.214394,-0.706752,71),(-0.264669,-0.869232,149),(-0.528107,-0.958433,149),(-0.28747,-0.95357,86),(-0.5175,-0.882715,149),(-0.406831,-0.896561,149),(-0.330182,-0.957211,78),(-0.200446,-0.662052,71),(-0.523419,-0.91417,149),(-0.455633,-0.86913,149),(-0.458226,-0.864258,149),(-0.414414,-0.809804,149),(-0.559116,-0.909292,149),(-0.474977,-0.866435,149),(-0.399729,-0.754113,149),(-0.398691,-0.830883,149),(-0.393169,-0.732078,149),(-0.391153,-0.830103,149),(-0.380516,-0.952014,78),(-0.439648,-0.860695,149),(-0.39634,-0.74368,149),(-0.369617,-0.834447,149),(-0.413827,-0.810065,149),(-0.344998,-0.769458,149),(-0.483445,-0.847046,149),(-0.189097,-0.672577,71),(-0.20607,-0.687408,71),(-0.337295,-0.72004,149),(-0.392156,-0.775741,149),(-0.427388,-0.835029,149),(-0.387836,-0.895402,149),(-0.387972,-0.888251,149),(-0.321984,-0.880548,149),(-0.396471,-0.760183,149),(-0.442713,-0.856554,149),(-0.530362,-0.985263,149),(-0.440051,-0.88973,149),(-0.178217,-0.642984,116),(-0.375886,-0.870187,149),(-0.38181,-0.904847,149),(-0.386164,-0.896905,149),(-0.379842,-0.909588,149),(-0.336975,-0.853888,149),(-0.418981,-0.809881,149),(-0.302659,-0.684533,71),(-0.387987,-0.801741,149),(-0.24597,-0.809299,149),(-0.457941,-0.891485,149),(-0.287102,-0.681808,71),(-0.381422,-0.828668,149),(-0.405173,-0.829448,149),(-0.524176,-0.894132,149),(-0.518392,-0.894341,149),(-0.234587,-0.857805,149),(-0.265746,-1.0356,86),(-0.356333,-0.748897,149),(-0.393329,-0.972594,78),(-0.366912,-0.838408,149),(-0.43799,-0.875491,149),(-0.33553,-0.784269,149),(-0.385868,-0.875661,149),(-0.466711,-0.858299,149),(-0.380268,-0.81265,149),(-0.283732,-0.988254,86),(-0.253591,-0.704507,71),(-0.410642,-0.808868,149),(-0.269702,-0.831024,149),(-0.363688,-0.710732,149),(-0.357187,-0.802119,149),(-0.343529,-0.783483,149),(-0.366684,-0.841627,149),(-0.432095,-0.903407,149),(-0.204732,-0.707823,71),(-0.301937,-0.842635,149),(-0.444041,-0.856317,149),(-0.388777,-0.898845,149),(-0.302727,-0.784385,149),(-0.383948,-0.863191,149),(-0.404805,-0.861911,149),(-0.428061,-0.871768,149),(-0.394954,-0.766166,149),(-0.383905,-0.827737,149),(-0.396631,-0.831635,149),(-0.30199,-0.855502,149),(-0.402366,-0.809101,149),(-0.392922,-0.767955,149),(-0.448472,-0.901632,149),(-0.385994,-0.814768,149),(-0.187478,-0.704429,71),(-0.400097,-0.793456,149),(-0.415616,-0.832808,149),(-0.413851,-0.827771,149),(-0.392786,-0.753609,149),(-0.424464,-0.820276,149),(-0.360207,-0.892023,149),(-0.368104,-0.786993,149),(-0.467215,-0.84903,149),(-0.179599,-0.638553,116),(-0.373845,-0.874017,149),(-0.554525,-0.913549,149),(-0.3424,-0.768696,149),(-0.396922,-0.818584,149),(-0.279345,-0.720772,149),(-0.39011,-0.851284,149),(-0.397256,-0.822996,149),(-0.330633,-0.820174,149),(-0.324263,-0.811893,149),(-0.457776,-0.919275,149),(-0.391453,-0.757798,149),(-0.361613,-0.813493,149),(-0.493279,-0.914669,149),(-0.517117,-0.887233,149),(-0.405227,-0.78039,149),(-0.402701,-0.915692,149),(-0.408208,-0.850373,149),(-0.343432,-0.893449,78),(-0.445408,-0.846645,149),(-0.386799,-0.755602,149),(-0.391177,-0.882715,149),(-0.37607,-0.79827,149),(-0.346627,-0.778562,149),(-0.300584,-0.818118,149),(-0.394595,-0.762932,149),(-0.493797,-0.93378,149),(-0.423834,-0.939685,149),(-0.397741,-0.876461,149),(-0.486937,-0.930498,149),(-0.443827,-0.872776,149),(-0.462236,-0.907406,149),(-0.482501,-0.849413,149),(-0.409411,-0.90842,149),(-0.267908,-0.846485,149),(-0.355957,-0.759308,149),(-0.358156,-0.762568,149),(-0.401057,-0.870405,149),(-0.380424,-0.887999,149),(-0.521621,-0.877372,149),(-0.41072,-0.816669,149),(-0.494956,-0.860297,149),(-0.361637,-0.83578,149),(-0.36122,-0.782383,149),(-0.361933,-0.853723,149),(-0.374688,-0.859066,149),(-0.517985,-0.892397,149),(-0.312273,-0.68717,71),(-0.326561,-0.705123,149),(-0.502374,-0.900764,149),(-0.512715,-0.892115,149),(-0.25826,-0.999865,86),(-0.397542,-0.825468,149),(-0.348814,-0.765269,149),(-0.397222,-0.758365,149),(-0.358384,-0.860695,149),(-0.388893,-0.742308,149),(-0.344703,-0.751146,149),(-0.189455,-0.647973,116),(-0.178344,-0.653107,116),(-0.399389,-0.7523,149),(-0.252617,-0.845782,149),(-0.398066,-0.757715,149),(-0.286346,-0.859027,149),(-0.370635,-0.789514,149),(-0.227504,-0.68093,71),(-0.40256,-0.945804,78),(-0.469474,-0.849175,149),(-0.311352,-0.704308,149),(-0.373079,-0.812024,149),(-0.225438,-0.685042,71),(-0.368798,-0.739433,149),(-0.315667,-0.690292,71),(-0.201586,-0.71831,71),(-0.361831,-0.838767,149),(-0.309466,-0.856947,149),(-0.292081,-0.765531,149),(-0.36983,-0.819961,149),(-0.518164,-0.898166,149),(-0.400495,-0.825817,149),(-0.326808,-0.829007,149),(-0.3649,-0.848952,149),(-0.362549,-0.867676,149),(-0.371076,-0.846422,149),(-0.420503,-0.813687,149),(-0.391511,-0.819568,149),(-0.390469,-0.819296,149),(-0.41055,-0.806138,149),(-0.374683,-0.820387,149),(-0.368851,-0.891892,149),(-0.373714,-0.736471,149),(-0.306645,-0.91719,149),(-0.391894,-0.758675,149),(-0.352198,-0.838315,149),(-0.393165,-0.763281,149),(-0.441486,-0.944116,149),(-0.303232,-0.701981,71),(-0.413081,-0.810904,149),(-0.341348,-0.769365,149),(-0.348828,-0.775411,149),(-0.377049,-0.844143,149),(-0.218695,-0.668447,71),(-0.271627,-0.685958,71),(-0.386518,-0.893099,149),(-0.408848,-0.9065,149),(-0.387706,-0.871719,149),(-0.40002,-0.747326,149),(-0.355659,-0.757754,149),(-0.409891,-0.903935,149),(-0.428585,-0.943467,149),(-0.496532,-0.911062,149),(-0.367275,-0.712521,149),(-0.223014,-0.679272,71),(-0.234592,-0.705651,71),(-0.377243,-0.962869,78),(-0.35531,-0.732306,149),(-0.35357,-0.733625,149),(-0.400723,-0.768653,149),(-0.410981,-0.901826,149),(-0.406987,-0.813091,149),(-0.410952,-0.823504,149),(-0.45573,-0.869266,149),(-0.378295,-0.80145,149),(-0.392738,-0.850174,149),(-0.390445,-0.72932,149),(-0.28366,-0.83689,149),(-0.28507,-0.976221,86),(-0.402934,-0.819442,149),(-0.396728,-0.787575,149),(-0.406841,-0.892959,149),(-0.400083,-0.927419,149),(-0.238116,-0.730256,71),(-0.378363,-0.86817,149),(-0.338439,-0.699392,149),(-0.393829,-0.827315,149),(-0.375803,-0.744262,149),(-0.39442,-0.851726,149),(-0.387211,-0.827116,149),(-0.3708,-0.785393,149),(-0.443449,-0.914834,149),(-0.188607,-0.648739,116),(-0.402294,-0.834907,149),(-0.449766,-0.867705,149),(-0.351708,-0.726455,149),(-0.485483,-0.878356,149),(-0.514295,-0.906897,149),(-0.497113,-0.851386,149),(-0.492333,-0.899295,149),(-0.34256,-0.76602,149),(-0.349459,-0.794886,149),(-0.190541,-0.657116,116),(-0.331695,-1.00534,78),(-0.404679,-0.818283,149),(-0.510106,-0.936922,149),(-0.379856,-0.756605,149),(-0.348227,-0.773928,149),(-0.36744,-0.867225,149),(-0.459099,-0.852516,149),(-0.309665,-0.805862,149),(-0.34575,-0.753522,149),(-0.474347,-0.898927,149),(-0.175842,-0.671617,71),(-0.286825,-0.715643,149),(-0.241859,-0.699591,71),(-0.389145,-0.847493,149),(-0.312089,-0.902587,149),(-0.403195,-0.815563,149),(-0.366829,-0.833637,149),(-0.374902,-0.979794,78),(-0.46227,-0.856375,149),(-0.27501,-0.861048,149),(-0.395196,-0.761894,149),(-0.270235,-0.774344,149),(-0.410632,-0.818603,149),(-0.411951,-0.901346,149),(-0.275806,-0.755883,149),(-0.353759,-0.882191,149),(-0.396287,-0.820057,149),(-0.423262,-0.86753,149),(-0.179139,-0.70155,71),(-0.568386,-0.931584,149),(-0.236153,-0.697623,71),(-0.388956,-0.813537,149),(-0.195138,-0.707178,71),(-0.278647,-0.959378,86),(-0.404228,-0.872131,149),(-0.406754,-0.802255,149),(-0.370965,-0.843382,149),(-0.516462,-0.89292,149),(-0.35499,-0.833928,149),(-0.34432,-0.876078,149),(-0.404097,-0.821313,149),(-0.321475,-0.858969,149),(-0.33107,-0.863327,149),(-0.239672,-0.683282,71),(-0.406036,-0.825526,149),(-0.26384,-0.699358,71),(-0.35038,-0.778005,149),(-0.4032,-0.848506,149),(-0.401527,-0.817493,149),(-0.420843,-0.861,149),(-0.508332,-0.987037,149),(-0.40991,-0.808931,149),(-0.271612,-0.871768,149),(-0.376914,-0.851944,149),(-0.391584,-0.817192,149),(-0.411006,-0.819156,149),(-0.418569,-0.853039,149),(-0.411752,-0.838684,149),(-0.266143,-0.702456,71),(-0.370097,-0.73108,149),(-0.440172,-0.861281,149),(-0.366713,-0.712686,149),(-0.472815,-0.848429,149),(-0.413939,-0.817672,149),(-0.357313,-0.78759,149),(-0.224944,-0.675069,71),(-0.260941,-0.864801,149),(-0.378198,-0.734367,149),(-0.422074,-0.81662,149),(-0.266075,-0.70903,71),(-0.311667,-0.748029,149),(-0.29739,-0.689948,71),(-0.25618,-0.687223,71),(-0.3914,-0.793301,149),(-0.469629,-0.849311,149),(-0.408717,-0.856792,149),(-0.398846,-0.764023,149),(-0.258057,-0.68557,71),(-0.396965,-0.748038,149),(-0.353487,-0.764478,149),(-0.342419,-0.754452,149),(-0.279607,-0.869353,149),(-0.218646,-0.703489,71),(-0.196766,-0.65956,116),(-0.186488,-0.653194,116),(-0.197295,-0.730522,71),(-0.444487,-0.884029,149),(-0.394105,-0.829356,149),(-0.286966,-0.892174,149),(-0.212203,-0.693545,71),(-0.246741,-0.693487,71),(-0.407539,-0.832323,149),(-0.339786,-0.742405,149),(-0.309306,-0.840546,149),(-0.338831,-0.740359,149),(-0.285497,-0.86387,149),(-0.403001,-0.824111,149),(-0.469455,-0.859255,149),(-0.440347,-0.883214,149),(-0.492881,-0.849457,149),(-0.258115,-0.681541,71),(-0.356619,-0.896096,149),(-0.415005,-0.791647,149),(-0.49546,-0.940989,149),(-0.431237,-0.829996,149),(-0.516171,-0.886458,149),(-0.350292,-0.77321,149),(-0.349735,-0.833341,149),(-0.392859,-0.847493,149),(-0.501142,-0.860447,149),(-0.212673,-0.754341,71),(-0.412882,-0.824188,149),(-0.379745,-0.852225,149),(-0.349449,-0.768973,149),(-0.245514,-0.691858,71),(-0.472233,-0.864248,149),(-0.406124,-0.890957,149),(-0.259443,-0.690932,71),(-0.339961,-0.812257,149),(-0.383182,-0.8377,149),(-0.416237,-0.875942,149),(-0.22283,-0.701826,71),(-0.398953,-0.824144,149),(-0.558917,-0.931928,149),(-0.204713,-0.856409,56),(-0.371847,-0.815292,149),(-0.409503,-0.81216,149),(-0.418758,-0.807326,149),(-0.372802,-0.841743,149),(-0.45174,-0.847789,149),(-0.398221,-0.788758,149),(-0.408669,-0.803462,149),(-0.371071,-0.883883,149),(-0.443231,-0.898113,149),(-0.360475,-0.706894,149),(-0.371741,-0.816858,149),(-0.462042,-0.85526,149),(-0.356542,-0.834689,149),(-0.50345,-0.905656,149),(-0.393349,-0.750176,149),(-0.327686,-0.749313,149),(-0.248244,-0.746676,71),(-0.354622,-0.843178,149),(-0.362602,-0.727443,149),(-0.522629,-0.889977,149),(-0.329014,-0.732156,149),(-0.314377,-0.861402,149),(-0.278108,-0.875113,149),(-0.287911,-0.862653,149),(-0.291097,-0.859643,149),(-0.267341,-0.857262,149),(-0.470041,-0.854494,149),(-0.510615,-0.899431,149),(-0.387647,-0.866663,149),(-0.239876,-0.689172,71),(-0.349497,-0.854174,149),(-0.477508,-0.931909,149),(-0.40704,-0.815539,149),(-0.406342,-0.815859,149),(-0.455201,-0.925984,149),(-0.358466,-0.827301,149),(-0.445893,-0.952741,149),(-0.501739,-0.863453,149),(-0.271176,-0.826142,149),(-0.357172,-0.79284,149),(-0.481653,-0.847343,149),(-0.50665,-0.893289,149),(-0.410865,-0.809285,149),(-0.354021,-0.876965,149),(-0.214094,-0.680097,71),(-0.510072,-0.896188,149),(-0.18339,-0.680955,71),(-0.489759,-0.889042,149),(-0.52118,-0.893245,149),(-0.517461,-0.893153,149),(-0.196669,-0.653422,116),(-0.205881,-0.662265,71),(-0.26051,-0.747335,149),(-0.344921,-0.773423,149),(-0.482307,-0.912351,149),(-0.208426,-0.664699,71),(-0.533091,-0.916681,149),(-0.510266,-0.905297,149),(-0.415951,-0.817013,149),(-0.412751,-0.817725,149),(-0.377166,-0.795264,149),(-0.397683,-0.755931,149),(-0.387832,-0.956537,78),(-0.540752,-0.954225,149),(-0.449136,-0.926023,149),(-0.390362,-0.844395,149),(-0.35149,-0.783372,149);
/*&*/
INSERT INTO `x2_timezone_points` VALUES (-0.251478,-0.98517,86),(-0.318513,-0.760968,149),(-0.413401,-0.813721,149),(-0.382295,-0.831116,149),(-0.327361,-0.775464,149),(-0.476174,-0.882865,149),(-0.443798,-0.859977,149),(-0.272203,-0.979072,86),(-0.417046,-0.810274,149),(-0.415127,-0.926304,149),(-0.394027,-0.784749,149),(-0.221133,-0.682458,71),(-0.499838,-0.935608,149),(-0.292667,-0.831014,149),(-0.500517,-0.861664,149),(-0.372458,-0.833036,149),(-0.323002,-0.955742,78),(-0.411966,-0.818894,149),(-0.395244,-0.823727,149),(-0.176724,-0.631383,116),(-0.331773,-1.00624,78),(-0.453432,-0.917481,149),(-0.340664,-0.744015,149),(-0.32242,-0.8238,149),(-0.320806,-0.77591,149),(-0.392384,-0.828275,149),(-0.384472,-0.739336,149),(-0.347873,-0.768881,149),(-0.36059,-0.764212,149),(-0.357788,-0.765463,149),(-0.206186,-0.656428,71),(-0.475326,-0.908056,149),(-0.389737,-0.823315,149),(-0.201828,-0.685614,71),(-0.214966,-0.676606,71),(-0.347577,-0.844536,149),(-0.218268,-0.680654,71),(-0.324515,-0.693458,149),(-0.39859,-0.907101,149),(-0.441423,-0.859124,149),(-0.341028,-0.709137,149),(-0.255531,-0.690297,71),(-0.356803,-0.781311,149),(-0.185005,-0.669915,71),(-0.413003,-0.91813,149),(-0.522808,-0.901031,149),(-0.472921,-0.918363,149),(-0.404306,-0.833283,149),(-0.267181,-0.865654,149),(-0.482312,-0.895989,149),(-0.509079,-0.89325,149),(-0.383575,-0.78422,149),(-0.215602,-0.669838,71),(-0.368924,-0.854736,149),(-0.317054,-0.836822,149),(-0.373311,-0.745197,149),(-0.432687,-0.872873,149),(-0.359601,-0.718809,149),(-0.333591,-0.902932,78),(-0.39236,-0.736602,149),(-0.435561,-0.932971,149),(-0.380026,-0.821813,149),(-0.331627,-0.808369,149),(-0.35228,-0.781403,149),(-0.511338,-0.898908,149),(-0.493647,-0.921296,149),(-0.345396,-0.735467,149),(-0.410545,-0.817435,149),(-0.36186,-0.733552,149),(-0.365709,-0.764566,149),(-0.412252,-0.792607,149),(-0.401338,-0.829167,149),(-0.477236,-0.900798,149),(-0.198638,-0.698355,71),(-0.308773,-0.742041,149),(-0.183318,-0.646693,116),(-0.519158,-0.872834,149),(-0.418981,-0.843857,149),(-0.456879,-0.879471,149),(-0.522164,-0.893323,149),(-0.547946,-0.919362,149),(-0.512526,-0.886899,149),(-0.396999,-0.879418,149),(-0.517825,-0.92134,149),(-0.27358,-0.679757,71),(-0.356338,-0.943641,78),(-0.478249,-0.894045,149),(-0.370621,-0.798638,149),(-0.396878,-0.79572,149),(-0.227533,-0.81632,149),(-0.379609,-0.720821,149),(-0.419674,-0.914257,149),(-0.444337,-0.864432,149),(-0.356794,-0.953759,78),(-0.18339,-0.703741,71),(-0.364725,-0.790237,149),(-0.399777,-0.821366,149),(-0.441665,-0.856176,149),(-0.394658,-0.803855,149),(-0.40624,-0.894976,149),(-0.402235,-0.873949,149),(-0.538453,-0.904294,149),(-0.397155,-0.805377,149),(-0.221613,-0.668883,71),(-0.309651,-0.848666,149),(-0.371324,-0.825613,149),(-0.431727,-0.839901,149),(-0.407641,-0.818157,149),(-0.407782,-0.815777,149),(-0.245558,-0.741329,71),(-0.346971,-0.76218,149),(-0.363882,-0.717553,149),(-0.522745,-0.891757,149),(-0.392045,-0.744436,149),(-0.524282,-0.923173,149),(-0.220231,-0.679908,71),(-0.532539,-0.933601,149),(-0.403186,-0.797737,149),(-0.467317,-0.89038,149),(-0.406793,-0.822622,149),(-0.399322,-0.733363,149),(-0.525688,-0.906912,149),(-0.302834,-0.784739,149),(-0.272582,-0.81024,149),(-0.415345,-0.848104,149),(-0.261091,-0.68591,71),(-0.47295,-0.853771,149),(-0.2479,-0.727196,71),(-0.351567,-0.771431,149),(-0.388932,-0.839969,149),(-0.366369,-0.8318,149),(-0.275408,-0.836531,149),(-0.400587,-0.81231,149),(-0.493492,-0.858101,149),(-0.399433,-0.845525,149),(-0.368856,-0.727448,149),(-0.231343,-0.757788,71),(-0.344465,-0.7898,149),(-0.406371,-0.832037,149),(-0.298587,-0.764716,149),(-0.36809,-0.795274,149),(-0.469833,-0.856365,149),(-0.411418,-0.803525,149),(-0.371556,-0.878599,149),(-0.479864,-0.8492,149),(-0.348504,-0.771406,149),(-0.416339,-0.805271,149),(-0.509137,-0.899179,149),(-0.335452,-0.741479,149),(-0.347684,-0.766859,149),(-0.39731,-0.757463,149),(-0.385873,-0.986479,78),(-0.365637,-0.846121,149),(-0.389465,-0.856268,149),(-0.364619,-0.830515,149),(-0.38261,-0.885473,149),(-0.410337,-0.818142,149),(-0.369782,-0.767523,149),(-0.369898,-0.840618,149),(-0.358791,-0.847668,149),(-0.272562,-0.760964,149),(-0.212106,-0.785224,71),(-0.46482,-0.849709,149),(-0.39347,-0.770936,149),(-0.190396,-0.646446,116),(-0.392175,-0.7649,149),(-0.277333,-0.912051,86),(-0.263065,-0.997999,86),(-0.327336,-0.71368,149),(-0.392607,-0.847498,149),(-0.193547,-0.752964,71),(-0.385272,-0.850678,149),(-0.370461,-0.763994,149),(-0.34812,-0.758995,149),(-0.403346,-0.879079,149),(-0.349177,-0.802449,149),(-0.471074,-0.848836,149),(-0.340669,-0.715861,149),(-0.546836,-0.944344,149),(-0.403147,-0.853917,149),(-0.403467,-0.812456,149),(-0.405484,-0.901734,149),(-0.395521,-0.879859,149),(-0.408339,-0.808451,149),(-0.393974,-0.823315,149),(-0.562651,-0.926542,149),(-0.513146,-0.906611,149),(-0.400834,-0.733523,149),(-0.397009,-0.730973,149),(-0.353987,-0.794813,149),(-0.341968,-0.819267,149),(-0.446683,-0.862372,149),(-0.399205,-0.739026,149),(-0.390202,-0.82701,149),(-0.380385,-0.840822,149),(-0.505006,-0.863691,149),(-0.408746,-0.897526,149),(-0.325455,-0.841026,149),(-0.277464,-0.911949,149),(-0.294083,-0.734265,149),(-0.345929,-0.702902,149),(-0.410245,-0.831024,149),(-0.197804,-0.680097,71),(-0.370165,-0.880218,149),(-0.190435,-0.647023,116),(-0.357288,-0.973671,78),(-0.41104,-0.898161,149),(-0.42777,-0.852462,149),(-0.350579,-0.891752,78),(-0.398754,-0.789408,149),(-0.443813,-0.850184,149),(-0.287301,-0.871996,149),(-0.401542,-0.773496,149),(-0.364706,-0.89674,149),(-0.38516,-0.812785,149),(-0.357506,-0.974015,78),(-0.284954,-0.854387,149),(-0.396209,-0.816193,149),(-0.379163,-0.839532,149),(-0.396873,-0.826089,149),(-0.227421,-0.691233,71),(-0.385359,-0.898355,149),(-0.442,-0.860622,149),(-0.282457,-0.710252,149),(-0.37401,-0.80193,149),(-0.382014,-0.745333,149),(-0.519812,-0.973753,149),(-0.362393,-0.724889,149),(-0.211805,-0.670541,71),(-0.340266,-0.7167,149),(-0.392161,-0.854993,149),(-0.274841,-0.723614,149),(-0.392287,-0.813896,149),(-0.38501,-0.819931,149),(-0.37848,-0.891383,149),(-0.334405,-0.793179,149),(-0.525587,-0.89579,149),(-0.178247,-0.844046,56),(-0.0585413,-1.12943,118),(-0.142443,-1.23509,144),(-0.0738246,-1.22062,118),(-0.158224,-1.19829,93),(-0.00227381,-1.17093,118),(-0.174092,-1.18351,144),(-0.152925,-1.11533,139),(-0.0541391,-1.04763,118),(-0.057591,-1.05803,118),(-0.131006,-1.09992,118),(-0.0438757,-1.15352,118),(-0.116244,-1.21952,93),(-0.0712967,-1.10203,118),(-0.0852206,-1.16755,118),(0.0492134,-1.05895,75),(-0.17302,-1.10027,139),(-0.159989,-1.05825,86),(-0.222365,-1.04974,139),(-0.228347,-1.08676,139),(-0.203724,-1.06803,139),(-0.187589,-1.08587,139),(-0.182193,-1.09024,139),(-0.188195,-1.14039,139),(-0.199641,-1.07246,139),(-0.293622,-0.859468,149),(-0.481614,-0.848351,149),(-0.141595,-0.611122,142),(-0.22505,-0.668936,71),(-0.444094,-0.858571,149),(-0.0471141,-1.04196,118),(-0.223131,-0.670274,71),(-0.063197,-0.677696,95),(-0.354352,-0.703967,149),(-0.481469,-0.846892,149),(-0.483766,-0.847578,149),(0.437349,-1.34989,131),(0.463094,-1.37299,131),(0.463094,-1.37357,131),(0.479374,1.56455,233),(0.46865,1.56012,233),(-0.37424,0.479294,23),(-0.430575,0.445753,23),(-0.390736,0.466191,23),(-0.383605,0.485951,23),(-0.434091,0.451515,23),(-0.393503,0.473422,23),(-0.432349,0.44369,23),(-0.425975,0.444973,23),(-0.429821,0.451439,23),(-0.426151,0.456404,23),(-0.348775,0.408698,23),(-0.403242,0.467996,23),(-0.440248,0.448153,23),(-0.373791,0.446513,23),(-0.435752,0.44214,23),(-0.443605,0.445932,23),(-0.430302,0.45219,23),(-0.369485,0.480103,23),(0.944197,0.494506,287),(0.92315,0.524018,287),(0.963254,0.527175,287),(0.951054,0.469687,287),(0.927749,0.426756,287),(0.918617,0.519042,287),(0.933376,0.46676,287),(0.950852,0.460692,287),(0.925503,0.481008,287),(0.926541,0.441853,287),(0.935521,0.431908,287),(0.921317,0.48069,287),(0.926655,0.524463,287),(0.913884,0.530433,287),(0.917275,0.42686,287),(0.968447,0.502403,287),(0.909716,0.455445,287),(0.961969,0.468318,287),(0.93028,0.499838,287),(0.951346,0.53088,287),(0.940442,0.479093,287),(0.969213,0.499141,287),(0.935395,0.450628,287),(0.940732,0.481129,287),(0.908435,0.510432,287),(0.932219,0.428281,287),(0.933908,0.491258,287),(0.948005,0.468691,287),(0.941026,0.529618,287),(0.957861,0.500892,287),(0.911886,0.46783,287),(0.940442,0.441563,287),(0.93746,0.553566,287),(0.9415,0.484893,287),(0.911303,0.425099,287),(0.90988,0.51183,287),(0.919946,0.442268,287),(0.937039,0.415839,287),(0.947473,0.540813,287),(0.915155,0.540623,287),(0.962347,0.48329,287),(0.936949,0.473647,287),(0.914708,0.546702,287),(0.934118,0.527882,287),(0.916846,0.435959,287),(0.909274,0.413429,287),(0.946455,0.497506,287),(0.927341,0.454028,287),(0.92744,0.51001,287),(0.939998,0.478873,287),(0.299431,-1.55459,74),(0.315577,-1.54572,74),(0.301069,-1.54927,74),(0.305424,-1.53934,74),(0.856223,-2.13371,161),(0.895356,-1.99029,92),(0.765329,-1.37938,159),(0.847359,-1.25051,129),(0.847652,-1.36339,129),(0.858995,-1.18942,129),(0.774928,-1.39044,159),(0.792963,-1.2892,129),(0.771065,-1.35037,159),(0.79529,-1.27757,129),(0.797036,-1.28949,129),(0.796163,-1.28862,129),(0.795714,-1.2817,129),(0.769984,-1.38957,159),(0.762419,-1.39219,159),(0.869993,-1.74451,163),(0.75282,-1.40237,159),(0.75282,-1.40091,159),(0.778127,-1.32091,159),(0.793254,-1.28222,129),(0.757232,-1.39342,159),(0.85986,-2.14593,161),(0.890993,-1.99116,92),(0.756777,-1.40172,159),(0.87295,-2.18593,161),(0.925318,-1.96935,92),(0.792089,-1.28309,129),(0.793254,-1.27902,129),(0.806957,-1.10177,104),(0.792089,-1.28717,129),(0.740021,-1.43437,159),(0.85826,-2.12833,161),(0.794999,-1.31408,159),(0.767243,-1.36424,159),(0.893319,-1.99786,92),(0.776382,-1.40004,159),(0.82903,-0.924991,151),(0.86015,-2.14244,161),(0.85463,-1.01139,151),(0.785714,-1.30425,159),(0.79352,-1.28571,129),(0.867194,-2.18155,161),(0.863936,-2.02055,92),(0.779662,-1.10963,104),(0.857724,-2.14513,161),(0.794728,-1.28983,129),(0.80422,-1.12901,126),(0.794029,-1.28848,129),(0.793205,-1.28724,129),(0.800816,-1.26506,129),(0.851423,-2.15902,161),(0.934626,-1.9804,92),(0.76191,-1.38871,159),(0.748748,-1.37764,159),(0.990069,-1.94397,92),(0.981746,-2.10928,88),(0.801899,-1.16353,126),(0.793727,-1.32124,129),(0.806289,-1.04645,96),(0.792381,-1.26942,129),(0.96284,-2.0735,92),(0.811404,-1.41354,159),(0.77231,-1.34302,159),(0.760093,-1.40062,159),(0.750202,-1.39393,159),(0.754565,-1.39538,159),(0.791217,-1.38259,159),(0.803144,-1.28193,129),(0.884297,-2.09997,161),(0.778127,-1.37589,159),(0.870624,-2.08542,161),(0.869466,-1.64818,163),(0.77231,-1.38695,159),(0.771955,-1.33484,159),(0.793254,-1.2892,129),(0.757916,-1.40519,159),(0.845606,-2.15553,161),(0.856951,-2.14069,161),(0.856659,-2.13953,161),(0.792672,-1.2828,129),(0.799765,-1.28158,129),(0.795346,-1.28617,129),(0.733996,-1.44175,159),(0.929681,-1.98186,92),(0.867428,-1.96906,92),(0.929972,-1.91989,92),(0.750202,-1.41778,159),(0.79467,-1.28313,129),(0.790054,-1.25924,129),(0.85904,-2.13981,161),(0.76562,-1.38346,159),(0.798482,-1.28455,129),(0.873538,-1.93153,92),(0.781037,-1.39422,159),(0.796744,-1.29298,129),(0.82038,-1.14259,126),(0.857546,-2.13479,161),(0.760595,-1.3903,159),(0.804875,-1.13101,126),(0.794279,-1.28435,129),(0.794417,-1.28542,129),(0.79529,-1.27757,129),(0.879647,-1.84192,143),(0.829321,-0.921208,151),(0.858115,-2.16309,161),(0.795581,-1.09342,104),(0.768819,-1.38695,159),(0.85882,-2.1452,161),(0.752239,-1.37997,159),(0.747584,-1.40295,159),(0.921245,-1.88992,143),(0.808381,-1.38695,159),(0.852442,-2.15873,161),(0.860733,-2.14797,161),(0.763875,-1.38608,159),(0.758347,-1.39073,159),(0.766493,-1.398,159),(0.778568,-1.38615,159),(0.766202,-1.37618,159),(0.792574,-1.32118,159),(0.777844,-1.41273,159),(0.860732,-2.16978,161),(0.799654,-1.34593,159),(0.8636,-2.08717,161),(0.773183,-1.36688,159),(0.766202,-1.38113,159),(0.859072,-2.14134,161),(0.793229,-1.28834,129),(0.859423,-2.17822,161),(0.748748,-1.38287,159),(0.86015,-2.14418,161),(0.928517,-1.84599,143),(0.767947,-1.34826,159),(0.941022,-2.14244,161),(0.771146,-1.35379,159),(0.912228,-1.98622,92),(0.88052,-1.82593,143),(0.798352,-1.28195,129),(0.858179,-2.14914,161),(0.765695,-1.38644,159),(0.841944,-1.37931,129),(0.845032,-1.24033,129),(0.794707,-1.27902,129),(0.794708,-1.28018,129),(0.7918,-1.28397,129),(0.808408,-1.26652,129),(0.79558,-1.27989,129),(0.796555,-1.28853,129),(0.795259,-1.2899,129),(0.796163,-1.2732,129),(0.790927,-1.27873,129),(0.799018,-1.29161,129),(0.790158,-1.1531,126),(0.854386,-1.38683,129),(0.794126,-1.28571,129),(0.792381,-1.29386,129),(0.789763,-1.29386,129),(0.884878,-2.08222,161),(0.750119,-1.43822,159),(0.90961,-1.86112,143),(0.811871,-1.47189,159),(0.876157,-1.15859,129),(0.812743,-1.26971,129),(0.792381,-1.25488,129),(0.934045,-1.97778,92),(0.803434,-1.27611,129),(0.934335,-1.98826,92),(0.93608,-1.98331,92),(0.753403,-1.38317,159),(0.756893,-1.41284,159),(0.74654,-1.41686,159),(0.857067,-2.1437,161),(0.95149,-2.24455,161),(0.797616,-1.28539,129),(0.75253,-1.38229,159),(0.844741,-1.55887,157),(0.845906,-1.41953,159),(0.762711,-1.38608,159),(0.808961,-1.26622,129),(0.791801,-1.10419,104),(0.839507,-1.35757,129),(0.859569,-2.14884,161),(0.797325,-1.28164,129),(0.792381,-1.29211,129),(0.765084,-1.38751,159),(0.877169,-2.08164,161),(0.845314,-2.1532,161),(0.803725,-1.25604,129),(0.758639,-1.40528,159),(0.750202,-1.38317,159),(0.793835,-1.28455,129),(1.0597,-2.35713,162),(0.855497,-2.14331,161),(0.738276,-1.44891,159),(0.870647,-1.69554,163),(0.75282,-1.40935,159),(1.09006,-1.99583,164),(0.8939,-1.7884,143),(0.779208,-1.10955,104),(0.830165,-0.919951,151),(0.817028,-1.24293,129),(0.816871,-1.24229,129),(0.845591,-1.19597,129),(0.834799,-1.2136,129),(0.805209,-1.05039,96),(0.816708,-1.24533,129),(0.826827,-1.1925,126),(0.804487,-1.24451,129),(0.779681,-1.10785,104),(0.879015,-2.08305,161),(0.870265,-2.08712,161),(0.814487,-1.23424,129),(0.845027,-1.24353,129),(0.815778,-1.24706,129),(0.856771,-2.14819,161),(0.858086,-2.14048,161),(0.754297,-1.39604,159),(-0.212176,1.68987,317),(0.0141408,0.426447,35),(0.0530084,0.515492,35),(0.0374963,0.488599,35),(-0.0594576,0.508691,35),(-0.111984,0.363028,35),(-0.0274647,0.506931,35),(-0.122173,0.40928,35),(-0.0846811,0.376284,35),(-0.107094,0.41172,35),(-0.0868307,0.409173,35),(-0.0934132,0.373883,35),(-0.0940333,0.449402,35),(-0.0607956,0.408989,35),(0.0375467,0.375538,30),(-0.0939916,0.471244,35),(0.00899333,0.439666,35),(-0.0514872,0.452913,35),(-0.0772729,0.465419,35),(-0.132063,0.422079,35),(-0.102909,0.391243,35),(-0.0628319,0.465421,35),(-0.152518,0.436168,35),(-0.103803,0.509544,35),(-0.107047,0.427315,35),(-0.0430805,0.503077,35),(-0.105592,0.469785,35),(0.0484139,0.481991,35),(-0.0753401,0.359247,35),(-0.029307,0.510034,35),(0.0746826,0.366569,30),(-0.11781,0.418006,35),(-0.0959186,0.388678,35),(0.00247208,0.511227,35),(0.0486217,0.43162,35),(0.0582701,0.364525,30),(0.0272168,0.528001,35),(0.0381827,0.392145,30),(-0.0437786,0.503717,35),(-0.16057,0.451168,35),(0.0665775,0.41341,35),(-0.00491537,0.364434,30),(0.00857184,0.514402,35),(0.0216262,0.412177,35),(0.0478006,0.415096,35),(-0.203521,0.479606,35),(-0.191661,0.466585,35),(-0.187009,0.444478,35),(-0.205367,0.475311,35),(-0.189829,0.464204,35),(-0.0869755,0.225729,30),(-0.0474148,0.308632,30),(-0.0526508,0.294961,30),(-0.0917759,0.259328,30),(0.000849103,0.318703,30),(-0.10122,0.234584,30),(-0.0706858,0.340921,30),(0.0637625,0.325254,30),(-0.075423,0.267176,30),(-0.0879817,0.328404,30),(-0.113068,0.293518,30),(-0.08013,0.264781,30),(-0.0340339,0.318814,30),(0.0568368,0.345092,30),(-0.0794125,0.324631,30),(-0.0378155,0.283325,30),(-0.0578868,0.303106,30),(-0.0765084,0.26863,30),(0.0753811,0.369636,7),(0.109396,0.370441,7),(0.114185,0.383734,7),(0.0827516,0.398256,7),(0.10067,0.360858,7),(0.0997981,0.332902,7),(0.126409,0.286942,7),(0.0615606,0.279951,7),(0.067506,0.313971,7),(0.121992,0.334884,7),(0.0865814,0.326438,7),(0.086235,0.276922,7),(0.110293,0.285884,7),(0.103569,0.272201,7),(0.113318,0.30465,7),(0.0753785,0.304901,7),(0.0742936,0.321417,7),(0.0743713,0.275625,7),(0.127423,0.319104,7),(0.0761176,0.323845,7),(-0.0642616,0.232999,11),(-0.0833585,0.207057,11),(-0.00841126,0.277505,11),(0.0281628,0.280154,11),(-0.051497,0.222113,11),(-0.0724942,0.236492,11),(-0.0732749,0.221075,11),(-0.0830098,0.206957,11),(-0.0727027,0.232003,11),(0.0285895,0.315323,11),(-0.0327492,0.276887,11),(-0.074458,0.266742,11),(0.826704,0.149226,314),(0.823314,0.148657,314),(0.816439,0.11591,314),(0.829031,0.152716,314),(0.82836,0.157874,314),(0.828517,0.145148,314),(0.8109,0.119438,314),(0.806639,0.106203,314),(0.826363,0.152209,314),(0.815962,0.133023,314),(0.816431,0.133212,314),(0.80685,0.128446,314),(0.827667,0.149187,314),(0.832475,0.150708,314),(0.827703,0.163621,314),(0.812274,0.114984,314),(0.824242,0.153978,314),(0.811757,0.116271,314),(0.806061,0.106497,314),(0.826413,0.137938,314),(0.82743,0.149096,314),(0.809539,0.108901,314),(0.820161,0.120969,314),(0.829428,0.133432,314),(0.810409,0.120627,314),(0.80731,0.121486,314),(0.80694,0.10612,314),(0.821186,0.144973,314),(0.803027,0.156382,314),(0.821177,0.144212,314),(0.810623,0.120412,314),(0.811857,0.115765,314),(0.822049,0.119134,314),(0.820922,0.144449,314),(0.831649,0.160279,314),(0.818985,0.129409,314),(0.828185,0.149835,314),(0.824316,0.154267,314),(0.824769,0.150103,314),(0.827341,0.148302,314),(0.827044,0.161952,314),(0.823658,0.129082,314),(0.827582,0.161465,314),(0.806381,0.107263,314),(0.816855,0.124813,314),(0.830046,0.155309,314),(0.82172,0.144946,314),(0.827238,0.150425,314),(0.827315,0.14661,314),(0.817684,0.16638,314),(0.80601,0.107149,314),(0.822616,0.126434,314),(0.819399,0.129982,314),(0.806216,0.157377,314),(0.830051,0.132179,314),(0.828566,0.144966,314),(0.82373,0.148869,314),(0.826894,0.148724,314),(0.829917,0.131528,314),(0.825715,0.148783,314),(0.827156,0.140398,314),(0.830407,0.133462,314),(0.827199,0.148794,314),(0.827603,0.148566,314),(0.826241,0.1489,314),(0.826829,0.148556,314),(0.827204,0.149002,314),(0.826832,0.14818,314),(0.827102,0.148097,314),(0.828943,0.152185,314),(0.827351,0.149681,314),(0.828621,0.153065,314),(0.82655,0.148405,314),(0.827692,0.148731,314),(0.82698,0.148003,314),(0.829327,0.153041,314),(0.827421,0.148362,314),(0.826196,0.148721,314),(0.826497,0.149417,314),(0.82682,0.149756,314),(0.82715,0.149118,314),(0.806164,0.106717,314),(0.129683,-0.105602,1),(0.119041,-0.0920965,1),(0.128839,-0.113059,1),(0.114459,-0.0875752,1),(0.144571,-0.134099,1),(0.182931,-0.111822,1),(0.102946,-0.084176,1),(0.136194,-0.0552976,1),(0.077195,-0.128331,1),(0.115483,-0.103265,1),(0.0863938,-0.106174,1),(0.0828771,-0.115825,1),(0.130108,-0.0923738,1),(0.111406,-0.0945548,1),(0.165895,-0.132022,1),(0.140649,-0.108031,1),(0.129373,-0.131839,1),(0.102058,-0.0991696,1),(0.165074,-0.0982552,1),(0.142022,-0.0890284,1),(0.113311,-0.11494,1),(0.114209,-0.130786,1),(0.0909631,-0.0652551,1),(0.110311,-0.0689815,1),(0.107022,-0.103858,1),(0.167426,-0.090661,1),(0.11767,-0.128267,1),(0.101882,-0.0935013,1),(0.116008,-0.0821211,1),(0.123205,-0.0691691,1),(0.126703,-0.142331,1),(0.120033,-0.112578,1),(0.0929486,-0.0763904,1),(0.166184,-0.113218,1),(0.161779,-0.0522744,1),(0.134283,-0.0877955,1),(0.122006,-0.100255,1),(0.092022,-0.0627664,1),(0.116095,-0.0733747,1),(0.140328,-0.0488697,1),(0.0934765,-0.0678125,1),(0.135073,-0.132885,1),(0.133936,-0.0974044,1),(0.122388,-0.130662,1),(0.116473,-0.0692787,1),(0.0958992,-0.0707178,1),(0.111426,-0.0678512,1),(0.124462,-0.055923,1),(0.103463,-0.073534,1),(0.106586,-0.0674036,1),(0.092264,-0.057666,1),(0.0954309,-0.0559746,1),(0.0945293,-0.0700907,1),(0.0926711,-0.0700341,1),(0.117456,-0.0610235,1),(0.138948,-0.116467,1),(0.100977,-0.115337,1),(-0.370146,-2.7886,342),(-0.576387,-1.24882,147),(-0.685665,-1.26061,147),(-0.576696,-1.2457,147),(-0.667007,-1.26245,147),(-0.576645,-1.25013,147),(-0.498655,-1.23496,147),(-0.694889,-1.27838,147),(-0.639081,-1.27322,147),(-0.385578,-1.22518,147),(-0.676024,-1.26711,147),(-0.640827,-1.27613,147),(-0.618428,-1.25082,147),(-0.587594,-1.23802,147),(-0.600975,-1.24064,147),(-0.583934,-1.23304,147),(-0.604466,-1.24558,147),(-0.621337,-1.25227,147),(-0.571595,-1.23453,147),(-0.635732,-1.2559,147),(-0.586431,-1.23424,147),(-0.586314,-1.25003,147),(-0.703659,-1.27351,147),(-0.600684,-1.23686,147),(-0.596393,-1.23472,147),(-0.576744,-1.24703,147),(-0.573922,-1.24384,147),(-0.927643,-1.23773,147),(-0.721161,-1.27384,147),(-0.752528,-1.28485,147),(-0.902748,-1.26514,147),(-0.723785,-1.27313,147),(-0.792379,-1.26885,147),(-0.586722,-1.23191,147),(-0.685604,-1.25584,147),(-0.641118,-1.2738,147),(-0.586722,-1.23773,147),(-0.630937,-1.25373,147),(-0.691732,-1.26245,147),(-0.590212,-1.23482,147),(-0.534042,-1.24268,147),(-0.708022,-1.27671,147),(-0.676024,-1.27322,147),(-0.654498,-1.26827,147),(-0.65828,-1.26071,147),(-0.612902,-1.24413,147),(-0.588176,-1.24297,147),(-0.596612,-1.23337,147),(-0.647226,-1.277,147),(-0.653917,-1.26275,147),(-0.573056,-1.23217,147),(-0.687078,-1.26769,147),(-0.573341,-1.2386,147),(-0.625701,-1.24966,147),(-0.57625,-1.24384,147),(-0.656535,-1.28543,147),(-0.672243,-1.26449,147),(-0.703077,-1.27554,147),(-0.521989,-1.24362,147),(-0.580904,-1.23744,147),(-0.566402,-1.24322,147),(-0.650426,-1.26885,147),(-0.35292,-1.22423,147),(-0.552062,-1.24207,147),(-0.572177,-1.24297,147),(-0.594576,-1.23453,147),(-0.717797,-1.27485,147),(-0.587885,-1.23947,147),(-0.460185,-1.2226,147),(-0.610574,-1.24326,147),(-0.653917,-1.2802,147),(-0.646063,-1.27642,147),(-0.522784,-1.24518,147),(-0.477638,-1.22755,147),(-0.616683,-1.26391,147),(-0.642752,-1.27496,147),(-0.662352,-1.2642,147),(-0.795438,-1.25779,147),(-0.605629,-1.24006,147),(-0.638906,-1.25844,147),(-0.644317,-1.27438,147),(-0.627744,-1.26227,147),(-0.741278,-1.28759,147),(-0.585631,-1.24975,147),(-0.659734,-1.28107,147),(-0.392117,-1.20311,147),(-0.646354,-1.26362,147),(-0.588758,-1.23482,147),(-0.32245,-1.22704,147),(-0.650071,-1.27963,147),(-0.41277,-1.22871,147),(-0.659734,-1.26915,147),(-0.730764,-1.28841,147),(-0.694792,-1.2779,147),(-0.586139,-1.2328,147),(-0.583713,-1.23439,147),(0.0674861,0.201004,20),(0.180486,0.265864,20),(0.11141,0.175697,20),(0.0866847,0.18675,20),(0.0711134,0.163536,20),(0.112865,0.220493,20),(0.146646,0.24731,20),(0.0511963,0.209149,20),(0.0809677,0.168946,20),(0.0727221,0.201295,20),(0.0788308,0.210021,20),(0.0864758,0.173493,20),(0.1277,0.237074,20),(0.0817395,0.215839,20),(0.0748711,0.164241,20),(0.0714067,0.162567,20),(0.192791,0.246791,20),(0.187445,0.240888,20),(0.0893923,0.17386,20),(0.113737,0.249582,20),(0.0981884,0.178986,20),(0.0785677,0.166977,20),(0.0776672,0.207694,20),(0.0613775,0.200713,20),(0.184847,0.24986,20),(0.0845228,0.171421,20),(0.100426,0.16253,20),(0.0823481,0.16991,20),(0.0564323,0.187332,20),(0.0702355,0.16083,20),(0.157952,0.239692,20),(0.10821,0.186169,20),(0.0809187,0.16488,20),(0.0514872,0.173079,20),(0.210781,0.262334,20),(0.176438,0.252215,20),(0.173384,0.243449,20),(0.102683,0.253945,20),(0.162316,0.233874,20),(0.109083,0.179187,20),(0.0961305,0.185626,20),(0.0999917,0.190243,20),(0.0954433,0.17247,20),(0.0637045,0.187914,20),(0.0663225,0.17686,20),(0.0506145,0.194604,20),(0.0950435,0.175493,20),(0.0706556,0.169372,20),(0.0657408,0.174242,20),(0.0724783,0.161286,20),(0.187337,0.25498,20),(0.0798886,0.238841,20),(0.0861029,0.232129,20),(0.0773762,0.250746,20),(0.11781,0.20624,20),(0.0897258,0.183604,20),(0.077826,0.155381,20),(0.103894,0.177295,20),(0.102752,0.174751,20),(0.0955334,0.181826,20),(0.0829031,0.196059,20),(0.0899935,0.177654,20),(0.0657408,0.213803,20),(0.0741329,0.157162,20),(0.510509,1.55131,236),(0.693649,1.71945,180),(0.670497,1.3481,200),(0.543961,1.69704,236),(0.549779,1.6057,236),(0.51749,1.58999,236),(0.695223,1.70577,180),(0.688615,1.3261,200),(0.694932,1.71566,180),(0.647512,1.39499,200),(0.522932,1.58334,236),(0.764471,1.52892,236),(0.749328,1.55625,236),(0.773181,1.50156,236),(0.728287,1.44751,236),(0.728845,1.50355,236),(0.747001,1.63101,236),(0.768236,1.52396,236),(0.796452,1.48673,236),(0.70713,1.41832,200),(0.835431,1.53793,236),(0.717733,1.40088,200),(0.483224,1.86588,180),(0.617856,2.04143,227),(0.525712,1.82645,180),(0.512108,1.8287,180),(0.485783,1.97484,227),(0.5756,1.99019,227),(0.601266,2.01847,227),(0.51869,2.09862,227),(0.628226,2.08388,227),(0.69291,2.1466,227),(0.543109,2.10913,227),(0.587012,2.00073,227),(0.642572,2.05629,227),(0.425075,1.7897,180),(0.588244,2.07134,227),(0.427897,1.81107,180),(0.541159,2.09271,227),(0.528757,1.94612,227),(0.563398,2.07991,227),(0.562186,2.08488,227),(0.523066,2.12385,227),(0.606638,1.98354,227),(0.574897,2.0915,227),(0.476766,1.8102,180),(0.402319,1.96279,227),(0.694059,2.06647,227),(0.652041,2.10131,227),(0.371431,1.92584,236),(0.427838,2.05348,227),(0.679529,1.75321,180),(0.642116,2.06059,227),(0.630054,1.99542,227),(0.608504,2.05171,227),(0.560726,1.96793,227),(0.524471,2.11446,227),(0.596253,1.98032,227),(0.594486,1.89593,180),(0.547643,2.11105,227),(0.583768,1.96723,227),(0.542143,1.98558,227),(0.383816,1.75814,180),(0.598847,2.05862,227),(0.400214,1.95542,180),(0.611268,1.93719,227),(0.668296,1.91549,180),(0.395026,1.92248,180),(0.512865,1.85912,180),(0.657645,1.96754,227),(0.609624,2.0327,227),(0.675709,1.96799,227),(0.530844,1.97023,227),(0.414225,2.0016,227),(0.478714,1.95797,227),(0.512278,1.84821,180),(0.624561,2.07045,227),(0.543951,1.96495,227),(0.569491,2.0293,227),(0.540179,1.98182,227),(0.671394,1.85481,180),(0.606293,1.95274,227),(0.625027,1.9952,227),(0.640478,2.06786,227),(0.485783,1.99666,227),(0.553352,1.95924,227),(0.547519,2.09213,227),(0.536068,1.94228,227),(0.502073,1.82603,180),(0.64839,2.13599,227),(0.387419,1.91885,180),(0.620513,2.03904,227),(0.65508,2.11883,227),(0.604917,1.90641,180),(0.565438,2.08455,227),(0.432507,1.92841,180),(0.556149,2.1038,227),(0.660738,1.98205,227),(0.683078,2.04203,227),(0.630248,2.02066,227),(0.687029,2.04309,227),(0.582688,2.09658,227),(0.596561,2.04478,227),(0.355175,1.92211,236),(0.496602,2.05894,227),(0.496622,1.82762,180),(0.593703,1.98648,227),(0.540223,2.07267,227),(0.613706,1.96987,227),(0.349079,1.92499,180),(0.518654,1.96175,227),(0.438369,1.99491,227),(0.493729,2.04576,227),(0.670366,1.96757,227),(0.538725,2.00364,227),(0.637026,1.94962,227),(0.485276,2.00597,227),(0.567557,1.96092,227),(0.560648,1.99082,227),(0.616256,1.98736,227),(0.626583,2.05516,227),(0.541873,1.97468,227),(0.603879,2.07972,227),(0.661528,2.01068,227),(0.639081,1.77616,180),(0.484203,1.94247,227),(0.646872,1.9983,227),(0.570374,1.90271,180),(0.642238,2.06463,227),(0.520399,1.98037,227),(0.632658,2.03795,227),(0.404129,1.97033,227),(0.435702,2.06611,227),(0.58963,1.99869,227),(0.553031,1.98035,227),(0.486884,1.78483,180),(0.609401,2.07064,227),(0.607413,2.04398,227),(0.532959,2.10637,227),(0.606676,1.97172,227),(0.457107,1.87645,180),(0.526522,2.09891,227),(0.559072,2.07439,227),(0.539598,1.98793,227),(0.599307,1.89722,180),(0.530289,1.9792,227),(0.680417,2.04872,227),(0.565976,2.08672,227),(0.521563,1.99346,227),(0.503527,2.10719,227),(0.388806,1.98213,227),(0.500328,1.97019,227),(0.484038,1.96408,227),(0.486074,1.97048,227),(0.559242,1.9573,227),(0.590742,1.98056,227),(0.597921,1.90116,180),(0.427253,2.06092,227),(0.409861,1.94284,180),(0.558374,2.0289,227),(0.520991,2.01677,227),(0.550981,2.09943,227),(0.510819,2.09833,227),(0.506955,1.94915,227),(0.546926,2.06604,227),(0.53378,1.99433,227),(0.69228,1.86422,180),(0.689395,1.86247,180),(0.516631,2.06254,227),(0.488682,2.10603,227),(0.623563,2.03324,227),(0.495097,2.11813,227),(0.649151,2.13019,227),(0.602201,1.91129,180),(0.654528,2.13128,227),(0.64071,2.07872,227),(0.537629,1.89176,180),(0.328127,1.92679,180),(0.6262,2.09396,227),(0.69147,2.12944,227),(0.518562,2.06494,227),(0.491092,1.86436,180),(0.696479,2.03504,227),(0.476952,2.09813,227),(0.483757,1.90564,180),(0.540179,2.05571,227),(0.542694,1.83412,180),(0.540819,1.81408,180),(0.683161,2.04512,227),(0.61221,2.04468,227),(0.608247,2.04785,227),(0.454333,2.08739,227),(0.600965,2.0349,227),(0.691732,2.06269,227),(0.384527,1.95364,180),(0.693477,2.06734,227),(0.570519,1.96921,227),(0.681047,2.05333,227),(0.56707,2.09279,227),(0.660946,1.96455,227),(0.561414,2.09463,227),(0.388359,1.96838,180),(0.631552,2.04413,227),(0.587061,2.04167,227),(0.644967,2.06132,227),(0.553463,1.97856,227),(0.591504,2.0381,227),(0.591602,2.05832,227),(0.532465,1.8426,180),(0.54168,2.11559,227),(0.62219,2.04685,227),(0.643314,2.10359,227),(0.643677,2.07236,227),(0.684751,1.86348,180),(0.613852,2.07396,227),(0.569806,1.93344,227),(0.568396,1.93353,227),(0.401444,1.97357,227),(0.684765,1.85605,180),(0.400569,1.9785,227),(0.392993,1.97895,227),(0.426694,2.05619,227),(0.403423,1.98701,227),(0.612271,1.90397,180),(0.663948,1.99803,227),(0.393494,1.99087,227),(0.632527,2.01877,227),(0.522859,2.1345,227),(0.528961,1.95904,227),(0.397413,1.97129,227),(0.523791,2.10437,227),(0.477189,2.05047,227),(0.432842,1.9824,227),(0.607292,2.02601,227),(0.397621,2.01319,227),(0.407851,2.03706,227),(0.612179,2.05002,227),(0.544931,2.11984,227),(0.644695,1.9985,227),(0.318401,1.91122,180),(0.458125,2.05283,227),(0.575978,1.99586,227),(0.448986,2.08356,227),(0.410656,2.03094,227),(0.618327,2.08489,227),(0.675423,2.02622,227),(0.505438,2.07465,227),(0.444768,1.81136,180),(0.621279,2.04188,227),(0.434829,2.06971,227),(0.463788,1.95201,227),(0.650964,2.1088,227),(0.349168,1.92604,180),(0.503405,1.96092,227),(0.3831,1.89572,180),(0.580375,2.09288,227),(0.696939,2.08721,227),(0.433187,2.06951,227),(0.531473,2.0116,227),(0.586232,2.07728,227),(0.63004,2.10089,227),(0.413643,1.9728,227),(0.467196,1.95666,227),(0.623131,2.00722,227),(0.514179,2.09241,227),(0.444002,2.07712,227),(0.518654,1.98764,227),(0.397062,1.89339,180),(0.687577,2.12872,227),(0.506013,2.03623,227),(0.633259,2.03235,227),(0.619602,2.05305,227),(0.649306,1.95788,227),(0.482002,1.98706,227),(0.401317,2.00212,227),(0.4111,1.9268,180),(0.620276,1.86202,180),(0.64201,2.09346,227),(0.588847,1.97748,227),(0.635843,1.99264,227),(0.463348,1.77509,180),(0.624203,2.03839,227),(0.493056,1.96437,227),(0.652462,2.12203,227),(0.511192,2.11926,227),(0.521473,2.12144,227),(0.51633,1.83368,180),(0.512421,1.96179,227),(0.554734,1.95176,227),(0.575867,1.96407,227),(0.559034,2.10966,227),(0.487354,2.0688,227),(0.465043,2.06252,227),(0.398226,1.89048,180),(0.631489,2.06225,227),(0.547219,1.85115,180),(0.559582,2.07306,227),(0.652021,2.01366,227),(0.414113,1.95123,227),(0.398851,1.93423,180),(0.641379,2.06046,227),(0.537476,1.85153,180),(0.500619,2.02255,227),(0.425933,1.80542,180),(0.640827,2.05076,227),(0.572122,2.05886,227),(0.56651,1.99052,227),(0.549069,1.82831,180),(0.69707,2.02618,227),(0.623204,2.0582,227),(0.580603,2.03446,227),(0.424075,2.02645,227),(0.374498,1.93323,236),(0.436914,1.79134,180),(0.530953,1.95046,227),(0.544165,2.00769,227),(0.430819,1.98267,227),(0.677188,2.1165,227),(0.49883,2.11843,227),(0.605343,1.96269,227),(0.435623,2.07141,227),(0.404261,1.99445,227),(0.425962,1.91303,180),(0.585936,1.99029,227),(0.512862,1.81564,180),(0.545129,2.04693,227),(0.524494,1.77954,180),(0.404433,1.95971,227),(0.661116,2.00105,227),(0.484057,1.95467,227),(0.430606,1.78305,180),(0.657131,2.10013,227),(0.548571,2.08609,227),(0.49131,1.98328,227),(0.406849,2.02753,227),(0.496728,2.09283,227),(0.60001,1.90606,180),(0.611966,2.06547,227),(0.621342,1.80129,180),(0.692896,2.06705,227),(0.635731,1.99325,227),(0.637317,2.06891,227),(0.530857,1.80573,180),(0.643076,2.01955,227),(0.530973,2.09958,227),(0.503527,2.11388,227),(0.396316,1.92596,180),(0.347456,1.91438,180),(0.62987,1.94637,227),(0.482874,1.98095,227),(0.528835,1.89979,227),(0.406584,1.98668,227),(0.636066,2.02397,227),(0.432512,1.96144,227),(0.378181,1.90537,180),(0.434983,1.7887,180),(0.693453,2.02703,227),(0.377807,1.92478,236),(0.515959,1.81102,180),(0.460961,1.94771,227),(0.483248,1.94481,227),(0.460808,1.96976,227),(0.438317,1.9784,227),(0.565239,1.94897,227),(0.629303,1.81152,180),(0.509976,2.08527,227),(0.483253,1.94891,227),(0.689575,2.03671,227),(0.648768,2.09302,227),(0.64535,2.10685,227),(0.631683,2.0535,227),(0.413643,1.90706,180),(0.48286,2.10427,227),(0.437011,1.79277,180),(0.413602,1.80299,180),(0.407861,1.82003,180),(0.60735,1.99504,227),(0.617754,2.02612,227),(0.564045,2.11509,227),(0.518945,2.02429,227),(0.588758,2.01411,227),(0.494219,1.91492,227),(0.682424,2.12436,227),(0.47879,2.10498,227),(0.516702,1.9525,227),(0.560073,2.11313,227),(0.344339,1.91997,180),(0.405406,1.93428,180),(0.617934,2.03473,227),(0.508027,2.08837,227),(0.529712,1.95809,227),(0.663191,1.98995,227),(0.541639,1.95834,227),(0.534943,1.97397,227),(0.511289,2.04566,227),(0.671869,1.78327,180),(0.619631,1.9693,227),(0.639983,2.04199,227),(0.63512,2.10246,227),(0.511217,1.85449,180),(0.646198,1.95324,227),(0.580555,2.01343,227),(0.398114,2.02163,227),(0.620339,2.06743,227),(0.399319,2.02586,227),(0.536727,2.10749,227),(0.615049,1.97629,227),(0.633273,2.09445,227),(0.465334,2.08607,227),(0.472058,2.06517,227),(0.567339,2.09689,227),(0.492074,2.02081,227),(0.394153,1.97368,227),(0.444836,2.08041,227),(0.381354,1.95419,180),(0.473284,2.00677,227),(0.56622,1.84696,180),(0.538788,2.09602,227),(0.55036,2.08538,227),(0.564697,2.02971,227),(0.398266,1.98397,227),(0.40288,1.99666,227),(0.555209,2.12328,227),(0.402097,2.02964,227),(0.391931,1.97306,227),(0.377573,1.93004,236),(0.531453,2.00364,227),(0.499998,2.11638,227),(0.527162,2.00848,227),(0.403345,1.97998,227),(0.539037,1.99627,227),(0.526956,2.02502,227),(0.413242,2.04203,227),(0.693269,2.03033,227),(0.560726,2.00782,227),(0.575242,2.04493,227),(0.569438,2.04198,227),(0.417223,1.95814,227),(0.480828,1.91915,227),(0.583522,2.00771,227),(0.592966,2.0384,227),(0.473159,1.91978,227),(0.615107,2.01483,227),(0.523507,1.85454,180),(0.498975,1.9605,227),(0.408944,2.02161,227),(0.469285,1.9655,227),(0.658551,2.01937,227),(0.55613,2.04694,227),(0.589364,2.09879,227),(0.637627,1.99161,227),(0.626559,1.99304,227),(0.577229,1.86803,180),(0.472795,2.0882,227),(0.641772,2.08062,227),(0.528724,2.09721,227),(0.685022,2.05581,227),(0.6388,1.99784,227),(0.534943,1.9856,227),(0.618899,1.92735,180),(0.603564,2.07919,227),(0.500565,2.11958,227),(0.404802,2.03527,227),(0.43249,1.79028,180),(0.349866,1.92583,180),(0.693477,2.06676,227),(0.599798,1.87377,180),(0.504109,2.09498,227),(0.463967,1.86256,180),(0.587647,2.06279,227),(0.408276,1.92128,180),(0.441253,1.92486,180),(0.403108,1.91304,180),(0.563149,1.94839,227),(0.403462,1.97659,227),(0.551871,1.98964,227),(0.406767,1.80054,180),(0.382912,1.93463,236),(0.572282,2.08465,227),(0.537138,1.85185,180),(0.635009,2.09008,227),(0.593717,2.08023,227),(0.454857,2.08228,227),(0.574213,2.02138,227),(0.52453,2.09356,227),(0.654426,2.11635,227),(0.518402,1.87434,180),(0.401893,1.97452,227),(0.485396,2.00133,227),(0.605697,2.03483,227),(0.695223,2.06152,227),(0.525053,1.97688,227),(0.615413,2.05892,227),(0.692867,2.02445,227),(0.53058,2.00422,227),(0.528835,1.91084,227),(0.387171,1.96011,180),(0.45844,1.87652,180),(0.535293,1.9668,227),(0.405567,1.9466,180),(0.390483,1.9364,236),(0.653737,2.06796,227),(0.573381,2.0998,227),(0.694922,1.91947,180),(0.593407,2.09144,227),(0.400482,2.01833,227),(0.402279,1.98522,227),(0.625701,2.05425,227),(0.641874,2.11464,227),(0.67218,2.00705,227),(0.612058,2.01695,227),(0.653602,2.02969,227),(0.543324,1.82181,180),(0.533108,2.0937,227),(0.659885,2.1075,227),(0.570412,1.9562,227),(0.601358,1.97271,227),(0.579445,2.10239,227),(0.508405,1.92821,227),(0.525053,2.00626,227),(0.468949,1.74918,180),(0.544821,1.87625,180),(0.68141,1.85696,180),(0.569341,2.04314,227),(0.5176,2.11894,227),(0.620707,1.9985,227),(0.397907,1.99783,227),(0.567979,1.94619,227),(0.550822,2.06792,227),(0.587012,2.01033,227),(0.398645,1.97659,227),(0.679146,2.12236,227),(0.44855,1.74853,180),(0.564124,2.06469,227),(0.386881,1.95099,180),(0.511644,2.09573,227),(0.515968,1.8597,180),(0.51977,1.83002,180),(0.535079,2.05047,227),(0.450295,1.9728,227),(0.620978,2.07402,227),(0.556952,2.09899,227),(0.535234,1.81631,180),(0.409477,2.03802,227),(0.413034,2.03571,227),(0.551524,2.05716,227),(0.554724,2.09381,227),(0.614511,1.95021,227),(0.492183,1.97164,227),(0.638049,2.03727,227),(0.692968,2.07957,227),(0.50091,2.02138,227),(0.527608,2.01469,227),(0.468621,1.81921,180),(0.668752,2.03971,227),(0.53378,1.99026,227),(0.528618,1.95878,227),(0.591269,2.02057,227),(0.664389,2.03447,227),(0.636754,2.05658,227),(0.417129,1.86075,180),(0.652171,2.05978,227),(0.405331,1.89896,180),(0.476693,1.83773,180),(0.608223,2.06027,227),(0.574926,2.04833,227),(0.696517,2.03151,227),(0.374955,1.90415,180),(0.603336,1.84819,180),(0.695029,2.08598,227),(0.520554,1.85762,180),(0.579958,2.08234,227),(0.550658,1.84994,180),(0.67808,2.01569,227),(0.638063,1.81877,180),(0.38659,1.87157,180),(0.52387,2.1096,227),(0.426151,1.94633,180),(0.513127,1.95739,227),(0.458149,1.84889,180),(0.635896,2.0803,227),(0.532485,2.04292,227),(0.401649,1.82301,180),(0.545546,1.98406,227),(0.476814,1.92166,227),(0.409261,2.03647,227),(0.554433,1.82765,180),(0.546359,2.10479,227),(0.523786,2.13287,227),(0.54552,2.10345,227),(0.544426,2.10692,227),(0.372149,1.93004,236),(0.523451,2.11008,227),(0.626786,2.03002,227),(0.681178,2.12398,227),(0.511963,1.97383,227),(0.46194,1.95421,227),(0.800226,2.15194,188),(0.75933,2.15559,188),(0.797325,2.18719,188),(0.794125,2.18399,188),(0.804306,2.19882,188),(0.712269,2.00502,227),(0.837758,2.14181,227),(0.781907,2.20842,188),(0.835431,2.24857,188),(0.709735,2.13329,227),(0.808378,2.26136,188),(0.832522,2.24973,188),(0.722523,2.08813,227),(0.755587,2.19928,188),(0.748877,2.26034,188),(0.860156,2.10719,227),(0.708783,2.00791,227),(0.703242,2.15154,227),(0.84183,2.2602,188),(0.732878,2.14371,227),(0.767179,2.1898,188),(0.708895,2.1069,227),(0.767363,2.02516,227),(0.745905,2.17681,227),(0.720771,2.16632,227),(0.783902,2.21919,188),(0.756108,2.2648,188),(0.734081,2.2151,188),(0.817396,2.20784,188),(0.804306,2.13076,227),(0.7499,2.26618,188),(0.761182,2.13393,227),(0.738153,2.16144,227),(0.819432,2.23489,188),(0.791216,2.14297,188),(0.809542,2.15374,188),(0.817396,2.17148,188),(0.913389,2.17701,188),(0.72709,2.15267,227),(0.824668,2.21802,188),(0.814031,2.21651,188),(0.774926,2.28929,188),(0.736283,2.22493,188),(0.753342,2.17064,188),(0.700313,2.03584,227),(0.775217,2.2157,188),(0.813954,2.28907,188),(0.75964,2.19342,188),(0.791507,2.20406,188),(0.710451,1.92485,180),(0.729412,2.15431,227),(0.780162,2.22006,188),(0.78918,2.23344,188),(0.734464,2.20959,188),(0.707581,1.92878,180),(0.814196,2.17933,188),(0.799361,2.28376,188),(0.826253,2.16364,188),(0.814778,2.20057,188),(0.787442,2.17916,188),(0.733688,2.08198,227),(0.749483,2.20009,188),(0.718867,2.13016,227),(0.829322,2.14472,188),(0.858411,2.18544,188),(0.846194,2.17875,188),(0.71426,2.14334,227),(0.717299,2.10745,227),(0.822632,2.25613,188),(0.735075,2.07316,227),(0.778126,2.26195,188),(0.794997,2.3018,188),(0.752358,2.25011,188),(0.823214,2.19766,188),(0.74224,2.19345,188),(0.865683,2.0496,227),(0.746502,2.25886,188),(0.826069,2.14996,188),(0.812451,2.1837,188),(0.737228,2.19418,188),(0.75581,2.16993,188),(0.790634,2.27387,188),(0.729669,2.21496,188),(0.719774,2.08394,227),(0.812746,2.28892,188),(0.724418,2.14194,227),(0.748809,2.18403,188),(0.720331,2.14978,227),(0.807428,2.2041,188),(0.819432,2.24944,188),(0.698587,2.16994,227),(0.710848,2.1779,227),(0.742342,2.16491,227),(0.782143,2.14937,188),(0.790634,2.2858,188),(0.770607,2.1962,188),(0.716749,2.14588,227),(0.773472,2.21308,188),(0.717466,2.11432,227),(0.711472,2.10929,227),(0.716065,1.97407,180),(0.765341,2.20889,188),(0.78918,2.28784,188),(0.763208,2.22258,188),(0.817396,2.27504,188),(0.863065,2.05425,227),(0.879937,2.16624,227),(0.731855,2.15568,227),(0.748179,2.27518,188),(0.823868,2.15781,188),(0.802561,2.20959,188),(0.743903,2.20368,188),(0.720205,2.18806,227),(0.760236,2.23444,188),(0.806633,2.27795,188),(0.749852,2.21217,188),(0.810996,2.17933,188),(0.712279,1.9487,180),(0.788889,2.28493,188),(0.742459,2.25143,188),(0.727613,2.13127,227),(0.876926,2.22512,188),(0.827286,2.27533,188),(0.798488,2.21046,188),(0.828159,2.2154,188),(0.778126,2.25875,188),(0.858702,2.08916,227),(0.712995,2.14235,227),(0.759231,2.17852,188),(0.717621,2.15461,227),(0.886336,2.12087,227),(0.83627,2.15553,188),(0.844095,2.34379,188),(0.810414,2.21802,188),(0.833976,2.17206,188),(0.788598,2.17846,188),(0.734066,2.12485,227),(0.73331,2.12335,227),(0.730522,2.16287,227),(0.815447,2.28882,188),(0.824843,2.3044,188),(0.705801,1.9749,180),(0.830486,2.28347,188),(0.706049,2.16546,227),(0.761793,1.95436,227),(0.729136,2.19967,188),(0.756993,2.23825,188),(0.76903,2.28849,188),(0.7298,2.15681,227),(0.744214,2.19059,188),(0.791798,2.28289,188),(0.777253,2.19388,188),(0.699766,1.97731,227),(0.755844,2.24295,188),(0.709255,2.13807,227),(0.813033,2.18166,188),(0.700386,2.1711,227),(0.71847,2.11825,227),(0.794125,2.16944,188),(0.737722,2.07631,227),(0.791216,2.28754,188),(0.715105,2.05837,227),(0.744596,2.19957,188),(0.725538,2.1024,227),(0.746632,2.16587,227),(0.701947,2.02842,227),(0.772576,2.16422,188),(0.76585,2.1873,188),(0.781326,2.26369,188),(0.798779,2.27795,188),(0.798537,2.22494,188),(0.720622,2.16011,227),(0.729407,2.10799,227),(0.804306,2.22355,188),(0.709515,1.91676,180),(0.812601,2.29379,188),(0.80864,2.30752,188),(0.784235,2.27824,188),(0.760673,2.22646,188),(0.830486,2.20057,188),(0.796161,2.14356,188),(0.732045,2.2066,188),(0.717742,2.14658,227),(0.809833,2.18719,188),(0.882555,2.15926,227),(0.794918,2.21617,188),(0.366946,1.92678,236),(0.55233,2.10735,227),(0.435429,1.99082,227),(0.53842,2.11055,227),(0.487568,1.91287,227),(0.628232,2.08397,227),(0.691301,1.91605,180),(0.0876518,-1.29163,76),(0.0767006,-1.3277,76),(0.13072,-1.30671,76),(0.0625236,-1.33503,76),(0.0931613,-1.26355,76),(0.121531,-1.31628,76),(0.0883559,-1.32421,76),(0.0874211,-1.29979,76),(0.0722915,-1.28503,76),(0.136727,-1.26491,76),(0.185097,-1.27374,76),(0.0922115,-1.25606,76),(0.0880505,-1.31798,76),(0.182616,-1.27851,76),(0.110221,-1.32879,76),(0.0926653,-1.28833,76),(0.141261,-1.33914,76),(0.180283,-1.31618,76),(0.0190649,-1.35474,76),(0.0966089,-1.28051,76),(0.0313917,-1.37559,76),(0.0712908,-1.32986,76),(0.166224,-1.31914,76),(0.142656,-1.32748,76),(0.112766,-1.25193,76),(0.153787,-1.30412,76),(0.0996691,-1.31442,76),(0.190563,-1.30489,76),(0.099734,-1.27294,76),(0.112895,-1.27863,76),(0.0799251,-1.29533,76),(0.162398,-1.31594,76),(0.161337,-1.31156,76),(0.0782649,-1.29582,76),(0.0744252,-1.32524,76),(0.123568,-1.30374,76),(0.107134,-1.31361,76),(0.187758,-1.30471,76),(0.0849637,-1.31984,76),(0.0525248,-1.33491,76),(0.196189,-1.29502,76),(0.180191,-1.3083,76),(0.169923,-1.31818,76),(0.0645138,-1.2863,76),(0.151141,-1.31123,76),(0.173687,-1.31043,76),(0.187991,-1.27415,76),(0.171525,-1.31112,76),(0.114419,-1.27641,76),(0.153515,-1.32121,76),(0.135992,-1.30504,76),(0.155841,-1.30947,76),(0.219645,-1.42594,76),(0.160284,-1.31566,76),(0.0943757,-1.31751,76),(0.15614,-1.31672,76),(0.107365,-1.31976,76),(0.185522,-1.30761,76),(0.188341,-1.30482,76),(0.0770137,-1.32915,76),(0.0946255,-1.32127,76),(0.107428,-1.31552,76),(0.201488,-1.27247,76),(0.183119,-1.31125,76),(0.0806876,-1.32231,76),(0.0993916,-1.33799,76),(0.056394,-1.33372,76),(0.145973,-1.26373,76),(0.0712881,-1.27332,76),(0.191773,-1.30821,76),(0.104298,-1.30181,76),(0.113299,-1.29858,76),(0.00895843,-1.33519,76),(0.0597096,-1.33072,76),(0.0425551,-1.33715,76),(0.146865,-1.31927,76),(0.182591,-1.3023,76),(0.0322827,-1.32729,76),(0.121962,-1.27495,76),(0.0840085,-1.32115,76),(0.03611,-1.34482,76),(0.0211815,-1.34881,76),(0.128729,-1.26795,76),(0.0617749,-1.33175,76),(0.187458,-1.30471,76),(0.0463336,-1.32632,76),(0.0895839,-1.29433,76),(0.143776,-1.2803,76),(0.051091,-1.31392,76),(0.0821338,-1.29556,76),(0.144429,-1.28925,76),(0.152681,-1.32438,76),(0.0796985,-1.32211,76),(0.139328,-1.31638,76),(0.161302,-1.29899,76),(0.0200596,-1.33774,76),(0.0733867,-1.30273,76),(0.109115,-1.31883,76),(0.0907377,-1.30713,76),(0.107749,-1.31486,76),(0.17424,-1.31426,76),(0.0929339,-1.31174,76),(0.0884688,-1.31803,76),(0.189535,-1.30505,76),(0.11692,-1.26942,76),(0.198674,-1.26088,76),(0.161304,-1.30472,76),(0.0825967,-1.29615,76),(0.136798,-1.26543,76),(0.161207,-1.3232,76),(0.0859016,-1.31008,76),(-0.0735705,-1.22069,76),(0.0848652,-1.30742,76),(0.0855162,-1.3244,76),(0.0791126,-1.32825,76),(0.0280038,-1.3462,76),(0.0777134,-1.32274,76),(0.0417729,-1.32457,76),(0.0919207,-1.29009,76),(0.166893,-1.27992,76),(0.107472,-1.32022,76),(0.0950826,-1.30312,76),(0.105258,-1.31653,76),(0.0569106,-1.33579,76),(0.107942,-1.31945,76),(0.0144894,-1.35524,76),(0.0774732,-1.31305,76),(0.0909065,-1.30439,76),(0.0656912,-1.33226,76),(0.0617604,-1.28632,76),(0.123363,-1.27705,76),(0.0750258,-1.30559,76),(0.0383262,-1.31995,76),(0.190186,-1.30701,76),(0.0756855,-1.29789,76),(0.0823164,-1.29524,76),(0.18362,-1.29477,76),(0.0899305,-1.30963,76),(0.189998,-1.27145,76),(0.123259,-1.2756,76),(0.0579851,-1.33055,76),(0.0281762,-1.31958,76),(0.0749467,-1.30584,76),(0.0840144,-1.29773,76),(0.0724179,-1.30698,76),(0.10779,-1.31932,76),(0.185203,-1.29623,76),(0.177156,-1.29087,76),(0.0432302,-1.36329,76),(0.0643239,-1.33193,76),(0.169601,-1.3111,76),(0.1571,-1.29112,76),(0.132518,-1.30566,76),(0.101657,-1.27469,76),(0.0844593,-1.32064,76),(0.160569,-1.28356,76),(0.137775,-1.2655,76),(0.162578,-1.31411,76),(0.055398,-1.33099,76),(0.110764,-1.31788,76),(0.0806148,-1.32009,76),(0.154888,-1.31982,76),(0.192109,-1.29587,76),(0.163404,-1.28462,76),(0.0980242,-1.28836,76),(0.158924,-1.31595,76),(0.086961,-1.31953,76),(0.161579,-1.28827,76),(0.133804,-1.33834,76),(0.0848014,-1.29257,76),(0.0649812,-1.31743,76),(0.155069,-1.32279,76),(0.139391,-1.31237,76),(0.0828401,-1.32491,76),(0.181509,-1.31798,76),(0.106157,-1.31485,76),(0.0594583,-1.33253,76),(0.181132,-1.30696,76),(0.0468602,-1.31464,76),(0.0599908,-1.33557,76),(0.106309,-1.32009,76),(0.0790545,-1.32018,76),(0.0858452,-1.29203,76),(0.0756146,-1.32342,76),(0.0680834,-1.33165,76),(0.0677205,-1.34445,76),(0.0625409,-1.3439,76),(0.124362,-1.27618,76),(0.0804546,-1.29297,76),(0.110607,-1.31874,76),(0.0907725,-1.32416,76),(0.191356,-1.30544,76),(0.191245,-1.27038,76),(0.123312,-1.28901,76),(0.112366,-1.31478,76),(0.103527,-1.28483,76),(0.188392,-1.30754,76),(0.145102,-1.31144,76),(0.0791313,-1.32088,76),(0.178974,-1.315,76),(0.178896,-1.29154,76),(0.123652,-1.23498,76),(0.184862,-1.29486,76),(0.137584,-1.33737,76),(0.0930746,-1.3228,76),(0.0987176,-1.32433,76),(0.0727909,-1.32935,76),(0.0902827,-1.26619,76),(0.0979411,-1.31696,76),(0.14501,-1.28485,76),(0.0695854,-1.28732,76),(0.0481189,-1.33722,76),(0.135411,-1.33784,76),(0.10217,-1.32689,76),(0.175128,-1.27821,76),(0.170873,-1.3052,76),(0.0449049,-1.26791,76),(0.172869,-1.46055,85),(0.170104,-1.47016,85),(0.176234,-1.45746,85),(0.173838,-1.46691,85),(0.172361,-1.46741,85),(0.171583,-1.47114,85),(0.174089,-1.46974,85),(0.173274,-1.46847,85),(0.173281,-1.46696,85),(0.174456,-1.46776,85),(0.172285,-1.46714,85),(0.172391,-1.46755,85),(0.17383,-1.4675,85),(0.191144,-1.48591,85),(0.173369,-1.46753,85),(0.163574,-1.46091,85),(0.174411,-1.46833,85),(0.172873,-1.46792,85),(0.17277,-1.46613,85),(0.180184,-1.47353,85),(0.173801,-1.46661,85),(0.174118,-1.48071,85),(0.174533,-1.44921,85),(0.172451,-1.46669,85),(0.171711,-1.46373,85),(0.177121,-1.49142,85),(0.174654,-1.46841,85),(0.185616,-1.49117,85),(0.173965,-1.46631,85),(0.174533,-1.46811,85),(0.178301,-1.46235,85),(0.173592,-1.467,85),(0.174436,-1.47768,85),(0.172993,-1.46667,85),(0.173676,-1.46756,85),(0.174234,-1.47956,85),(0.172206,-1.46462,85),(0.182027,-1.48515,85),(0.17366,-1.46724,85),(0.172068,-1.46769,85),(0.174824,-1.46986,85),(0.173863,-1.46693,85),(0.35387,-1.34309,105),(0.389684,-1.38296,105),(0.39473,-1.46098,105),(0.371047,-1.36391,105),(0.379352,-1.37526,105),(0.404107,-1.4181,105),(0.397853,-1.4231,105),(0.380516,-1.39599,105),(0.370621,-1.35309,105),(0.394212,-1.40052,105),(0.400902,-1.43792,105),(0.349497,-1.32334,105),(0.36154,-1.36128,105),(0.404112,-1.42984,105);
/*&*/
INSERT INTO `x2_timezone_points` VALUES (0.390954,-1.39568,105),(0.402584,-1.43631,105),(0.352338,-1.32385,105),(0.400752,-1.43381,105),(0.382746,-1.38653,105),(0.396437,-1.44946,105),(0.399525,-1.43988,105),(0.398051,-1.39758,105),(0.359223,-1.31321,105),(0.389921,-1.40599,105),(0.355465,-1.30929,105),(0.358845,-1.34244,105),(0.392607,-1.38834,105),(0.403607,-1.43696,105),(0.390556,-1.39886,105),(0.369923,-1.33697,105),(0.383046,-1.36883,105),(0.389417,-1.39021,105),(0.391259,-1.46081,105),(0.397397,-1.41405,105),(0.396665,-1.41878,105),(0.38819,-1.40308,105),(0.352857,-1.32643,105),(0.376036,-1.34852,105),(0.381936,-1.44513,105),(0.349817,-1.35407,105),(0.385883,-1.37231,105),(0.360532,-1.30795,105),(0.374955,-1.35467,105),(0.351543,-1.3515,105),(0.402143,-1.4238,105),(0.401208,-1.44432,105),(0.355058,-1.34594,105),(0.386581,-1.3958,105),(0.399879,-1.42866,105),(0.394221,-1.45296,105),(0.36585,-1.34305,105),(0.399181,-1.43857,105),(0.403747,-1.43786,105),(0.398013,-1.41711,105),(0.365981,-1.33168,105),(0.355465,-1.33391,105),(0.382959,-1.38178,105),(0.402177,-1.43136,105),(0.393169,-1.41596,105),(0.364551,-1.33104,105),(0.353516,-1.33585,105),(0.39777,-1.43999,105),(0.398565,-1.43166,105),(0.351587,-1.31265,105),(0.387507,-1.4676,105),(0.400141,-1.44317,105),(0.403588,-1.43641,105),(0.367392,-1.35001,105),(0.368434,-1.32875,105),(0.385786,-1.39141,105),(0.375677,-1.3653,105),(0.381398,-1.3634,105),(0.39474,-1.39401,105),(0.386581,-1.39979,105),(0.360304,-1.32533,105),(0.389926,-1.40092,105),(0.401111,-1.40648,105),(0.354263,-1.33066,105),(0.392781,-1.45759,105),(0.38182,-1.39348,105),(0.396524,-1.41207,105),(0.366311,-1.3514,105),(0.39523,-1.39707,105),(0.386523,-1.40387,105),(0.38118,-1.37466,105),(0.387337,-1.3773,105),(0.403321,-1.43776,105),(0.40208,-1.41729,105),(0.353153,-1.34877,105),(0.392408,-1.3919,105),(0.373166,-1.35991,105),(0.393281,-1.41208,105),(0.393058,-1.38696,105),(0.385349,-1.38752,105),(0.40018,-1.43795,105),(0.355684,-1.33768,105),(0.401125,-1.44071,105),(0.378678,-1.3724,105),(0.355116,-1.3002,105),(0.365865,-1.32154,105),(0.399743,-1.4514,105),(0.398163,-1.44447,105),(0.398037,-1.44137,105),(0.404189,-1.436,105),(0.390692,-1.41111,105),(0.388816,-1.40617,105),(0.404204,-1.43694,105),(0.40384,-1.43753,105),(0.4037,-1.43733,105),(0.362185,-1.32692,105),(0.401677,-1.43646,105),(0.401551,-1.43818,105),(0.402963,-1.43745,105),(0.289725,-0.39968,245),(0.260604,-0.410371,245),(0.294789,-0.435991,245),(0.211331,-1.20312,87),(-0.181893,1.84445,316),(0.611083,0.59443,212),(0.606793,0.565778,212),(0.613774,0.582358,212),(0.605193,0.57654,212),(0.609411,0.58694,212),(0.616829,0.581486,212),(0.613047,0.592539,212),(0.8802,0.276007,293),(0.852689,0.280104,293),(0.859167,0.308336,293),(0.858993,0.308342,293),(0.865461,0.278069,293),(0.865031,0.278192,293),(0.878375,0.236418,293),(0.860054,0.296688,293),(0.861123,0.314093,293),(0.888574,0.255136,293),(0.863446,0.313655,293),(0.872209,0.286122,293),(0.884196,0.244909,293),(0.85565,0.308001,293),(0.856429,0.304729,293),(0.882456,0.277729,293),(0.867038,0.325867,293),(0.858962,0.277187,293),(0.883842,0.241283,293),(0.862444,0.255827,293),(0.868405,0.287426,293),(0.872059,0.296193,293),(0.859774,0.242642,293),(0.871214,0.320027,293),(0.875829,0.220611,293),(0.876687,0.245863,293),(0.863214,0.316655,293),(0.874475,0.239693,293),(0.863447,0.298658,293),(0.874701,0.253073,293),(0.867252,0.244528,293),(0.863155,0.304576,293),(0.874201,0.25169,293),(0.868257,0.233483,293),(0.860601,0.24692,293),(0.86274,0.265698,293),(0.873376,0.275353,293),(0.858993,0.305724,293),(0.858865,0.306121,293),(0.878004,0.225829,293),(0.869779,0.319082,293),(0.869964,0.321666,293),(0.871594,0.312459,293),(0.865605,0.3011,293),(0.865585,0.314339,293),(0.87719,0.25338,293),(0.879937,0.282096,293),(0.881444,0.237996,293),(0.872859,0.251495,293),(0.879844,0.26011,293),(0.878782,0.252621,293),(0.878895,0.240797,293),(0.88321,0.237681,293),(0.881976,0.246646,293),(0.886053,0.26278,293),(0.874553,0.252629,293),(0.874992,0.253364,293),(0.871764,0.26648,293),(0.86041,0.303567,293),(0.87423,0.30899,293),(0.876872,0.249783,293),(0.865674,0.316687,293),(0.873156,0.2653,293),(0.862114,0.232042,293),(0.879375,0.229882,293),(0.875236,0.246141,293),(0.870116,0.323614,293),(0.876726,0.224644,293),(0.879355,0.231547,293),(0.879227,0.231628,293),(0.881388,0.234706,293),(0.857725,0.261852,293),(0.862125,0.272118,293),(0.880296,0.267936,293),(0.885306,0.264785,293),(0.864775,0.309529,293),(0.876316,0.276334,293),(0.852575,0.299017,293),(0.86582,0.271934,293),(0.868822,0.321784,293),(0.867138,0.320268,293),(0.886316,0.248095,293),(0.871811,0.275685,293),(0.880702,0.234185,293),(0.874054,0.215966,293),(0.868234,0.325087,293),(0.854766,0.252625,293),(0.870995,0.287004,293),(0.884629,0.25373,293),(0.872463,0.304817,293),(0.858619,0.289864,293),(0.851005,0.294647,293),(0.873292,0.251543,293),(0.87593,0.255922,293),(0.870991,0.3204,293),(0.861548,0.290501,293),(0.882264,0.240274,293),(0.882238,0.240425,293),(0.872033,0.245603,293),(0.868853,0.256336,293),(0.874493,0.254464,293),(0.885464,0.218166,264),(0.859575,0.128573,264),(0.884882,0.116064,264),(0.911353,0.234747,264),(0.888333,0.258442,264),(0.862933,0.191186,264),(0.906981,0.210926,264),(0.890991,0.212058,264),(0.915134,0.231256,264),(0.901753,0.112574,264),(0.896518,0.222239,264),(0.868961,0.173418,264),(0.886918,0.107047,264),(0.894772,0.125373,264),(0.915134,0.164352,264),(0.895063,0.123046,264),(0.856225,0.143965,264),(0.866304,0.145905,264),(0.915134,0.188496,264),(0.836238,0.199346,264),(0.91048,0.184132,264),(0.901753,0.214385,264),(0.895936,0.172206,264),(0.927838,0.217867,264),(0.935091,0.135759,264),(0.872374,0.120137,264),(0.925119,0.205082,264),(0.917924,0.2325,264),(0.897681,0.127991,264),(0.940613,0.19989,264),(0.892154,0.129154,264),(0.935496,0.174533,264),(0.931265,0.178247,264),(0.853041,0.164029,264),(0.886918,0.141372,264),(0.916007,0.23242,264),(0.894772,0.114319,264),(0.916728,0.229983,264),(0.934274,0.14159,264),(0.923279,0.147189,264),(0.860409,0.151868,264),(0.874119,0.14399,264),(0.889245,0.131481,264),(0.882264,0.148353,264),(0.896808,0.129154,264),(0.929388,0.138463,264),(0.916596,0.231716,264),(0.887209,0.121882,264),(0.901753,0.115483,264),(0.868432,0.165971,264),(0.904662,0.188205,264),(0.901715,0.133242,264),(0.892736,0.125955,264),(0.899717,0.138172,264),(0.894772,0.135554,264),(0.914181,0.225741,264),(0.885464,0.21613,264),(0.849473,0.163648,264),(0.889536,0.137299,264),(0.861383,0.194575,264),(0.871055,0.150016,264),(0.898915,0.255519,264),(0.893609,0.208858,264),(0.855752,0.191501,264),(0.85195,0.16343,264),(0.864781,0.151252,264),(0.834267,0.168133,264),(0.889827,0.197513,264),(0.834849,0.194604,264),(0.886046,0.119264,264),(0.850848,0.154753,264),(0.83066,0.133008,264),(0.867036,0.212174,264),(0.917281,0.235035,264),(0.892736,0.109374,264),(0.927933,0.128282,264),(0.935213,0.169268,264),(0.917171,0.233292,264),(0.891863,0.107338,264),(0.897972,0.146026,264),(0.906699,0.139335,264),(0.934107,0.221305,264),(0.926188,0.143117,264),(0.898845,0.159989,264),(0.832231,0.171624,264),(0.920521,0.234886,264),(0.901172,0.129154,264),(0.922607,0.167422,264),(0.91368,0.139917,264),(0.831182,0.143417,264),(0.841398,0.216402,264),(0.839431,0.138993,264),(0.888082,0.132936,264),(0.852286,0.162602,264),(0.859686,0.148479,264),(0.859866,0.118391,264),(0.86452,0.120137,264),(0.883718,0.123918,264),(0.908233,0.119171,264),(0.859603,0.119707,264),(0.90059,0.116646,264),(0.910456,0.154635,264),(0.848812,0.230093,264),(0.838845,0.148241,264),(0.894481,0.11141,264),(0.864665,0.149725,264),(0.908444,0.142244,264),(0.905535,0.148644,264),(0.923688,0.16118,264),(0.895936,0.123046,264),(0.920079,0.144571,264),(0.912116,0.180902,264),(0.839597,0.205395,264),(0.931952,0.142004,264),(0.854048,0.156498,264),(0.937027,0.168668,264),(0.901583,0.168163,264),(0.842703,0.201876,264),(0.838813,0.202785,264),(0.83635,0.134224,264),(0.899426,0.134099,264),(0.844712,0.174385,264),(0.924426,0.184326,264),(0.833686,0.159989,264),(0.888954,0.106756,264),(0.837467,0.15388,264),(0.84688,0.157991,264),(0.839096,0.150868,264),(0.886918,0.125082,264),(0.8684,0.115879,264),(0.835722,0.220784,264),(0.837107,0.219777,264),(0.900008,0.226893,264),(0.895645,0.112574,264),(0.83194,0.167552,264),(0.927095,0.235658,264),(0.915716,0.233874,264),(0.914553,0.231547,264),(0.90728,0.135845,264),(0.917624,0.232022,264),(0.875283,0.142244,264),(0.838512,0.202791,264),(0.923279,0.154171,264),(0.895936,0.139626,264),(0.863909,0.205105,264),(0.860447,0.123337,264),(0.883137,0.18675,264),(0.851412,0.160169,264),(0.925606,0.152716,264),(0.91767,0.242381,264),(0.853175,0.21933,264),(0.947873,0.22832,264),(0.897972,0.109374,264),(0.886046,0.108792,264),(0.940596,0.185827,264),(0.83514,0.157371,264),(0.918164,0.206973,264),(0.93536,0.173289,264),(0.907571,0.146608,264),(0.910197,0.128049,264),(0.935676,0.175566,264),(0.915716,0.232711,264),(0.904986,0.202198,264),(0.837758,0.198095,264),(0.90728,0.121009,264),(0.913214,0.160625,264),(0.887209,0.157371,264),(0.935381,0.165392,264),(0.916937,0.229521,264),(0.896227,0.126536,264),(0.911209,0.166752,264),(0.860966,0.147093,264),(0.909898,0.148062,264),(0.829322,0.179478,264),(0.878773,0.194895,264),(0.896518,0.189659,264),(0.892736,0.193732,264),(0.924787,0.171799,264),(0.893318,0.123627,264),(0.900164,0.14148,264),(0.882264,0.126536,264),(0.859625,0.154962,264),(0.833558,0.154292,264),(0.849975,0.157371,264),(0.883137,0.109956,264),(0.839212,0.160861,264),(0.887791,0.140208,264),(0.886627,0.125664,264),(0.899284,0.244375,264),(0.904953,0.1309,264),(0.84342,0.175308,264),(0.902335,0.130318,264),(0.873419,0.156625,264),(0.875642,0.211718,264),(0.91305,0.173978,264),(0.932006,0.173951,264),(0.905826,0.177733,264),(0.914553,0.167552,264),(0.86181,0.149783,264),(0.897972,0.132063,264),(0.936009,0.199197,264),(0.895063,0.127118,264),(0.873526,0.178613,264),(0.926065,0.24926,264),(0.882053,0.223144,264),(0.929097,0.150098,264),(0.860908,0.211354,264),(0.8939,0.109374,264),(0.888954,0.160861,264),(0.860447,0.118973,264),(0.857153,0.169979,264),(0.851711,0.171009,264),(0.860956,0.192432,264),(0.847357,0.19664,264),(0.841667,0.14636,264),(0.934333,0.138754,264),(0.851814,0.166281,264),(0.831668,0.1365,264),(0.915716,0.233001,264),(0.907862,0.205076,264),(0.927064,0.170959,264),(0.883137,0.220493,264),(0.862774,0.119555,264),(0.915864,0.231967,264),(0.892736,0.144862,264),(0.885173,0.182387,264),(0.878754,0.166248,264),(0.951581,0.166829,264),(0.897099,0.213221,264),(0.861611,0.1245,264),(0.86197,0.146166,264),(0.935545,0.171449,264),(0.838049,0.165806,264),(0.936436,0.176485,264),(0.911644,0.171915,264),(0.863356,0.125082,264),(0.860156,0.124209,264),(0.886046,0.125373,264),(0.898263,0.197222,264),(0.922482,0.194648,264),(0.901841,0.150114,264),(0.860738,0.11781,264),(0.859284,0.122173,264),(0.884009,0.198386,264),(0.872534,0.147219,264),(0.916323,0.235504,264),(0.914973,0.235363,264),(0.885173,0.197804,264),(0.840687,0.150573,264),(0.846071,0.15595,264),(0.859487,0.193576,264),(0.926966,0.16425,264),(0.944026,0.211892,264),(0.888296,0.125345,264),(0.835251,0.211577,264),(0.913146,0.168519,264),(0.88798,0.121637,264),(0.910818,0.158461,264),(0.904081,0.147189,264),(0.895354,0.232129,264),(0.860447,0.121009,264),(0.946705,0.21741,264),(0.830081,0.135911,264),(0.912516,0.130027,264),(0.899717,0.115192,264),(0.883584,0.121285,264),(0.904662,0.116937,264),(0.904947,0.144865,264),(0.846335,0.160645,264),(0.851139,0.155916,264),(0.947829,0.168653,264),(0.893318,0.125664,264),(0.882766,0.126135,264),(0.917461,0.232711,264),(0.869644,0.154219,264),(0.934048,0.178875,264),(0.883428,0.214676,264),(0.855473,0.211107,264),(0.903499,0.111701,264),(0.900881,0.125664,264),(0.833976,0.167843,264),(0.895306,0.119543,264),(0.918158,0.215321,264),(0.941605,0.187332,264),(0.929388,0.143117,264),(0.852593,0.143117,264),(0.915134,0.150389,264),(0.833104,0.156498,264),(0.893609,0.128282,264),(0.891977,0.23842,264),(0.892057,0.24281,264),(0.937736,0.172951,264),(0.903879,0.194605,264),(0.860194,0.120205,264),(0.890118,0.118682,264),(0.840376,0.198095,264),(0.91688,0.233874,264),(0.930544,0.241948,264),(0.946586,0.179384,264),(0.914533,0.228039,264),(0.911721,0.155666,264),(0.936529,0.176012,264),(0.8939,0.13759,264),(0.881391,0.211767,264),(0.889392,0.243247,264),(0.858727,0.132737,264),(0.936671,0.170857,264),(0.869285,0.150219,264),(0.845867,0.161058,264),(0.853175,0.151844,264),(0.847066,0.201004,264),(0.914262,0.156498,264),(0.833395,0.198677,264),(0.913098,0.178605,264),(0.847727,0.234729,264),(0.932465,0.2068,264),(0.926188,0.129154,264),(0.917507,0.233907,264),(0.902668,0.152793,264),(0.925897,0.157371,264),(0.888944,0.127128,264),(0.862216,0.12504,264),(0.838891,0.203562,264),(0.929097,0.153589,264),(0.912225,0.140499,264),(0.908153,0.19635,264),(0.895354,0.228929,264),(0.920762,0.231116,264),(0.891282,0.122464,264),(0.896227,0.148353,264),(0.8907,0.137008,264),(0.927933,0.143117,264),(0.841249,0.197804,264),(0.858731,0.165874,264),(0.846194,0.138463,264),(0.87441,0.153007,264),(0.906778,0.151184,264),(0.901172,0.126536,264),(0.904372,0.142244,264),(0.8907,0.124209,264),(0.911353,0.125373,264),(0.876155,0.149807,264),(0.874119,0.154462,264),(0.915618,0.235987,264),(0.869761,0.15275,264),(0.84705,0.140999,264),(0.898263,0.119555,264),(0.86259,0.191247,264),(0.848678,0.163049,264),(0.863027,0.193179,264),(0.888373,0.131772,264),(0.906408,0.128282,264),(0.902335,0.174533,264),(0.852615,0.183062,264),(0.91509,0.123366,264),(0.899136,0.188496,264),(0.936996,0.174191,264),(0.933509,0.14802,264),(0.935418,0.125775,264),(0.915153,0.2304,264),(0.918848,0.160934,264),(0.917778,0.233922,264),(0.893609,0.108501,264),(0.886918,0.122755,264),(0.872273,0.140891,264),(0.877028,0.155334,264),(0.879937,0.15708,264),(0.933169,0.171042,264),(0.880228,0.130318,264),(0.844613,0.174727,264),(0.93133,0.228165,264),(0.944347,0.188749,264),(0.878192,0.194022,264),(0.861436,0.142031,264),(0.916378,0.165086,264),(0.910189,0.20304,264),(0.893609,0.116646,264),(0.92377,0.223456,264),(0.86132,0.125373,264),(0.943783,0.174218,264),(0.860103,0.200063,264),(0.873537,0.151844,264),(0.843285,0.203622,264),(0.916819,0.238921,264),(0.850557,0.195186,264),(0.934871,0.231698,264),(0.878192,0.148353,264),(0.895645,0.109665,264),(0.888664,0.141372,264),(0.858576,0.161026,264),(0.892736,0.20624,264),(0.918166,0.224689,264),(0.847354,0.152257,264),(0.924775,0.176061,264),(0.906914,0.133094,264),(0.897362,0.168432,264),(0.840157,0.20203,264),(0.83441,0.133175,264),(0.897681,0.120137,264),(0.874701,0.154171,264),(0.852459,0.161099,264),(0.8939,0.182387,264),(0.842121,0.218748,264),(0.854339,0.154171,264),(0.888664,0.129154,264),(0.844838,0.158025,264),(0.861388,0.159572,264),(0.845903,0.208276,264),(0.891572,0.120137,264),(0.893609,0.112283,264),(0.935794,0.186531,264),(0.897972,0.116064,264),(0.916758,0.23281,264),(0.889877,0.226463,264),(0.912516,0.155625,264),(0.866968,0.157123,264),(0.84713,0.162024,264),(0.894481,0.121591,264),(0.896227,0.144571,264),(0.863065,0.115773,264),(0.896518,0.20944,264),(0.919625,0.127251,264),(0.897681,0.136136,264),(0.837474,0.177767,264),(0.911062,0.145735,264),(0.892938,0.23516,264),(0.882576,0.18178,264),(0.892154,0.133518,264),(0.895063,0.116355,264),(0.8875,0.217584,264),(0.883718,0.122464,264),(0.883137,0.116064,264),(0.878482,0.125955,264),(0.898176,0.154453,264),(0.901463,0.123627,264),(0.872752,0.210855,264),(0.833976,0.185296,264),(0.895063,0.215839,264),(0.917461,0.233292,264),(0.914879,0.233302,264),(0.915212,0.233544,264),(0.886918,0.153007,264),(0.854158,0.161617,264),(0.863734,0.147737,264),(0.872665,0.144358,264),(0.875283,0.154171,264),(0.916461,0.237604,264),(0.91048,0.203622,264),(0.900881,0.131191,264),(0.929404,0.18176,264),(0.863608,0.147223,264),(0.912807,0.231547,264),(0.853419,0.160424,264),(0.903499,0.130318,264),(0.8939,0.132936,264),(0.909147,0.22982,264),(0.94019,0.186528,264),(0.905166,0.243503,264),(0.912807,0.150389,264),(0.933169,0.150971,264),(0.864229,0.11781,264),(0.831038,0.133772,264),(0.872553,0.167173,264),(0.919207,0.143699,264),(0.887209,0.125955,264),(0.891855,0.255994,264),(0.901753,0.145735,264),(0.916589,0.1277,264),(0.89046,0.128763,264),(0.829904,0.169006,264),(0.879355,0.140499,264),(0.887791,0.222529,264),(0.927352,0.155625,264),(0.915134,0.232262,264),(0.914525,0.233985,264),(0.875207,0.193021,264),(0.8907,0.122173,264),(0.834704,0.174824,264),(0.907789,0.151815,264),(0.851721,0.157371,264),(0.892154,0.14079,264),(0.910771,0.137299,264),(0.908153,0.155334,264),(0.896045,0.21592,264),(0.849872,0.160013,264),(0.861339,0.151659,264),(0.892154,0.122464,264),(0.914262,0.173951,264),(0.929066,0.130219,264),(0.862193,0.120719,264),(0.84183,0.172497,264),(0.864117,0.19683,264),(0.898637,0.240266,264),(0.915185,0.23293,264),(0.936641,0.174557,264),(0.915425,0.17017,264),(0.891863,0.1213,264),(0.935593,0.150013,264),(0.872548,0.151369,264),(0.847066,0.212058,264),(0.838599,0.189941,264),(0.858833,0.141604,264),(0.865717,0.147863,264),(0.843867,0.137299,264),(0.877901,0.132936,264),(0.907436,0.153467,264),(0.913098,0.171042,264),(0.888954,0.146608,264),(0.890991,0.126827,264),(0.860132,0.169103,264),(0.882163,0.16961,264),(0.87441,0.19984,264),(0.875762,0.148572,264),(0.876847,0.1978,264),(0.889536,0.139335,264),(0.916293,0.233933,264),(0.885755,0.113155,264),(0.895936,0.11461,264),(0.90324,0.208932,264),(0.893458,0.113682,264),(0.852795,0.160321,264),(0.852282,0.159198,264),(0.894928,0.154863,264),(0.915425,0.237074,264),(0.915295,0.237056,264),(0.867429,0.114901,264),(0.83183,0.160148,264),(0.912832,0.237941,264),(0.884591,0.125373,264),(0.875864,0.147771,264),(0.911935,0.188787,264),(0.842412,0.18995,264),(0.888954,0.1213,264),(0.83514,0.210603,264),(0.878773,0.132645,264),(0.90379,0.107338,264),(0.91469,0.230822,264),(0.868122,0.177163,264),(0.911062,0.15068,264),(0.849047,0.165,264),(0.886918,0.156498,264),(0.892445,0.132354,264),(0.948086,0.176887,264),(0.900299,0.109083,264),(0.887791,0.116937,264),(0.832989,0.180011,264),(0.896518,0.111992,264),(0.874992,0.14748,264),(0.853757,0.207112,264),(0.847758,0.136401,264),(0.9166,0.237168,264),(0.835722,0.185296,264),(0.895645,0.165806,264),(0.918201,0.235291,264),(0.871971,0.170557,264),(0.855294,0.14636,264),(0.916022,0.236175,264),(0.84154,0.200131,264),(0.876682,0.153092,264),(0.898845,0.114028,264),(0.894795,0.245982,264),(0.90059,0.133809,264),(0.939562,0.173802,264),(0.863065,0.135263,264),(0.89419,0.115483,264),(0.888954,0.111119,264),(0.891863,0.113446,264),(0.915365,0.235735,264),(0.888954,0.202167,264),(0.941099,0.166073,264),(0.915716,0.171624,264),(0.896518,0.13439,264),(0.851139,0.199549,264),(0.884589,0.190565,264),(0.861611,0.123046,264),(0.841656,0.176339,264),(0.876737,0.144281,264),(0.867429,0.127409,264),(0.912225,0.134972,264),(0.950957,0.157994,264),(0.887863,0.119862,264),(0.884527,0.170471,264),(0.93633,0.175257,264),(0.927061,0.147771,264),(0.892736,0.128282,264),(0.890991,0.108501,264),(0.89776,0.248456,264),(0.903644,0.163739,264),(0.904372,0.150971,264),(0.913098,0.132354,264),(0.845511,0.151692,264),(0.860738,0.127991,264),(0.898845,0.133227,264),(0.904569,0.164855,264),(0.835605,0.204235,264),(0.886627,0.221948,264),(0.919207,0.231838,264),(0.874119,0.14748,264),(0.898554,0.164061,264),(0.878192,0.207985,264),(0.860845,0.149153,264),(0.872956,0.145735,264),(0.913389,0.152716,264),(0.910203,0.17368,264),(0.893027,0.121009,264),(0.889827,0.141372,264),(0.91048,0.150389,264),(0.86132,0.121009,264),(0.873828,0.153589,264),(0.901468,0.200913,264),(0.91048,0.161443,264),(0.887861,0.106489,264),(0.865124,0.18999,264),(0.90059,0.1245,264),(0.848147,0.154749,264),(0.899717,0.125955,264),(0.918241,0.23244,264),(0.909898,0.151553,264),(0.897099,0.129736,264),(0.884591,0.145153,264),(0.866396,0.150748,264),(0.918671,0.230457,264),(0.886201,0.127114,264),(0.913056,0.169709,264),(0.896808,0.135554,264),(0.911549,0.192158,264),(0.891282,0.106174,264),(0.896808,0.17686,264),(0.918296,0.231169,264),(0.895819,0.121668,264),(0.85766,0.160919,264),(0.849591,0.177179,264),(0.889633,0.242032,264),(0.862327,0.151683,264),(0.945895,0.158804,264),(0.843893,0.156437,264),(0.897099,0.125082,264),(0.873828,0.147771,264),(0.861543,0.14413,264),(0.90699,0.143699,264),(0.921243,0.126245,264),(0.933063,0.174252,264),(0.914038,0.169877,264),(0.874992,0.155625,264),(0.902917,0.114901,264),(0.901992,0.1365,264),(0.909386,0.163297,264),(0.934915,0.176278,264),(0.934915,0.175987,264),(0.934624,0.174824,264),(0.934915,0.174242,264),(0.934624,0.173369,264),(0.935066,0.174801,264),(0.893366,0.130868,264),(0.903085,0.125343,264),(0.936078,0.171915,264),(0.908735,0.146026,264),(0.898845,0.20944,264),(0.912616,0.199139,264),(0.905749,0.192967,264),(0.917324,0.230529,264),(0.885755,0.143408,264),(0.896227,0.130318,264),(0.839657,0.204667,264),(0.893609,0.122173,264),(0.905826,0.146317,264),(0.938938,0.212465,264),(0.856957,0.187623,264),(0.845612,0.179187,264),(0.8907,0.131772,264),(0.906696,0.256816,264),(0.870357,0.155926,264),(0.871288,0.1585,264),(0.871336,0.148241,264),(0.895063,0.236492,264),(0.911062,0.122755,264),(0.841249,0.198386,264),(0.89419,0.221948,264),(0.87027,0.149667,264),(0.891707,0.11489,264),(0.909206,0.13254,264),(0.884009,0.21293,264),(0.944103,0.233662,264),(0.895987,0.110666,264),(0.899426,0.173369,264),(0.889214,0.186784,264),(0.9059,0.181997,264),(0.892826,0.261599,264),(0.850024,0.168509,264),(0.901753,0.107629,264),(0.934521,0.178032,264),(0.886918,0.218748,264),(0.900008,0.121882,264),(0.872417,0.145604,264),(0.839794,0.197222,264),(0.916007,0.184132,264),(0.882846,0.150971,264),(0.848617,0.178776,264),(0.895645,0.127991,264),(0.917177,0.233724,264),(0.901463,0.148644,264),(0.906768,0.122257,264),(0.84503,0.18995,264),(0.859104,0.145977,264),(0.840085,0.198386,264),(0.851713,0.158182,264),(0.835275,0.200373,264),(0.888029,0.210868,264),(0.911062,0.140499,264),(0.899136,0.123046,264),(0.876155,0.160279,264),(0.899136,0.110537,264),(0.848653,0.17152,264),(0.889536,0.106756,264),(0.93263,0.181129,264),(0.838966,0.198567,264),(0.828893,0.193658,264),(0.842121,0.203331,264),(0.914843,0.167552,264),(0.925606,0.148935,264),(0.851721,0.145444,264),(0.863518,0.191787,264),(0.913971,0.24551,264),(0.840883,0.196432,264),(0.882292,0.168864,264),(0.898263,0.135554,264),(0.918625,0.231958,264),(0.925315,0.137008,264),(0.91688,0.234456,264),(0.915434,0.237795,264),(0.831649,0.165515,264),(0.916398,0.235761,264),(0.877021,0.150845,264),(0.915797,0.23262,264),(0.878773,0.153007,264),(0.843988,0.191718,264),(0.845321,0.146899,264),(0.888373,0.137299,264),(0.890147,0.238217,264),(0.844801,0.205055,264),(0.83514,0.226602,264),(0.837686,0.137047,264),(0.854024,0.160612,264),(0.888563,0.232806,264),(0.888664,0.118973,264),(0.874701,0.151553,264),(0.91363,0.253956,264),(0.864588,0.145822,264),(0.891282,0.153589,264),(0.888599,0.227593,264),(0.902954,0.255511,264),(0.867735,0.193012,264),(0.872956,0.147189,264),(0.956167,0.164752,264),(0.901181,0.239226,264),(0.893027,0.139045,264),(0.851872,0.159823,264),(0.85188,0.161914,264),(0.917347,0.228511,264),(0.944931,0.185136,264),(0.8843,0.118391,264),(0.854181,0.146741,264),(0.850667,0.162398,264),(0.897972,0.122464,264),(0.914262,0.150389,264),(0.886918,0.109665,264),(0.893318,0.175697,264),(0.874992,0.149226,264),(0.900881,0.145735,264),(0.865504,0.192054,264),(0.8939,0.120428,264),(0.891572,0.110247,264),(0.889827,0.192568,264),(0.886918,0.118101,264),(0.843099,0.207814,264),(0.857601,0.155514,264),(0.862193,0.121591,264),(0.904662,0.139917,264),(0.895327,0.128507,264),(0.909898,0.149517,264),(0.889827,0.129154,264),(0.910771,0.131481,264),(0.904662,0.109083,264),(0.839869,0.137071,264),(0.931438,0.125799,264),(0.873246,0.141663,264),(0.889025,0.114638,264),(0.938184,0.168483,264),(0.854542,0.176832,264),(0.886046,0.130027,264),(0.849891,0.169415,264),(0.910189,0.255691,264),(0.889827,0.18006,264),(0.904372,0.172206,264),(0.898144,0.220494,264),(0.84269,0.169777,264),(0.856783,0.146587,264),(0.927352,0.139335,264),(0.950655,0.17171,264),(0.922143,0.241196,264),(0.850255,0.166218,264),(0.863405,0.156954,264),(0.893988,0.118266,264),(0.886627,0.113155,264),(0.904662,0.127409,264),(0.897681,0.11781,264),(0.899074,0.179062,264),(0.891006,0.239779,264),(0.903999,0.135056,264),(0.872665,0.151844,264),(0.899136,0.130027,264),(0.901753,0.121591,264),(0.891863,0.119264,264),(0.849975,0.188496,264),(0.836975,0.148302,264),(0.892154,0.228929,264),(0.852187,0.15825,264),(0.900008,0.117519,264),(0.848812,0.218166,264),(0.847648,0.182969,264),(0.86132,0.117519,264),(0.885464,0.144571,264),(0.872956,0.153298,264),(0.918043,0.146026,264),(0.8709,0.154365,264),(0.906499,0.154866,264),(0.904755,0.213725,264),(0.925897,0.150389,264),(0.899426,0.215548,264),(0.903499,0.149517,264),(0.852302,0.226311,264),(0.901753,0.128863,264),(0.870405,0.150961,264),(0.916589,0.143117,264),(0.915567,0.231902,264),(0.842296,0.199561,264),(0.94024,0.151684,264),(0.886918,0.21613,264),(0.857558,0.175788,264),(0.903342,0.250086,264),(0.892445,0.237074,264),(0.906408,0.124791,264),(0.877191,0.191355,264),(0.922406,0.140208,264),(0.904081,0.180351,264),(0.887209,0.225438,264),(0.916589,0.231838,264),(0.859148,0.221022,264),(0.918438,0.175937,264),(0.899717,0.1277,264),(0.850223,0.152547,264),(0.933178,0.169059,264),(0.880238,0.151341,264),(0.866444,0.147655,264),(0.891863,0.124209,264),(0.840667,0.223984,264),(0.91536,0.174645,264),(0.91231,0.206908,264),(0.899717,0.149517,264),(0.911062,0.149807,264),(0.849975,0.142244,264),(0.877901,0.159116,264),(0.915111,0.234924,264),(0.91212,0.157942,264),(0.930721,0.172231,264),(0.918085,0.234401,264),(0.864355,0.162718,264),(0.887138,0.120515,264),(0.894316,0.107927,264),(0.835722,0.207985,264),(0.85738,0.150064,264),(0.875864,0.155625,264),(0.915302,0.234465,264),(0.897099,0.149807,264),(0.855895,0.151892,264),(0.933482,0.159577,264),(0.934627,0.149692,264),(0.926336,0.153725,264),(0.912225,0.183841,264),(0.914843,0.219039,264),(0.914553,0.139335,264),(0.902626,0.160279,264),(0.930842,0.148062,264),(0.856603,0.158214,264),(0.899136,0.120719,264),(0.886046,0.122173,264),(0.892154,0.218166,264),(0.904953,0.119846,264),(0.876694,0.132469,264),(0.885464,0.123918,264),(0.90059,0.135554,264),(0.840376,0.202749,264),(0.898554,0.125955,264),(0.904662,0.115192,264),(0.849684,0.157371,264),(0.842412,0.189077,264),(0.906582,0.158662,264),(0.859352,0.126644,264),(0.90391,0.191202,264),(0.900881,0.214966,264),(0.872083,0.137881,264),(0.85463,0.159407,264),(0.916456,0.236551,264),(0.908153,0.148935,264),(0.839389,0.170877,264),(0.861253,0.126628,264),(0.901753,0.163479,264),(0.903987,0.204903,264),(0.919436,0.237139,264),(0.916723,0.234058,264),(0.8907,0.133518,264),(0.901172,0.133227,264),(0.889827,0.1245,264),(0.889345,0.115887,264),(0.867084,0.150379,264),(0.880228,0.132063,264),(0.889988,0.11469,264),(0.903208,0.140208,264),(0.862193,0.116937,264),(0.871758,0.20208,264),(0.893266,0.251937,264),(0.894513,0.164191,264),(0.915716,0.235328,264),(0.922406,0.152425,264),(0.870897,0.190253,264),(0.842562,0.154543,264),(0.846485,0.146317,264),(0.911062,0.152135,264),(0.888541,0.108014,264),(0.928224,0.139626,264),(0.892206,0.159257,264),(0.836304,0.170461,264),(0.875783,0.152499,264),(0.833589,0.201741,264),(0.875122,0.148431,264),(0.941485,0.179806,264),(0.941062,0.186696,264),(0.886918,0.178605,264),(0.909076,0.152618,264),(0.829969,0.138686,264),(0.833104,0.224857,264),(0.85941,0.158869,264),(0.90728,0.161443,264),(0.939191,0.181063,264),(0.911062,0.153589,264),(0.87833,0.178001,264),(0.882264,0.123918,264),(0.879029,0.152517,264),(0.882264,0.118101,264),(0.910984,0.165182,264),(0.863807,0.170582,264),(0.90379,0.15388,264),(0.891863,0.185878,264),(0.869756,0.137299,264),(0.876195,0.175891,264),(0.883893,0.126149,264),(0.876621,0.150441,264),(0.887791,0.169297,264),(0.905535,0.184423,264),(0.913098,0.145444,264),(0.850848,0.14399,264),(0.86339,0.14253,264),(0.902917,0.157371,264),(0.890991,0.146608,264),(0.913098,0.125082,264),(0.835381,0.209624,264),(0.854339,0.164643,264),(0.872083,0.156343,264),(0.933213,0.130591,264),(0.844158,0.18995,264),(0.881682,0.216421,264),(0.882846,0.221657,264),(0.892325,0.137939,264),(0.903337,0.200029,264),(0.90379,0.132936,264),(0.872209,0.159683,264),(0.896747,0.157332,264),(0.887334,0.191148,264),(0.896808,0.141081,264),(0.890409,0.200713,264),(0.860447,0.184714,264),(0.882779,0.227002,264),(0.925286,0.244333,264),(0.880228,0.129154,264),(0.862915,0.207035,264),(0.86833,0.141653,264),(0.874119,0.158243,264),(0.914747,0.236239,264),(0.889827,0.217293,264),(0.895354,0.133809,264),(0.861974,0.198221,264),(0.885755,0.161734,264),(0.888082,0.107629,264),(0.885464,0.122464,264),(0.907289,0.171389,264),(0.841536,0.157533,264),(0.845744,0.194327,264),(0.936808,0.178476,264),(0.903441,0.137684,264),(0.908735,0.122173,264),(0.915172,0.236462,264),(0.925272,0.157539,264),(0.848774,0.140954,264),(0.85238,0.176161,264),(0.896367,0.165453,264),(0.905826,0.150389,264),(0.861611,0.116646,264),(0.938836,0.17418,264),(0.917171,0.236492,264),(0.916589,0.236783,264),(0.88622,0.106176,264),(0.872572,0.149812,264),(0.869769,0.148287,264),(0.865077,0.16937,264),(0.849225,0.160928,264),(0.850447,0.161435,264),(0.873123,0.155088,264),(0.914989,0.235038,264),(0.868563,0.151005,264),(0.91683,0.232019,264),(0.916647,0.233959,264),(0.900061,0.250866,264),(0.854662,0.144985,264),(0.851435,0.16075,264),(0.898874,0.125238,264),(0.915963,0.23431,264),(0.934746,0.173905,264),(0.889168,0.120787,264),(0.889116,0.122291,264),(0.888832,0.120604,264),(0.889474,0.122258,264),(0.889472,0.121372,264),(0.888177,0.123169,264),(0.889013,0.12148,264),(0.935618,0.172881,264),(0.898482,0.207974,264),(0.933483,0.17853,264),(0.915161,0.231114,264),(0.916315,0.231971,264),(0.91719,0.23037,264),(0.915895,0.234053,264),(0.915854,0.232973,264),(0.916189,0.234654,264),(0.874115,0.150596,264),(0.894232,0.244796,264),(0.935587,0.175229,264),(0.935608,0.176622,264),(0.916674,0.235568,264),(0.916927,0.230419,264),(0.91667,0.233836,264),(0.91747,0.234128,264),(0.917549,0.232919,264),(0.917204,0.229825,264),(0.917464,0.235838,264),(0.917102,0.235642,264),(0.916808,0.235142,264),(0.205692,0.748475,19),(0.208795,0.755563,19),(0.202266,0.753023,19),(0.194706,0.745474,19),(0.985294,0.164096,270),(0.97231,0.166429,270),(0.971306,0.214539,270),(0.960975,0.185123,270),(0.97334,0.212882,270),(0.958347,0.171171,270),(0.966961,0.198175,270),(0.987275,0.157661,270),(0.980346,0.166593,270),(0.971128,0.210842,270),(0.97181,0.217359,270),(0.967656,0.205776,270),(0.985529,0.175406,270),(0.966842,0.18131,270),(0.9559,0.207245,270),(0.965389,0.188315,270),(0.963944,0.205267,270),(0.975202,0.215475,270),(0.965689,0.194405,270),(0.967925,0.212618,270),(0.971728,0.21931,270),(0.96849,0.16532,270),(0.971791,0.193533,270),(0.970672,0.21558,270),(0.971401,0.217706,270),(0.974952,0.171921,270),(0.975348,0.218166,270),(0.983669,0.150379,270),(0.972439,0.204494,270),(1.00294,0.174224,270),(0.976105,0.214866,270),(0.979816,0.156622,270),(0.978014,0.220149,270),(0.96436,0.165629,270),(0.970112,0.214676,270),(0.971567,0.216421,270),(1.00253,0.183899,270),(0.971789,0.218771,270),(0.969804,0.170214,270),(0.974043,0.215734,270),(0.968076,0.14748,270),(0.973085,0.219769,270),(0.974724,0.216908,270),(0.972701,0.21578,270),(0.98012,0.178211,270),(0.995675,0.173114,270),(0.971396,0.215789,270),(0.960705,0.164365,270),(0.267066,-1.07142,91),(0.341452,-1.23702,148),(0.325905,-1.22471,148),(0.340084,-1.2324,148),(0.322888,-1.22153,148),(0.339467,-1.23395,148),(0.327521,-1.20496,148),(0.317799,-1.24094,148),(0.322215,-1.20946,148),(0.328225,-1.2432,148),(0.323699,-1.23057,148),(0.336764,-1.22619,148),(0.346739,-1.25053,148),(0.345461,-1.23375,148),(0.324893,-1.19918,148),(0.339954,-1.24514,148),(0.330652,-1.21812,148),(0.323853,-1.2114,148),(0.324314,-1.19388,148),(0.322561,-1.24651,148),(0.338301,-1.21907,148),(0.328244,-1.21796,148),(0.338481,-1.23091,148),(0.341244,-1.24055,148),(0.329398,-1.2482,148),(0.321618,-1.2038,148),(0.333738,-1.23294,148),(0.327472,-1.20876,148),(0.341817,-1.23892,148),(0.341191,-1.25155,148),(0.332533,-1.22434,148),(0.330028,-1.23473,148),(0.335488,-1.23097,148),(0.330511,-1.22887,148),(0.322044,-1.21491,148),(0.321432,-1.22348,148),(0.327361,-1.21538,148),(0.319104,-1.22755,148),(0.321409,-1.22231,148),(0.322069,-1.23456,148),(0.641695,0.0606881,4),(0.60533,0.11364,4),(0.64074,0.0496099,4),(0.623475,0.0131788,4),(0.577796,0.105731,4),(0.606017,0.0938717,4),(0.608742,-0.0229511,4),(0.640043,0.07316,4),(0.637843,0.0708101,4),(0.638588,0.0658766,4),(0.639732,0.0694891,4),(0.642281,0.0744674,4),(0.510751,0.00403136,4),(0.639663,0.0833152,4),(0.626069,0.0353963,4),(0.64098,0.0620753,4),(0.630352,0.110904,4),(0.577995,0.106174,4),(0.619273,0.109271,4),(0.397673,0.0963907,4),(0.642938,0.115893,4),(0.641306,0.0680757,4),(0.630896,0.0644241,4),(0.637365,0.0507067,4),(0.614106,0.0261122,4),(0.643611,0.120588,4),(0.620086,-0.00338053,4),(0.606417,0.102945,4),(0.638902,0.0538928,4),(0.637404,0.109277,4),(0.600166,0.0870544,4),(0.622368,-0.00910503,4),(0.61418,-0.0110104,4),(0.584665,0.10486,4),(0.636429,0.0227343,4),(0.62632,0.0658401,4),(0.612076,-0.0198454,4),(0.61496,-0.00426471,4),(0.630564,0.131489,4),(0.637869,0.081788,4),(0.60453,-0.0232378,4),(0.640615,0.0527896,4),(0.625779,0.0923372,4),(0.607904,0.00264784,4),(0.557184,0.0933783,4),(0.641204,0.0572606,4),(0.636308,0.105464,4),(0.58084,0.120599,4),(0.611947,-0.0250214,4),(0.585801,0.116994,4),(0.641162,0.0582971,4),(0.466278,0.00299149,4),(0.627343,0.0878087,4),(0.622626,0.0985291,4),(0.626144,0.124155,4),(0.609202,-0.0180457,4),(0.630086,0.020935,4),(0.627642,0.0160389,4),(0.631548,0.0267557,4),(0.63801,0.0486996,4),(0.618823,0.012004,4),(0.557621,0.0929391,4),(0.622927,-0.0111993,4),(0.611103,-0.0305082,4),(0.641343,0.0668746,4),(0.636468,0.0469478,4),(0.627117,0.00155648,4),(0.636177,0.109335,4),(0.56316,0.0634136,4),(0.596105,0.0611405,4),(0.621871,0.133798,4),(0.623569,-0.0123587,4),(0.621879,0.103181,4),(0.627969,0.0730708,4),(0.640218,0.074417,4),(0.61838,0.0306679,4),(0.579309,0.106237,4),(0.639147,0.0562429,4),(0.632929,0.0480651,4),(0.630453,0.0156844,4),(0.629841,0.0777007,4),(0.608449,-0.0233761,4),(0.642031,0.070908,4),(0.639334,0.0732801,4),(0.638175,0.0550536,4),(0.638173,0.0627149,4),(0.589921,0.0500061,4),(0.626379,0.04798,4),(0.614569,0.0404723,4),(0.639469,0.0483186,4),(0.632875,0.0387489,4),(0.639663,0.0581334,4),(0.644536,0.11494,4),(0.627095,0.0144637,4),(0.64086,0.0640403,4),(0.474616,0.0429471,4),(0.636399,0.0786327,4),(0.610017,-0.0238772,4),(0.637108,0.129901,4),(0.552927,0.105991,4),(0.618695,0.138786,4),(0.617478,-0.0168909,4),(0.63551,0.115122,4),(0.637265,0.0421291,4),(0.636384,0.12961,4),(0.612007,0.0183164,4),(0.641449,0.0753197,4),(0.638099,0.0847277,4),(0.622171,-0.0108903,4),(0.617696,-0.0190656,4),(0.640177,0.0847445,4),(0.632914,0.116826,4),(0.643949,0.147364,4),(0.601186,0.044113,4),(0.569211,0.0962128,4),(0.642347,0.135033,4),(0.630986,0.099312,4),(0.632227,0.0291796,4),(0.625996,0.137649,4),(0.620018,-0.0177285,4),(0.636523,0.0458198,4),(0.629433,0.0807641,4),(0.574091,0.00957121,4),(0.633022,0.0294278,4),(0.631738,0.0219105,4),(0.640271,0.135282,4),(0.637678,0.0669055,4),(0.641136,0.069154,4),(0.640012,0.0513902,4),(0.585277,0.104599,4),(0.636216,0.115827,4),(0.644326,0.0682967,4),(0.584976,0.1213,4),(0.640768,0.0560687,4),(0.609057,0.0608322,4),(0.634689,0.115449,4),(0.63469,0.0755092,4),(0.636398,0.0477999,4),(0.609491,-0.0226041,4),(0.615631,0.135297,4),(0.641718,0.0516485,4),(0.63879,0.0805761,4),(0.631161,0.107626,4),(0.638393,0.0525199,4),(0.60425,0.0487825,4),(0.639438,0.0644854,4),(0.577685,0.0220055,4),(0.620861,-0.015701,4),(0.636318,0.131142,4),(0.629476,0.0196528,4),(0.639534,0.0469506,4),(0.637598,0.0522192,4),(0.616358,-0.000879122,4),(0.637774,0.0537736,4),(0.634129,0.0888099,4),(0.638339,0.0508264,4),(0.641013,0.0595149,4),(0.642319,0.0724638,4),(0.636399,0.0491247,4),(0.633112,0.0847651,4),(0.626593,0.0854873,4),(0.641386,0.0557193,4),(0.637782,0.0689939,4),(0.640797,0.0532329,4),(0.621948,0.0562869,4),(0.623432,-0.00951204,4),(0.606413,0.140678,4),(0.640575,0.13696,4),(0.630678,0.0508039,4),(0.57293,0.0657448,4),(0.642897,0.130085,4),(0.612168,-0.0213682,4),(0.641752,0.137993,4),(0.616118,-0.024125,4),(0.608604,-0.0248394,4),(0.637462,0.0499393,4),(0.639132,0.0712586,4),(0.639973,0.0626774,4),(0.641511,0.0887383,4),(0.551815,-0.0386882,4),(0.620569,0.107759,4),(0.617655,0.0936516,4),(0.638209,0.0866847,4),(0.639952,0.0540364,4),(0.640992,0.0555523,4),(0.641224,0.124011,4),(0.641316,0.0763096,4),(0.615382,0.110777,4),(0.64217,0.0752513,4),(0.639449,0.0588398,4),(0.470657,0.0189077,4),(0.644027,0.135554,4),(0.626011,0.0193981,4),(0.639492,0.085544,4),(0.641452,0.0530924,4),(0.636303,0.0791496,4),(0.617441,0.102975,4),(0.616057,-0.0199032,4),(0.642165,0.0573679,4),(0.632986,0.11347,4),(0.571595,-0.010181,4),(0.618743,0.0507163,4),(0.631159,0.0169362,4),(0.627005,0.116855,4),(0.627814,0.119969,4),(0.623847,-0.0134268,4),(0.608098,0.0726725,4),(0.638175,0.0751572,4),(0.622559,0.0677455,4),(0.624896,-0.00526705,4),(0.617217,-0.0089497,4),(0.599412,0.0562825,4),(0.608111,0.0269999,4),(0.633438,0.0641093,4),(0.64233,0.0509959,4),(0.624765,0.129028,4),(0.631579,0.0927375,4),(0.632367,0.121184,4),(0.595381,0.0366917,4),(0.486498,-0.00512917,4),(0.635589,0.0208769,4),(0.63687,0.096679,4),(-0.0710204,-1.37805,102),(-0.0369429,-1.39074,102),(-0.0270526,-1.39161,102),(-0.0253073,-1.38696,102),(-0.018326,-1.38957,102),(-0.0171623,-1.35816,102),(-0.0221076,-1.40383,102),(-0.00436332,-1.38143,102),(-0.0602139,-1.39568,102),(-0.038979,-1.4111,102),(0.0224856,-1.37596,102),(0.010472,-1.35816,102),(-0.0340339,-1.39161,102),(-0.0386882,-1.41313,102),(0.00581771,-1.38696,102),(-0.0290889,-1.37241,102),(-0.00401164,-1.37052,102),(-0.018035,-1.38666,102),(-0.0255982,-1.36107,102),(-0.0165806,-1.37328,102),(0.0162897,-1.39074,102),(-0.018326,-1.40412,102),(-0.0459603,-1.40295,102),(-0.0639955,-1.39015,102),(-0.0229802,-1.37067,102),(-0.0319976,-1.40034,102),(-0.0581776,-1.39306,102),(0.00407238,-1.36601,102),(-0.0386882,-1.38725,102),(-0.0465422,-1.38957,102),(-0.018326,-1.4079,102),(-0.0314159,-1.38463,102),(-0.0165806,-1.40906,102),(-0.0570141,-1.39568,102),(-0.00872665,-1.37125,102),(-0.0404335,-1.36339,102),(-0.0696933,-1.38237,102),(-0.0418879,-1.38463,102),(-0.0162897,-1.37212,102),(-0.0162897,-1.38259,102),(-0.038979,-1.41197,102),(0.00147864,-1.34186,102),(-0.023271,-1.40644,102),(0.00610865,-1.36339,102),(-0.0607956,-1.40034,102),(-0.0378155,-1.39452,102),(-0.0279253,-1.37881,102),(-0.0506145,-1.37503,102),(-0.033743,-1.39568,102),(-0.0383972,-1.39335,102),(-0.0503236,-1.37852,102),(-0.0119264,-1.39801,102),(0.000872665,-1.36368,102),(-0.0695222,-1.38492,102),(-0.0756309,-1.38841,102),(-0.0148353,-1.39917,102),(-0.0125083,-1.34623,102),(-0.0238529,-1.39452,102),(-0.010472,-1.40354,102),(-0.0317069,-1.38783,102),(-0.0477056,-1.3759,102),(0.00581771,-1.36514,102),(-0.0218006,-1.37212,102),(1.01864,0.44663,303),(1.01893,0.466441,303),(1.03737,0.432031,303),(1.03672,0.484411,303),(1.03579,0.459996,303),(1.01903,0.427555,303),(1.03633,0.492013,303),(1.03806,0.436769,303),(1.0367,0.476005,303),(0.536064,0.545315,13),(0.529776,0.544555,13),(0.53736,0.541086,13),(0.51446,0.540375,13),(0.541993,0.547647,13),(0.535471,0.540056,13),(0.467212,0.549816,13),(0.504691,0.538434,13),(0.463506,0.553178,13),(0.545783,0.537328,13),(0.544463,0.55015,13),(0.529056,0.54664,13),(0.54036,0.545299,13),(0.49414,0.535992,13),(0.548111,0.530866,13),(0.533457,0.543806,13),(0.540568,0.540287,13),(0.452286,0.571833,13),(0.456651,0.571189,13),(0.526727,0.54464,13),(0.454649,0.562719,13),(0.543198,0.55222,13),(0.531728,0.539859,13),(0.496005,0.537199,13),(0.529892,0.547642,13),(0.547205,0.47552,13),(0.476656,0.540529,13),(0.484004,0.538288,13),(0.520399,0.541925,13),(0.427199,0.575021,13),(0.53688,0.535769,13),(0.537446,0.551973,13),(0.537994,0.537876,13),(0.543047,0.540007,13),(0.543388,0.52584,13),(0.465535,0.549737,13),(0.459689,0.556614,13),(0.549925,0.555731,13),(0.510292,0.537377,13),(0.441452,0.568175,13),(0.546425,0.528817,13),(0.512394,0.535492,13),(0.520831,0.546303,13),(0.535315,0.551315,13),(0.53953,0.528663,13),(0.544594,0.533201,13),(0.454744,0.561355,13),(0.546808,0.553532,13),(0.536341,0.555046,13),(0.548321,0.555247,13),(0.536762,0.548718,13),(0.543374,0.534882,13),(0.455961,0.566813,13),(0.5426,0.551424,13),(0.480943,0.537695,13),(0.48244,0.538375,13),(0.541736,0.531787,13),(0.508731,0.543274,13),(0.54553,0.563464,13),(0.466512,0.592304,13),(0.544796,0.5473,13),(0.530936,0.550865,13),(0.540001,0.537795,13),(0.507444,0.54276,13),(0.497482,0.537568,13),(0.531611,0.544169,13),(0.533856,0.549814,13),(0.525746,0.543421,13),(0.533102,0.554757,13),(0.474397,0.544258,13),(0.42051,0.574336,13),(0.52314,0.56769,13),(0.516002,0.545958,13),(0.534004,0.539285,13),(0.52881,0.540639,13),(0.512041,0.54464,13),(0.448531,0.569712,13),(0.478922,0.537883,13),(0.455605,0.598263,13),(0.534353,0.553883,13),(0.534399,0.549098,13),(0.526972,0.543444,13),(0.524692,0.54541,13),(0.49061,0.536694,13),(0.544244,0.559048,13),(0.543812,0.557406,13),(0.541687,0.547696,13),(0.462108,0.555076,13),(0.540607,0.543932,13),(0.52727,0.547477,13),(0.52374,0.544733,13),(0.544209,0.556152,13),(0.534145,0.563257,13),(0.544816,0.522818,13),(0.536144,0.550878,13),(0.521853,0.545415,13),(0.546488,0.543629,13),(0.475731,0.590147,13),(0.511555,0.538291,13),(0.503079,0.539298,13),(0.494787,0.503805,13),(0.457899,0.558566,13),(0.531108,0.541695,13),(0.471109,0.548305,13),(0.516962,0.545546,13),(0.543349,0.589894,13),(0.463597,0.554055,13),(0.540032,0.54614,13),(0.538049,0.53296,13),(0.472009,0.546619,13),(0.487491,0.538232,13),(0.536254,0.552772,13),(0.539484,0.526642,13),(0.475944,0.543688,13),(0.435988,0.573772,13),(0.544687,0.552144,13),(0.516621,0.564033,13),(0.466673,-0.203714,21),(0.474071,-0.230438,21),(0.413377,-0.278519,21),(0.272441,0.688532,5),(0.275374,0.67122,5),(0.263787,0.656118,5),(0.267617,0.679515,5),(0.227053,0.745944,5),(0.259831,0.677454,5),(0.64785,-0.0625526,284),(0.670497,-0.111992,284),(0.673935,-0.0194548,284),(0.674348,-0.015109,284),(0.685389,-0.0453992,284),(0.696968,-0.00174533,284),(0.680269,-0.101184,284),(0.672083,-0.00407465,284),(0.642832,-0.0461243,284),(0.641803,-0.0715664,284),(0.688877,-0.0065867,284),(0.676526,-0.0590764,284),(0.649003,-0.100896,284),(0.640148,-0.0950506,284),(0.663457,-0.0588263,284),(0.65919,-0.0262199,284),(0.641547,-0.0689812,284),(0.662854,-0.011907,284),(0.658738,-0.0166497,284),(0.688306,-0.00812381,284),(0.639146,-0.0785356,284),(0.683334,-0.0527842,284),(0.652279,-0.105521,284),(0.695655,-0.0702081,284),(0.505466,-0.238151,244),(0.48856,-0.269115,244),(0.507201,-0.236736,244),(0.628562,-0.0978597,284),(0.697494,-0.0843127,284),(0.497015,-0.286411,244),(0.681842,-0.00465427,284),(0.684214,-0.00543042,284),(0.687078,-0.00727226,284),(0.652446,-0.104303,284),(0.670144,-0.0091717,284),(0.664298,-0.0183045,284),(0.66657,-0.00987507,284),(0.487152,-0.271237,244),(0.680409,0.0267749,284),(0.496865,-0.283697,244),(0.500622,-0.310044,244),(0.48925,-0.2706,244),(0.631995,-0.0939711,284),(0.660357,-0.0138059,284),(0.490407,-0.290023,244),(0.641899,-0.110855,284),(0.652022,-0.105371,284),(0.670232,-0.00761365,284),(0.679224,0.0223983,284),(0.659844,-0.0146147,284),(0.636625,-0.108178,284),(0.497162,-0.28484,244),(0.48738,-0.271805,244),(0.506162,-0.237592,244),(0.680341,0.0227525,284),(0.692605,-0.00465427,284),(0.639181,-0.110978,284),(0.641656,-0.045636,284),(0.641274,-0.0901827,284),(0.664761,-0.0126613,284),(0.640835,-0.0746273,284),(0.690278,-0.00989026,284),(0.689202,-0.0192063,284),(0.495262,-0.289476,244),(0.691441,-0.00523599,284),(0.637537,-0.108038,284),(0.675218,-0.0716866,284),(0.497425,-0.24195,244),(0.495917,-0.288829,244),(0.652569,-0.0831974,284),(0.69115,-0.00959931,284),(0.653418,-0.0732206,284),(0.669841,-0.0846183,284),(0.695981,0.0526437,284),(0.660885,-0.0138328,284),(0.687078,-0.00785398,284),(0.689405,-0.00756304,284),(0.690616,0.0462554,284),(0.657993,-0.0921745,284),(0.494808,-0.246224,244),(0.688241,-0.00727226,284),(0.64992,-0.089142,284),(0.664706,-0.0164761,284),(0.677479,-0.0107629,284),(0.69755,-0.00436332,284),(0.679277,-0.00208305,284),(0.669941,-0.0133994,284),(0.645188,-0.0385011,284),(0.641558,-0.0678457,284),(0.696239,-0.0967024,284),(0.662999,-0.0197229,284),(0.66394,-0.0260078,284),(0.670482,-0.00777178,284),(0.64142,-0.0613989,284),(0.647881,-0.0951908,284),(0.656004,-0.0809492,284),(0.67908,-0.115503,284),(0.6902,-0.00690295,284),(0.664177,-0.0210771,284),(0.650582,-0.119355,284),(0.486665,-0.27446,244),(0.688973,-0.00729984,284),(0.638716,-0.0809358,284),(0.679214,-0.110718,284),(0.615991,-0.0512835,15),(0.65623,-0.0229499,284),(0.690569,-0.00581771,284),(0.658357,-0.0693356,284),(0.691885,0.0480643,284),(0.651514,-0.0945413,284),(0.637314,-0.0852738,284),(0.649396,-0.0634415,284),(0.680664,-0.058816,284),(0.689255,-0.00808943,284),(0.69062,0.0560172,284),(0.640888,-0.0771495,284),(0.651786,-0.105835,284),(0.652282,-0.100348,284),(0.696186,0.0744528,284),(0.652907,-0.0782819,284),(0.648596,-0.103399,284),(0.500185,-0.312732,244),(0.631544,-0.0958558,284),(0.658761,-0.0148425,284),(0.657486,-0.0297003,284),(0.657273,-0.0964732,284),(0.648719,-0.0724537,284),(0.689247,0.0504589,284),(0.691732,-0.010472,284),(0.664886,-0.0634605,284),(0.650219,-0.125739,284),(0.644389,-0.106034,284),(0.656578,-0.0153238,284),(0.663718,-0.0216749,284),(0.490433,-0.269015,244),(0.679705,-0.0565155,284),(0.645489,-0.103661,284),(0.68446,-0.0375246,284),(0.654278,-0.104416,284),(0.495512,-0.288382,244),(0.499348,-0.243109,244),(0.673937,-0.00221482,284),(0.631252,-0.0933362,284),(0.690569,-0.00930836,284),(0.668035,-0.0630996,284),(0.671588,-0.0231256,284),(0.640299,-0.107094,284),(0.676897,0.00290894,284),(0.680387,-0.00901759,284),(0.659153,-0.0660316,284),(0.649262,-0.1277,284),(0.487311,-0.269489,244),(0.693264,0.0508053,284),(0.495192,-0.291677,244),(0.679087,0.0250099,284),(0.674139,-0.00998765,284),(0.652561,-0.0339529,284),(0.650281,-0.121315,284),(0.672137,-0.0296874,284),(0.493996,-0.286802,244),(0.492384,-0.292857,244),(0.664801,-0.0114417,284),(0.650996,-0.0547897,284),(0.490766,-0.289306,244),(0.649056,-0.0629483,284),(0.680097,-0.00319971,284),(0.491258,-0.273148,244),(0.637743,-0.0807168,284),(0.688874,0.0549484,284),(0.635782,-0.0898127,284),(0.652597,-0.0998316,284),(0.638684,-0.108786,284),(0.641867,-0.0491233,284),(0.671565,-0.0138155,284),(0.667801,-0.012236,284),(0.650357,-0.0967837,284),(0.655235,-0.0887081,284),(0.650709,-0.103339,284),(0.679915,-0.102305,284),(0.677899,0.00184551,284),(0.681901,-0.0630933,284),(0.683587,-0.00436332,284),(0.68908,-0.00766845,284),(0.667587,-0.0141328,284),(0.650792,-0.105664,284),(0.661189,-0.0831941,284),(0.633156,-0.106264,284),(0.639828,-0.0830147,284),(0.680387,-0.0686496,284),(0.667414,-0.0247814,284),(0.68881,-0.00743318,284),(0.641175,-0.112347,284),(0.635634,-0.107327,284),(0.664838,-0.0313897,284),(0.68766,-0.00698132,284),(0.652508,-0.105637,284),(0.697841,-0.000581718,284),(0.650679,-0.124803,284),(0.640722,-0.0808606,284),(0.656333,-0.017213,284),(0.653997,-0.0985427,284),(0.684751,-0.00901759,284),(0.683005,-0.00785398,284),(0.665068,-0.0325228,284),(0.494885,-0.285757,244),(0.687741,-0.0545401,284),(0.67071,-0.00694187,284),(0.652788,-0.105298,284),(0.690552,0.0437416,284),(0.674477,0.000776672,284),(0.665406,-0.0153278,284),(0.637632,-0.109946,284),(0.688995,-0.111217,284),(0.654018,-0.0775286,284),(0.696195,-0.00148336,284),(0.689696,-0.00727226,284),(0.652292,-0.105982,284),(0.690859,-0.00785398,284),(0.6431,-0.0514813,284),(0.672618,-0.00228603,284),(0.687951,-0.00698132,284),(0.638712,-0.0797506,284),(0.654337,-0.0483908,284),(0.631676,-0.103356,284),(0.664907,-0.0659361,284),(0.663118,-0.0605809,284),(0.656535,-0.075441,284);
/*&*/
INSERT INTO `x2_timezone_points` VALUES (0.678547,-0.12166,284),(0.649436,-0.129201,284),(0.649695,-0.0643478,284),(0.669248,-0.0133905,284),(0.490784,-0.270932,244),(0.5055,-0.236452,244),(0.490431,-0.291139,244),(0.648233,-0.0631554,284),(0.641422,-0.101413,284),(0.665255,-0.0226968,284),(0.64611,-0.0796085,284),(0.66391,-0.0706994,284),(0.673677,-0.000896925,284),(0.641128,-0.0644152,284),(0.665124,-0.0138225,284),(0.650392,-0.113737,284),(0.642947,-0.0429306,284),(0.675148,-0.111831,284),(0.697259,-0.000872665,284),(0.678395,-0.0191485,284),(0.650482,-0.122577,284),(0.669249,-0.00840359,284),(0.639541,-0.0818085,284),(0.639908,-0.0796113,284),(0.660625,-0.0248722,284),(0.683878,-0.00756304,284),(0.630644,-0.0951293,284),(0.687951,-0.00669037,284),(0.688806,-0.00802939,284),(0.695569,0.0544784,284),(0.675538,-0.00827845,284),(0.683296,-0.00756304,284),(0.687487,-0.0559949,284),(0.662691,-0.0212431,284),(0.653825,-0.0684694,284),(0.651669,-0.101919,284),(0.689405,-0.00610865,284),(0.649801,-0.0637935,284),(0.68766,-0.00727226,284),(0.680387,-0.0322886,284),(0.688632,-0.00804597,284),(0.487041,-0.269585,244),(0.652863,-0.0276266,284),(0.641402,-0.0527185,284),(0.490834,-0.291924,244),(0.691878,-0.00416942,284),(0.755456,-0.0378722,284),(0.727035,-0.0153125,284),(0.724312,-0.100356,284),(0.762051,-0.132531,284),(0.747874,-0.0465422,284),(0.70634,0.00830061,284),(0.704361,-0.0680698,284),(0.70424,-0.0645772,284),(0.744328,-0.0970115,284),(0.719493,0.0301088,284),(0.706567,-0.0692315,284),(0.705932,-0.0698879,284),(0.755728,-0.134099,284),(0.743446,-0.152965,284),(0.721694,0.0296706,284),(0.717621,0.0200713,284),(0.734116,0.0393621,284),(0.721066,0.0351556,284),(0.737102,-0.152239,284),(0.731819,0.0393547,284),(0.705113,-0.0628319,284),(0.719367,0.0267617,284),(0.720579,0.0218154,284),(0.72702,-0.0824445,284),(0.701462,-0.0642084,284),(0.703822,-0.0612764,284),(0.728046,-0.0173638,284),(0.733861,-0.150872,284),(0.734114,-0.0280042,284),(0.712312,0.00910364,284),(0.708194,-0.0685318,284),(0.75659,-0.0706483,284),(0.706079,-0.0605582,284),(0.718117,0.0244104,284),(0.727787,0.0474534,284),(0.752845,-0.0362681,284),(0.704164,-0.0193114,284),(0.746128,-0.148353,284),(0.726878,0.0198892,284),(0.725475,0.0351975,284),(0.717621,0.0218166,284),(0.69828,-0.0524875,284),(0.72892,-0.0430892,284),(0.719688,0.0316241,284),(0.755898,-0.0524848,284),(0.69996,-0.0645411,284),(0.714712,-0.0718494,284),(0.724156,0.0373638,284),(0.722447,0.0350268,284),(0.755651,-0.0523126,284),(0.756224,-0.0529268,284),(0.722322,0.0362283,284),(0.748406,-0.14915,284),(0.724893,0.0381063,284),(0.758602,-0.0664,284),(0.724589,0.0370807,284),(0.723466,0.0385386,284),(0.707632,-0.063109,284),(0.755951,-0.0344701,284),(0.724893,0.036361,284),(0.720239,0.0308342,284),(0.701751,-0.0623192,284),(0.708454,-0.0723854,284),(0.724479,0.0417771,284),(0.721985,0.0360702,284),(0.740019,-0.153711,284),(0.705529,-0.0616557,284),(0.722275,0.0357792,284),(0.729257,0.0529416,284),(0.72373,0.036361,284),(0.727511,0.0433423,284),(0.708895,0.010472,284),(0.721581,0.0355452,284),(0.723184,0.0382196,284),(0.743715,-0.0980301,284),(0.723379,0.0344156,284),(0.723103,0.038721,284),(0.755652,-0.0992073,284),(0.7326,0.0487437,284),(0.716922,0.0199252,284),(0.715003,-0.0986111,284),(0.725067,0.0368163,284),(0.724177,0.0354834,284),(0.737611,0.0554472,284),(0.724257,0.0376536,284),(0.74606,-0.147374,284),(0.71831,0.0193185,284),(0.755936,-0.0332021,284),(0.737984,-0.150266,284),(0.704979,-0.0638738,284),(0.736238,-0.148353,284),(0.724173,0.0412812,284),(0.705688,-0.066556,284),(0.740792,-0.152102,284),(0.756094,-0.0527201,284),(0.735858,-0.150444,284),(0.740561,-0.150872,284),(0.742579,-0.115125,284),(0.757338,-0.0988441,284),(0.698676,-0.106263,284),(0.702346,-0.064577,284),(0.726539,0.0469302,284),(0.702251,-0.0657556,284),(0.725617,0.0389742,284),(0.747295,-0.0286798,284),(0.733329,-0.0791215,284),(0.730393,0.0546134,284),(0.731596,0.0552065,284),(0.75678,-0.10201,284),(0.754949,-0.0352335,284),(0.738856,-0.137008,284),(0.736197,0.0434608,284),(0.725075,0.0330579,284),(0.756309,-0.145153,284),(0.735508,-0.153703,284),(0.703177,-0.0700221,284),(0.759509,-0.142293,284),(0.7566,-0.0494509,284),(0.703758,-0.0674563,284),(0.705404,-0.0637045,284),(0.731482,0.00338699,284),(0.724893,0.0395609,284),(0.742143,-0.131148,284),(0.751616,-0.0434547,284),(0.724021,0.0381063,284),(0.725014,0.0386252,284),(0.722857,0.0351975,284),(0.737983,-0.152716,284),(0.74502,-0.051434,284),(0.754855,-0.100647,284),(0.704988,-0.0607713,284),(0.721037,-0.0857677,284),(0.725047,0.0426646,284),(0.723959,0.0404707,284),(0.723858,0.0336957,284),(0.739729,-0.151844,284),(0.728238,0.0318795,284),(0.733078,0.0398766,284),(0.726871,0.0478456,284),(0.706396,-0.067576,284),(0.705401,-0.0646219,284),(0.750492,-0.132063,284),(0.741183,-0.0427606,284),(0.727801,0.049666,284),(0.752991,-0.0516974,284),(0.726348,0.0107629,284),(0.74351,-0.0971567,284),(0.756309,-0.0520689,284),(0.703842,-0.0656855,284),(0.706735,-0.067609,284),(0.755165,-0.0352851,284),(0.716916,0.0206848,284),(0.744572,-0.141596,284),(0.725734,-0.0824375,284),(0.744965,-0.148062,284),(0.756973,-0.146538,284),(0.756409,-0.0312306,284),(0.700263,-0.0671435,284),(0.725725,0.0282255,284),(0.702502,-0.0668569,284),(0.735415,-0.00713316,284),(0.721862,0.0366568,284),(0.706412,-0.0635492,284),(0.755137,-0.0344903,284),(0.756019,-0.0468329,284),(0.75672,-0.0525599,284),(0.709185,-0.0552688,284),(0.726196,0.0399284,284),(0.722608,0.0376365,284),(0.759842,-0.0988122,284),(0.703467,-0.0651523,284),(0.732744,0.0493043,284),(0.720927,0.0349281,284),(0.754564,-0.0494509,284),(0.708225,-0.0698875,284),(0.756985,-0.0313196,284),(0.703092,-0.0662204,284),(0.759906,-0.12262,284),(0.737689,0.0516902,284),(0.72217,0.036444,284),(0.724893,0.0325795,284),(0.753691,-0.0436332,284),(0.755865,-0.0514003,284),(0.721307,0.0365598,284),(0.758925,-0.143761,284),(0.757489,-0.0666805,284),(0.735243,-0.0198472,284),(0.753719,-0.0431372,284),(0.75348,-0.0459685,284),(0.755516,-0.146408,284),(0.699295,-0.0372336,284),(0.705528,-0.0621562,284),(0.755151,-0.0688899,284),(0.721694,0.036361,284),(0.709635,-0.0657574,284),(0.709216,-0.069898,284),(0.706047,-0.0637803,284),(0.698151,0.0670458,284),(0.700909,-0.0631989,284),(0.757174,-0.0562071,284),(0.757436,-0.118546,284),(0.720436,0.0343887,284),(0.726348,0.036361,284),(0.726751,0.0411442,284),(0.754209,-0.151687,284),(0.726348,0.0398516,284),(0.737648,-0.153321,284),(0.71689,0.0183685,284),(0.755629,-0.145689,284),(0.757603,-0.0678057,284),(0.726371,0.0465621,284),(0.726639,0.0378155,284),(0.721755,-0.0286789,284),(0.738363,-0.0342994,284),(0.719075,0.027372,284),(0.747448,-0.0282169,284),(0.739147,-0.0645772,284),(0.744383,-0.155334,284),(0.7052,-0.06769,284),(0.727352,0.048701,284),(0.755077,-0.0510558,284),(0.757837,-0.0474995,284),(0.734859,0.0322237,284),(0.699004,0.00116361,284),(0.705401,0.00745413,284),(0.733082,-0.0991043,284),(0.704876,-0.10059,284),(0.722371,0.0376815,284),(0.733661,0.00221412,284),(0.7471,-0.0292746,284),(0.706399,-0.0624439,284),(0.735075,0.0482875,284),(0.729394,0.0141536,284),(0.72344,0.0392247,284),(0.708026,-0.0568963,284),(0.760173,-0.103408,284),(0.709476,-0.0820305,284),(0.755812,-0.148484,284),(0.703381,-0.0599908,284),(0.698674,-0.0628748,284),(0.727286,-0.0643887,284),(0.710577,0.0101409,284),(0.754273,-0.0477056,284),(0.748746,-0.15068,284),(0.756588,-0.0525239,284),(0.708553,-0.0610417,284),(0.704167,-0.0667566,284),(0.707687,-0.0635644,284),(0.716458,-0.00232705,284),(0.706545,-0.0586424,284),(0.723293,0.0380005,284),(0.706492,-0.064025,284),(0.484446,-0.2719,244),(0.504804,-0.238513,244),(0.626387,-0.0928479,15),(0.705732,-0.0651304,284),(0.722374,0.0377304,284),(0.722342,0.0371767,284),(0.722889,0.0378335,284),(0.722089,0.0376049,284),(0.722883,0.0383856,284),(0.722221,0.0379293,284),(0.705117,-0.0645105,284),(0.705792,-0.0631001,284),(0.704921,-0.0653746,284),(0.704915,-0.0645833,284),(0.705632,-0.0642238,284),(0.705707,-0.0646433,284),(0.704955,-0.0649996,284),(0.705433,-0.0646252,284),(0.705343,-0.0642817,284),(0.673358,-0.00180135,284),(0.648092,-0.0645362,284),(0.726917,-0.0158401,284),(0.727126,-0.0157375,284),(0.726574,-0.0163839,284),(0.726834,-0.0162925,284),(0.754915,-0.0508955,284),(0.495104,-0.289434,244),(0.756169,-0.0336337,284),(0.754675,-0.0503667,284),(0.723231,0.0387376,284),(0.759404,-0.102435,284),(0.644562,-0.0557746,284),(0.747149,-0.0289419,284),(0.74719,-0.0290438,284),(0.74726,-0.0287801,284),(0.747244,-0.0286749,284),(0.70683,-0.0651252,284),(0.704536,-0.0628573,284),(0.138463,0.675733,3),(0.11781,0.670497,3),(0.0852302,0.66468,3),(0.207985,0.657989,3),(0.14748,0.685623,3),(0.125664,0.618719,3),(0.125664,0.673697,3),(0.16697,0.647517,3),(0.100356,0.679224,3),(0.155625,0.673988,3),(0.20973,0.691732,3),(0.165806,0.619592,3),(0.149226,0.685333,3),(0.150098,0.682715,3),(0.144862,0.621046,3),(0.155334,0.696677,3),(0.171042,0.612611,3),(0.235561,0.688974,3),(0.223184,0.690142,3),(0.218268,0.689803,3),(0.1277,0.66468,3),(0.102683,0.680387,3),(0.187041,0.695805,3),(0.19341,0.693653,3),(0.0986111,0.639663,3),(0.133809,0.642863,3),(0.163188,0.747001,3),(0.246145,0.668162,3),(0.16248,0.735234,3),(0.156789,0.660607,3),(0.219911,0.653917,3),(0.122464,0.697841,3),(0.148935,0.662934,3),(0.1245,0.710349,3),(0.159989,0.62541,3),(0.158243,0.671952,3),(0.15388,0.707149,3),(0.171042,0.670206,3),(0.14399,0.603593,3),(0.18675,0.650426,3),(0.171042,0.676024,3),(0.109956,0.643736,3),(0.204834,0.717073,3),(0.121882,0.683878,3),(0.16743,0.730701,3),(0.111992,0.668752,3),(0.194313,0.691732,3),(0.148935,0.607375,3),(0.152716,0.680387,3),(0.206822,0.663516,3),(0.180642,0.658571,3),(0.169006,0.689987,3),(0.229617,0.661446,3),(0.141663,0.669625,3),(0.18675,0.646935,3),(0.127118,0.632391,3),(0.121591,0.660898,3),(0.182387,0.666716,3),(0.155334,0.711803,3),(0.147585,0.63448,3),(0.195186,0.698423,3),(0.100938,0.638209,3),(0.202347,0.652592,3),(0.123256,0.671539,3),(0.175697,0.60272,3),(0.158534,0.713258,3),(0.201823,0.723255,3),(0.123918,0.684169,3),(0.123337,0.657989,3),(0.105301,0.655371,3),(0.246519,0.675869,3),(0.098335,0.667345,3),(0.137008,0.639663,3),(0.211476,0.659443,3),(0.157515,0.676261,3),(0.249181,0.688742,3),(0.19664,0.654208,3),(0.174242,0.697841,3),(1.07436,0.411829,274),(1.05448,0.424458,274),(1.08761,0.486476,274),(1.05233,0.437048,274),(1.06926,0.419424,274),(1.10123,0.377266,274),(1.06117,0.373647,274),(1.05424,0.436793,274),(1.05508,0.388662,274),(1.14927,0.421438,274),(1.07336,0.415164,274),(1.10101,0.482874,274),(1.05379,0.441028,274),(1.09607,0.398517,274),(1.07983,0.504051,274),(1.05389,0.403753,274),(1.16064,0.448841,274),(1.06007,0.432445,274),(1.06687,0.375442,274),(1.05568,0.386921,274),(1.12894,0.427315,274),(1.07309,0.380191,274),(1.0727,0.412461,274),(1.13468,0.444503,274),(1.0553,0.432969,274),(1.0728,0.410152,274),(1.07667,0.475991,274),(1.05825,0.441859,274),(1.05154,0.420019,274),(1.0561,0.392032,274),(1.07018,0.414516,274),(1.08933,0.452947,274),(1.06568,0.491986,274),(1.06435,0.447878,274),(1.04936,0.426533,274),(1.06291,0.464839,274),(1.15134,0.509345,274),(1.09768,0.483055,274),(1.06232,0.466003,274),(1.05534,0.469785,274),(1.10155,0.378425,274),(1.11419,0.403706,274),(1.05424,0.438165,274),(1.14732,0.428718,274),(1.05622,0.470366,274),(1.07275,0.420206,274),(1.12098,0.483953,274),(1.05431,0.390413,274),(1.08618,0.449131,274),(1.0926,0.519465,274),(1.05546,0.437902,274),(1.06291,0.429351,274),(1.07973,0.439649,274),(1.11134,0.396234,274),(1.06765,0.501824,274),(1.10932,0.474567,274),(1.05825,0.434005,274),(1.06552,0.443895,274),(1.05016,0.435206,274),(1.06843,0.454367,274),(1.13755,0.442482,274),(1.05714,0.474694,274),(1.06458,0.426983,274),(1.06142,0.412272,274),(1.05078,0.430262,274),(1.05404,0.44794,274),(1.05912,0.46833,274),(1.05243,0.389215,274),(-0.316631,3.11439,328),(-0.310669,3.0965,328),(-0.307469,3.09738,328),(-0.286525,3.13083,328),(-0.902335,-1.00967,250),(0.12086,2.76043,340),(1.08227,-0.118187,246),(0.850287,0.0435177,291),(0.834404,0.128055,291),(0.884903,0.0561668,291),(0.884366,0.0546955,291),(0.79175,0.0976004,291),(0.851497,0.0419458,291),(0.850557,0.0799942,291),(0.75852,0.0916055,291),(0.839813,-0.0210447,291),(0.849489,0.0417689,291),(0.851734,0.0377307,291),(0.852569,0.0425457,291),(0.852262,0.0444787,291),(0.855364,0.0418563,291),(0.798779,0.0852302,291),(0.84947,0.107352,291),(0.854549,0.044201,291),(0.8542,0.0456339,291),(0.775075,0.0122897,291),(0.850537,0.0427475,291),(0.850618,0.041902,291),(0.854153,0.0404005,291),(0.781441,-0.00949808,291),(0.853175,0.0436332,291),(0.851614,0.0411884,291),(0.802561,0.0823214,291),(0.796088,0.0898073,291),(0.850026,0.0421247,291),(0.824086,0.036361,291),(0.794416,0.0849394,291),(0.804888,0.0596321,291),(0.831358,0.107629,291),(0.823249,-0.0256439,291),(0.851721,0.0372336,291),(0.850772,0.0395834,291),(0.856833,0.0255398,291),(0.854755,0.0342922,291),(0.85812,0.0939568,291),(0.79766,0.0850232,291),(0.834267,0.0186169,291),(0.763086,0.124133,291),(0.851406,0.0382917,291),(0.855793,0.0354883,291),(0.799043,0.085885,291),(0.85213,0.0399724,291),(0.83194,-0.0479966,291),(0.849103,0.107919,291),(0.76058,0.123124,291),(0.878773,0.0616682,291),(0.784235,0.0855211,291),(0.790052,0.0308342,291),(0.842994,0.0712676,291),(0.854331,0.044827,291),(0.851269,0.0352174,291),(0.826995,0.0119264,291),(0.760767,0.0230247,291),(0.866351,-0.0273387,291),(0.885299,0.0551728,291),(0.761038,0.0251968,291),(0.752528,0.103556,291),(0.849684,0.102974,291),(0.852593,0.0462512,291),(0.809251,0.113155,291),(0.861611,0.107629,291),(0.851109,0.0418198,291),(0.866662,0.0576145,291),(0.855655,0.0386924,291),(0.798575,0.0835685,291),(0.754564,0.00145438,291),(0.781991,-0.0103922,291),(0.852967,0.0389085,291),(0.851175,0.0442396,291),(0.847941,0.13514,291),(0.854339,0.041597,291),(0.862362,0.0190251,291),(0.768123,0.085064,291),(0.855004,0.0401698,291),(0.861873,0.0580079,291),(0.752237,0.102102,291),(0.878976,0.0546485,291),(0.800853,0.106261,291),(0.852121,0.0387039,291),(0.854246,0.0441125,291),(0.757504,0.0645178,291),(0.841249,0.0573049,291),(0.858702,0.0450876,291),(0.842412,0.130027,291),(0.867429,0.0863938,291),(0.848361,0.135251,291),(0.851309,0.0399726,291),(0.84957,0.0409864,291),(0.847778,0.0450796,291),(0.824959,-0.00145438,291),(0.854307,0.0382522,291),(0.85713,0.123351,291),(0.855211,0.041597,291),(0.836888,0.0327426,291),(0.85463,0.0392699,291),(0.752548,0.10123,291),(0.761675,0.0889324,291),(0.801878,0.115744,291),(0.823929,-0.0262379,291),(0.75788,0.11822,291),(0.870027,0.0573789,291),(0.797548,0.0862004,291),(0.890662,0.0408379,291),(0.827046,0.0130636,291),(0.855971,0.0370244,291),(0.853466,0.0407243,291),(0.885755,0.0392699,291),(0.82525,-0.0383972,291),(0.848837,0.0402876,291),(0.783599,-0.0125901,291),(0.758383,0.102315,291),(0.851615,0.0435151,291),(0.788283,0.10059,291),(0.852395,0.0421635,291),(0.849103,-0.0351975,291),(0.830574,0.13199,291),(0.85724,-0.0190295,291),(0.855502,0.0392699,291),(0.815603,0.0785543,291),(0.762202,0.125246,291),(0.836209,0.0325474,291),(0.83624,0.034506,291),(0.824103,-0.0287702,291),(0.854749,0.0399207,291),(0.853466,0.036361,291),(0.797538,0.0836606,291),(0.797769,0.084833,291),(0.861808,0.0192801,291),(0.792961,0.0767945,291),(0.798488,-0.0110537,291),(0.849047,0.0404855,291),(0.79826,0.0837213,291),(0.789471,0.0991928,291),(0.848812,0.0863938,291),(0.842703,0.1213,291),(0.854048,0.0413062,291),(0.827286,0.0116356,291),(0.851697,0.0360959,291),(0.852523,0.0384477,291),(0.793665,0.0789833,291),(0.846776,-0.0485783,291),(0.857004,0.116948,291),(0.82665,0.0129142,291),(0.880469,0.0598781,291),(0.853056,0.038217,291),(0.796367,-0.0179437,291),(0.862945,0.0191868,291),(0.884781,0.0554065,291),(0.852945,0.0436175,291),(0.883116,0.0539404,291),(0.826704,0.0305433,291),(0.786208,0.0882473,291),(0.853211,0.0424956,291),(0.851574,0.0462071,291),(0.774099,0.044914,291),(0.801688,-0.0171623,291),(0.803433,0.0709768,291),(0.849122,0.0421333,291),(0.801106,0.0543962,291),(0.799652,0.0855211,291),(0.823471,-0.0270465,291),(0.839712,-0.0292219,291),(0.859575,0.0703949,291),(0.849103,0.0319976,291),(0.837758,-0.0715585,291),(0.853176,0.0390769,291),(0.757588,0.0869331,291),(0.856084,0.0366519,291),(0.838922,-0.0520689,291),(0.81862,0.110923,291),(0.853603,0.105748,291),(0.813033,0.00581771,291),(0.853972,0.0357709,291),(0.833104,-0.0599229,291),(0.852125,0.0341055,291),(0.760364,0.0226455,291),(0.854634,0.0412079,291),(0.782084,-0.0111926,291),(0.762578,0.0960428,291),(0.745214,0.0505344,291),(0.788598,0.0125083,291),(0.755728,-0.0063996,291),(0.852653,0.0409943,291),(0.853368,0.0420511,291),(0.752528,0.0279253,291),(0.850266,0.0392699,291),(0.851145,0.0465778,291),(0.807375,0.098738,291),(0.884975,0.0277455,291),(0.797925,0.0838425,291),(0.856248,0.0359857,291),(0.825034,-0.0283075,291),(0.849901,0.0381751,291),(0.850812,0.0417574,291),(0.836063,0.0332291,291),(0.770374,0.0839139,291),(0.835353,0.0331455,291),(0.866139,-0.0286843,291),(0.865392,0.0523599,291),(0.853317,0.0430138,291),(0.85259,0.0447269,291),(0.85257,0.0458035,291),(0.859951,0.0431225,291),(0.852302,0.0433423,291),(0.808491,-0.00800705,291),(0.765036,0.0759218,291),(0.762764,0.126817,291),(0.820123,0.055135,291),(0.853197,0.0396129,291),(0.852658,0.044489,291),(0.852828,0.043738,291),(0.753691,0.0523599,291),(0.824097,-0.0271112,291),(0.853326,0.0385151,291),(0.849684,0.10821,291),(0.758637,0.0235619,291),(0.833395,0.127991,291),(0.812742,0.0581776,291),(0.760941,0.122249,291),(0.849309,0.0410742,291),(0.847939,-0.0669042,291),(0.863293,0.0190876,291),(0.852003,0.0403859,291),(0.85284,0.0426422,291),(0.761154,0.0676704,291),(0.855006,0.0409,291),(0.808669,0.0453786,291),(0.864727,0.00327581,291),(0.856858,0.107367,291),(0.854897,0.0384034,291),(0.851134,0.0355009,291),(0.85007,0.0427674,291),(0.853435,0.0450143,291),(0.853627,0.0373071,291),(0.844448,0.0514872,291),(0.77769,0.0829195,291),(0.766029,-0.00867656,291),(0.814487,0.0762128,291),(0.79587,0.0706858,291),(0.829322,0.118682,291),(0.768236,0.0235619,291),(0.837758,0.0479966,291),(0.883718,0.0543962,291),(0.848685,0.0454004,291),(0.85492,0.0456695,291),(0.760731,0.0873474,291),(0.76969,0.0538143,291),(0.798779,0.0872665,291),(0.789236,0.101056,291),(0.851962,0.0390081,291),(0.85729,0.107734,291),(0.782474,-0.0110621,291),(0.764044,0.130976,291),(0.847066,0.0465422,291),(0.854516,0.0502454,291),(0.842994,-0.0107629,291),(0.851107,0.0336714,291),(0.761279,0.0699421,291),(0.87753,0.0693362,291),(0.850445,0.039846,291),(0.757601,0.0882309,291),(0.755674,0.0939174,291),(0.776672,0.00290894,291),(0.852884,0.036361,291),(0.757753,0.0910107,291),(0.8843,0.0538143,291),(0.854753,0.0297148,291),(0.85492,0.0299615,291),(0.764957,0.101,291),(0.760091,0.121009,291),(0.85207,0.0401422,291),(0.854385,0.037441,291),(0.851925,0.0425764,291),(0.808087,0.0843575,291),(0.798461,0.084591,291),(0.84823,0.113446,291),(0.762321,0.0721887,291),(0.845383,0.0255445,291),(0.858993,0.0203622,291),(0.752237,-0.000872665,291),(0.783216,-0.00903766,291),(0.833395,-0.0587595,291),(0.883308,0.052687,291),(0.814487,0.0968658,291),(0.849889,0.040271,291),(0.883897,0.0521356,291),(0.852339,0.0459018,291),(0.853803,0.0443846,291),(0.766534,0.0881552,291),(0.85777,0.00400117,291),(0.847489,0.134085,291),(0.799911,0.0219528,291),(0.850757,0.0434072,291),(0.855133,0.0303829,291),(0.883712,0.0533823,291),(0.879992,0.048532,291),(0.783944,-0.00407238,291),(0.85143,0.0407243,291),(0.853341,0.0372293,291),(0.853359,0.0399443,291),(0.811578,-0.031125,291),(0.757652,0.0927304,291),(0.853585,0.0437463,291),(0.855067,0.0333309,291),(0.853116,0.0422469,291),(0.817978,-0.0177442,291),(0.852106,0.0346757,291),(0.78616,0.0678101,291),(0.853213,0.0419616,291),(0.767268,0.0848244,291),(0.851908,0.0449183,291),(0.851527,0.0396326,291),(0.862426,0.0185275,291),(0.852593,0.0436332,291),(0.853347,0.0367167,291),(0.880222,0.0493563,291),(0.847036,0.0458723,291),(0.837758,0.00349066,291),(0.851977,0.0412025,291),(0.86383,0.0018792,291),(0.862206,0.018253,291),(0.816939,0.0770793,291),(0.852108,0.0370382,291),(0.760556,0.122507,291),(0.783059,-0.0103692,291),(0.854142,0.0429592,291),(0.849681,0.107303,291),(0.75289,0.104425,291),(0.838922,-0.0133809,291),(0.760397,0.0681481,291),(0.778919,-0.0199071,291),(0.752205,0.102708,291),(0.814487,-0.0250163,291),(0.80576,-0.0200713,291),(0.865102,0.0631228,291),(0.850557,-0.0605048,291),(0.833592,-0.0582879,291),(0.845656,-0.0742205,291),(0.884009,0.0529416,291),(0.88394,0.0536837,291),(0.852884,0.0474148,291),(0.853548,0.0392158,291),(0.752634,0.10485,291),(0.83249,-0.00131825,291),(0.753106,0.106016,291),(0.853956,0.0418228,291),(0.753542,0.0978168,291),(0.825468,-0.0271065,291),(0.852598,0.0374413,291),(0.855398,0.0356096,291),(0.826452,0.0116773,291),(0.852164,0.0431896,291),(0.851994,0.0416238,291),(0.759509,0.0869755,291),(0.852088,0.0397443,291),(0.794997,0.0567232,291),(0.833934,0.128223,291),(0.84699,0.134656,291),(0.752578,0.107145,291),(0.853843,0.0382686,291),(0.858892,-0.00534996,291),(0.855036,0.0378719,291),(0.879883,0.0517464,291),(0.884054,0.0556203,291),(0.885296,0.0442841,291),(0.861046,0.105639,291),(0.877041,0.0684419,291),(0.86142,0.108081,291),(0.883281,0.0522103,291),(0.886388,0.0545609,291),(0.851992,0.13597,291),(0.851255,0.0361969,291),(0.778999,-0.0186169,291),(0.80576,0.0325795,291),(0.826049,-0.0423817,291),(0.849175,0.0417732,291),(0.788307,0.0997747,291),(0.762127,0.120719,291),(0.890387,0.0401382,291),(0.78143,-0.0107151,291),(0.85545,0.0430389,291),(0.854983,0.0427417,291),(0.795594,0.0832969,291),(0.849684,0.0372336,291),(0.832405,0.0459186,291),(0.851947,0.0408704,291),(0.854048,0.0401426,291),(0.854651,0.0418497,291),(0.758431,0.0954543,291),(0.852458,0.0380887,291),(0.777835,0.106174,291),(0.853175,0.0442149,291),(0.758319,0.0655197,291),(0.850947,0.0405337,291),(0.758046,0.117552,291),(0.85492,0.038979,291),(0.843867,-0.020944,291),(0.758132,0.086299,291),(0.858411,0.120428,291),(0.85267,0.0433309,291),(0.810996,-0.0142536,291),(0.851603,0.040016,291),(0.844739,0.0471239,291),(0.788861,0.099181,291),(0.782473,-0.00897291,291),(0.836594,0.0334773,291),(0.850625,-0.0100297,291),(0.792158,0.0748875,291),(0.868439,0.00653748,291),(0.882846,0.0535235,291),(0.783365,-0.0112898,291),(0.848812,0.0427606,291),(0.855633,0.0200856,291),(0.845321,0.0375246,291),(0.825405,-0.0412587,291),(0.855038,0.0394102,291),(0.855502,0.0366519,291),(0.866533,-0.0288513,291),(0.8544,0.0404068,291),(0.840958,0.112574,291),(0.856084,0.0689405,291),(0.860215,0.0175036,291),(0.851445,0.0341247,291),(0.798964,0.0833362,291),(0.78791,0.0999869,291),(0.855161,0.039837,291),(0.890991,0.0413062,291),(0.850557,0.0238529,291),(0.849708,0.0421354,291),(0.853916,0.0426791,291),(0.7598,0.112865,291),(0.839423,-0.075556,291),(0.879064,0.0535235,291),(0.855697,0.040603,291),(0.82205,0.0959931,291),(0.825832,0.0875574,291),(0.76956,0.108769,291),(0.871501,0.0189077,291),(0.854805,0.0406177,291),(0.878412,0.0592417,291),(0.79882,0.0867912,291),(0.762889,-0.0183898,291),(0.846776,0.0462512,291),(0.759853,0.0234621,291),(0.884506,0.0549657,291),(0.85143,0.0430515,291),(0.859288,0.0504063,291),(0.859692,0.0433674,291),(0.801106,0.106465,291),(0.798234,0.0557821,291),(0.853409,0.0393861,291),(0.851974,0.0538431,291),(0.824059,-0.0300495,291),(0.890517,0.041776,291),(0.854707,0.0384829,291),(0.848335,0.0434163,291),(0.855239,0.0365985,291),(0.835577,-0.0684597,291),(0.862506,0.0493241,291),(0.849364,0.0448475,291),(0.851688,0.0454965,291),(0.761181,0.0232614,291),(0.853794,0.0393404,291),(0.839212,0.128573,291),(0.797615,-0.00581771,291),(0.803942,0.114755,291),(0.853644,0.0445624,291),(0.853469,0.0403087,291),(0.799006,0.0538657,291),(0.851773,0.0395652,291),(0.821468,-0.015417,291),(0.85117,0.042215,291),(0.850235,0.0404285,291),(0.851106,0.0410205,291),(0.866379,-0.0282108,291),(0.825423,0.0873462,291),(0.851669,0.0443394,291),(0.853136,0.0452555,291),(0.851819,0.038199,291),(0.839794,0.0895935,291),(0.853288,0.0376752,291),(0.851763,0.0400284,291),(0.851111,0.0395588,291),(0.816814,0.00930836,291),(0.856084,0.0593412,291),(0.817105,0.0296706,291),(0.839212,0.023271,291),(0.845557,0.0259923,291),(0.868592,0.0823214,291),(0.852106,0.0421003,291),(0.852593,0.0453786,291),(0.852007,0.0435226,291),(0.795288,0.103556,291),(0.798935,0.0534612,291),(0.816523,0.0846485,291),(0.854407,0.0762227,291),(0.817576,-0.0327232,291),(0.780921,-0.0118517,291),(0.839873,-0.0279776,291),(0.855847,0.0362353,291),(0.782883,-0.00904761,291),(0.86496,0.0284145,291),(0.76649,0.0922115,291),(0.765,0.0878923,291),(0.760964,0.0392699,291),(0.761545,0.0680678,291),(0.881258,0.0516295,291),(0.85433,0.0356166,291),(0.82551,-0.0260096,291),(0.768818,0.0881391,291),(0.754273,0.0410152,291),(0.862902,0.0178825,291),(0.760114,0.122396,291),(0.875574,0.0564323,291),(0.799193,0.0844935,291),(0.889387,0.0323244,291),(0.775783,0.0250739,291),(0.762091,0.12485,291),(0.858455,-0.00626783,291),(0.851656,0.0407815,291),(0.852386,0.0440675,291),(0.849874,0.0434976,291),(0.8811,0.0445059,291),(0.798197,0.0858121,291),(0.788016,0.0267617,291),(0.757473,0.105883,291),(0.849684,0.0456695,291),(0.848428,0.0402461,291),(0.844739,-0.0782489,291),(0.817687,-0.0084357,291),(0.795579,0.0922115,291),(0.78463,0.0856997,291),(0.851352,0.0404534,291),(0.821759,0.0418879,291),(0.806442,0.0912074,291),(0.885173,0.0282162,291),(0.852302,0.0392699,291),(0.823405,-0.0282993,291),(0.782613,-0.0101316,291),(0.851188,0.0432719,291),(0.853497,0.0434467,291),(0.850874,0.0438362,291),(0.853804,0.0397034,291),(0.853466,0.0427606,291),(0.830486,0.023271,291),(0.783871,-0.0111113,291),(0.761535,0.0243297,291),(0.848511,0.135323,291),(0.758871,-0.02715,291),(0.853889,0.0386206,291),(0.756559,0.056182,291),(0.881973,0.0459603,291),(0.824647,0.105037,291),(0.78278,0.0084357,291),(0.879646,0.0279253,291),(0.879769,0.027305,291),(0.831358,0.119846,291),(0.782055,-0.00956598,291),(0.862774,0.036361,291),(0.820886,0.0843575,291),(0.758927,-0.025889,291),(0.860051,-0.0122854,291),(0.745304,0.164934,291),(0.85143,0.0901754,291),(0.761157,0.0261702,291),(0.770736,0.0805951,291),(0.852884,0.0421788,291),(0.851645,0.0402815,291),(0.844778,0.0474768,291),(0.879827,0.0494021,291),(0.767043,0.0839315,291),(0.834267,0.0622501,291),(0.819432,0.0750492,291),(0.783944,0.0427606,291),(0.854132,0.0435289,291),(0.828739,0.119615,291),(0.761836,0.010181,291),(0.853757,0.041597,291),(0.755601,0.0972265,291),(0.850066,0.041739,291),(0.853757,0.0398516,291),(0.877779,0.0485526,291),(0.884632,0.0503028,291),(0.762304,0.0808142,291),(0.854339,0.0392699,291),(0.850848,-0.000290946,291),(0.851719,0.0407109,291),(0.850848,0.0401426,291),(0.760307,0.124403,291),(0.789582,0.08152,291),(0.806244,0.108869,291),(0.80145,0.107232,291),(0.801106,0.106756,291),(0.796743,0.00261799,291),(0.758811,-0.0264149,291),(0.82845,-0.00959931,291),(0.870919,0.0401426,291),(0.756351,0.0956791,291),(0.851821,0.042244,291),(0.770272,0.0712676,291),(0.845321,0.00145438,291),(0.76672,0.0374897,291),(0.797171,0.111537,291),(0.731768,0.152448,291),(0.797325,0.103366,291),(0.759712,0.0951157,291),(0.771436,0.0110537,291),(0.755917,0.0606647,291),(0.854533,0.0361077,291),(0.87441,0.0319976,291),(0.883428,0.0552683,291),(0.849655,0.0378639,291),(0.795628,0.0920419,291),(-0.0497419,0.192568,32),(-0.0125547,0.153266,32),(0.0279165,0.202097,32),(-0.0326108,0.192963,32),(-0.0271828,0.230693,32),(0.00684885,0.164996,32),(-0.012219,0.178731,32),(-0.0197278,0.217705,32),(-0.028507,0.237078,32),(0.941738,-0.0188969,282),(0.889098,-0.045939,282),(0.940111,-0.0294512,282),(0.899556,-0.0422089,282),(0.925839,-0.0522084,282),(0.88688,-0.00647971,282),(0.930292,-0.0196182,282),(0.953692,-0.0618567,282),(0.910876,-0.0387465,282),(0.900754,0.000406487,282),(0.934133,-0.0243819,282),(0.91779,-0.0370526,282),(0.897295,-0.0145848,282),(0.895686,-0.00975517,282),(0.903794,-0.0259251,282),(0.904082,0.0111767,282),(0.973312,-0.0683588,282),(0.919199,0.00278171,282),(0.928224,-0.0439242,282),(0.898554,-0.010472,282),(0.891255,-0.0230157,282),(0.93075,-0.0389467,282),(0.918043,-0.0354883,282),(0.917716,-0.0190674,282),(0.934333,-0.0456695,282),(0.931339,-0.0477183,282),(0.900782,0.00913348,282),(0.896413,0.0179018,282),(0.960625,-0.0252572,282),(0.952059,-0.0625547,282),(0.934624,-0.0401426,282),(0.958982,-0.0292578,282),(0.883335,-0.0428189,282),(0.896613,-0.00790582,282),(0.896157,-0.0519523,282),(0.897097,-0.00663173,282),(0.934606,-0.0440633,282),(0.916624,-0.0348106,282),(0.923799,-0.0196414,282),(0.904111,-0.00361126,282),(0.919789,-0.0439242,282),(0.912855,-0.0121206,282),(0.898189,0.0018778,282),(0.918043,-0.036361,282),(0.917195,-0.0353176,282),(0.933802,-0.0234886,282),(0.901555,-0.00691185,282),(0.888035,-0.0179839,282),(0.958186,-0.0264709,282),(0.912516,-0.0276343,282),(0.931876,-0.0450337,282),(0.893684,-0.038026,282),(0.904301,-0.000494277,282),(0.896843,-0.0073419,282),(0.902108,-7.34784e-005,282),(0.917786,-0.0346266,282),(0.959776,-0.0267728,282),(0.932411,-0.0534938,282),(0.934042,-0.0418879,282),(0.936951,-0.0261394,282),(0.932853,-0.0410884,282),(0.889585,0.0016736,282),(0.960243,-0.0248812,282),(0.933994,-0.0430667,282),(0.877294,-0.0882152,282),(0.895684,-0.0385475,282),(0.8887,-0.0260119,282),(0.88076,-0.0613368,282),(0.893476,0.00480524,282),(0.888373,-0.0607956,282),(0.916814,-0.0360887,282),(0.951786,-0.0226893,282),(0.914843,0.01309,282),(0.897163,-0.0219997,282),(0.882223,-0.0610232,282),(0.890379,-0.0541563,282),(0.918636,-0.0295985,282),(0.896234,-0.019696,282),(0.933751,-0.0410152,282),(0.899856,-0.0310871,282),(0.900953,-0.0688223,282),(0.897922,0.00541541,282),(0.89705,0.00302308,282),(0.92108,-0.0271825,282),(0.927213,-0.0220147,282),(0.917461,-0.0317069,282),(0.896227,-0.00349066,282),(0.958267,-0.0241243,282),(0.897205,-0.00722043,282),(0.903208,-0.0383972,282),(0.897028,0.00861512,282),(0.932878,-0.0404335,282),(0.910916,-0.0297987,282),(0.910869,0.0174138,282),(0.91368,-0.0395609,282),(0.915531,-0.0374054,282),(0.925097,-0.0381421,282),(0.9524,-0.0230157,282),(0.932177,-0.0376574,282),(0.979462,-0.0687105,282),(0.905865,-0.00353534,282),(0.929679,-0.0235619,282),(0.918916,-0.0084357,282),(0.933474,-0.0359377,282),(0.897639,-0.00883241,282),(0.921625,-0.0369374,282),(0.954674,-0.0279652,282),(0.921309,-0.0026426,282),(0.959906,-0.0249984,282),(0.886488,-0.0189531,282),(0.936331,-0.052473,282),(0.898984,0.00494504,282),(0.899505,0.0124674,282),(0.935446,-0.0223461,282),(0.899769,0.00976721,282),(0.888442,-0.0245093,282),(0.899001,-0.00648041,282),(0.914801,-0.0310833,282),(0.89901,-0.0103919,282),(0.924994,-0.00714555,282),(0.934628,-0.0484064,282),(0.927531,0.00586954,282),(0.896074,0.0127901,282),(0.919965,-0.0480329,282),(0.887223,-0.00478761,282),(0.895937,0.00310686,282),(0.939569,-0.0308342,282),(0.931709,-0.0255848,282),(0.89483,0.00336465,282),(0.938696,-0.0186169,282),(0.957122,-0.0234878,282),(0.886128,0.0017921,282),(0.935131,-0.0114209,282),(0.947359,-0.00705863,282),(0.884037,-0.0202638,282),(0.927558,-0.0412336,282),(0.891328,-0.0313407,282),(0.933537,-0.0399754,282),(0.932445,-0.040569,282),(0.911353,-0.00465427,282),(0.932878,-0.0477056,282),(0.87857,-0.0831794,282),(0.983296,-0.0488521,282),(0.903208,-0.00581771,282),(0.918334,-0.0410152,282),(0.885405,-0.0202825,282),(0.974397,-0.073544,282),(0.912657,-0.0104585,282),(0.930989,-0.0476691,282),(0.900126,-0.0073899,282),(0.920824,-0.033806,282),(0.914045,-0.0220639,282),(0.934887,-0.0370476,282),(0.89243,0.00459598,282),(0.886799,-0.00103655,282),(0.932532,-0.0236803,282),(0.889927,-0.026178,282),(0.900275,0.0123348,282),(0.896883,0.00882194,282),(0.935805,-0.0376153,282),(0.900729,-0.0541193,282),(0.944838,-0.0265503,282),(0.925606,-0.0244346,282),(0.930602,-0.0608879,282),(0.901619,-0.0601938,282),(0.97515,-0.0766641,282),(0.894264,-0.00362679,282),(0.894315,-0.00297474,282),(0.912921,-0.0339587,282),(0.953239,-0.0185003,282),(0.898081,-0.0169494,282),(0.90034,0.0105521,282),(0.937255,-0.0398706,282),(0.933064,-0.0234637,282),(0.895978,0.0247055,282),(0.936332,-0.0404363,282),(0.895996,-0.00195494,282),(0.938906,-0.0289959,282),(0.968367,-0.0805761,282),(0.934333,-0.0398516,282),(0.938405,-0.0474148,282),(0.930915,-0.0594766,282),(0.93252,-0.0488746,282),(0.939569,-0.0520689,282),(0.902222,-0.00311279,282),(0.88661,-0.0190459,282),(0.887384,-0.00376014,282),(0.89853,-0.0483409,282),(0.898479,-0.0646404,282),(0.976244,-0.0818472,282),(0.885173,-0.0349066,282),(0.900627,-0.0583308,282),(0.902355,-0.0531355,282),(0.937086,-0.0229108,282),(0.977219,-0.0647058,282),(0.878948,-0.0713925,282),(0.879149,-0.0723099,282),(0.899959,0.00887657,282),(0.900482,-0.00666995,282),(0.955748,-0.0233262,282),(1.00367,-0.0313821,282),(0.917583,-0.0043244,282),(0.984282,-0.0598891,282),(0.874735,-0.0966415,282),(0.974446,-0.0562734,282),(0.897787,-0.0554332,282),(0.974447,-0.0773624,282),(0.880268,-0.0622714,282),(0.903247,-0.0219206,282),(0.922615,-0.0533193,282),(0.936889,-0.0275772,282),(0.896655,0.0017078,282),(0.934918,-0.0502965,282),(0.95295,-0.127409,282),(0.934458,-0.0369713,282),(0.918152,-0.0189113,282),(0.916703,-0.0255731,282),(0.924215,-0.0200795,282),(0.918529,0.0226603,282),(0.929586,-0.043847,282),(0.960218,-0.0252942,282),(0.899692,-0.00641897,282),(0.88713,-0.00562816,282),(0.911935,-0.015417,282),(0.948395,-0.0250006,282),(0.952816,-0.0993253,282),(0.953994,-0.103124,282),(0.973428,-0.0756319,282),(0.932878,-0.0453786,282),(0.953271,-0.0274348,282),(0.88189,-0.0630388,282),(0.945592,-0.110608,282),(0.879876,-0.0886952,282),(0.909095,-0.0126044,282),(0.900376,-0.0523311,282),(0.884907,-0.0225364,282),(0.885859,-0.0290737,282),(0.911842,0.00705427,282),(0.897084,-0.00446106,282),(0.959465,-0.0281689,282),(0.925025,-0.038979,282),(0.897105,-0.0230486,282),(0.959715,-0.0304412,282),(0.926188,-0.0142536,282),(0.939569,-0.0383972,282),(0.901692,-0.0663998,282),(0.897665,-0.0481444,282),(0.976367,-0.053231,282),(0.973706,-0.0696713,282),(0.937942,-0.0279038,282),(0.932006,-0.0543962,282),(0.943671,-0.0499353,282),(0.897182,-0.00286304,282),(0.936778,-0.0296071,282),(0.908299,-0.0131917,282),(0.934624,-0.0383972,282),(0.952535,-0.0215518,282),(0.933645,-0.0225572,282),(0.903172,-0.0589536,282),(0.920938,-0.0154798,282),(0.93191,-0.0360047,282),(0.900055,-0.0135115,282),(0.915907,-0.0160663,282),(0.896773,0.0241932,282),(0.917193,0.00154078,282),(0.927903,-0.0208364,282),(0.927352,-0.020944,282),(0.898632,-0.0437036,282),(0.933419,-0.0390505,282),(0.932297,-0.020944,282),(0.902878,0.0117745,282),(0.894772,0.00901759,282),(0.899242,-0.0125639,282),(0.934034,-0.0513331,282),(0.900752,-0.0638482,282),(0.929566,-0.0370994,282),(0.905471,-0.0072864,282),(0.915865,0.030571,282),(0.931424,-7.64454e-005,282),(0.920952,-0.020944,282),(0.897045,0.00527299,282),(0.923254,-0.0221894,282),(0.959882,-0.127569,282),(0.959898,-0.127572,282),(0.899068,-0.00160291,282),(0.898993,-0.00219458,282),(0.937756,-0.0261271,282),(0.90202,-0.072639,282),(0.930696,-0.0668719,282),(0.975689,-0.0614811,282),(0.93219,-0.0519749,282),(0.886748,-0.00938673,282),(0.933226,-0.0523265,282),(0.951612,-0.105335,282),(0.928983,-0.00938847,282),(0.919466,-0.0318608,282),(0.937204,-0.0469071,282),(0.887912,0.000197746,282),(0.907212,-0.00398633,282),(0.906126,-0.0114846,282),(0.93346,-0.0439242,282),(0.918717,-0.0197517,282),(0.926846,-0.0352918,282),(0.938926,-0.0270151,282),(0.895283,-0.00568803,282),(0.912807,-0.0267617,282),(0.957313,-0.10152,282),(0.97273,-0.0692315,282),(0.943641,-0.0494509,282),(0.976326,-0.0724769,282),(0.979301,-0.0551784,282),(0.926767,-0.0217082,282),(0.93346,-0.0506145,282),(0.89802,-0.0437786,282),(0.916255,-0.0378543,282),(0.93802,-0.00585122,282),(0.920691,0.00689684,282),(0.971334,-0.0821467,282),(0.970607,-0.0784667,282),(0.926541,-0.0390565,282),(0.904459,-0.0224903,282),(0.914346,-0.0392699,282),(0.897341,-0.0435948,282),(0.914524,-0.012666,282),(0.913555,-0.0275788,282),(0.948182,-0.0479541,282),(0.909596,-0.00873433,282),(0.940172,-0.0332771,282),(0.974401,-0.0788199,282),(0.959588,-0.0259047,282),(0.899477,-0.00179839,282),(0.898411,-0.00597705,282),(0.970742,-0.0812465,282),(0.932748,-0.0422933,282),(0.908604,0.0201664,282),(1.0032,-0.0737224,282),(0.92451,-0.0228553,282),(0.887675,-0.0244629,282),(0.932901,-0.0362929,282),(0.932207,-0.049556,282),(0.913339,-0.00325521,282),(0.936352,-0.0311395,282),(0.925606,-0.020944,282),(0.933751,-0.0253073,282),(0.887166,-0.00291819,282),(0.957144,-0.0255563,282),(0.935518,-0.0445015,282),(0.891234,-0.00571054,282),(0.93965,-0.0286297,282),(0.893159,-0.00277839,282),(0.903408,-0.000199666,282),(0.906753,-0.00462844,282),(0.934333,-0.0450876,282),(0.916977,-0.024018,282),(0.901097,-0.0130785,282),(0.973621,-0.0715597,282),(0.930737,-0.0540438,282),(0.904009,-0.00137078,282),(0.896628,0.0196973,282),(0.908563,-0.0473825,282),(0.903272,-0.00829328,282),(0.95946,-0.0264498,282),(0.925264,-0.0236288,282),(0.931715,-0.0369429,282),(0.890078,-0.00179996,282),(0.89912,-0.00738972,282),(0.933179,-0.0468038,282),(0.92825,-0.0528098,282),(0.909007,0.00766042,282),(0.887617,-0.0172018,282),(0.903441,-0.00391285,282),(0.887591,0.00999934,282),(0.937299,-0.0405583,282),(0.906558,0.0224165,282),(0.954453,-0.0211621,282),(0.942317,-0.0268309,282),(0.904374,-0.00623187,282),(0.903671,0.00194744,282),(0.897332,-0.00640553,282),(0.973312,-0.0703949,282),(0.937533,-0.0322886,282),(0.915401,-0.0357684,282),(0.8939,-0.0136717,282),(0.887713,0.00449859,282),(0.899764,0.0106435,282),(0.940307,-0.0298856,282),(0.951811,-0.0184317,282),(0.894226,-0.0100229,282),(0.900756,-0.0248163,282),(0.976483,-0.0830988,282),(0.899345,-0.00619732,282),(0.918188,0.0302033,282),(0.919139,-0.0351005,282),(0.931872,-0.0460756,282),(0.909519,-0.0405815,282),(0.89842,0.00567599,282),(0.897821,0.00652247,282),(0.92348,-0.0112022,282),(0.977584,-0.0649582,282),(0.886542,-0.0197051,282),(0.959931,-0.0282162,282),(0.9018,-0.0705398,282),(0.937533,-0.0151262,282),(0.933348,-0.0453176,282),(0.89334,-0.010773,282),(0.905227,-0.0391495,282),(0.932761,-0.0340165,282),(0.98079,-0.0553821,282),(0.975031,-0.0743097,282),(0.89691,0.0095754,282),(0.973959,-0.0749598,282),(0.901715,-0.0568298,282),(0.959269,-0.0279546,282),(0.938843,-0.0240972,282),(0.931715,-0.0133809,282),(0.939569,-0.0509055,282),(0.894103,-0.0405285,282),(0.904757,0.0217512,282),(0.934687,-0.0535495,282),(0.891572,0.020653,282),(0.941173,-0.0525492,282),(0.895063,-0.0145444,282),(0.897906,-0.00722357,282),(0.95911,-0.0274282,282),(0.906939,0.0235811,282),(0.895612,0.0155083,282),(0.934624,-0.0418879,282),(0.893859,-0.0138906,282),(0.895253,-0.0131886,282),(0.887528,-0.0205825,282),(0.87536,-0.0885079,282),(0.97737,-0.0660979,282),(0.883437,-0.0593819,282),(0.885294,-0.0615667,282),(0.909183,-0.0340142,282),(0.896563,-0.00638302,282),(0.895886,-0.00471431,282),(0.887461,-0.0163532,282),(0.92989,-0.0506379,282),(1.00618,-0.0581776,282),(0.89765,-0.00964102,282),(0.976548,-0.0557891,282),(0.93346,-0.0407243,282),(0.903682,-0.0559888,282),(0.925025,-0.0226893,282),(0.930647,-0.0164611,282),(0.897077,-0.00609399,282),(0.889536,-0.0235619,282),(0.973312,-0.0727221,282),(0.892279,-0.000106465,282),(0.919498,0.0162897,282),(0.886081,0.00496599,282),(0.956035,-0.0275005,282),(0.905582,-0.00909299,282),(0.978633,-0.0603687,282),(0.986111,-0.0517782,282),(0.976413,-0.0797722,282),(0.933314,-0.036444,282),(0.916298,-0.036361,282),(0.933403,-0.0374448,282),(0.930299,-0.0257448,282),(0.912225,-0.0375246,282),(0.892445,0.0226893,282),(0.894183,-0.00574946,282),(0.885173,-0.0424696,282),(0.934157,-0.0198428,282),(0.900752,-0.0216794,282),(0.937081,-0.0284326,282),(0.923677,-0.0257721,282),(0.932997,-0.0369699,282),(0.894014,0.02451,282),(0.912055,-0.0202573,282),(0.937207,-0.0430213,282),(0.93527,-0.026647,282),(0.897859,0.00383344,282),(0.951628,-0.0270594,282),(0.899717,0.00290894,282),(0.90154,-0.052758,282),(0.976457,-0.0696475,282),(0.89658,-0.0138263,282),(0.891173,0.00282237,282),(0.926733,-0.0426141,282),(0.892091,-0.00319605,282),(0.961441,-0.0276806,282),(0.902883,-0.0210735,282),(0.885983,-0.0226495,282),(0.914667,-0.0263923,282),(0.895703,-0.00245882,282),(0.916234,-0.0120321,282),(0.957384,-0.0319674,282),(0.933435,-0.0215049,282),(0.927872,-0.0386159,282),(0.93017,-0.0650439,282),(0.939984,-0.0378476,282),(0.962258,-0.116355,282),(0.905638,0.0157814,282),(0.899229,-0.0620519,282),(0.895877,-0.00717854,282),(0.974979,-0.0702441,282),(0.920079,-0.0238529,282),(0.975663,-0.076894,282),(0.902044,-0.0680678,282),(0.940151,-0.0418879,282),(0.897807,-0.0498719,282),(0.934807,-0.000562869,282),(0.937662,-0.0298964,282),(0.9039,0.0201755,282),(0.902633,-0.0343524,282),(0.885459,-0.0309913,282),(0.936369,-0.0456695,282),(0.897398,0.00119695,282),(0.89951,-0.0417795,282),(0.898146,-0.0370834,282),(0.887268,-0.0136141,282),(0.957464,-0.0274729,282),(0.929388,-0.0247256,282),(0.928349,-0.050473,282),(0.896443,-0.00531051,282),(0.902473,-0.000652579,282),(0.902335,-0.010472,282),(0.905826,-0.036361,282),(0.898627,-0.00295589,282),(0.902959,0.00819572,282),(0.931589,-0.0382175,282),(0.896731,0.0092129,282),(0.933141,-0.0256942,282),(0.890331,-0.0241093,282),(0.900744,-0.00970717,282),(0.895045,-0.00137689,282),(0.952487,-0.102708,282),(0.937693,-0.0237812,282),(0.896546,-0.0029243,282),(0.954971,-0.10133,282),(0.90505,-0.0751425,282),(0.9581,-0.0512813,282),(0.898495,-0.0555015,282),(0.894988,0.0188482,282),(0.919622,-0.035445,282),(0.911062,0.00203628,282),(0.876383,-0.0924555,282),(0.896001,-0.012961,282),(0.900145,-0.0561647,282),(0.929517,-0.0333326,282),(0.901343,-0.00629244,282),(0.91187,0.0124112,282),(0.935496,-0.0401426,282),(0.921661,-0.0286693,282),(0.919453,-0.0336428,282),(0.938987,-0.038979,282),(0.894283,-0.0523215,282),(0.889392,-0.00231902,282),(0.927933,-0.0538143,282),(0.980377,-0.0529493,282),(0.926188,-0.0535235,282),(0.918625,-0.033743,282),(0.913431,-0.0359508,282),(0.896385,0.0251219,282),(0.879547,-0.0613632,282),(0.901132,-0.0666538,282),(0.898063,-0.0453201,282),(0.887123,-0.00243421,282),(0.937298,-0.0311416,282),(0.915979,-0.0370252,282),(0.943927,-0.00334964,282),(0.892358,-0.052422,282),(0.898946,-0.0624343,282),(0.900961,0.00533303,282),(0.931273,-0.0377932,282),(0.905445,0.00965027,282),(0.938881,-0.0305792,282),(0.897337,-0.0130994,282),(0.885239,-0.0328035,282),(0.924611,-0.000464956,282),(0.901544,-0.00484538,282),(0.933169,-0.0526508,282),(0.935206,-0.0424696,282),(0.886314,-0.0118644,282),(0.962149,-0.0263293,282),(0.918358,-0.0349818,282),(0.907455,-0.0128231,282),(0.939278,-0.0532325,282),(0.938114,-0.0433423,282),(0.889532,-0.0231836,282),(0.905322,0.00276949,282),(0.975756,-0.07363,282),(0.953919,-0.0292702,282),(0.915974,-0.0331583,282),(0.93189,-0.052618,282),(0.939836,-0.0320891,282),(0.953094,-0.0225521,282),(0.90109,0.00732392,282),(0.909081,-0.0046239,282),(0.89043,-0.0733838,282),(0.927071,-0.0379756,282),(0.905826,-0.0201336,282),(0.897826,0.00259461,282),(0.887504,0.00821963,282),(0.939788,-0.00738833,282),(0.973603,-0.0349066,282),(0.903389,-0.009866,282),(0.934333,-0.0200713,282),(0.925431,-0.0258516,282),(0.974185,-0.0701041,282),(0.952659,-0.103556,282),(0.915933,-0.0256405,282),(0.962211,-0.0278064,282),(0.90992,-0.00813882,282),(0.897253,-0.00044087,282),(0.931133,-0.0526508,282),(0.975907,-0.0756214,282),(0.937293,-0.0285134,282),(0.975675,-0.0635995,282),(0.896714,-0.0411735,282),(0.894699,-0.0189731,282),(0.900039,0.00799047,282),(0.897216,-0.0570625,282),(0.944514,-0.0564323,282),(0.973879,-0.0766697,282),(0.891518,-0.0708269,282),(0.934624,-0.025889,282),(0.901463,-0.00349066,282),(0.899426,0.00145438,282),(0.895791,-0.00341543,282),(0.953881,-0.0989418,282),(0.928977,-0.0721622,282),(0.908622,-0.0233925,282),(0.948586,-0.109665,282),(0.95755,-0.109542,282),(0.939809,-0.0312039,282),(0.968007,-0.0808773,282),(0.904371,-0.0142171,282),(0.934165,-0.0435205,282),(0.933555,-0.0366327,282),(0.93346,-0.0462512,282),(0.892664,0.0152334,282),(0.897288,-0.0117775,282),(0.925025,-0.0197803,282),(0.987214,-0.045158,282),(0.954695,-0.10821,282),(0.893753,-0.0258738,282),(0.901753,-0.0107629,282),(0.931788,-0.0409887,282),(0.892724,-0.0170115,282),(0.979407,-0.0661475,282),(0.926702,-0.0242308,282),(0.918139,-0.0334606,282),(0.894451,-0.0133324,282),(0.975046,-0.0694685,282),(0.899002,-0.0048206,282),(0.938181,-0.0411659,282),(0.901831,-0.0223887,282),(0.914823,-0.0712604,282),(0.929988,-0.0625212,282),(0.997346,-0.0366195,282),(0.902586,-0.0601995,282),(0.933363,-0.0529416,282),(0.901773,-0.0559814,282),(0.897313,-0.038407,282),(0.899553,-0.00250176,282),(0.91938,-0.0427477,282),(0.950281,-0.111474,282),(0.899039,-0.00321594,282),(0.896105,-0.0144836,282),(0.918721,0.0212729,282),(0.888588,-0.0227025,282),(0.975648,-0.077672,282),(0.931627,-0.0407135,282),(0.901893,-0.0106015,282),(0.898404,-0.00271346,282),(0.896439,-0.00164427,282),(0.899837,0.00378108,282),(0.896951,-0.00520544,282),(0.896217,-0.00435285,282),(0.899768,0.00225147,282),(0.89825,-0.00185912,282),(0.899319,-0.00106622,282),(0.933836,-0.0377982,282),(0.934829,-0.0405711,282),(0.935365,-0.038736,282),(0.933018,-0.0384154,282),(0.885239,-0.0610247,282),(0.886757,-0.0331569,282),(0.937985,-0.0523075,282),(0.901754,-0.00296374,282),(0.939493,-0.0268491,282),(0.898228,0.000137881,282),(0.909134,-0.00871059,282),(0.894258,-0.0458428,282),(0.897572,-0.0160534,282),(0.915169,-0.0348554,282),(0.897865,-0.00323584,282),(0.907211,-0.00395561,282),(0.91474,-0.0317566,282),(0.957627,-0.0296437,282),(0.936972,-0.0397394,282),(0.933907,-0.0523253,282),(0.928524,-0.0530303,282),(0.931447,-0.0322076,282),(0.886344,-0.0169068,282),(1.01611,-0.111492,282),(1.0499,-0.0200537,282),(1.02948,-0.0516535,282),(0.899759,-0.00218114,282),(0.210425,-1.07771,99),(0.741919,0.730785,231),(0.734958,0.751408,231),(0.737011,0.767397,231),(0.747705,0.727454,231),(0.731638,0.793656,231),(0.7277,0.782495,231),(0.750613,0.715398,231),(0.737758,0.734216,231),(0.735721,0.738888,231),(0.725175,0.78528,231),(0.735589,0.727313,231),(0.745471,0.723764,231),(0.723891,0.782064,231),(0.737395,0.745251,231),(0.729897,0.729116,231),(0.732936,0.760962,231),(0.732763,0.769966,231),(0.726783,0.726684,231),(0.726738,0.750188,231),(0.751898,0.712763,231),(0.738995,0.743468,231),(0.727676,0.781934,231),(0.0959931,-0.94306,81),(0.0858121,-0.912225,81),(0.0845961,-0.913184,81),(0.0899749,-0.918877,81),(0.0861029,-0.913389,81),(0.863237,-0.0442488,273),(0.164807,-0.000172962,2),(0.0933948,-0.0108757,2),(0.135074,-0.0367315,2),(0.175592,-0.0436667,2),(0.0974531,-0.00187134,2),(0.0989567,-0.000289201,2),(0.132403,-0.0338833,2),(0.0926149,-0.0346402,2),(0.164075,-0.0146485,2),(0.0852501,-0.0306368,2),(0.11754,-0.0281478,2),(0.0966408,-0.0122145,2),(0.128106,-0.0406096,2),(0.105433,-0.00785468,2),(0.0874187,-0.0284508,2),(0.0861145,-0.0299097,2),(0.167978,-0.0144042,2),(0.0909165,-0.0185106,2),(0.14924,-0.0090539,2),(0.0948192,-0.0373996,2),(0.0965951,-0.00727436,2),(0.10344,-0.0172049,2),(0.108315,-0.0290058,2),(0.0977569,-0.00134617,2),(0.101385,-0.00611319,2),(0.11434,-0.0133727,2),(0.190164,-0.0190607,2),(0.123268,-0.0244364,2),(0.0991755,-0.00286461,2),(0.116736,-0.0283517,2),(0.122092,0.00511486,2),(0.115483,-0.0212349,2),(0.106362,-0.00452267,2),(0.140608,-0.0302043,2),(0.103287,0.0172421,2),(0.124823,0.00826623,2),(0.115206,0.00822574,2),(0.0973395,-0.00541663,2),(0.0995045,-0.0224549,2),(0.0888339,-0.0235277,2),(0.128903,-0.0236696,2),(0.10412,-0.031066,2),(0.0986116,-0.00412072,2),(0.0891052,-0.0217573,2),(0.188244,-0.0148596,2),(0.112809,-0.0404808,2),(0.130086,-0.0451,2),(0.111475,-0.00658652,2),(0.193061,-0.00421811,2),(0.0849961,-0.0391034,2),(0.102277,-0.0115803,2),(0.0922377,-0.012865,2),(0.101137,0.0156605,2),(0.105422,-0.0141155,2),(0.118683,-0.0188832,2),(0.0994838,-0.00581771,2),(0.0969708,-0.00343655,2),(0.102053,-0.00309866,2),(0.630845,-0.09342,272),(1.12021,-0.902712,97),(0.234054,-0.291612,8),(0.23304,-0.286825,8),(0.236783,-0.272271,8),(0.231629,-0.290588,8),(0.234795,-0.289341,8),(0.235237,-0.291155,8),(0.19984,-0.203913,16),(0.190241,-0.227475,16);
/*&*/
INSERT INTO `x2_timezone_points` VALUES (0.199366,-0.160021,16),(0.193441,-0.216421,16),(0.135372,-0.153901,16),(0.181086,-0.211036,16),(0.149112,-0.1653,16),(0.19754,-0.214384,16),(0.160305,-0.176276,16),(0.175526,-0.22455,16),(0.18126,-0.162415,16),(0.186169,-0.254818,16),(0.14953,-0.176865,16),(0.182387,-0.236201,16),(0.169394,-0.233472,16),(0.166469,-0.238714,16),(0.166417,-0.238897,16),(0.190955,-0.249524,16),(0.285054,-1.07683,100),(0.283203,-1.07127,100),(0.28348,-1.07398,100),(0.282592,-1.07498,100),(0.283982,-1.07346,100),(0.285067,-1.07071,100),(0.282863,-1.07326,100),(0.280007,-1.07453,100),(0.279227,-1.07731,100),(0.283919,-1.07487,100),(0.0375431,0.197838,37),(0.0654498,0.153298,37),(0.0325314,0.170446,37),(0.660471,0.414978,262),(0.687078,0.40048,262),(0.662643,0.414516,262),(0.654654,0.390595,262),(0.69037,0.379915,262),(0.668897,0.406991,262),(0.647052,0.391472,262),(0.662602,0.410091,262),(0.617231,0.427106,262),(0.679806,0.362156,262),(0.657555,0.374216,262),(0.662308,0.412545,262),(0.663956,0.41338,262),(0.663516,0.413643,262),(0.662662,0.411411,262),(0.667491,0.379338,262),(0.66184,0.413803,262),(0.662643,0.41277,262),(0.662352,0.413934,262),(0.663807,0.413643,262),(0.663807,0.414516,262),(0.663807,0.414225,262),(0.66497,0.415679,262),(0.670061,0.380962,262),(0.662352,0.413061,262),(0.682598,0.463467,262),(0.664098,0.41597,262),(0.663225,0.407457,262),(0.670817,0.399225,262),(0.6918,0.391308,262),(0.678933,0.391535,262),(0.64391,0.476281,262),(0.66146,0.416642,262),(0.66219,0.400681,262),(0.664523,0.415581,262),(0.663225,0.415388,262),(0.669644,0.456156,262),(0.619805,0.419151,262),(0.671317,0.411888,262),(0.663759,0.415352,262),(0.662571,0.412242,262),(0.687059,0.382605,262),(0.662352,0.413643,262),(0.646451,0.385965,262),(0.66166,0.414055,262),(0.662643,0.415388,262),(0.664389,0.414807,262),(0.616588,0.438835,262),(0.692328,0.363916,262),(0.663516,0.414516,262),(0.661189,0.414225,262),(0.663947,0.410902,262),(0.662934,0.413061,262),(0.663516,0.41597,262),(0.662866,0.413926,262),(0.664389,0.411607,262),(0.683481,0.366262,262),(0.656826,0.396771,262),(0.66468,0.413643,262),(0.664098,0.415388,262),(0.659734,0.372628,262),(0.66468,0.414225,262),(0.667564,0.385403,262),(0.662934,0.413352,262),(0.67407,0.373636,262),(0.636012,0.492576,262),(0.711954,0.391085,262),(0.718053,0.434301,262),(0.707266,0.387526,262),(0.709307,0.400446,262),(0.709467,0.400568,262),(0.717078,0.41102,262),(0.707115,0.378363,262),(0.709768,0.400532,262),(0.708613,0.401208,262),(0.706836,0.400137,262),(0.708391,0.401976,262),(0.724365,0.463031,262),(0.710887,0.399981,262),(0.709117,0.38516,262),(0.709597,0.39968,262),(0.703387,0.380244,262),(0.717728,0.443251,262),(0.715444,0.399171,262),(0.714533,0.425894,262),(0.702878,0.392743,262),(0.708298,0.400558,262),(0.71178,0.373672,262),(0.712104,0.384797,262),(0.71828,0.421313,262),(0.712923,0.451594,262),(0.691499,0.347665,262),(0.663815,0.415905,262),(0.661771,0.413934,262),(0.669686,0.374016,262),(0.664168,0.415493,262),(-0.947384,-0.637206,249),(0.261218,-1.56265,101),(0.253543,-1.58105,101),(0.252748,-1.58008,101),(0.260345,-1.59465,101),(0.257732,-1.58815,101),(0.255628,-1.58361,101),(0.257727,-1.59145,101),(0.255434,-1.5826,101),(0.255485,-1.59225,101),(0.253393,-1.58348,101),(0.250164,-1.58854,101),(0.262333,-1.59085,101),(0.254275,-1.57944,101),(0.261218,-1.60163,101),(0.258076,-1.57867,101),(0.254527,-1.5961,101),(0.261218,-1.60221,101),(0.254988,-1.58226,101),(0.256893,-1.58204,101),(0.253878,-1.57798,101),(0.260927,-1.5961,101),(0.26849,-1.57778,101),(0.295191,-1.5692,101),(0.258221,-1.57415,101),(0.255167,-1.58553,101),(0.253654,-1.60018,101),(0.25889,-1.59727,101),(0.243047,-1.58519,101),(0.274308,-1.54636,101),(0.249291,-1.59465,101),(0.285032,-1.56062,101),(0.253121,-1.58042,101),(0.256272,-1.58854,101),(0.255371,-1.58697,101),(0.268781,-1.56498,101),(0.251424,-1.58298,101),(0.255948,-1.57706,101),(0.259472,-1.59901,101),(0.254818,-1.60047,101),(0.268882,-1.5908,101),(0.259181,-1.59378,101),(0.270235,-1.55014,101),(0.262561,-1.59538,101),(0.2554,-1.58138,101),(0.253654,-1.59698,101),(0.2458,-1.58912,101),(0.259472,-1.59814,101),(0.249291,-1.56905,101),(0.254503,-1.58377,101),(0.2554,-1.57051,101),(0.273435,-1.60105,101),(0.26738,-1.59647,101),(0.264126,-1.55974,101),(0.252467,-1.57849,101),(0.295355,-1.56904,101),(0.254236,-1.55945,101),(0.249669,-1.5845,101),(0.255652,-1.58463,101),(0.255691,-1.59843,101),(0.271108,-1.55945,101),(0.24917,-1.57604,101),(0.263254,-1.60076,101),(0.257281,-1.58629,101),(0.256854,-1.60105,101),(0.270235,-1.5772,101),(0.256563,-1.60338,101),(0.253533,-1.58406,101),(0.255529,-1.57975,101),(0.276053,-1.57574,101),(0.258309,-1.56294,101),(0.256709,-1.57951,101),(0.256016,-1.58505,101),(0.260636,-1.59029,101),(0.253654,-1.59378,101),(0.2586,-1.5961,101),(0.249747,-1.5771,101),(0.25012,-1.56575,101),(0.254139,-1.58361,101),(0.252855,-1.58153,101),(0.252729,-1.58489,101),(0.235405,2.52691,331),(0.236249,2.52878,331),(0.235129,2.52636,331),(0.23593,2.52792,331),(0.235195,2.52634,331),(0.234705,2.52726,331),(0.207058,-0.272231,9),(0.212348,-0.255982,9),(0.109047,-1.00386,103),(0.104861,-1.01765,103),(0.118761,-1.015,103),(0.390372,1.99142,190),(0.389499,1.99288,190),(0.388956,1.99243,190),(0.276344,-1.53502,156),(0.264126,-1.52076,156),(0.267326,-1.53589,156),(0.273726,-1.50098,156),(0.275471,-1.52629,156),(0.245774,-1.52205,156),(0.254818,-1.53298,156),(0.257727,-1.54956,156),(0.260345,-1.53996,156),(0.270526,-1.53647,156),(0.234296,-1.52624,156),(0.265872,-1.53531,156),(0.270526,-1.51087,156),(0.249873,-1.53036,156),(0.269362,-1.53444,156),(0.275059,-1.51464,156),(0.255691,-1.50447,156),(0.268781,-1.5324,156),(0.242019,-1.51058,156),(0.244928,-1.51116,156),(0.2522,-1.52949,156),(0.268781,-1.53851,156),(0.232134,-1.52177,156),(0.272523,-1.53507,156),(0.800345,0.275898,312),(0.799613,0.278868,312),(0.770034,0.266027,312),(0.79139,0.331608,312),(0.799918,0.303406,312),(0.79043,0.328204,312),(0.797834,0.280571,312),(0.808165,0.285148,312),(0.759374,0.286917,312),(0.760091,0.287979,312),(0.788196,0.314431,312),(0.791337,0.308666,312),(0.793533,0.285856,312),(0.763184,0.277609,312),(0.799904,0.281284,312),(0.799414,0.274332,312),(0.791386,0.251487,312),(0.7831,0.241694,312),(0.795017,0.32627,312),(0.805692,0.293695,312),(0.793902,0.27136,312),(0.744349,0.315768,312),(0.809561,0.286825,312),(0.801082,0.294069,312),(0.79959,0.278861,312),(0.332485,-1.26478,138),(0.325538,-1.25829,138),(0.339176,-1.26013,138),(0.333501,-1.26875,138),(0.32357,-1.26248,138),(0.321688,-1.27177,138),(0.323104,-1.26162,138),(0.321879,-1.27562,138),(0.34383,-1.26362,138),(0.323075,-1.2677,138),(0.322023,-1.26165,138),(0.325504,-1.29358,138),(0.318246,-1.26597,138),(0.334231,-1.25693,138),(0.323759,-1.26565,138),(0.321645,-1.27009,138),(0.339467,-1.26856,138),(0.322988,-1.25623,138),(0.331467,-1.26342,138),(0.323666,-1.26192,138),(0.324195,-1.26056,138),(0.31765,-1.28718,138),(0.323604,-1.2636,138),(0.344838,-1.2602,138),(0.347902,-1.27118,138),(0.823504,0.356338,268),(0.836594,0.367974,268),(0.823504,0.352556,268),(0.814196,0.35372,268),(0.807267,0.351653,268),(0.817978,0.358665,268),(0.844739,0.378155,268),(0.825832,0.368555,268),(0.84154,0.354302,268),(0.812742,0.360701,268),(0.836979,0.379028,268),(0.839503,0.362738,268),(0.820305,0.36012,268),(0.834558,0.359247,268),(0.836978,0.389618,268),(0.806633,0.357502,268),(0.84154,0.385427,268),(0.842121,0.36012,268),(0.825832,0.365356,268),(0.810124,0.354884,268),(0.828159,0.3735,268),(0.83514,0.374082,268),(0.83194,0.375537,268),(0.814196,0.371464,268),(0.819141,0.36361,268),(0.836059,0.355581,268),(0.829613,0.377573,268),(0.815301,0.351552,268),(0.824086,0.376118,268),(0.814778,0.368264,268),(0.816232,0.368846,268),(0.831068,0.372628,268),(0.823619,0.349149,268),(0.817512,0.293981,268),(0.821933,0.312614,268),(0.827409,0.336613,268),(0.823784,0.316595,268),(0.833847,0.333988,268),(0.830514,0.321023,268),(0.8317,0.319716,268),(0.818237,0.304406,268),(0.824334,0.290101,268),(0.826306,0.332369,268),(0.831989,0.332932,268),(0.808963,0.326535,268),(0.82362,0.321321,268),(0.825991,0.330241,268),(0.83226,0.289559,268),(0.818631,0.315172,268),(0.824737,0.295576,268),(0.839481,0.345628,268),(0.804306,0.318232,268),(0.836233,0.348666,268),(0.826065,0.304864,268),(0.813786,0.329162,268),(0.828799,0.319609,268),(0.820901,0.345201,268),(0.810766,0.29655,268),(0.835452,0.301417,268),(0.826437,0.33942,268),(0.80273,0.326081,268),(0.806216,0.318783,268),(0.833276,0.316238,268),(0.810427,0.340074,268),(0.81528,0.346353,268),(0.813697,0.336592,268),(0.816258,0.30095,268),(0.818667,0.343678,268),(0.809251,0.310669,268),(0.812039,0.331365,268),(0.829031,0.347611,268),(0.83194,0.343539,268),(0.832231,0.307791,268),(0.833963,0.347809,268),(0.827015,0.335477,268),(0.830717,0.337811,268),(0.83223,0.333954,268),(0.831086,0.334906,268),(0.834142,0.327101,268),(0.827197,0.330105,268),(0.820014,0.330449,268),(0.831412,0.334032,268),(0.826492,0.333327,268),(0.809424,0.31655,268),(0.82355,0.337039,268),(0.823318,0.345567,268),(0.828997,0.332309,268),(0.828365,0.330887,268),(0.839031,0.336781,268),(0.805905,0.330851,268),(0.822084,0.306461,268),(0.82889,0.331873,268),(0.828613,0.332242,268),(0.828735,0.332763,268),(0.828843,0.332836,268),(0.829039,0.332812,268),(0.829096,0.332761,268),(0.829351,0.333496,268),(0.829551,0.333021,268),(0.83011,0.333167,268),(0.830124,0.333651,268),(0.82929,0.334585,268),(0.828667,0.334376,268),(0.82821,0.334221,268),(0.828057,0.334683,268),(0.827249,0.333618,268),(0.827757,0.332313,268),(0.827818,0.332851,268),(0.827927,0.333374,268),(0.828682,0.336044,268),(0.829757,0.332398,268),(0.829257,0.332168,268),(0.82898,0.332304,268),(0.0523773,1.74212,194),(0.0580933,1.73071,194),(0.0708831,1.71688,194),(0.0517782,1.74184,194),(0.0624217,1.72116,194),(0.0656418,1.7183,194),(0.0939825,1.67483,194),(0.0304159,1.72402,194),(0.102794,1.66359,194),(0.0910481,1.68046,194),(0.0366519,1.74242,194),(0.0632734,1.7255,194),(0.0622716,1.72711,194),(0.051653,1.72907,194),(0.0702286,1.71528,194),(0.0238529,1.73253,194),(0.0721921,1.67776,194),(0.0625409,1.72206,194),(0.0904098,1.6956,194),(0.0779865,1.70987,194),(0.0650624,1.72218,194),(0.0520894,1.73862,194),(0.054107,1.71899,194),(0.0612227,1.72236,194),(0.0908095,1.68775,194),(0.0628336,1.71889,194),(0.0658949,1.72235,194),(0.0357792,1.74097,194),(0.0970002,1.66369,194),(-0.135835,1.92616,194),(-0.128456,1.91816,194),(-0.121882,1.91317,194),(-0.139466,1.99667,194),(-0.120292,1.91321,194),(-0.117129,1.89375,194),(-0.121672,1.92102,194),(-0.118682,1.93237,194),(-0.135142,1.92998,194),(-0.0792135,2.10012,209),(-0.131181,1.90335,194),(-0.125226,1.88462,194),(-0.168541,2.099,209),(-0.124612,1.92693,194),(-0.0897099,2.08431,209),(-0.148524,2.01176,209),(-0.140773,1.95307,194),(-0.130441,1.96612,194),(-0.120386,1.9559,194),(-0.098902,2.31692,195),(-0.13471,1.93136,194),(-0.140455,1.94969,194),(0.0227556,2.18011,209),(0.0232932,2.17886,209),(0.0139626,2.22355,195),(-0.0849394,1.83667,194),(-0.119894,1.90486,194),(-0.114139,1.93822,194),(-0.127887,1.88881,194),(-0.121009,1.90532,194),(0.0575959,2.05309,209),(0.0159989,1.823,194),(-0.0479966,1.87885,194),(-0.0946918,1.8371,194),(-0.0686496,1.81165,194),(-0.130892,1.96698,194),(-0.107827,1.86104,194),(-0.149074,2.00931,209),(-0.131879,1.93438,194),(-0.126522,1.96787,194),(0.0122173,1.90066,218),(-0.036361,1.76947,194),(-0.0322886,1.85238,194),(-0.122464,1.98735,194),(-0.119555,1.8835,194),(-0.142394,1.9632,194),(-0.117989,1.89339,194),(-0.148353,2.0496,209),(-0.130168,1.90744,194),(-0.120743,1.86622,194),(-0.146608,1.99433,194),(-0.138555,1.92424,194),(-0.129615,1.9377,194),(-0.015417,2.29074,195),(-0.12275,1.87655,194),(-0.01382,1.75684,194),(-0.130606,1.96222,194),(-0.172102,2.16916,209),(-0.134662,1.92607,194),(-0.121852,1.90486,194),(-0.134499,1.98985,194),(-0.0894324,2.09881,209),(-0.137748,1.96639,194),(-0.145153,1.99375,194),(0.015708,1.90241,218),(-0.0720454,2.09491,209),(-0.141581,2.00867,209),(-0.128308,1.88689,194),(-0.0221076,1.8166,194),(-0.0120012,1.76197,194),(-0.129989,1.96731,194),(-0.130631,1.89878,194),(-0.137469,1.92613,194),(-0.110251,1.86164,194),(-0.106725,1.85267,194),(-0.106795,1.86008,194),(-0.122054,1.9272,194),(-0.135845,1.93499,194),(-0.11175,1.86357,194),(-0.0442149,1.97135,218),(-0.12544,1.9764,194),(-0.00872665,2.04465,209),(-0.127966,1.92846,194),(-0.150336,2.10263,209),(-0.107498,1.8727,194),(-0.117,1.94328,194),(-0.051838,2.09261,209),(-0.110987,1.8544,194),(-0.123885,1.90807,194),(-0.12603,1.88826,194),(-0.129528,1.9065,194),(-0.123688,1.93585,194),(-0.11444,1.87524,194),(-0.128946,1.90876,194),(-0.138792,1.92595,194),(-0.135338,1.97599,194),(-0.134099,1.96553,194),(-0.151937,2.0293,209),(-0.135263,1.92849,194),(-0.0243631,2.10753,209),(-0.000581718,1.90823,218),(-0.137331,1.94538,194),(-0.0599067,2.08294,209),(-0.117024,1.89321,194),(-0.120137,1.90997,194),(-0.0602139,1.81951,194),(0.0203622,1.90183,218),(-0.120428,1.90881,194),(-0.121955,1.85967,194),(0.00930836,1.77064,194),(-0.120229,1.9142,194),(-0.116899,1.93227,194),(-0.00384304,1.75634,194),(-0.117913,1.93798,194),(-0.133436,1.97061,194),(-0.123964,1.88084,194),(-0.107692,1.8593,194),(-0.112074,1.86284,194),(-0.0108032,1.74742,194),(-0.135575,1.95822,194),(-0.134832,1.99141,194),(-0.0372336,1.85238,194),(-0.0468329,1.94808,218),(-0.110102,1.85191,194),(-0.133564,1.96677,194),(-0.138109,1.92499,194),(-0.134422,1.98825,194),(-0.110702,1.86294,194),(-0.122493,1.87804,194),(-0.12491,1.98051,194),(-0.109679,1.88165,194),(-0.0155631,2.09214,209),(-0.117058,1.89236,194),(-0.0509065,1.82816,194),(-0.0383972,1.98677,218),(-0.140787,1.96521,194),(-0.0701041,1.80234,194),(-0.0165674,1.75151,194),(-0.12002,1.96133,194),(-0.141473,1.95505,194),(-0.134109,1.95927,194),(-0.129221,1.9451,194),(-0.132734,1.95308,194),(-0.145125,2.00019,209),(-0.0587595,2.36463,195),(-0.0360702,1.8358,194),(-0.132315,1.92497,194),(-0.147189,1.99549,194),(-0.122641,1.92886,194),(-0.130313,1.96234,194),(-0.132063,1.96088,194),(-0.114028,1.93208,194),(-0.0892397,1.83795,194),(-0.131249,1.92381,194),(-0.134972,1.92626,194),(-0.150446,2.13299,209),(-0.149807,2.02662,209),(-0.0596321,2.00451,209),(-0.123918,1.9027,194),(-0.121664,1.87741,194),(-0.0151262,2.3402,195),(-0.0430515,1.9379,218),(-0.0503236,1.88961,194),(-0.018035,1.80787,194),(0.025953,2.17897,209),(-0.0466841,2.075,209),(-0.139272,1.96577,194),(-0.0617899,2.07643,209),(-0.127365,1.89829,194),(-0.119313,1.88893,194),(-0.130386,1.92366,194),(-0.133165,1.94646,194),(-0.0166086,2.14305,209),(-0.141956,1.97615,194),(-0.0575959,1.79536,194),(-0.0101744,2.04369,209),(-0.118886,1.87828,194),(-0.123039,1.90492,194),(-0.136752,1.96689,194),(-0.116801,1.94522,194),(-0.124209,1.96204,194),(-0.0663225,1.807,194),(-0.14829,2.09244,209),(-0.111324,1.84708,194),(-0.134686,1.91834,194),(-0.152251,2.01014,209),(-0.121751,1.89339,194),(-0.118766,1.93453,194),(-0.0142536,1.80583,194),(-0.0525192,1.99644,218),(-0.133222,1.9067,194),(-0.129336,1.96488,194),(-0.107013,1.85668,194),(-0.135411,1.97914,194),(-0.0843575,1.83085,194),(-0.148935,2.01411,209),(-0.134492,1.93045,194),(-0.117102,1.89263,194),(0.015708,1.8262,194),(-0.121096,1.90051,194),(-0.132354,1.95651,194),(-0.141901,1.96476,194),(-0.0688532,2.13801,209),(-0.144571,1.97862,194),(-0.164875,2.17255,209),(-0.121656,1.91372,194),(-0.14079,1.95331,194),(-0.136427,1.95506,194),(-0.134395,1.92969,194),(-0.125082,1.96582,194),(-0.128835,1.88859,194),(-0.0861023,2.13832,209),(-0.119532,1.89616,194),(-0.14748,2.01789,209),(-0.133498,1.93077,194),(-0.112787,1.89284,194),(-0.125101,1.96732,194),(-0.123046,1.98851,194),(-0.117199,1.93996,194),(-0.131702,1.95884,194),(-0.134453,1.92922,194),(-0.142524,1.98449,194),(-0.118782,1.93603,194),(-0.117524,1.88954,194),(-0.13759,1.93935,194),(-0.113005,1.89046,194),(-0.132247,1.93553,194),(-0.0279253,1.80845,194),(-0.108466,1.8648,194),(-0.110416,1.89054,194),(-0.132664,1.93415,194),(-0.124859,1.96622,194),(0.00944572,2.14779,209),(-0.142686,1.96587,194),(-0.132771,1.91138,194),(-0.135607,1.92499,194),(-0.146026,1.99229,194),(-0.128994,1.96745,194),(-0.117548,1.9346,194),(-0.135554,1.95506,194),(-0.146501,1.99223,194),(-0.0927922,2.08333,209),(-0.154343,2.12341,209),(0.0293797,1.77064,194),(-0.120428,1.90386,194),(-0.128559,1.96562,194),(-0.132278,1.9588,194),(-0.135481,1.9274,194),(-0.111701,1.86434,194),(-0.150971,2.01091,209),(-0.120269,1.93103,194),(-0.132936,1.93179,194),(-0.14332,1.96785,194),(-0.0605048,1.78954,194),(-0.109359,1.85976,194),(-0.12052,1.91174,194),(-0.131481,1.93295,194),(-0.113194,1.86544,194),(-0.117047,1.89468,194),(-0.108865,1.86219,194),(-0.119943,1.87697,194),(-0.121106,1.88064,194),(-0.111609,1.86679,194),(-0.109277,1.87017,194),(-0.112045,1.87546,194),(-0.118358,1.86371,194),(-0.113126,1.86496,194),(-0.127858,1.89112,194),(-0.124747,1.94762,194),(-0.13394,1.93171,194),(-0.117044,1.86439,194),(-0.114401,1.86228,194),(-0.119988,1.90164,194),(-0.00539429,1.7518,194),(-0.129645,1.96739,194),(-0.123046,1.91201,194),(-0.141688,1.95291,194),(-0.131477,1.93026,194),(0.00232705,2.05076,209),(-0.138116,1.98656,194),(-0.124795,1.9527,194),(-0.115095,1.86382,194),(-0.121646,1.94462,194),(-0.141342,1.9577,194),(0.0252218,2.18484,209),(-0.147771,2.072,209),(-0.13498,1.9844,194),(-0.0663302,1.78487,194),(-0.10882,1.86732,194),(-0.0721402,1.81805,194),(-0.127409,1.90619,194),(-0.137357,1.96399,194),(-0.113178,1.93222,194),(-0.0450876,2.01382,209),(-0.143684,1.99592,194),(-0.131147,1.90754,194),(-0.137673,1.9256,194),(-0.0580221,1.99999,209),(-0.122963,1.87776,194),(-0.142942,2.00656,209),(-0.125585,1.87503,194),(-0.122967,1.9676,194),(-0.132634,1.96906,194),(-0.120496,1.8783,194),(-0.138754,1.92481,194),(-0.134972,1.98822,194),(-0.0221226,2.03905,209),(-0.123046,1.90386,194),(0.018326,1.76773,194),(-0.132868,1.93354,194),(-0.118113,1.93477,194),(-0.124142,1.95762,194),(-0.158932,2.17979,209),(-0.118712,1.89597,194),(-0.115982,1.89212,194),(-0.0421974,2.01148,209),(-0.0644974,2.23719,195),(-0.126769,1.9268,194),(-0.0581776,2.25002,195),(-0.121082,1.90472,194),(-0.119342,1.87575,194),(-0.119031,1.87199,194),(-0.108846,1.85892,194),(-0.106446,1.86119,194),(-0.139025,1.9304,194),(-0.136058,1.92556,194),(-0.136606,1.92561,194),(-0.131767,1.93237,194),(-0.131806,1.93274,194),(-0.132485,1.93216,194),(-0.177442,2.15694,209),(-0.0442149,2.45568,195),(-0.0459603,2.45364,195),(-0.142991,2.00606,209),(-0.111149,1.88418,194),(-0.0216777,2.04019,209),(0.913404,-0.112705,271),(0.91208,-0.124127,271),(0.912291,-0.169343,271),(0.930014,-0.111238,271),(0.933048,-0.108526,271),(0.947185,-0.147819,271),(0.9282,-0.118624,271),(0.936418,-0.116612,271),(0.928791,-0.11636,271),(0.934333,-0.128282,271),(0.919173,-0.150501,271),(0.959058,-0.134972,271),(0.931409,-0.113369,271),(0.918989,-0.126575,271),(0.929771,-0.157933,271),(0.922295,-0.156842,271),(0.930155,-0.107091,271),(0.942478,-0.111992,271),(0.930838,-0.109064,271),(0.937572,-0.11079,271),(0.90579,-0.14784,271),(0.913767,-0.134458,271),(0.930934,-0.114208,271),(0.922246,-0.120883,271),(0.928564,-0.106436,271),(0.930287,-0.107823,271),(0.932588,-0.138754,271),(0.554474,0.614641,196),(0.575359,0.6196,196),(0.556348,0.606327,196),(0.559386,0.606541,196),(0.567533,0.613544,196),(0.571774,0.610374,196),(0.572332,0.620137,196),(0.559917,0.607035,196),(0.57625,0.61552,196),(0.573393,0.614333,196),(0.550215,0.60383,196),(0.573589,0.61605,196),(0.560149,0.60992,196),(0.55788,0.607452,196),(0.557201,0.608543,196),(0.561075,0.608102,196),(0.559911,0.607622,196),(0.573335,0.612082,196),(0.579577,0.620851,196),(0.573115,0.61222,196),(0.551698,0.60675,196),(0.572948,0.612363,196),(0.572648,0.61283,196),(0.563478,0.610535,196),(0.559048,0.608174,196),(0.546534,0.604237,196),(0.54842,0.603685,196),(0.564316,0.60842,196),(0.557272,0.607352,196),(0.571883,0.611738,196),(0.57071,0.616186,196),(0.576061,0.612507,196),(0.570303,0.615052,196),(0.553649,0.612727,196),(0.574036,0.617969,196),(0.557657,0.609038,196),(0.56156,0.609241,196),(0.574505,0.616087,196),(0.560498,0.61041,196),(0.572648,0.615405,196),(0.571536,0.616842,196),(0.574705,0.613606,196),(0.558704,0.60689,196),(0.561138,0.608916,196),(0.5614,0.608015,196),(0.572789,0.610665,196),(0.566123,0.609461,196),(0.559819,0.608189,196),(0.559722,0.607578,196),(0.562591,0.609997,196),(0.563151,0.611021,196),(0.571131,0.616384,196),(0.515885,0.609961,196),(0.542216,0.611447,196),(0.570615,0.611683,196),(0.554135,0.610669,196),(0.567185,0.619528,196),(0.560081,0.608068,196),(0.545447,0.607223,196),(0.558908,0.606507,196),(0.552733,0.603386,196),(0.555306,0.604757,196),(0.574704,0.6122,196),(0.569557,0.616541,196),(0.560107,0.608859,196),(0.556729,0.611049,196),(0.554608,0.614952,196),(0.5547,0.614698,196),(0.557322,0.611636,196),(0.560364,0.614085,196),(0.945096,-0.0782489,275),(0.589361,1.29311,202),(0.161126,1.37507,202),(0.453204,1.64963,202),(0.443895,1.45851,202),(0.46833,1.41953,202),(0.308632,1.35467,202),(0.349648,1.29998,202),(0.261218,1.30405,202),(0.307178,1.40208,202),(0.228769,1.35438,202),(0.356047,1.36368,202),(0.369428,1.32121,202),(0.292052,1.43495,202),(0.525344,1.34885,202),(0.292634,1.34623,202),(0.455531,1.64526,202),(0.471239,1.34681,202),(0.198386,1.34041,202),(0.492474,1.37968,202),(0.350811,1.34652,202),(0.374664,1.36601,202),(0.353138,1.37881,202),(0.436623,1.49458,202),(0.362156,1.37212,202),(0.379609,1.39685,202),(0.314159,1.38899,202),(0.285652,1.36252,202),(0.394735,1.23802,202),(0.350229,1.37794,202),(0.225586,1.3852,202),(0.312996,1.2898,202),(0.29787,1.34361,202),(0.368555,1.28107,202),(0.285652,1.4111,202),(0.48142,1.35612,202),(0.200713,1.38463,202),(0.316196,1.4559,202),(0.301651,1.30114,202),(0.413643,1.26624,202),(0.308749,1.45228,202),(0.37321,1.23366,202),(0.167291,1.36062,202),(0.151844,1.35321,202),(0.21293,1.32296,202),(0.339757,1.2706,202),(0.280125,1.3919,202),(0.208388,1.3874,202),(0.302524,1.35961,202),(0.28827,1.40703,202),(0.411316,1.26973,202),(0.410734,1.35816,202),(0.184343,1.34239,202),(0.275471,1.40179,202),(0.364774,1.22813,202),(0.310292,1.45239,202),(0.243764,1.38899,202),(0.322304,1.37677,202),(0.193876,1.36138,202),(0.225469,1.38112,202),(0.395899,1.28398,202),(0.181027,1.39366,202),(0.169297,1.33227,202),(0.177337,1.35715,202),(0.161152,1.35118,202),(0.338885,1.27874,202),(0.268708,1.28833,202),(0.395608,1.26944,202),(0.152439,1.33878,202),(0.36681,1.3247,202),(0.44215,1.44862,202),(0.221336,1.37218,202),(0.218241,1.38938,202),(0.36012,1.27293,202),(0.180239,1.34305,202),(0.393281,1.27235,202),(0.381936,1.25431,202),(0.170461,1.33343,202),(0.347611,1.30434,202),(0.389208,1.27758,202),(0.415097,1.26769,202),(0.249873,1.39277,202),(0.176013,1.36068,202),(0.182678,1.36281,202),(0.146317,1.35525,202),(0.342957,1.27642,202),(0.220162,1.39203,202),(0.536398,1.36921,202),(0.171165,1.34961,202),(0.476766,1.43844,202),(0.173998,1.35763,202),(0.485177,1.38299,202),(0.260927,1.34856,202),(0.329465,1.27304,202),(0.379318,1.22668,202),(0.303788,1.37112,202),(0.463094,1.40499,202),(0.415388,1.26362,202),(0.407243,1.31889,202),(0.549488,1.3314,202),(0.363319,1.23977,202),(0.516351,1.34834,202),(0.416843,1.25256,202),(0.39619,1.27613,202),(0.363901,1.38463,202),(0.343248,1.43495,202),(0.342085,1.35612,202),(0.410734,1.41081,202),(0.31125,1.33721,202),(0.223591,1.3066,202),(0.335394,1.27671,202),(0.404625,1.32238,202),(0.488983,1.3791,202),(0.184797,1.34823,202),(0.232734,1.30457,202),(0.574795,1.31132,202),(0.32085,1.34594,202),(0.147189,1.36165,202),(0.467167,1.60803,202),(0.40288,1.37008,202),(0.483857,1.31723,202),(0.428848,1.28617,202),(0.410734,1.59669,202),(0.199201,1.33858,202),(0.51429,1.32936,202),(0.194895,1.37212,202),(0.445405,1.57464,202),(0.302815,1.44077,202),(0.47473,1.3663,202),(0.37321,1.39161,202),(0.232866,1.34568,202),(0.480838,1.43844,202),(0.314159,1.3279,202),(0.459313,1.56498,202),(0.458731,1.65515,202),(0.148474,1.34315,202),(0.183551,1.33023,202),(0.456689,1.32275,202),(0.169879,1.3791,202),(0.518363,1.3247,202),(0.454205,1.31741,202),(0.469785,1.3407,202),(0.354302,1.45124,202),(0.396825,1.54241,202),(0.145444,1.35932,202),(0.229647,1.40157,202),(0.220968,1.38829,202),(0.213395,1.38011,202),(0.229402,1.39467,202),(0.16377,1.33634,202),(0.229964,1.38957,202),(0.165515,1.35845,202),(0.190241,1.325,202),(0.171624,1.36601,202),(0.194,1.35009,202),(0.172206,1.36252,202),(0.238237,1.38608,202),(0.152425,1.35612,202),(0.238819,1.38492,202),(0.20885,1.38235,202),(0.198621,1.35951,202),(0.188583,1.37332,202),(0.148305,1.36343,202),(0.23911,1.31307,202),(0.231406,1.3348,202),(0.479966,1.66446,202),(0.228837,1.39672,202),(0.213524,1.39025,202),(0.488401,1.39161,202),(0.431882,1.3759,202),(0.487529,1.34129,202),(0.429933,1.6409,202),(0.188019,1.38992,202),(0.397935,1.27787,202),(0.425792,1.25012,202),(0.188496,1.38143,202),(0.523308,1.3407,202),(0.335103,1.27351,202),(0.51638,1.35118,202),(0.393863,1.24238,202),(0.46164,1.53822,202),(0.509636,1.37619,202),(0.464839,1.61967,202),(0.287979,1.30987,202),(0.436041,1.42506,202),(0.156382,1.34941,202),(0.174533,1.35234,202),(0.205037,1.31752,202),(0.366989,1.34109,202),(0.324922,1.47015,202),(0.271108,1.34187,202),(0.435169,1.48062,202),(0.530289,1.36979,202),(0.444768,1.50011,202),(0.297288,1.30202,202),(0.548906,1.30769,202),(0.239277,1.3232,202),(0.192469,1.39372,202),(0.500361,1.30956,202),(0.407243,1.32703,202),(0.204204,1.36107,202),(0.399419,1.53619,202),(0.492474,1.34303,202),(0.292343,1.42593,202),(0.300778,1.35408,202),(0.505855,1.37765,202),(0.463385,1.44251,202),(0.5076,1.3983,202),(0.389208,1.53444,202),(0.557608,1.32412,202),(0.538434,1.30783,202),(0.376409,1.29533,202),(0.210312,1.31511,202),(0.287688,1.33198,202),(0.269944,1.28805,202),(0.326668,1.28602,202),(0.365646,1.48731,202),(0.372628,1.25751,202),(0.394202,1.55197,202),(0.38659,1.42884,202),(0.44215,1.27409,202),(0.509054,1.36979,202),(0.260345,1.36165,202),(0.293797,1.42244,202),(0.287688,1.40674,202),(0.299324,1.38957,202),(0.444477,1.43844,202),(0.39619,1.25111,202),(0.511757,1.28979,202),(0.369428,1.27118,202),(0.156498,1.35088,202),(0.494104,1.32179,202),(0.455822,1.51146,202),(0.425279,1.32587,202),(0.55036,1.34187,202),(0.386009,1.46666,202),(0.525926,1.32296,202),(0.21933,1.31569,202),(0.23911,1.39655,202),(0.19241,1.3461,202),(0.544809,1.31248,202),(0.45844,1.43233,202),(0.430224,1.32703,202),(0.506727,1.37968,202),(0.166028,1.35496,202),(0.314741,1.27438,202),(0.15061,1.35984,202),(0.280707,1.37648,202),(0.301358,1.36582,202),(0.226328,1.39525,202),(0.232711,1.36514,202),(0.595021,1.30554,202),(0.52738,1.37503,202),(0.479384,1.31947,202),(0.520814,1.28203,202),(0.319395,1.46433,202),(0.490364,1.29175,202),(0.359538,1.31976,202),(0.486656,1.37445,202),(0.371547,1.51295,202),(0.344703,1.47364,202),(0.598648,1.29969,202),(0.505855,1.34419,202),(0.369428,1.28398,202),(0.36361,1.46462,202),(0.472403,1.65864,202),(0.406662,1.52571,202),(0.330449,1.47655,202),(0.235619,1.31016,202),(0.539598,1.34594,202),(0.393572,1.26915,202),(0.452475,1.28572,202),(0.493056,1.34507,202),(0.39619,1.36485,202),(0.447386,1.26391,202),(0.457567,1.47248,202),(0.164933,1.35783,202),(0.194022,1.35787,202),(0.163094,1.35139,202),(0.171863,1.3698,202),(0.417425,1.52774,202),(0.504982,1.39103,202),(0.481129,1.40819,202),(0.464258,1.49197,202),(0.473857,1.462,202),(0.513418,1.35205,202),(0.328704,1.29823,202),(0.197804,1.34419,202),(0.272853,1.34216,202),(0.32085,1.3759,202),(0.500037,1.3727,202),(0.255109,1.30638,202),(0.472112,1.37357,202),(0.515454,1.30929,202),(0.420624,1.35612,202),(0.434384,1.27144,202),(0.196127,1.39165,202),(0.534866,1.33313,202),(0.2399,1.34232,202),(0.346448,1.29154,202),(0.398095,1.53989,202),(0.266163,1.39685,202),(0.191986,1.34419,202),(0.275471,1.33983,202),(0.295252,1.33052,202),(0.542856,1.34691,202),(0.394735,1.47509,202),(0.35372,1.27438,202),(0.354302,1.32034,202),(0.433133,1.61967,202),(0.437787,1.4908,202),(0.481921,1.31144,202),(0.483456,1.36834,202),(0.454658,1.46695,202),(0.496546,1.35612,202),(0.391535,1.21882,202),(0.415097,1.50651,202),(0.409861,1.3983,202),(0.378736,1.25606,202),(0.233666,1.35896,202),(0.426151,1.42913,202),(0.476184,1.41081,202),(0.315905,1.37619,202),(0.417425,1.26333,202),(0.470948,1.65166,202),(0.408407,1.33896,202),(0.216658,1.33874,202),(0.397111,1.54186,202),(0.324922,1.30347,202),(0.28827,1.33954,202),(0.187914,1.3314,202),(0.228954,1.38614,202),(0.308632,1.325,202),(0.443895,1.35525,202),(0.5012,1.38434,202),(0.372628,1.30696,202),(0.265872,1.31918,202),(0.344993,1.29998,202),(0.243152,1.31891,202),(0.446262,1.60366,202),(0.466284,1.54328,202),(0.472984,1.37183,202),(0.493637,1.36165,202),(0.249,1.31511,202),(0.261799,1.31307,202),(0.169297,1.33227,202),(0.512254,1.37154,202),(0.428769,1.47975,202),(0.447968,1.33867,202),(0.462803,1.48877,202),(0.438761,1.27527,202),(0.362738,1.33838,202),(0.405789,1.54403,202),(0.480547,1.38637,202),(0.47153,1.36368,202),(0.513999,1.34943,202),(0.422079,1.32005,202),(0.408989,1.3311,202),(0.43895,1.49837,202),(0.478067,1.32574,202),(0.44717,1.30769,202),(0.512254,1.3535,202),(0.446513,1.47393,202),(0.370592,1.33023,202),(0.29147,1.34099,202),(0.486656,1.39481,202),(0.498291,1.38434,202),(0.454658,1.4431,202),(0.406371,1.41983,202),(0.376118,1.29969,202),(0.526533,1.34166,202),(0.498582,1.3791,202),(0.482584,1.39539,202),(0.298987,1.34292,202),(0.406662,1.62025,202),(0.299906,1.34885,202),(0.391826,1.35205,202),(0.385427,1.38812,202),(0.456539,1.37497,202),(0.509927,1.37154,202),(0.378446,1.31074,202),(0.404916,1.34536,202),(0.305507,1.37083,202),(0.393572,1.24733,202),(0.454187,1.33246,202),(0.369137,1.32441,202),(0.261218,1.31511,202),(0.277507,1.28834,202),(0.377864,1.37503,202),(0.275471,1.31103,202),(0.200805,1.34806,202),(0.163292,1.36004,202),(0.286234,1.39946,202),(0.42906,1.41081,202),(0.308632,1.29125,202),(0.359247,1.29503,202),(0.319977,1.29213,202),(0.45488,1.30919,202),(0.401135,1.26536,202),(0.518363,1.31336,202),(0.508763,1.35467,202),(0.496382,1.30011,202),(0.497419,1.38056,202),(0.411316,1.3346,202),(0.372337,1.44862,202),(0.454077,1.44717,202),(0.443023,1.42273,202),(0.37321,1.37706,202),(0.393572,1.53938,202),(0.283907,1.29998,202),(0.527671,1.32354,202),(0.304269,1.31249,202),(0.435059,1.33145,202),(0.294164,1.30139,202),(0.520108,1.2994,202),(0.307692,1.36296,202),(0.341503,1.29533,202),(0.263545,1.33605,202),(0.472693,1.40528,202),(0.476475,1.39539,202),(0.268199,1.2898,202),(0.432061,1.25266,202),(0.387172,1.32761,202),(0.528878,1.3344,202),(0.401135,1.26333,202),(0.451168,1.37736,202),(0.538201,1.32976,202),(0.450586,1.26682,202),(0.469634,1.31234,202),(0.498873,1.37096,202),(0.374373,1.46549,202),(0.568396,1.31103,202),(0.451168,1.4972,202),(0.297579,1.43437,202),(0.510218,1.34419,202),(0.323468,1.4524,202),(0.421239,1.29232,202),(0.203331,1.36427,202),(0.389499,1.21475,202),(0.384554,1.44804,202),(0.226311,1.32267,202),(0.22683,1.39981,202),(0.418006,1.53007,202),(0.339757,1.3346,202),(0.392408,1.62257,202),(0.445932,1.45182,202),(0.440696,1.52978,202),(0.485202,1.37619,202),(0.490147,1.37445,202),(0.508473,1.37212,202),(0.451749,1.51146,202),(0.523017,1.3535,202),(0.467457,1.47888,202),(0.41597,1.37387,202),(0.247255,1.30958,202),(0.466585,1.40237,202),(0.513418,1.33809,202),(0.439532,1.28165,202),(0.307469,1.36048,202),(0.289143,1.30114,202),(0.479093,1.36223,202),(0.458149,1.35088,202),(0.449422,1.50156,202),(0.462221,1.39452,202),(0.540465,1.33575,202),(0.461455,1.45935,202),(0.521272,1.35932,202),(0.273435,1.3218,202),(0.5044,1.33634,202),(0.321722,1.27613,202),(0.226311,1.3663,202),(0.431096,1.44979,202),(0.348484,1.34012,202),(0.396437,1.54196,202),(0.525635,1.36688,202),(0.477348,1.31889,202),(0.50091,1.38783,202),(0.491892,1.33721,202),(0.428187,1.41895,202),(0.450004,1.47771,202),(0.279544,1.4111,202),(0.451168,1.47277,202),(0.42237,1.44921,202),(0.238237,1.38783,202),(0.375701,1.51621,202),(0.412479,1.38026,202),(0.322304,1.46026,202),(0.287688,1.30522,202),(0.256563,1.34158,202),(0.245219,1.37445,202),(0.481129,1.35758,202),(0.470948,1.48091,202),(0.511091,1.29823,202),(0.435169,1.31918,202),(0.370882,1.32703,202),(0.296415,1.27933,202),(0.406953,1.31016,202),(0.518072,1.31918,202),(0.446513,1.3887,202),(0.389208,1.43408,202),(0.490112,1.30234,202),(0.451168,1.46346,202),(0.200016,1.36461,202),(0.411316,1.23278,202),(0.440696,1.37997,202),(0.51749,1.38608,202),(0.412189,1.52076,202),(0.255109,1.31976,202),(0.515454,1.30609,202),(0.461931,1.5993,202),(0.468039,1.61705,202),(0.407534,1.48935,202),(0.37846,1.21721,202),(0.404625,1.54607,202),(0.3735,1.38463,202),(0.421788,1.53211,202),(0.527962,1.31307,202),(0.427024,1.31656,202),(0.520399,1.35176,202),(0.502946,1.37939,202),(0.513127,1.38085,202),(0.474148,1.4716,202),(0.441277,1.44921,202),(0.398517,1.5292,202),(0.475619,1.31212,202),(0.412479,1.49255,202),(0.430224,1.32529,202),(0.162115,1.38427,202),(0.228929,1.3823,202),(0.163565,1.37586,202),(0.221948,1.34914,202),(0.294088,1.43146,202),(0.345284,1.38521,202),(0.367392,1.24675,202),(0.437579,1.28945,202),(0.53203,1.33683,202),(0.389208,1.29765,202),(0.382809,1.31132,202),(0.381645,1.28282,202),(0.368264,1.4143,202),(0.437205,1.53298,202),(0.389208,1.2354,202),(0.329286,1.2898,202),(0.436914,1.4908,202),(0.499897,1.31574,202),(0.475381,1.33731,202),(0.418879,1.33896,202),(0.395899,1.30812,202),(0.582649,1.29678,202),(0.164985,1.35356,202),(0.247546,1.38172,202),(0.489274,1.29969,202),(0.469426,1.36435,202),(0.296415,1.42739,202),(0.515498,1.28193,202),(0.407243,1.35787,202),(0.529126,1.3631,202),(0.454529,1.29196,202),(0.370592,1.42477,202),(0.534943,1.31947,202),(0.318523,1.28165,202),(0.382227,1.4556,202),(0.447095,1.53793,202),(0.282743,1.3503,202),(0.338303,1.30289,202),(0.307178,1.29503,202),(0.415097,1.36776,202),(0.411025,1.51262,202),(0.426733,1.34739,202),(0.433133,1.47742,202),(0.457567,1.41779,202),(0.41597,1.24966,202),(0.287398,1.31074,202),(0.154995,1.33678,202),(0.451168,1.52804,202),(0.555325,1.31584,202),(0.234747,1.38841,202),(0.22282,1.31278,202),(0.462512,1.30114,202),(0.347321,1.35408,202),(0.461931,1.40994,202),(0.407243,1.50738,202),(0.450004,1.52658,202),(0.334812,1.34478,202),(0.345575,1.49837,202),(0.49771,1.39888,202),(0.462221,1.49604,202),(0.198095,1.34739,202),(0.233292,1.37154,202),(0.323227,1.28902,202),(0.519235,1.33605,202),(0.388045,1.33343,202),(0.15708,1.34274,202),(0.486365,1.34739,202),(0.591214,1.30724,202),(0.160132,1.35085,202),(0.251618,1.36543,202),(0.361865,1.36717,202),(0.457858,1.39365,202),(0.181188,1.37569,202),(0.257145,1.37096,202),(0.419461,1.30522,202),(0.203622,1.61879,202),(0.465479,1.3679,202),(0.377727,1.21491,202),(0.227746,1.39827,202),(0.280416,1.40615,202),(0.232804,1.39966,202),(0.187919,1.32515,202),(0.208218,1.3933,202),(0.268781,1.29183,202),(0.218379,1.38098,202),(0.186022,1.34405,202),(0.34383,1.48033,202),(0.469785,1.25518,202),(0.516326,1.40005,202),(0.298742,1.43582,202),(0.44215,1.47335,202),(0.215369,1.32818,202),(0.172206,1.33518,202),(0.345575,1.31831,202),(0.468209,1.45787,202),(0.351102,1.49807,202),(0.460495,1.28358,202),(0.537513,1.34246,202),(0.432798,1.27505,202),(0.469212,1.36796,202),(0.324922,1.28805,202),(0.5012,1.35525,202),(0.499746,1.39277,202),(0.513999,1.293,202),(0.495122,1.31954,202),(0.482293,1.39975,202),(0.445932,1.43292,202),(0.468912,1.31307,202),(0.357211,1.47015,202),(0.284489,1.40092,202),(0.541561,1.32268,202),(0.447968,1.64934,202),(0.464258,1.38696,202),(0.313868,1.29911,202),(0.473566,1.26304,202),(0.509345,1.35816,202),(0.544853,1.32243,202),(0.392117,1.2706,202),(0.196797,1.35416,202),(0.17686,1.33489,202),(0.194649,1.34306,202),(0.176569,1.3535,202),(0.1796,1.38233,202),(0.225729,1.37387,202),(0.196059,1.37677,202),(0.2458,1.35408,202),(0.290888,1.42652,202),(0.211767,1.35961,202),(0.198968,1.38288,202),(0.327249,1.27554,202),(0.523308,1.33663,202),(0.29816,1.4335,202),(0.324922,1.38521,202),(0.283907,1.41663,202),(0.211185,1.31249,202),(0.489856,1.39801,202),(0.246091,1.34856,202),(0.526217,1.37503,202),(0.362738,1.38986,202),(0.35692,1.34274,202),(0.181926,1.38439,202),(0.545953,1.3065,202),(0.361574,1.45124,202),(0.446804,1.48557,202),(0.5293,1.33344,202),(0.335976,1.3343,202),(0.417134,1.3823,202),(0.413061,1.50855,202),(0.334522,1.3122,202),(0.56345,1.32034,202),(0.161734,1.34012,202),(0.393863,1.45677,202),(0.494219,1.34012,202),(0.30598,1.36598,202),(0.41597,1.25867,202),(0.358956,1.51087,202),(0.489856,1.66388,202),(0.398808,1.43466,202),(0.469203,1.30492,202),(0.327831,1.45619,202),(0.342085,1.33023,202),(0.364483,1.31103,202),(0.328995,1.33576,202),(0.32754,1.46753,202),(0.505855,1.36019,202),(0.358083,1.27322,202),(0.336267,1.34012,202),(0.153298,1.33867,202),(0.387463,1.37474,202),(0.166615,1.37167,202),(0.354593,1.51175,202),(0.208567,1.31511,202),(0.19071,1.38353,202),(0.531453,1.35467,202),(0.331322,1.27584,202),(0.205541,1.38846,202),(0.431387,1.39975,202),(0.512933,1.34335,202),(0.396088,1.54242,202),(0.40288,1.54083,202),(0.376991,1.37037,202),(0.308342,1.31481,202),(0.218176,1.3382,202),(0.270235,1.28863,202),(0.406662,1.39597,202),(0.49131,1.34972,202),(0.307178,1.40819,202),(0.182393,1.35299,202),(0.230383,1.37445,202),(0.208276,1.36863,202),(0.225438,1.37765,202),(0.226476,1.39947,202),(0.187109,1.35925,202),(0.191842,1.3489,202),(0.324631,1.46171,202),(0.375537,1.25373,202),(0.496546,1.40644,202),(0.44982,1.27973,202),(0.407534,1.41459,202),(0.188016,1.33782,202),(0.343539,1.26973,202),(0.436623,1.38288,202),(0.32754,1.47335,202),(0.421788,1.2642,202),(0.288561,1.42652,202),(0.214797,1.36258,202),(0.429933,1.53327,202),(0.235038,1.38085,202),(0.340048,1.31569,202),(0.491892,1.36223,202),(0.469537,1.46576,202),(0.388045,1.27554,202),(0.143896,1.34959,202),(0.518517,1.28501,202),(0.366228,1.44979,202),(0.480256,1.44251,202),(0.360701,1.31511,202),(0.187914,1.33314,202),(0.317068,1.32732,202),(0.453495,1.38696,202),(0.270526,1.39714,202),(0.392166,1.20533,202),(0.350811,1.29038,202),(0.426151,1.44833,202),(0.292924,1.4111,202),(0.508763,1.36863,202),(0.475311,1.64265,202),(0.457301,1.60088,202),(0.44535,1.5929,202),(0.48104,1.28232,202),(0.509345,1.30492,202),(0.38659,1.49284,202),(0.325795,1.36339,202),(0.459313,1.51116,202),(0.333358,1.36747,202),(0.286234,1.29823,202),(0.48415,1.32272,202),(0.429729,1.30341,202),(0.350229,1.50127,202),(0.456399,1.29154,202),(0.52069,1.34245,202),(0.213803,1.31074,202),(0.315905,1.33983,202),(0.177413,1.35874,202),(0.374514,1.51437,202),(0.511963,1.36805,202),(0.295252,1.42535,202),(0.476766,1.46142,202),(0.146608,1.34536,202),(0.499788,1.34782,202),(0.332194,1.27962,202),(0.374664,1.33343,202),(0.251909,1.39568,202),(0.205367,1.39074,202),(0.228677,1.35071,202),(0.150098,1.3439,202),(0.242601,1.39452,202),(0.351393,1.48528,202),(0.543088,1.32878,202),(0.486074,1.31365,202),(0.460082,1.32503,202),(0.434296,1.49284,202),(0.498291,1.38986,202),(0.470075,1.4175,202),(0.468912,1.4335,202),(0.47153,1.309,202),(0.27169,1.3154,202),(0.408698,1.54229,202),(0.478802,1.4559,202),(0.443314,1.52018,202),(0.178508,1.36537,202),(0.435251,1.28847,202),(0.395899,1.34856,202),(0.437205,1.47189,202),(0.328704,1.38666,202),(0.459104,1.30435,202),(0.348775,1.28805,202),(0.447677,1.35961,202),(0.516908,1.32849,202),(0.308342,1.44193,202),(0.413643,1.34565,202),(0.400553,1.3823,202),(0.509927,1.32907,202),(0.489468,1.32834,202),(0.274308,1.31569,202),(0.27198,1.32325,202),(0.292052,1.35263,202),(0.532034,1.34623,202),(0.230306,1.3993,202),(0.492183,1.36805,202),(0.497419,1.37387,202),(0.283616,1.39743,202),(0.287107,1.42535,202),(0.321432,1.46695,202),(0.439532,1.4047,202),(0.467457,1.31249,202),(0.488004,1.28385,202),(0.486365,1.42244,202),(0.211529,1.33837,202),(0.500619,1.34507,202),(0.547452,1.33314,202),(0.270235,1.36979,202),(0.372919,1.29591,202),(0.36361,1.3343,202),(0.276926,1.36601,202),(0.292924,1.4015,202),(0.354593,1.30289,202),(0.518581,1.35116,202),(0.474439,1.66388,202),(0.198386,1.34972,202),(0.195848,1.36424,202),(0.200131,1.36601,202),(0.424115,1.53269,202),(0.297579,1.38346,202),(0.31096,1.33169,202),(0.522144,1.34914,202),(0.465712,1.53967,202),(0.543248,1.31726,202),(0.517199,1.36717,202),(0.449797,1.32383,202),(0.391535,1.3983,202),(0.513082,1.38661,202),(0.399729,1.54317,202),(0.476184,1.66388,202),(0.533198,1.34914,202),(0.369137,1.38056,202),(0.428769,1.40674,202),(0.513999,1.36921,202),(0.14301,1.35143,202),(0.40928,1.31627,202),(0.47473,1.28689,202),(0.287667,1.36702,202),(0.232711,1.38899,202),(0.478639,1.34564,202),(0.187914,1.39335,202),(0.223674,1.33967,202),(0.39619,1.27176,202),(0.475129,1.34732,202),(0.204204,1.32063,202),(0.429642,1.46811,202),(0.530139,1.32904,202),(0.214639,1.33761,202),(0.455822,1.49051,202),(0.51429,1.35583,202),(0.173951,1.33663,202),(0.181514,1.38725,202),(0.531453,1.36281,202),(0.191166,1.36911,202),(0.39299,1.50884,202),(0.416261,1.40324,202),(0.361865,1.35059,202),(0.422079,1.54054,202),(0.45204,1.51815,202),(0.537421,1.33511,202),(0.335976,1.28107,202),(0.502364,1.35263,202),(0.176278,1.34507,202),(0.443023,1.50913,202),(0.385136,1.42564,202),(0.426151,1.3631,202),(0.472403,1.28834,202),(0.398808,1.21708,202),(0.261218,1.30958,202),(0.265581,1.3247,202),(0.3799,1.36572,202),(0.228638,1.30551,202),(0.266163,1.31831,202),(0.229802,1.36834,202),(0.205949,1.31685,202),(0.350229,1.39045,202),(0.532034,1.30056,202),(0.326377,1.3503,202),(0.557642,1.31975,202),(0.476766,1.38666,202),(0.454363,1.45532,202),(0.447386,1.46171,202),(0.441568,1.45066,202),(0.334522,1.35292,202),(0.285361,1.31394,202),(0.279544,1.33401,202),(0.28507,1.32878,202),(0.228347,1.30871,202),(0.455356,1.45372,202),(0.46513,1.48208,202),(0.39968,1.28863,202),(0.372439,1.36158,202),(0.462459,1.36136,202),(0.398226,1.23627,202),(0.457732,1.3653,202),(0.310669,1.3346,202),(0.503237,1.37503,202),(0.466876,1.65981,202),(0.459603,1.64992,202),(0.443314,1.49953,202),(0.427606,1.63654,202),(0.537561,1.31191,202),(0.409571,1.27933,202),(0.479093,1.40528,202),(0.43895,1.44135,202),(0.294379,1.38899,202),(0.498291,1.3823,202),(0.489274,1.39015,202),(0.511381,1.36019,202),(0.231547,1.40092,202),(0.499455,1.38201,202),(0.45875,1.37849,202),(0.30776,1.30522,202),(0.205739,1.35788,202),(0.197217,1.34277,202),(0.46513,1.29213,202),(0.372046,1.22929,202),(0.404916,1.53793,202),(0.175099,1.36728,202),(0.470807,1.45057,202),(0.351684,1.33634,202),(0.505855,1.35612,202),(0.391535,1.52425,202),(0.314741,1.36601,202),(0.193793,1.39024,202),(0.429642,1.63857,202),(0.507891,1.3599,202),(0.19664,1.325,202),(0.161734,1.33605,202),(0.525053,1.31336,202),(0.430805,1.42913,202),(0.448259,1.3983,202),(0.44855,1.42972,202),(0.458445,1.3731,202),(0.452768,1.45842,202),(0.207985,1.31918,202),(0.479966,1.35583,202),(0.459603,1.55712,202),(0.442441,1.48411,202),(0.268781,1.28805,202),(0.274598,1.38376,202),(0.465421,1.64643,202),(0.447095,1.44193,202),(0.453204,1.4812,202),(0.476184,1.66999,202),(0.212793,1.39525,202),(0.484038,1.37154,202),(0.272124,1.28821,202),(0.336849,1.33518,202),(0.278962,1.34478,202),(0.325504,1.39045,202),(0.523308,1.31569,202),(0.408989,1.26827,202),(0.476475,1.32558,202),(0.186161,1.38668,202),(0.191695,1.3346,202),(0.353429,1.2994,202),(0.445641,1.56847,202),(0.334231,1.33052,202),(0.445641,1.42041,202),(0.194022,1.32849,202),(0.442441,1.52949,202),(0.453495,1.46899,202),(0.354593,1.35001,202),(0.442103,1.33535,202),(0.368555,1.22377,202),(0.520108,1.35903,202),(0.225448,1.30648,202),(0.461349,1.60628,202),(0.286816,1.40586,202),(0.447677,1.48149,202),(0.218588,1.34209,202),(0.398517,1.21068,202),(0.370882,1.27933,202),(0.390372,1.31569,202),(0.420043,1.31016,202),(0.394444,1.40295,202),(0.55356,1.34245,202),(0.514872,1.36368,202),(0.294379,1.43001,202),(0.161892,1.38097,202),(0.439719,1.31026,202),(0.444034,1.30149,202),(0.329286,1.38637,202),(0.388045,1.31045,202),(0.375246,1.22406,202),(0.427321,1.31369,202),(0.18514,1.36879,202),(0.168829,1.36958,202),(0.229802,1.40092,202),(0.280416,1.28224,202),(0.227024,1.36027,202),(0.458739,1.31536,202),(0.233001,1.30405,202),(0.200422,1.36194,202),(0.364483,1.32994,202),(0.320268,1.42942,202),(0.469785,1.40877,202),(0.532616,1.32441,202),(0.358665,1.30085,202),(0.21613,1.34536,202),(0.52738,1.29998,202),(0.19315,1.32761,202),(0.479966,1.66592,202),(0.40608,1.32907,202),(0.472,1.30419,202),(0.457858,1.46869,202),(0.475311,1.3791,202),(0.463676,1.55014,202),(0.423533,1.40935,202),(0.472112,1.34274,202),(0.398226,1.27293,202),(0.482874,1.40441,202),(0.441277,1.39394,202),(0.476475,1.41575,202),(0.387172,1.5356,202),(0.462512,1.3719,202),(0.387172,1.31918,202),(0.493637,1.32907,202),(0.398517,1.27002,202),(0.204204,1.31831,202),(0.292052,1.36107,202),(0.307469,1.39655,202),(0.368264,1.43292,202),(0.473566,1.45851,202),(0.455822,1.47451,202),(0.505855,1.33169,202),(0.285943,1.31103,202),(0.315614,1.28136,202),(0.467002,1.45085,202),(0.226311,1.34798,202),(0.21837,1.39425,202),(0.173369,1.36339,202),(0.182969,1.38579,202),(0.190241,1.34332,202),(0.228426,1.40112,202),(0.216875,1.32188,202),(0.39619,1.54374,202),(0.423242,1.51233,202),(0.238422,1.34755,202),(0.460185,1.50244,202),(0.452331,1.51465,202),(0.267035,1.29067,202),(0.219911,1.34507,202),(0.236492,1.37008,202),(0.282162,1.41604,202),(0.448259,1.43844,202),(0.539564,1.32991,202),(0.287688,1.38637,202),(0.399389,1.6185,202),(0.403753,1.28485,202),(0.539307,1.32383,202),(0.468621,1.41226,202),(0.439532,1.50244,202),(0.47822,1.30754,202),(0.501782,1.34885,202),(0.327249,1.28136,202),(0.348775,1.33576,202),(0.408989,1.478,202),(0.282162,1.33547,202),(0.393863,1.25315,202),(0.419752,1.35088,202),(0.596321,1.35408,202),(0.508182,1.35728,202),(0.52738,1.32092,202),(0.321141,1.33663,202),(0.379027,1.24587,202),(0.414516,1.4748,202),(0.457344,1.46558,202),(0.463551,1.33219,202),(0.387463,1.22115,202),(0.430805,1.36863,202),(0.18979,1.37566,202),(0.426151,1.54025,202),(0.452622,1.42593,202),(0.451459,1.48673,202),(0.264126,1.31714,202),(0.519526,1.36223,202),(0.413061,1.51262,202),(0.394444,1.38928,202),(0.48782,1.40964,202),(0.447968,1.32936,202),(0.483747,1.41197,202),(0.457247,1.37785,202),(0.523502,1.34468,202),(0.482638,1.29852,202),(0.485492,1.30958,202),(0.145175,1.34725,202),(0.187098,1.38781,202),(0.377398,1.22141,202),(0.27518,1.32994,202),(0.201876,1.38928,202),(0.315614,1.31656,202),(0.291179,1.30172,202),(0.222529,1.36776,202),(0.185878,1.3279,202),(0.197302,1.32432,202),(0.227281,1.34437,202),(0.372337,1.24442,202),(0.266163,1.31336,202),(0.50091,1.37503,202),(0.448841,1.42273,202),(0.251825,1.29885,202),(0.476764,1.35038,202),(0.371173,1.42273,202),(0.425279,1.34478,202),(0.191325,1.38564,202),(0.557924,1.34565,202),(0.414225,1.51582,202),(0.441859,1.39015,202),(0.190849,1.36856,202),(0.587303,1.30929,202),(0.387463,1.30463,202),(0.305142,1.36863,202),(0.413934,1.49226,202),(0.260054,1.33314,202),(0.290306,1.30638,202),(0.470958,1.29105,202),(0.473812,1.30649,202),(0.388627,1.50389,202),(0.220871,1.33497,202),(0.408407,1.54462,202),(0.218501,1.36509,202),(0.19635,1.32238,202),(0.296997,1.42652,202),(0.252782,1.39597,202),(0.160076,1.35909,202),(0.258735,1.33029,202),(0.167261,1.33547,202),(0.306305,1.40732,202),(0.483492,1.32993,202),(0.404916,1.43059,202),(0.519235,1.37067,202),(0.334231,1.43728,202),(0.175697,1.3375,202),(0.199329,1.34147,202),(0.439532,1.32354,202),(0.389208,1.43175,202),(0.276635,1.34856,202),(0.485202,1.35147,202),(0.374955,1.27322,202),(0.420916,1.36209,202),(0.325504,1.293,202),(0.390081,1.4431,202),(0.328413,1.37387,202),(0.328413,1.44368,202),(0.267908,1.32907,202),(0.34703,1.29998,202),(0.454193,1.4585,202),(0.282743,1.30463,202),(0.39619,1.54195,202),(0.290016,1.40557,202),(0.342085,1.42535,202),(0.453495,1.38143,202),(0.347321,1.50302,202),(0.422786,1.61755,202),(0.212058,1.34594,202),(0.29147,1.29533,202),(0.440405,1.35438,202),(0.22922,1.36368,202),(0.142757,1.34841,202),(0.46075,1.57554,202),(0.447968,1.64265,202),(0.446513,1.48004,202),(0.178411,1.32993,202),(0.29467,1.29503,202),(0.362859,1.234,202),(0.427024,1.494,202),(0.296415,1.39568,202),(0.178709,1.35244,202);
/*&*/
INSERT INTO `x2_timezone_points` VALUES (0.459313,1.56091,202),(0.441859,1.47073,202),(0.179769,1.33256,202),(0.503818,1.36019,202),(0.581486,1.32238,202),(0.463806,1.30667,202),(0.455822,1.53473,202),(0.515163,1.36485,202),(0.473857,1.35758,202),(0.342666,1.36485,202),(0.504691,1.38754,202),(0.492183,1.40121,202),(0.493056,1.35874,202),(0.352266,1.49429,202),(0.41964,1.36715,202),(0.40288,1.48847,202),(0.420624,1.5993,202),(0.327831,1.27991,202),(0.386881,1.34129,202),(0.419461,1.33634,202),(0.488704,1.32272,202),(0.378155,1.30172,202),(0.486947,1.41023,202),(0.416843,1.2674,202),(0.503818,1.34885,202),(0.419461,1.27496,202),(0.397062,1.26856,202),(0.401135,1.51582,202),(0.504691,1.39568,202),(0.394444,1.34245,202),(0.511091,1.35641,202),(0.462803,1.60803,202),(0.383391,1.45066,202),(0.504109,1.34129,202),(0.380773,1.31947,202),(0.396515,1.54249,202),(0.536592,1.33776,202),(0.321722,1.28747,202),(0.438369,1.51058,202),(0.38979,1.52425,202),(0.374082,1.37823,202),(0.535894,1.33034,202),(0.381063,1.33227,202),(0.481798,1.31776,202),(0.272853,1.30056,202),(0.301069,1.39888,202),(0.360992,1.33634,202),(0.389208,1.2674,202),(0.387589,1.21594,202),(0.405207,1.39423,202),(0.467312,1.44991,202),(0.433714,1.3951,202),(0.470366,1.35816,202),(0.373791,1.41313,202),(0.480547,1.40935,202),(0.48782,1.35845,202),(0.446513,1.4844,202),(0.445059,1.50942,202),(0.32405,1.28922,202),(0.474439,1.46404,202),(0.408698,1.31394,202),(0.352556,1.4527,202),(0.441568,1.32529,202),(0.371755,1.22609,202),(0.279544,1.31889,202),(0.357792,1.50826,202),(0.404916,1.51029,202),(0.502946,1.38259,202),(0.453285,1.31161,202),(0.160279,1.33518,202),(0.1496,1.36345,202),(0.384263,1.41808,202),(0.260345,1.39597,202),(0.230674,1.40179,202),(0.415388,1.50593,202),(0.226602,1.38114,202),(0.41277,1.53822,202),(0.371173,1.37154,202),(0.445641,1.52862,202),(0.564905,1.31801,202),(0.371755,1.27293,202),(0.392699,1.44077,202),(0.40928,1.39248,202),(0.380191,1.39248,202),(0.386299,1.31947,202),(0.509927,1.37794,202),(0.485492,1.3727,202),(0.218166,1.309,202),(0.258546,1.29381,202),(0.191248,1.36277,202),(0.548732,1.31772,202),(0.469188,1.54073,202),(0.500037,1.34739,202),(0.518072,1.34361,202),(0.321432,1.31249,202),(0.230383,1.30871,202),(0.330158,1.27991,202),(0.321722,1.38143,202),(0.434005,1.61181,202),(0.471244,1.37779,202),(0.444477,1.36397,202),(0.399971,1.37997,202),(0.462483,1.34438,202),(0.357502,1.35234,202),(0.393572,1.27235,202),(0.196185,1.34321,202),(0.175697,1.37503,202),(0.190532,1.39335,202),(0.301651,1.29503,202),(0.547675,1.31571,202),(0.443406,1.32775,202),(0.401717,1.27525,202),(0.507309,1.37241,202),(0.357502,1.44717,202),(0.485202,1.39277,202),(0.461931,1.40237,202),(0.395608,1.33925,202),(0.141199,1.3533,202),(0.472192,1.3949,202),(0.214818,1.31085,202),(0.35372,1.31132,202),(0.353812,1.42232,202),(0.408989,1.48906,202),(0.283907,1.28631,202),(0.268781,1.38783,202),(0.192091,1.35369,202),(0.265581,1.39481,202),(0.402007,1.22551,202),(0.418006,1.53647,202),(0.511672,1.34856,202),(0.224016,1.39103,202),(0.219039,1.35118,202),(0.370592,1.3823,202),(0.268781,1.33721,202),(0.169933,1.34887,202),(0.395686,1.54243,202),(0.319686,1.36747,202),(0.482722,1.3486,202),(0.475893,1.39015,202),(0.365356,1.49313,202),(0.401135,1.54433,202),(0.335976,1.27671,202),(0.159698,1.35641,202),(0.455822,1.39161,202),(0.202643,1.32789,202),(0.394444,1.28194,202),(0.405207,1.54229,202),(0.370592,1.37706,202),(0.151262,1.35234,202),(0.204909,1.37809,202),(0.538163,1.34274,202),(0.447386,1.54142,202),(0.472403,1.54433,202),(0.264999,1.30842,202),(0.387754,1.22842,202),(0.520981,1.30812,202),(0.503237,1.33343,202),(0.343248,1.34972,202),(0.332485,1.29067,202),(0.148353,1.35379,202),(0.486819,1.38224,202),(0.469203,1.41023,202),(0.295542,1.43495,202),(0.427315,1.64032,202),(0.520108,1.33314,202),(0.513127,1.34739,202),(0.408116,1.3919,202),(0.481129,1.38492,202),(0.424697,1.60599,202),(0.459313,1.35467,202),(0.289143,1.41721,202),(0.289434,1.29707,202),(0.23655,1.32668,202),(0.370301,1.27816,202),(0.246382,1.36427,202),(0.406662,1.26245,202),(0.15835,1.34986,202),(0.400902,1.54343,202),(0.440114,1.44368,202),(0.443605,1.39655,202),(0.335103,1.28951,202),(0.346739,1.44746,202),(0.375537,1.22988,202),(0.426442,1.49255,202),(0.546734,1.31911,202),(0.397353,1.50418,202),(0.466876,1.64439,202),(0.459603,1.35816,202),(0.21933,1.37154,202),(0.461058,1.5228,202),(0.396481,1.22668,202),(0.458789,1.27461,202),(0.381936,1.22231,202),(0.342375,1.33867,202),(0.511672,1.33198,202),(0.443895,1.43001,202),(0.490884,1.31594,202),(0.515163,1.34769,202),(0.463676,1.39161,202),(0.381354,1.46666,202),(0.414516,1.50796,202),(0.391826,1.51815,202),(0.443895,1.37154,202),(0.45844,1.50593,202),(0.512254,1.36572,202),(0.42834,1.32946,202),(0.407825,1.5004,202),(0.429351,1.32907,202),(0.499274,1.33791,202),(0.43226,1.50738,202),(0.397353,1.30202,202),(0.491019,1.3535,202),(0.296997,1.33983,202),(0.379318,1.23249,202),(0.328995,1.44135,202),(0.463967,1.5036,202),(0.387041,1.54318,202),(0.195768,1.38521,202),(0.429351,1.30638,202),(0.449131,1.4431,202),(0.436623,1.37968,202),(0.351975,1.49575,202),(0.46912,1.37711,202),(0.511091,1.37561,202),(0.427897,1.51233,202),(0.39968,1.46869,202),(0.384554,1.24267,202),(0.474148,1.42332,202),(0.412479,1.31132,202),(0.511963,1.35874,202),(0.427024,1.53705,202),(0.309214,1.38201,202),(0.543961,1.31976,202),(0.413643,1.51989,202),(0.434878,1.50476,202),(0.418006,1.51495,202),(0.397935,1.50418,202),(0.392117,1.22289,202),(0.571304,1.30667,202),(0.25889,1.36834,202),(0.28827,1.31423,202),(0.384845,1.2706,202),(0.441568,1.50971,202),(0.387463,1.37154,202),(0.413934,1.50796,202),(0.462803,1.54869,202),(0.442364,1.26738,202),(0.346157,1.32441,202),(0.367368,1.33578,202),(0.36681,1.31889,202),(0.380773,1.52222,202),(0.479675,1.36688,202),(0.456318,1.38468,202),(0.459313,1.44397,202),(0.365937,1.27235,202),(0.486365,1.36601,202),(0.534362,1.29591,202),(0.516942,1.35155,202),(0.483879,1.39033,202),(0.363901,1.5068,202),(0.531744,1.30696,202),(0.45733,1.29043,202),(0.293215,1.30143,202),(0.469801,1.23751,202),(0.458149,1.42303,202),(0.469836,1.32275,202),(0.447152,1.31382,202),(0.495964,1.3631,202),(0.440114,1.48324,202),(0.328122,1.37765,202),(0.53727,1.31743,202),(0.294961,1.39801,202),(0.444768,1.47335,202),(0.332776,1.43175,202),(0.35372,1.50389,202),(0.253654,1.33256,202),(0.526508,1.34914,202),(0.40434,1.39539,202),(0.475602,1.36485,202),(0.394735,1.35699,202),(0.472984,1.63392,202),(0.45844,1.53938,202),(0.43895,1.48702,202),(0.49451,1.37387,202),(0.192277,1.34507,202),(0.180351,1.33052,202),(0.436332,1.53851,202),(0.521504,1.34514,202),(0.396502,1.32354,202),(0.299615,1.32587,202),(0.470108,1.39055,202),(0.319395,1.27845,202),(0.433133,1.63974,202),(0.278671,1.32878,202),(0.34383,1.28369,202),(0.202218,1.35855,202),(0.333649,1.47829,202),(0.29147,1.29969,202),(0.303256,1.36964,202),(0.26209,1.32558,202),(0.428187,1.46637,202),(0.214806,1.33147,202),(0.280416,1.32732,202),(0.283325,1.30202,202),(0.399603,1.54291,202),(0.267869,1.31133,202),(0.461349,1.58767,202),(0.222293,1.35844,202),(0.266454,1.33343,202),(0.228061,1.35784,202),(0.550341,1.32501,202),(0.397062,1.35641,202),(0.240822,1.33144,202),(0.248531,1.32026,202),(0.249291,1.2994,202),(0.310087,1.34623,202),(0.223102,1.33069,202),(0.244928,1.32965,202),(0.453786,1.62083,202),(0.486947,1.3503,202),(0.433423,1.4908,202),(0.509054,1.32151,202),(0.243396,1.33726,202),(0.252491,1.31569,202),(0.375537,1.46375,202),(0.340048,1.47917,202),(0.344121,1.34652,202),(0.358956,1.3759,202),(0.24136,1.35251,202),(0.417134,1.3887,202),(0.466598,1.34452,202),(0.411898,1.27322,202),(0.441859,1.48847,202),(0.418588,1.48964,202),(0.258309,1.31598,202),(0.420915,1.38928,202),(0.481711,1.36223,202),(0.509054,1.36165,202),(0.226903,1.32819,202),(0.466824,1.55948,202),(0.5012,1.3663,202),(0.210359,1.36974,202),(0.385718,1.33925,202),(0.258309,1.32616,202),(0.441366,1.38465,202),(0.413643,1.25489,202),(0.253364,1.32296,202),(0.523017,1.36427,202),(0.478511,1.3983,202),(0.38979,1.34565,202),(0.5012,1.35758,202),(0.394255,1.54131,202),(0.5163,1.29729,202),(0.507891,1.32587,202),(0.257727,1.31132,202),(0.443023,1.43437,202),(0.552978,1.33547,202),(0.452913,1.39888,202),(0.401717,1.24238,202),(0.392699,1.28224,202),(0.267535,1.30474,202),(0.400548,1.54321,202),(0.509927,1.38783,202),(0.511381,1.3663,202),(0.458149,1.59756,202),(0.448259,1.48731,202),(0.430805,1.61559,202),(0.439532,1.62374,202),(0.340339,1.35554,202),(0.398536,1.54684,202),(0.457688,1.36448,202),(0.410152,1.53153,202),(0.184905,1.32717,202),(0.536107,1.29882,202),(0.447063,1.38193,202),(0.473275,1.39132,202),(0.294379,1.35088,202),(0.496837,1.34449,202),(0.333067,1.46288,202),(0.284489,1.40412,202),(0.264708,1.35059,202),(0.493056,1.36892,202),(0.205949,1.33838,202),(0.430224,1.34943,202),(0.234008,1.39816,202),(0.402298,1.47568,202),(0.415097,1.49778,202),(0.280125,1.32296,202),(0.302524,1.34099,202),(0.499164,1.35758,202),(0.452118,1.30307,202),(0.224144,1.39738,202),(0.246673,1.39365,202),(0.22595,1.37661,202),(0.287107,1.41343,202),(0.168918,1.34826,202),(0.232313,1.34293,202),(0.466,1.55379,202),(0.479966,1.35205,202),(0.386818,1.5499,202),(0.513999,1.32092,202),(0.466963,1.45515,202),(0.199927,1.35162,202),(0.461931,1.47364,202),(0.374373,1.39975,202),(0.383391,1.23569,202),(0.473566,1.43001,202),(0.416552,1.50389,202),(0.490147,1.40441,202),(0.462803,1.64003,202),(0.253945,1.29707,202),(0.282202,1.30592,202),(0.508473,1.33867,202),(0.461223,1.36912,202),(0.397062,1.28514,202),(0.433423,1.52222,202),(0.395026,1.50215,202),(0.399239,1.54913,202),(0.456695,1.58156,202),(0.422079,1.50622,202),(0.213803,1.38608,202),(0.527089,1.30318,202),(0.267908,1.37736,202),(0.347902,1.38114,202),(0.344121,1.28514,202),(0.455676,1.45811,202),(0.446513,1.45851,202),(0.500328,1.35147,202),(0.394444,1.50942,202),(0.351393,1.36688,202),(0.456695,1.39917,202),(0.395608,1.53094,202),(0.515527,1.34341,202),(0.336267,1.32209,202),(0.432551,1.48353,202),(0.455243,1.57013,202),(0.237559,1.35292,202),(0.457035,1.60136,202),(0.422079,1.46288,202),(0.395026,1.54287,202),(0.375828,1.24936,202),(0.544834,1.32878,202),(0.502655,1.3631,202),(0.414807,1.38143,202),(0.288561,1.41023,202),(0.477057,1.54665,202),(0.238242,1.30325,202),(0.519526,1.34827,202),(0.269362,1.33576,202),(0.443314,1.54491,202),(0.462032,1.33897,202),(0.440164,1.29609,202),(0.343539,1.30929,202),(0.522144,1.28951,202),(0.33074,1.33954,202),(0.405207,1.26856,202),(0.363319,1.2738,202),(0.597484,1.30522,202),(0.503527,1.36543,202),(0.274598,1.32616,202),(0.283325,1.35787,202),(0.283325,1.29765,202),(0.383391,1.24907,202),(0.399971,1.37503,202),(0.2693,1.31999,202),(0.392777,1.53909,202),(0.459022,1.5228,202),(0.485202,1.34303,202),(0.539598,1.30202,202),(0.473857,1.36863,202),(0.195186,1.32383,202),(0.53058,1.29213,202),(0.44535,1.48906,202),(0.472874,1.35542,202),(0.488602,1.30823,202),(0.474148,1.4175,202),(0.452622,1.41023,202),(0.556098,1.30822,202),(0.496837,1.38405,202),(0.515163,1.31685,202),(0.47153,1.36688,202),(0.298063,1.36487,202),(0.47822,1.3887,202),(0.492474,1.38841,202),(0.535234,1.30463,202),(0.496255,1.34943,202),(0.433133,1.53414,202),(0.462876,1.55693,202),(0.369428,1.32383,202),(0.467457,1.4335,202),(0.467345,1.37923,202),(0.2554,1.37067,202),(0.197969,1.3566,202),(0.169297,1.34012,202),(0.365065,1.31481,202),(0.274598,1.35234,202),(0.29147,1.41546,202),(0.175697,1.3314,202),(0.513999,1.30289,202),(0.306305,1.4463,202),(0.382227,1.52774,202),(0.388151,1.20371,202),(0.409861,1.52396,202),(0.349066,1.38405,202),(0.369719,1.41866,202),(0.41614,1.28656,202),(0.484038,1.37794,202),(0.445932,1.46869,202),(0.463676,1.49255,202),(0.423533,1.5228,202),(0.481129,1.66795,202),(0.394832,1.54317,202),(0.477638,1.66359,202),(0.414516,1.50389,202),(0.415388,1.52513,202),(0.30456,1.39917,202),(0.537852,1.32674,202),(0.37001,1.40906,202),(0.372337,1.30143,202),(0.335394,1.27554,202),(0.231988,1.35338,202),(0.578286,1.31889,202),(0.361528,1.23887,202),(0.423242,1.25955,202),(0.450877,1.63072,202),(0.456113,1.56149,202),(0.400553,1.41517,202),(0.180972,1.36101,202),(0.561123,1.31714,202),(0.45204,1.63596,202),(0.351102,1.35641,202),(0.323759,1.35438,202),(0.449131,1.48353,202),(0.477929,1.66885,202),(0.479475,1.34959,202),(0.478237,1.30159,202),(0.272271,1.29067,202),(0.479646,1.65637,202),(0.492474,1.36572,202),(0.387318,1.53911,202),(0.529998,1.32412,202),(0.464009,1.5536,202),(0.430805,1.53531,202),(0.364774,1.30522,202),(0.454367,1.57021,202),(0.393863,1.229,202),(0.401135,1.24733,202),(0.379318,1.22958,202),(0.269072,1.35932,202),(0.396481,1.26478,202),(0.461931,1.61385,202),(0.360701,1.494,202),(0.466003,1.61443,202),(0.488692,1.41517,202),(0.465878,1.35926,202),(0.328413,1.32849,202),(0.492474,1.34012,202),(0.562728,1.33206,202),(0.251909,1.35641,202),(0.211668,1.36411,202),(0.425279,1.60861,202),(0.205658,1.31656,202),(0.329867,1.35874,202),(0.557705,1.31457,202),(0.372337,1.23947,202),(0.187418,1.35319,202),(0.36681,1.31365,202),(0.358374,1.27729,202),(0.394444,1.31423,202),(0.427897,1.25693,202),(0.390372,1.25635,202),(0.415388,1.50884,202),(0.505564,1.36572,202),(0.528544,1.31918,202),(0.361409,1.42331,202),(0.511672,1.37037,202),(0.387754,1.31714,202),(0.465712,1.48644,202),(0.400844,1.32761,202),(0.449422,1.31569,202),(0.445501,1.28994,202),(0.39619,1.2898,202),(0.29147,1.37765,202),(0.230951,1.35611,202),(0.173609,1.37573,202),(0.349357,1.32703,202),(0.485202,1.2802,202),(0.398808,1.3186,202),(0.408407,1.3791,202),(0.462595,1.46236,202),(0.499746,1.38725,202),(0.360701,1.36979,202),(0.348193,1.28863,202),(0.375828,1.47888,202),(0.518363,1.35583,202),(0.218691,1.35767,202),(0.500328,1.34769,202),(0.434005,1.46928,202),(0.529126,1.36194,202),(0.469319,1.33231,202),(0.322304,1.30202,202),(0.436914,1.47306,202),(0.362447,1.36427,202),(0.447968,1.3695,202),(0.489274,1.38579,202),(0.555335,1.32051,202),(0.500619,1.35321,202),(0.365356,1.34972,202),(0.354593,1.35728,202),(0.471821,1.54054,202),(0.456695,1.49924,202),(0.266454,1.30231,202),(0.447386,1.4844,202),(0.41597,1.38666,202),(0.378736,1.2482,202),(0.356338,1.27147,202),(0.419461,1.46724,202),(0.447968,1.49807,202),(0.451168,1.53327,202),(0.397062,1.27671,202),(0.398517,1.2962,202),(0.404335,1.27089,202),(0.348484,1.26944,202),(0.498582,1.3535,202),(0.522726,1.30434,202),(0.45204,1.36717,202),(0.453829,1.37665,202),(0.387172,1.28165,202),(0.357181,1.49888,202),(0.266163,1.29329,202),(0.264708,1.29125,202),(0.27169,1.38085,202),(0.252491,1.37561,202),(0.205076,1.3919,202),(0.237946,1.30376,202),(0.473566,1.42593,202),(0.440987,1.52222,202),(0.271292,1.28727,202),(0.191855,1.34323,202),(0.173484,1.33099,202),(0.528253,1.36252,202),(0.494001,1.30842,202),(0.424697,1.63479,202),(0.438659,1.44688,202),(0.391245,1.24238,202),(0.370882,1.31423,202),(0.31125,1.44775,202),(0.30456,1.4271,202),(0.18675,1.33954,202),(0.434406,1.30244,202),(0.416552,1.51611,202),(0.248232,1.33344,202),(0.298863,1.34534,202),(0.49287,1.32017,202),(0.276053,1.40237,202),(0.319395,1.45851,202),(0.306014,1.28311,202),(0.233874,1.36252,202),(0.203331,1.37706,202),(0.17174,1.35055,202),(0.304851,1.35147,202),(0.458711,1.4575,202),(0.280707,1.39917,202),(0.286816,1.30202,202),(0.234175,1.33732,202),(0.23242,1.32267,202),(0.355175,1.33081,202),(0.234471,1.35654,202),(0.198968,1.39103,202),(0.374664,1.39074,202),(0.425569,1.30376,202),(0.389499,1.29183,202),(0.385136,1.37765,202),(0.473827,1.3875,202),(0.434587,1.38928,202),(0.457567,1.51873,202),(0.483747,1.35263,202),(0.487529,1.36863,202),(0.509927,1.3471,202),(0.485492,1.29852,202),(0.406662,1.27002,202),(0.430481,1.34118,202),(0.190241,1.34507,202),(0.228115,1.40047,202),(0.194895,1.35467,202),(0.162897,1.3375,202),(0.214831,1.37517,202),(0.221657,1.39597,202),(0.183841,1.32732,202),(0.464347,1.32555,202),(0.337721,1.48324,202),(0.422661,1.4812,202),(0.412479,1.50389,202),(0.515745,1.35408,202),(0.499164,1.3311,202),(0.443314,1.3919,202),(0.45844,1.57894,202),(0.225225,1.33329,202),(0.220784,1.34769,202),(0.244928,1.32529,202),(0.165225,1.33605,202),(0.354884,1.29591,202),(0.370737,1.35692,202),(0.363319,1.36078,202),(0.344412,1.38201,202),(0.348193,1.38405,202),(0.396771,1.52745,202),(0.508763,1.36601,202),(0.536415,1.3403,202),(0.431387,1.36368,202),(0.496546,1.37474,202),(0.440987,1.45328,202),(0.399142,1.54247,202),(0.413934,1.25867,202),(0.208098,1.34285,202),(0.384845,1.44251,202),(0.568396,1.32878,202),(0.281289,1.41255,202),(0.249873,1.33779,202),(0.357211,1.30929,202),(0.373791,1.24209,202),(0.39619,1.49458,202),(0.395317,1.27293,202),(0.461058,1.4844,202),(0.327249,1.28893,202),(0.393863,1.49778,202),(0.389538,1.54761,202),(0.207127,1.31524,202),(0.393916,1.54234,202),(0.256272,1.31743,202),(0.446513,1.46579,202),(0.375246,1.46375,202),(0.405207,1.42303,202),(0.371755,1.33052,202),(0.404625,1.49371,202),(0.443986,1.32012,202),(0.358374,1.32965,202),(0.495674,1.35874,202),(0.522435,1.31889,202),(0.511091,1.35205,202),(0.489565,1.38085,202),(0.380773,1.46462,202),(0.337139,1.47975,202),(0.386881,1.25082,202),(0.391245,1.27235,202),(0.335685,1.27147,202),(0.462132,1.58051,202),(0.332884,1.27204,202),(0.413061,1.53094,202),(0.415097,1.5004,202),(0.454077,1.63683,202),(0.345575,1.26973,202),(0.174737,1.35001,202),(0.431096,1.48324,202),(0.325795,1.35961,202),(0.32405,1.45502,202),(0.479966,1.41372,202),(0.493056,1.31045,202),(0.40288,1.52396,202),(0.494219,1.37765,202),(0.493928,1.39277,202),(0.237656,1.32587,202),(0.462803,1.51873,202),(0.390954,1.47946,202),(0.367101,1.46259,202),(0.454367,1.40674,202),(0.422117,1.3649,202),(0.455933,1.46379,202),(0.491019,1.37736,202),(0.493056,1.39539,202),(0.362156,1.27322,202),(0.468621,1.39772,202),(0.474439,1.39685,202),(0.285361,1.31976,202),(0.504109,1.38346,202),(0.385427,1.43379,202),(0.457834,1.57489,202),(0.499746,1.37532,202),(0.456913,1.2864,202),(0.439823,1.47044,202),(0.488983,1.27933,202),(0.512545,1.36368,202),(0.589921,1.31074,202),(0.429933,1.38754,202),(0.293642,1.32148,202),(0.439532,1.49255,202),(0.449131,1.51815,202),(0.467787,1.38769,202),(0.312414,1.3535,202),(0.416552,1.34245,202),(0.200131,1.38986,202),(0.367392,1.32238,202),(0.322304,1.32063,202),(0.40608,1.21591,202),(0.294961,1.30202,202),(0.353138,1.49807,202),(0.364483,1.49807,202),(0.317068,1.28893,202),(0.40608,1.35088,202),(0.305622,1.37687,202),(0.475602,1.38201,202),(0.550651,1.32004,202),(0.502364,1.32878,202),(0.336849,1.27525,202),(0.450295,1.36339,202),(0.436323,1.26137,202),(0.483747,1.43001,202),(0.427606,1.29474,202),(0.463632,1.37512,202),(0.312123,1.45619,202),(0.288561,1.42303,202),(0.442441,1.3026,202),(0.370301,1.42128,202),(0.524762,1.31831,202),(0.381645,1.32558,202),(0.381354,1.22609,202),(0.336849,1.27147,202),(0.347321,1.45153,202),(0.528253,1.32706,202),(0.426151,1.32354,202),(0.3799,1.25926,202),(0.19984,1.35583,202),(0.280998,1.40994,202),(0.399181,1.54303,202),(0.243764,1.30143,202),(0.527089,1.30812,202),(0.379318,1.43001,202),(0.471919,1.34475,202),(0.445932,1.42244,202),(0.378736,1.27351,202),(0.467,1.38273,202),(0.475032,1.35246,202),(0.382688,1.21778,202),(0.368264,1.41226,202),(0.427833,1.32203,202),(0.347902,1.47626,202),(0.449131,1.37445,202),(0.369428,1.39015,202),(0.314741,1.34769,202),(0.333358,1.36078,202),(0.377806,1.35494,202),(0.440696,1.51844,202),(0.398362,1.54201,202),(0.242019,1.32151,202),(0.36744,1.51006,202),(0.308342,1.41168,202),(0.507943,1.31199,202),(0.443605,1.44106,202),(0.532034,1.31452,202),(0.494027,1.2967,202),(0.406371,1.22784,202),(0.437205,1.45939,202),(0.195186,1.32325,202),(0.475051,1.38405,202),(0.382494,1.35954,202),(0.467748,1.4748,202),(0.269944,1.36427,202),(0.50091,1.33663,202),(0.412479,1.35147,202),(0.419752,1.42041,202),(0.378736,1.42303,202),(0.229802,1.32412,202),(0.46164,1.49051,202),(0.405838,1.59613,202),(0.264417,1.34274,202),(0.276672,1.30035,202),(0.417715,1.54025,202),(0.452622,1.43088,202),(0.486743,1.33136,202),(0.526508,1.35467,202),(0.443605,1.50331,202),(0.436041,1.309,202),(0.411898,1.36717,202),(0.392699,1.2226,202),(0.455552,1.29713,202),(0.508763,1.38085,202),(0.469632,1.34896,202),(0.502655,1.34449,202),(0.36361,1.4716,202),(0.55534,1.31254,202),(0.473857,1.33663,202),(0.36888,1.51387,202),(0.467748,1.44368,202),(0.416261,1.36019,202),(0.474148,1.28543,202),(0.337139,1.34681,202),(0.535671,1.33341,202),(0.533875,1.34121,202),(0.468298,1.3273,202),(0.289434,1.32587,202),(0.311832,1.34303,202),(0.384554,1.30725,202),(0.512836,1.325,202),(0.444768,1.50069,202),(0.390076,1.54355,202),(0.318232,1.32121,202),(0.459313,1.58825,202),(0.37001,1.4588,202),(0.530289,1.3186,202),(0.449422,1.24587,202),(0.421788,1.49895,202),(0.412189,1.49197,202),(0.412189,1.59465,202),(0.426094,1.2998,202),(0.46513,1.35438,202),(0.441277,1.50156,202),(0.444768,1.49604,202),(0.401135,1.39394,202),(0.372337,1.45939,202),(0.494801,1.38608,202),(0.368555,1.27613,202),(0.405624,1.53361,202),(0.440114,1.49633,202),(0.507891,1.34856,202),(0.460767,1.47626,202),(0.396481,1.54491,202),(0.388045,1.54374,202),(0.395201,1.54227,202),(0.438078,1.33547,202),(0.597097,1.29749,202),(0.316777,1.30172,202),(0.397261,1.54238,202),(0.277507,1.40441,202),(0.533295,1.33899,202),(0.225147,1.30958,202),(0.375008,1.22293,202),(0.41087,1.29927,202),(0.32085,1.35932,202),(0.474439,1.44746,202),(0.451749,1.46986,202),(0.400936,1.54286,202),(0.215214,1.34151,202),(0.451749,1.52164,202),(0.405789,1.5196,202),(0.355756,1.49284,202),(0.434296,1.51698,202),(0.469494,1.40005,202),(0.226311,1.36485,202),(0.402589,1.55014,202),(0.267326,1.36543,202),(0.226403,1.35427,202),(0.544315,1.32631,202),(0.600684,1.30289,202),(0.472127,1.33646,202),(0.444768,1.40208,202),(0.419661,1.37816,202),(0.51429,1.35001,202),(0.345284,1.48673,202),(0.434587,1.36397,202),(0.440114,1.54927,202),(0.351975,1.48528,202),(0.478802,1.43437,202),(0.450861,1.26083,202),(0.378155,1.43408,202),(0.361807,1.41729,202),(0.395249,1.54183,202),(0.346157,1.38492,202),(0.439775,1.27917,202),(0.375144,1.51724,202),(0.403462,1.50476,202),(0.360701,1.33983,202),(0.361574,1.45706,202),(0.380482,1.39946,202),(0.542216,1.33198,202),(0.444477,1.49255,202),(0.392258,1.53886,202),(0.466876,1.48847,202),(0.242019,1.3026,202),(0.276053,1.30667,202),(0.385718,1.40586,202),(0.397673,1.54156,202),(0.48142,1.42419,202),(0.495674,1.37212,202),(0.502364,1.38754,202),(0.420624,1.54025,202),(0.500619,1.34245,202),(0.45844,1.53269,202),(0.46897,1.37179,202),(0.406953,1.54723,202),(0.505273,1.34769,202),(0.466003,1.54142,202),(0.535525,1.31074,202),(0.240589,1.35775,202),(0.374955,1.23831,202),(0.491963,1.31773,202),(0.282512,1.32115,202),(0.472984,1.46753,202),(0.257436,1.37968,202),(0.396917,1.54961,202),(0.401717,1.31278,202),(0.334231,1.27874,202),(0.277768,1.32081,202),(0.202458,1.31918,202),(0.386009,1.49051,202),(0.504982,1.36514,202),(0.493346,1.36834,202),(0.381354,1.24442,202),(0.440696,1.3695,202),(0.445932,1.40877,202),(0.39619,1.36019,202),(0.454833,1.45187,202),(0.467748,1.43466,202),(0.182386,1.35354,202),(0.279628,1.41229,202),(0.195354,1.34859,202),(0.22891,1.39804,202),(0.318523,1.33518,202),(0.431969,1.47248,202),(0.34703,1.31481,202),(0.461931,1.38783,202),(0.318523,1.35147,202),(0.202356,1.37185,202),(0.151553,1.34099,202),(0.489274,1.3663,202),(0.277216,1.37154,202),(0.180477,1.38543,202),(0.292052,1.31016,202),(0.358374,1.49429,202),(0.441277,1.40615,202),(0.449131,1.29736,202),(0.342085,1.47742,202),(0.338012,1.38376,202),(0.401717,1.33896,202),(0.295833,1.29852,202),(0.428769,1.35641,202),(0.413352,1.51815,202),(0.515163,1.33692,202),(0.366228,1.36543,202),(0.166097,1.3631,202),(0.149554,1.36294,202),(0.172206,1.33256,202),(0.232371,1.33092,202),(0.425569,1.35118,202),(0.222791,1.32744,202),(0.194403,1.38013,202),(0.225247,1.38438,202),(0.456404,1.52745,202),(0.177541,1.37866,202),(0.221075,1.38376,202),(0.325795,1.3122,202),(0.37001,1.43059,202),(0.399389,1.53211,202),(0.228367,1.39051,202),(0.446223,1.47771,202),(0.493637,1.38143,202),(0.495092,1.36601,202),(0.403171,1.42564,202),(0.509481,1.27773,202),(0.43895,1.33169,202),(0.349648,1.34943,202),(0.196108,1.34574,202),(0.269362,1.31656,202),(0.376991,1.27409,202),(0.403753,1.22202,202),(0.369365,1.3493,202),(0.384554,1.30987,202),(0.363901,1.48528,202),(0.178024,1.33343,202),(0.221851,1.35604,202),(0.310897,1.3627,202),(0.202023,1.35421,202),(0.174242,1.35496,202),(0.588758,1.31161,202),(0.256272,1.35438,202),(0.545415,1.33518,202),(0.393863,1.27293,202),(0.308632,1.44891,202),(0.184714,1.34274,202),(0.321432,1.46433,202),(0.394095,1.53604,202),(0.371755,1.27147,202),(0.504691,1.3695,202),(0.552101,1.30665,202),(0.377282,1.24326,202),(0.365356,1.35699,202),(0.383681,1.27235,202),(0.354011,1.27438,202),(0.398517,1.52425,202),(0.382809,1.36339,202),(0.441675,1.29025,202),(0.223256,1.37386,202),(0.403462,1.45211,202),(0.228609,1.39909,202),(0.15203,1.35179,202),(0.530202,1.34008,202),(0.326958,1.33314,202),(0.466134,1.3653,202),(0.342375,1.32296,202),(0.436914,1.51669,202),(0.424406,1.41343,202),(0.335103,1.277,202),(0.367392,1.31016,202),(0.289434,1.43146,202),(0.176438,1.33281,202),(0.481056,1.33736,202),(0.414807,1.3186,202),(0.491601,1.65399,202),(0.269362,1.30434,202),(0.516908,1.39045,202),(0.165632,1.33215,202),(0.444186,1.42855,202),(0.502655,1.34652,202),(0.486656,1.36281,202),(0.479966,1.38201,202),(0.325349,1.27198,202),(0.154753,1.35263,202),(0.219911,1.37445,202),(0.226936,1.39986,202),(0.325795,1.2898,202),(0.306596,1.33634,202),(0.368201,1.34493,202),(0.361865,1.3439,202),(0.426151,1.33634,202),(0.289725,1.42041,202),(0.461058,1.44077,202),(0.460476,1.39539,202),(0.384263,1.43873,202),(0.306014,1.33023,202),(0.281289,1.29503,202),(0.555756,1.30479,202),(0.46164,1.3026,202),(0.41407,1.61823,202),(0.436623,1.44891,202),(0.326377,1.34274,202),(0.333067,1.30434,202),(0.402007,1.2674,202),(0.474439,1.36165,202),(0.416023,1.59305,202),(0.413643,1.32674,202),(0.300197,1.33256,202),(0.513127,1.37328,202),(0.159989,1.33925,202),(0.410152,1.51262,202),(0.272853,1.34885,202),(0.343248,1.37067,202),(0.276053,1.39597,202),(0.474439,1.35728,202),(0.371008,1.35278,202),(0.427315,1.27031,202),(0.42924,1.26916,202),(0.526217,1.29474,202),(0.459603,1.58243,202),(0.380108,1.53159,202),(0.385028,1.53781,202),(0.400534,1.53622,202),(0.395157,1.53973,202),(0.394924,1.54109,202),(0.395007,1.54197,202),(0.394309,1.54004,202),(0.394216,1.53891,202),(0.393465,1.5383,202),(0.392844,1.53965,202),(0.392093,1.53854,202),(0.385863,1.53727,202),(0.389,1.54478,202),(0.594794,1.30395,202),(0.304904,1.36358,202),(0.30455,1.37332,202),(0.232017,1.3579,202),(0.548606,1.32152,202),(0.22745,1.39901,202),(0.226413,1.39991,202),(0.226393,1.40058,202),(0.224318,1.39708,202),(0.333644,1.27243,202),(0.332255,1.27437,202),(0.245992,1.3,202),(0.323412,1.28897,202),(0.497352,1.35326,202),(0.535466,1.33905,202),(0.394479,1.32115,202),(0.377983,1.49476,202),(0.334247,1.27402,202),(0.176412,1.33259,202),(0.533755,1.30608,202),(0.174181,1.33647,202),(0.1764,1.33472,202),(0.355554,1.27243,202),(0.540316,1.34026,202),(0.498815,1.34966,202),(0.492362,1.34147,202),(0.402851,1.35321,202),(0.422365,1.44296,202),(0.466076,1.55588,202),(0.46858,1.5599,202),(0.238237,1.38614,202),(0.332586,1.38741,202),(0.277471,1.38442,202),(0.303109,1.37051,202),(0.343027,1.3703,202),(0.284242,1.41816,202),(0.302774,1.37109,202),(0.304522,1.37054,202),(0.331003,1.3871,202),(0.252639,1.37594,202),(0.343268,1.37059,202),(0.308923,1.4524,202),(0.313828,1.40944,202),(0.253861,1.34575,202),(0.280494,1.40585,202),(0.305451,1.36935,202),(0.295749,1.43533,202),(0.306855,1.40807,202),(0.462562,1.58772,202),(0.301064,1.41143,202),(0.287723,1.40791,202),(0.46041,1.61166,202),(0.473066,1.63529,202),(0.305313,1.36663,202),(0.45738,1.63728,202),(0.449405,1.62612,202),(0.404567,1.54601,202),(0.399055,1.54701,202),(0.412801,1.52131,202),(0.540503,1.30884,202),(0.327336,1.38708,202),(0.648356,0.745318,172),(0.524231,0.836353,172),(0.608912,0.778985,172),(0.60416,0.762336,172),(0.63689,0.752591,172),(0.642412,0.75116,172),(0.596844,0.765744,172),(0.570994,0.772807,172),(0.639078,0.777198,172),(0.601778,0.731441,172),(0.633047,0.757082,172),(0.589015,0.795085,172),(0.629794,0.778915,172),(0.605448,0.78471,172),(0.619034,0.77479,172),(0.569257,0.768379,172),(0.63168,0.76813,172),(0.58707,0.747484,172),(0.613968,0.802609,172),(0.595764,0.739622,172),(0.620178,0.782506,172),(0.609656,0.759098,172),(0.588989,0.779179,172),(0.621632,0.802038,172),(0.593671,0.770489,172),(0.581903,0.774942,172),(0.530443,0.832552,172),(0.574659,0.781486,172),(0.620726,0.792954,172),(0.546846,0.790536,172),(0.551241,0.779233,172),(0.548191,0.805866,172),(0.557852,0.77843,172),(0.576608,0.703121,172),(0.550275,0.788955,172),(0.583299,0.755863,172),(0.542064,0.807342,172),(0.558317,0.773689,172),(0.601603,0.73203,172),(0.563706,0.779862,172),(0.572188,0.772773,172),(0.555091,0.776485,172),(0.593039,0.784298,172),(0.634094,0.752074,172),(0.634165,0.752567,172),(0.551041,0.823364,172),(0.567455,0.799678,172),(0.590062,0.777255,172),(0.566566,0.814858,172),(0.567968,0.771804,172),(0.566598,0.775269,172),(0.561546,0.80361,172),(0.536141,0.832886,172),(0.554022,0.778759,172),(0.540524,0.815466,172),(0.523149,0.846015,172),(0.582169,0.764212,172),(0.532902,0.834223,172),(0.574378,0.786508,172),(0.555641,0.822818,172),(0.559628,0.789717,172),(0.590736,0.772037,172),(0.558381,0.784098,172),(0.581317,0.771208,172),(0.532243,0.834562,172),(0.633919,0.730884,172),(0.607209,0.847708,232),(0.600111,0.82127,232),(0.594693,0.837278,232),(0.614959,0.912972,232),(0.618535,0.900047,232),(0.632036,0.858632,232),(0.64729,0.962967,232),(0.537783,0.987228,232),(0.640075,0.846113,232),(0.556711,0.948892,232),(0.616524,0.901388,232),(0.615648,1.03358,232),(0.642565,0.887915,232),(0.622985,0.897475,232),(0.659748,0.853531,232),(0.629533,0.867357,232),(0.635316,0.822282,232),(0.554091,0.946122,232),(0.664621,0.807946,232),(0.586358,0.993518,232),(0.60709,0.830784,232),(0.513773,0.971803,232),(0.559299,0.85271,232),(0.561895,0.84201,232),(0.51668,0.916975,232),(0.564187,0.887752,232),(0.525632,0.962001,232),(0.534939,0.84936,232),(0.620864,0.931956,232),(0.548324,0.900008,232),(0.611237,0.878888,232),(0.63815,0.926073,232),(0.63268,0.807625,232),(0.616353,0.82017,232),(0.666669,0.781302,232),(0.640175,0.812746,232),(0.632029,1.00674,232),(0.648174,0.877691,232),(0.619323,0.891565,232),(0.545688,0.991442,232),(0.650672,0.86539,232),(0.539212,0.862353,232),(0.545938,0.865745,232),(0.530697,0.977278,232),(0.647622,1.02118,232),(0.613769,0.834346,232),(0.604584,0.887961,232),(0.470508,0.98213,232),(0.6332,0.87275,232),(0.678785,0.785843,232),(0.563248,0.88977,232),(0.588639,1.03296,232),(0.60146,0.800454,232),(0.616241,0.902801,232),(0.640553,0.787864,232),(0.611623,0.809074,232),(0.691992,0.836316,232),(0.646465,0.787114,232),(0.655419,0.786725,232),(0.536858,0.867516,232),(0.525589,0.899224,232),(0.639646,0.898775,232),(0.632041,1.02618,232),(0.509615,0.948199,232),(0.639677,0.930244,232),(0.627483,0.883268,232),(0.644992,0.79217,232),(0.596702,0.844338,232),(0.473799,0.996236,232),(0.645238,0.804644,232),(0.562871,0.942767,232),(0.551379,0.950014,232),(0.557395,0.860515,232),(0.522249,0.987409,232),(0.633502,1.04032,232),(0.670781,0.798923,232),(0.598594,0.852131,232),(0.622487,0.889711,232),(0.641637,0.798003,232),(0.64921,0.875344,232),(0.585267,0.830951,232),(0.463521,0.942817,232),(0.67283,0.784562,232),(0.579807,0.878162,232),(0.531292,0.840974,232),(0.584472,0.843968,232),(0.587168,0.874042,232),(0.656574,0.846935,232),(0.598895,0.821439,232),(0.528542,0.996213,232),(0.516958,0.901535,232),(0.615025,1.02042,232),(0.593117,0.897735,232),(0.625447,0.890298,232),(0.602214,0.837152,232),(0.607298,0.819179,232),(0.652416,0.968512,232),(0.639509,0.923496,232),(0.607307,0.811879,232),(0.587083,0.810229,232),(0.598161,0.830534,232),(0.607361,0.846739,232),(0.642956,0.950066,232),(0.650136,0.962849,232),(0.599571,1.02422,232),(0.583877,0.877697,232),(0.482849,0.944871,232),(0.516253,0.881688,232),(0.503419,0.917532,232),(0.640299,0.916691,232),(0.505069,0.936338,232),(0.56299,0.882455,232),(0.647106,1.00374,232),(0.635617,0.959517,232),(0.529858,0.886594,232),(0.593246,0.884599,232),(0.57062,0.82498,232),(0.537472,0.882518,232),(0.55084,0.840954,232),(0.501816,0.95198,232),(0.631256,0.948552,232),(0.623393,0.908706,232),(0.639584,1.03186,232),(0.63975,0.897455,232),(0.505594,0.887299,232),(0.637412,0.806497,232),(0.591619,0.850876,232),(0.557899,0.895132,232),(0.510799,0.893886,232),(0.654057,1.00058,232),(0.573625,1.0336,232),(0.625994,0.830865,232),(0.651713,0.803831,232),(0.640402,0.93467,232),(0.533999,0.876883,232),(0.628275,0.80085,232),(0.463523,0.957848,232),(0.65402,0.863228,232),(0.474494,0.982285,232),(0.507996,1.01852,232),(0.609246,0.845462,232),(0.551748,0.967099,232),(0.64058,0.919048,232),(0.637941,0.919421,232),(0.586596,0.854002,232),(0.654113,0.821191,232),(0.670714,0.852977,232),(0.650303,0.871695,232),(0.607068,0.839827,232),(0.582523,0.914018,232),(0.563916,0.942783,232),(0.667585,0.842877,232),(0.595013,0.867239,232),(0.636515,0.913692,232),(0.633881,0.85814,232),(0.622377,0.891153,232),(0.582951,0.86734,232),(0.591026,0.842329,232),(0.510446,0.921173,232),(0.654108,0.801007,232),(0.546642,0.84944,232),(0.671557,0.821525,232),(0.535827,0.869724,232),(0.629482,0.882264,232),(0.630881,0.859016,232),(0.57583,0.827632,232),(0.543859,0.918926,232),(0.529519,0.843069,232),(0.61614,0.899469,232),(0.559097,0.905467,232),(0.570454,0.900612,232),(0.568571,0.898059,232),(0.569578,0.89652,232),(0.570726,0.899213,232),(0.56821,0.899304,232),(0.568197,0.899015,232),(0.569976,0.901944,232),(0.572464,0.902257,232),(0.569244,0.899814,232),(0.541553,1.0734,232),(0.514808,1.06226,232),(0.615124,1.05806,232),(0.606327,1.06073,232),(0.637829,1.0674,232),(0.492551,1.06842,232),(0.474772,1.05915,232),(0.441427,1.05842,232),(1.14639,-0.315692,248),(1.11938,-0.382147,248),(1.11897,-0.382454,248),(1.11818,-0.382886,248),(0.644964,0.253652,295),(0.664556,0.234657,295),(0.674994,0.280912,295),(0.696917,0.320361,295),(0.663502,0.218354,295),(0.66294,0.239032,295),(0.669443,0.279443,295),(0.647258,0.266564,295),(0.685953,0.160624,295),(0.668286,0.283929,295),(0.667936,0.28442,295),(0.685924,0.158665,295),(0.685158,0.160003,295),(0.650974,0.25902,295),(0.642111,0.256588,295),(0.654619,0.228359,295),(0.655826,0.263511,295),(0.685274,0.291463,295),(0.654221,0.244092,295),(0.690716,0.290334,295),(0.642704,0.260888,295),(0.671674,0.278886,295),(0.654471,0.231503,295),(0.686473,0.282471,295),(0.665153,0.273341,295),(0.644519,0.256863,295),(0.684901,0.160289,295),(0.641069,0.259179,295),(0.650893,0.23608,295),(0.652508,0.250754,295),(0.655737,0.260101,295),(0.663992,0.228988,295),(0.68696,0.279944,295),(0.669484,0.27662,295),(0.649134,0.240244,295),(0.665247,0.233172,295),(0.651501,0.257345,295),(0.640861,0.263382,295),(0.69644,0.149958,295),(0.643854,0.263009,295),(0.648366,0.251175,295),(0.680387,0.28478,295),(0.687743,0.28201,295),(0.685148,0.159518,295),(0.664622,0.231929,295),(0.643083,0.257855,295),(0.654815,0.262339,295),(0.663816,0.234777,295),(0.667085,0.265958,295),(0.666598,0.271393,295),(0.657363,0.219703,295),(0.656107,0.262321,295),(0.659676,0.217035,295),(0.647642,0.243405,295),(0.650754,0.261792,295),(0.686113,0.148964,295),(0.670625,0.27749,295),(0.658458,0.265075,295),(0.647174,0.248372,295),(0.647289,0.26445,295),(0.651314,0.238451,295),(0.663872,0.219676,295),(0.655526,0.249393,295),(0.682164,0.298762,295),(0.686089,0.283619,295),(0.691063,0.288288,295),(0.644923,0.254996,295),(0.678772,0.289702,295),(0.654536,0.263321,295),(0.694995,0.282958,295),(0.657686,0.223256,295),(0.694344,0.284806,295),(0.698394,0.317005,295),(0.650476,0.262019,295),(0.665959,0.229993,295),(0.683597,0.148741,295),(0.683723,0.156575,295),(0.652036,0.241734,295),(0.654284,0.245131,295),(0.649905,0.253303,295),(0.684298,0.159429,295),(0.65955,0.258905,295),(0.657032,0.259479,295),(0.65615,0.261509,295),(0.665801,0.265473,295),(0.66461,0.235783,295),(0.644224,0.264234,295),(0.6499,0.265634,295),(0.68575,0.157026,295),(0.669915,0.28158,295),(0.663196,0.226134,295),(0.651372,0.237169,295),(0.657322,0.258916,295),(0.689281,0.285951,295),(0.656351,0.263897,295),(0.65636,0.264641,295),(0.656173,0.264246,295),(0.655515,0.264148,295),(0.776491,0.195796,295),(0.785305,0.15723,295),(0.802444,0.214734,295),(0.740331,0.211334,295),(0.796077,0.163486,295),(0.79784,0.213924,295),(0.714217,0.247659,295),(0.791548,0.189197,295),(0.792861,0.208731,295),(0.776374,0.19207,295),(0.790838,0.154656,295),(0.709648,0.251881,295),(0.795125,0.201427,295),(0.765738,0.178997,295),(0.784167,0.183584,295),(0.792976,0.191948,295),(0.727495,0.234184,295),(0.791037,0.146875,295),(0.764272,0.132797,295),(0.793053,0.215141,295),(0.78756,0.133263,295),(0.727265,0.223041,295),(0.735208,0.256667,295),(0.799868,0.153972,295),(0.716376,0.2947,295),(0.785644,0.150822,295),(0.796713,0.197334,295),(0.763166,0.220546,295),(0.755824,0.215313,295),(0.803932,0.23112,295),(0.71675,0.295414,295),(0.796719,0.240506,295),(0.792782,0.158239,295),(0.797034,0.213716,295),(0.79454,0.167368,295),(0.804036,0.194099,295),(0.792986,0.152487,295),(0.720345,0.286502,295),(0.797807,0.155468,295),(0.783615,0.154701,295),(0.727641,0.266971,295),(0.711814,0.250818,295),(0.711217,0.252456,295),(0.786628,0.13416,295),(0.754201,0.231956,295),(0.746651,0.2165,295),(0.732356,0.223383,295),(0.797769,0.200357,295),(0.712307,0.253011,295),(0.720641,0.231104,295),(0.742937,0.220782,295),(0.732844,0.261617,295),(0.717874,0.28877,295),(0.744579,0.239093,295),(0.737475,0.205191,295),(0.706441,0.300715,295),(0.785256,0.187502,295),(0.733875,0.243109,295),(0.705751,0.314889,295),(0.740952,0.246807,295),(0.746038,0.222309,295),(0.709058,0.250881,295),(0.728077,0.237611,295),(0.805801,0.172249,295),(0.713344,0.251958,295),(0.797318,0.151996,295),(0.764321,0.193695,295),(0.756077,0.197795,295),(0.724369,0.228012,295),(0.79692,0.159877,295),(0.787846,0.135578,295),(0.772713,0.164006,295),(0.794727,0.161164,295),(0.765057,0.195393,295),(0.719788,0.243174,295),(0.797325,0.169696,295),(0.796784,0.160576,295),(0.76287,0.230674,295),(0.795456,0.159253,295),(0.792229,0.205958,295),(0.794059,0.162197,295),(0.79541,0.211291,295),(0.797832,0.198224,295),(0.763655,0.195266,295),(0.778355,0.186588,295),(0.711271,0.253663,295),(0.773339,0.147954,295),(0.779185,0.133621,295),(0.705173,0.306452,295),(0.777559,0.188229,295),(0.710824,0.149405,295),(0.76989,0.17381,295),(0.796357,0.157684,295),(0.712283,0.255164,295),(0.709604,0.309049,295),(0.711973,0.292435,295),(0.754503,0.238867,295),(0.769049,0.217234,295),(0.710763,0.253885,295),(0.714637,0.248385,295),(0.713262,0.251412,295),(0.716985,0.248823,295),(0.727623,0.268363,295),(0.760521,0.211936,295),(0.733795,0.257038,295),(0.764755,0.135738,295),(0.706601,0.314154,295),(0.730219,0.271667,295),(0.762605,0.189285,295),(0.787246,0.135342,295),(0.728032,0.272967,295),(0.776109,0.199212,295),(0.712615,0.25315,295),(0.763785,0.182219,295),(0.792305,0.162099,295),(0.760382,0.201295,295),(0.727889,0.274349,295),(0.792168,0.192649,295),(0.779114,0.1952,295),(0.706101,0.303316,295),(0.71263,0.250239,295),(0.792727,0.161727,295),(0.796423,0.219378,295),(0.761994,0.195294,295),(0.792325,0.19695,295),(0.749542,0.242279,295),(0.796313,0.1533,295),(0.779227,0.130659,295),(0.782165,0.174177,295),(0.709965,0.257715,295),(0.802051,0.218214,295),(0.720825,0.227384,295),(0.717568,0.287766,295),(0.715779,0.296802,295),(0.792063,0.159882,295),(0.786794,0.205827,295),(0.800925,0.192661,295),(0.757611,0.182787,295),(0.744668,0.244742,295),(0.794554,0.170141,295),(0.731201,0.217885,295),(0.786647,0.131357,295),(0.785992,0.131221,295),(0.76905,0.219577,295),(0.740146,0.224435,295),(0.767935,0.220904,295),(0.794664,0.15778,295),(0.780132,0.18555,295),(0.75754,0.236663,295),(0.775232,0.21295,295),(0.774047,0.161058,295),(0.765324,0.19165,295),(0.714234,0.246966,295),(0.712999,0.298823,295),(0.765925,0.193573,295),(0.712652,0.246266,295),(0.709377,0.275912,295),(0.712705,0.146559,295),(0.754999,0.240127,295),(0.75368,0.24074,295),(0.798929,0.224076,295),(0.755849,0.239469,295),(0.712367,0.250231,295),(0.802221,0.220915,295),(0.762039,0.185558,295),(0.763994,0.19946,295),(0.711154,0.253026,295),(0.713978,0.251087,295),(0.727226,0.218257,295),(0.715514,0.300474,295),(0.701823,0.290992,295),(0.712149,0.253754,295),(0.758737,0.194528,295),(0.76657,0.190653,295),(0.704949,0.288971,295),(0.76298,0.181455,295),(0.790591,0.210186,295),(0.785233,0.130266,295),(0.749354,0.183646,295),(0.794212,0.162866,295),(0.783362,0.128282,295),(0.767111,0.178456,295),(0.774803,0.197961,295),(0.786214,0.169286,295),(0.766148,0.186583,295),(0.792917,0.162467,295),(0.741071,0.248015,295),(0.766262,0.224977,295),(0.75245,0.216225,295),(0.803986,0.19614,295),(0.77373,0.189106,295),(0.788618,0.159897,295),(0.781954,0.180275,295),(0.795084,0.156131,295),(0.716589,0.291484,295),(0.795934,0.172738,295),(0.730168,0.224955,295),(0.708235,0.29738,295),(0.711248,0.255051,295),(0.797165,0.2123,295),(0.792645,0.207377,295),(0.795329,0.159956,295),(0.712964,0.252901,295),(0.710831,0.306766,295),(0.758917,0.235401,295),(0.745596,0.211387,295),(0.739141,0.251396,295),(0.721343,0.274203,295),(0.706812,0.307899,295),(0.785465,0.131596,295),(0.800753,0.146748,295),(0.714213,0.165555,295),(0.799012,0.217958,295),(0.703735,0.162835,295),(0.781224,0.153407,295),(0.794665,0.159431,295),(0.793087,0.150392,295),(0.795702,0.160562,295),(0.714224,0.253648,295),(0.716175,0.296524,295),(0.711933,0.299005,295),(0.711084,0.256091,295),(0.71126,0.255519,295),(0.785294,0.133375,295),(0.723597,0.220965,295),(0.795114,0.156691,295),(0.794627,0.190904,295),(0.742064,0.218569,295),(0.701188,0.314678,295),(0.712676,0.248709,295),(0.714037,0.247926,295),(0.795667,0.161028,295),(0.709219,0.297322,295),(0.795564,0.161877,295),(0.792644,0.181352,295),(0.759701,0.201916,295),(0.741834,0.246755,295),(0.733955,0.220238,295),(0.766577,0.192529,295),(0.794189,0.199177,295),(0.765912,0.188035,295),(0.798929,0.210118,295),(0.765682,0.18871,295),(0.789629,0.205059,295),(0.714816,0.30176,295),(0.799487,0.236216,295),(0.717577,0.242488,295),(0.774857,0.136444,295),(0.785333,0.134221,295),(0.71908,0.289681,295),(0.716649,0.298229,295),(0.795259,0.213541,295),(0.717285,0.292831,295),(0.779252,0.190684,295),(0.794028,0.211267,295),(0.783422,0.193142,295),(0.792903,0.211529,295),(0.720081,0.239524,295),(0.793501,0.160387,295),(0.793955,0.213672,295),(0.707885,0.310814,295),(0.711766,0.257557,295),(0.814513,0.194771,295),(0.733648,0.220651,295),(0.794147,0.164502,295),(0.714198,0.248361,295),(0.715524,0.273168,295),(0.79166,0.162734,295),(0.796886,0.159868,295),(0.7098,0.289752,295),(0.765635,0.180462,295),(0.708463,0.298718,295),(0.76833,0.176524,295),(0.710404,0.302534,295),(0.794954,0.212058,295),(0.74885,0.215301,295),(0.728892,0.220686,295),(0.768615,0.175256,295),(0.714299,0.252342,295),(0.797477,0.160217,295),(0.716147,0.249598,295),(0.713798,0.247671,295),(0.777104,0.189639,295),(0.788196,0.188458,295),(0.72651,0.277671,295),(0.705145,0.307763,295),(0.7992,0.155019,295),(0.700199,0.319377,295),(0.793506,0.155031,295),(0.716283,0.250923,295),(0.755695,0.234591,295),(0.775399,0.207827,295),(0.724455,0.267647,295),(0.765215,0.183362,295),(0.790871,0.165856,295),(0.759962,0.180048,295),(0.796086,0.161266,295),(0.795814,0.159332,295),(0.728363,0.214266,295),(0.7958,0.155471,295),(0.788595,0.197381,295),(0.800289,0.163887,295),(0.704363,0.317162,295),(0.723721,0.225223,295),(0.707782,0.309281,295),(0.763954,0.193781,295),(0.769874,0.1718,295),(0.739157,0.233866,295),(0.736821,0.251122,295),(0.8103,0.197893,295),(0.795377,0.157548,295),(0.732231,0.210722,295),(0.793553,0.137465,295),(0.726061,0.248504,295),(0.710931,0.243473,295),(0.710964,0.243441,295),(0.765981,0.140164,295),(0.774093,0.20448,295),(0.794703,0.220693,295),(0.759592,0.231146,295),(0.733329,0.222529,295),(0.756678,0.219431,295),(0.754535,0.22307,295),(0.714466,0.248881,295),(0.786586,0.132254,295),(0.707543,0.304275,295),(0.729262,0.221232,295),(0.746502,0.19387,295),(0.712439,0.286632,295),(0.710272,0.253288,295),(0.80182,0.237743,295),(0.794676,0.164142,295),(0.797512,0.160766,295),(0.746323,0.243538,295),(0.714318,0.24768,295),(0.718839,0.290901,295),(0.712037,0.295372,295),(0.708257,0.292449,295),(0.792398,0.179407,295),(0.727825,0.221513,295),(0.775037,0.155925,295),(0.795459,0.158332,295),(0.699101,0.313747,295),(0.796921,0.153443,295),(0.700626,0.315388,295),(0.701169,0.317095,295),(0.719321,0.236855,295),(0.763195,0.188672,295),(0.726755,0.232829,295),(0.714809,0.249106,295),(0.714526,0.249129,295),(0.729832,0.22111,295),(0.707393,0.30692,295),(0.74038,0.249355,295),(0.777526,0.134742,295),(0.777945,0.189316,295),(0.720058,0.237467,295),(0.771848,0.210361,295),(0.721765,0.234421,295),(0.749206,0.187826,295),(0.749515,0.221675,295),(0.72363,0.271386,295),(0.72898,0.213438,295),(0.763873,0.19635,295),(0.777299,0.188876,295),(0.782511,0.197116,295),(0.761305,0.200178,295),(0.783024,0.175697,295),(0.782375,0.20282,295),(0.753365,0.239517,295),(0.727721,0.231368,295),(0.803262,0.207816,295),(0.712695,0.302961,295),(0.76481,0.227103,295),(0.76137,0.233928,295),(0.772931,0.207403,295),(0.756437,0.225274,295),(0.789288,0.203483,295),(0.712204,0.250646,295),(0.799528,0.161116,295),(0.763015,0.190964,295),(0.708852,0.262809,295),(0.804885,0.144742,295),(0.796222,0.160644,295),(0.793566,0.183853,295),(0.79673,0.167621,295),(0.795051,0.160281,295),(0.77488,0.131677,295),(0.787775,0.175021,295),(0.79166,0.168743,295),(0.795414,0.142798,295),(0.755286,0.209183,295),(0.79292,0.159016,295),(0.78138,0.188187,295),(0.794072,0.157536,295),(0.794815,0.160063,295),(0.802672,0.221691,295),(0.752744,0.214455,295),(0.718125,0.286476,295),(0.78353,0.206384,295),(0.702871,0.315146,295),(0.714996,0.298709,295),(0.800941,0.214545,295),(0.799535,0.158606,295),(0.780119,0.212683,295),(0.794649,0.161931,295),(0.760769,0.18282,295),(0.786752,0.132164,295),(0.72826,0.226955,295),(0.757737,0.19428,295),(0.734666,0.205892,295),(0.738191,0.216581,295),(0.758678,0.213462,295),(0.796743,0.205673,295),(0.725896,0.223892,295),(0.789501,0.132624,295),(0.795121,0.160952,295),(0.729576,0.220026,295),(0.788703,0.137658,295),(0.789213,0.214287,295),(0.739338,0.246755,295),(0.785642,0.136525,295),(0.77349,0.162707,295),(0.794751,0.173317,295),(0.771433,0.216405,295),(0.770373,0.213683,295),(0.7964,0.159737,295),(0.772518,0.215515,295),(0.73291,0.211052,295),(0.760039,0.192688,295),(0.794599,0.162899,295),(0.720193,0.277515,295),(0.788751,0.195657,295),(0.713082,0.25059,295),(0.780615,0.197016,295),(0.70937,0.305703,295),(0.755951,0.183679,295),(0.725494,0.23271,295),(0.787764,0.210865,295),(0.710365,0.256662,295),(0.767203,0.222312,295),(0.792215,0.183003,295),(0.71617,0.243337,295),(0.774901,0.202193,295),(0.778017,0.198282,295),(0.709079,0.295604,295),(0.713603,0.299594,295),(0.71062,0.252883,295),(0.797198,0.208148,295),(0.778343,0.192894,295),(0.761139,0.191449,295),(0.758575,0.236408,295),(0.724096,0.241405,295),(0.794536,0.16605,295),(0.713956,0.24951,295),(0.717037,0.250192,295),(0.788502,0.133389,295),(0.762345,0.183249,295),(0.714837,0.295317,295),(0.714,0.25038,295),(0.787726,0.147605,295),(0.776245,0.196802,295),(0.715784,0.246525,295),(0.769043,0.175592,295),(0.7816,0.189852,295),(0.782728,0.134705,295),(0.714573,0.249572,295),(0.797156,0.161198,295),(0.717325,0.248188,295),(0.765759,0.18453,295),(0.705539,0.26321,295),(0.798128,0.159533,295),(0.719418,0.28043,295),(0.725359,0.255997,295),(0.764883,0.194297,295),(0.709744,0.263647,295),(0.76637,0.178755,295),(0.765431,0.194826,295),(0.714836,0.249761,295),(0.796067,0.154447,295),(0.793587,0.189378,295),(0.777319,0.2013,295),(0.714245,0.251745,295),(0.79505,0.162299,295),(0.709088,0.313057,295),(0.794787,0.160382,295),(0.815331,0.203435,295),(0.794557,0.1785,295),(0.734837,0.212501,295),(0.780215,0.137107,295),(0.711669,0.253063,295);
/*&*/
INSERT INTO `x2_timezone_points` VALUES (0.767166,0.19868,295),(0.797657,0.147622,295),(0.783412,0.199156,295),(0.811451,0.197808,295),(0.776563,0.197899,295),(0.794936,0.159183,295),(0.717519,0.291285,295),(0.719809,0.288056,295),(0.79517,0.140499,295),(0.79758,0.168755,295),(0.717846,0.258067,295),(0.805382,0.213303,295),(0.785802,0.132364,295),(0.708794,0.26154,295),(0.751677,0.218961,295),(0.798795,0.204827,295),(0.711182,0.2578,295),(0.721027,0.284328,295),(0.71764,0.294109,295),(0.79369,0.157041,295),(0.712325,0.247279,295),(0.763602,0.197615,295),(0.775144,0.20904,295),(0.712081,0.245715,295),(0.73374,0.234551,295),(0.715117,0.247923,295),(0.714091,0.258112,295),(0.783617,0.143236,295),(0.751698,0.220199,295),(0.747958,0.236927,295),(0.794461,0.197896,295),(0.714091,0.249008,295),(0.728153,0.221236,295),(0.718184,0.263254,295),(0.778633,0.206571,295),(0.758544,0.207291,295),(0.795037,0.158416,295),(0.726272,0.218416,295),(0.796336,0.162762,295),(0.725874,0.220786,295),(0.798268,0.127699,295),(0.723395,0.220384,295),(0.711094,0.25432,295),(0.71961,0.284329,295),(0.760931,0.235795,295),(0.728583,0.229558,295),(0.712605,0.288916,295),(0.787178,0.131364,295),(0.707886,0.145178,295),(0.78387,0.150429,295),(0.798729,0.170979,295),(0.791463,0.207122,295),(0.768817,0.143436,295),(0.728304,0.220973,295),(0.78016,0.140232,295),(0.728337,0.23283,295),(0.704186,0.261739,295),(0.714294,0.249771,295),(0.786382,0.210448,295),(0.715659,0.294467,295),(0.779728,0.147787,295),(0.713802,0.293957,295),(0.714725,0.250913,295),(0.792348,0.155627,295),(0.791699,0.205799,295),(0.794004,0.212242,295),(0.801479,0.149258,295),(0.791516,0.160617,295),(0.796706,0.179156,295),(0.792662,0.158962,295),(0.732927,0.222047,295),(0.680083,0.284649,295),(0.797087,0.153937,295),(0.793736,0.158052,295),(0.715686,0.252302,295),(0.716489,0.250129,295),(0.713435,0.24678,295),(0.655917,0.263037,295),(0.713826,0.249174,295),(0.713463,0.250331,295),(0.655468,0.262899,295),(0.793114,0.158728,295),(0.732998,0.220228,295),(0.858493,-0.0367376,277),(0.314003,-1.34316,109),(0.31364,-1.34159,109),(0.313137,-1.34581,109),(0.31429,-1.34012,109),(0.322383,-1.35994,109),(0.31354,-1.34818,109),(0.314887,-1.35275,109),(0.316547,-1.34446,109),(0.314107,-1.3403,109),(0.314377,-1.3404,109),(0.557655,0.625173,168),(0.556506,0.625776,168),(0.556273,0.628406,168),(0.55356,0.624828,168),(0.563329,0.621326,168),(0.563407,0.626561,168),(0.543825,0.622957,168),(0.568202,0.625701,168),(0.559775,0.629854,168),(0.567358,0.625831,168),(0.538216,0.621414,168),(0.559189,0.623558,168),(0.568265,0.62844,168),(0.563851,0.624069,168),(0.557724,0.627359,168),(0.557051,0.627446,168),(0.56449,0.631949,168),(0.544237,0.623082,168),(0.558956,0.625955,168),(0.515338,0.611001,168),(0.564332,0.623997,168),(0.543909,0.624165,168),(0.558816,0.629128,168),(0.588758,2.37336,234),(0.618525,2.43229,234),(0.604466,2.3559,234),(0.615956,2.43623,234),(0.619398,2.43279,234),(0.680678,2.44201,234),(0.588677,2.28608,234),(0.633555,2.44142,234),(0.613483,2.42717,234),(0.626316,2.44066,234),(0.632682,2.42572,234),(0.657698,2.42397,234),(0.630355,2.4295,234),(0.626282,2.43706,234),(0.618428,2.32711,234),(0.615815,2.43765,234),(0.61868,2.43722,234),(0.610283,2.38441,234),(0.612894,2.3771,234),(0.608598,2.36846,234),(0.567232,2.2794,234),(0.638209,2.39343,234),(0.618428,2.32565,234),(0.612052,2.37405,234),(0.609411,2.35561,234),(0.625221,2.44065,234),(0.604175,2.36667,234),(0.59283,2.30587,234),(0.578868,2.27591,234),(0.610865,2.34834,234),(0.596655,2.29461,234),(0.57625,2.28085,234),(0.608538,2.41437,234),(0.642281,2.4423,234),(0.625288,2.4383,234),(0.594576,2.34136,234),(0.638194,2.44143,234),(0.570432,2.28056,234),(0.577845,2.30013,234),(0.561831,2.26933,234),(0.577704,2.26864,234),(0.622569,2.44152,234),(0.642281,2.39808,234),(0.585849,2.27765,234),(0.640245,2.44288,234),(0.608829,2.37016,234),(0.621628,2.42804,234),(0.606502,2.37597,234),(0.574213,2.28085,234),(0.6353,2.41321,234),(0.592418,2.29076,234),(0.611738,2.33874,234),(0.613774,2.38616,234),(0.580147,2.29833,234),(0.675821,2.44035,234),(0.636173,2.3847,234),(0.622131,2.37462,234),(0.560251,2.29336,234),(0.57719,2.30134,234),(0.580613,2.289,234),(0.639954,2.38645,234),(0.657116,2.42484,234),(0.606158,2.38252,234),(0.61232,2.39372,234),(0.633553,2.40683,234),(0.620174,2.35329,234),(0.607068,2.36439,234),(0.607666,2.39808,234),(0.606793,2.39779,234),(0.605629,2.38994,234),(0.640453,2.39479,234),(0.619592,2.34281,234),(0.582358,2.27795,234),(0.601848,2.34194,234),(0.602139,2.36667,234),(0.632682,2.42426,234),(0.457014,2.22835,234),(0.622899,2.43808,234),(0.594285,2.30063,234),(0.594561,2.34851,234),(0.624813,2.43419,234),(0.608829,2.38848,234),(0.616974,2.3943,234),(0.648099,2.42194,234),(0.57305,2.26631,234),(0.653917,2.42601,234),(0.635009,2.43881,234),(0.601848,2.38848,234),(0.603593,2.37074,234),(0.696386,2.44288,234),(0.603011,2.37016,234),(0.628044,2.40851,234),(0.608538,2.34834,234),(0.610574,2.44113,234),(0.632682,2.43532,234),(0.549488,2.28115,234),(0.617265,2.38296,234),(0.582067,2.28085,234),(0.634718,2.43619,234),(0.623523,2.4354,234),(0.6235,2.43512,234),(0.607666,2.36958,234),(0.588758,2.36259,234),(0.601848,2.33787,234),(0.574504,2.27882,234),(0.633555,2.42804,234),(0.608247,2.38965,234),(0.579449,2.26922,234),(0.599317,2.31983,234),(0.626642,2.37656,234),(0.575377,2.29336,234),(0.630646,2.39546,234),(0.608218,2.36696,234),(0.634136,2.4263,234),(0.607363,2.36242,234),(0.641409,2.39139,234),(0.560832,2.29511,234),(0.599351,2.3395,234),(0.60243,2.36376,234),(0.607084,2.33205,234),(0.609411,2.39081,234),(0.585675,2.29415,234),(0.616392,2.39343,234),(0.605048,2.39576,234),(0.587012,2.28289,234),(0.598212,2.33438,234),(0.622957,2.4333,234),(0.608829,2.38383,234),(0.639663,2.41408,234),(0.628982,2.41053,234),(0.582358,2.32623,234),(0.599521,2.35445,234),(0.574795,2.31663,234),(0.606701,2.36519,234),(0.660316,2.43008,234),(0.6289,2.43881,234),(0.552397,2.28667,234),(0.625182,2.44005,234),(0.605048,2.33438,234),(0.615229,2.38616,234),(0.629482,2.43648,234),(0.608247,2.32158,234),(0.610463,2.41524,234),(0.659153,2.4263,234),(0.628609,2.43764,234),(0.607084,2.35125,234),(0.646354,2.42339,234),(0.630064,2.40797,234),(0.60912,2.39983,234),(0.603011,2.32594,234),(0.588467,2.27649,234),(0.621495,2.43875,234),(0.592539,2.28551,234),(0.633555,2.44317,234),(0.605048,2.42513,234),(0.596612,2.35969,234),(0.64199,2.39226,234),(0.607666,2.41175,234),(0.572177,2.27533,234),(0.62541,2.43619,234),(0.599055,2.34177,234),(0.549197,2.28821,234),(0.636754,2.42601,234),(0.662352,2.43183,234),(0.614938,2.39285,234),(0.578577,2.27707,234),(0.555306,2.27416,234),(0.629482,2.43852,234),(0.578737,2.26409,234),(0.612029,2.35998,234),(0.586722,2.27824,234),(0.633845,2.43619,234),(0.656535,2.42513,234),(0.608829,2.36027,234),(0.602139,2.37103,234),(0.6321,2.41699,234),(0.679224,2.44093,234),(0.620465,2.32536,234),(0.598939,2.33612,234),(0.632973,2.43037,234),(0.630064,2.43997,234),(0.603593,2.36434,234),(0.627567,2.4328,234),(0.575086,2.30209,234),(0.605338,2.41205,234),(0.620518,2.43219,234),(0.58031,2.27414,234),(0.627384,2.37688,234),(0.62221,2.41728,234),(0.66468,2.41612,234),(0.573632,2.28405,234),(0.633555,2.43997,234),(0.603884,2.41234,234),(0.594576,2.37714,234),(0.621337,2.42484,234),(0.610943,2.37135,234),(0.596903,2.30762,234),(0.633555,2.43241,234),(0.60552,2.36496,234),(0.600684,2.32478,234),(0.593436,2.28959,234),(0.627988,2.38215,234),(0.608247,2.35503,234),(0.598357,2.30849,234),(0.57654,2.27678,234),(0.574587,2.26812,234),(0.624547,2.43025,234),(0.635882,2.43095,234),(0.637045,2.40623,234),(0.559669,2.27969,234),(0.628319,2.43573,234),(0.609993,2.39401,234),(0.60496,2.33761,234),(0.629306,2.40934,234),(0.579449,2.27504,234),(0.651008,2.42252,234),(0.580114,2.29707,234),(0.616155,2.43129,234),(0.62572,2.43503,234),(0.595157,2.29336,234),(0.629191,2.43066,234),(0.616974,2.38441,234),(0.615326,2.4288,234),(0.614065,2.31256,234),(0.610865,2.39052,234),(0.572759,2.26689,234),(0.619518,2.36922,234),(0.644608,2.39983,234),(0.612611,2.42368,234),(0.639372,2.42688,234),(0.637627,2.38441,234),(0.588758,2.28173,234),(0.627291,2.44098,234),(0.568686,2.29802,234),(0.610574,2.35561,234),(0.608538,2.39197,234),(0.536398,2.28638,234),(0.60592,2.36201,234),(0.623083,2.41641,234),(0.616159,2.43043,234),(0.641409,2.43677,234),(0.659734,2.42804,234),(0.610574,2.32943,234),(0.592702,2.32682,234),(0.661519,2.42642,234),(0.551524,2.29278,234),(0.623664,2.43735,234),(0.495092,2.25991,234),(0.596612,2.3495,234),(0.605368,2.37024,234),(0.646644,2.39052,234),(0.641699,2.39692,234),(0.619301,2.39983,234),(0.586398,2.28967,234),(0.6385,2.42339,234),(0.641409,2.41495,234),(0.575668,2.32012,234),(0.590212,2.28115,234),(0.457494,2.22846,234),(0.614033,2.38947,234),(0.464049,2.2336,234),(0.571503,2.26672,234),(0.625811,2.44176,234),(0.653626,2.42339,234),(0.639687,2.41172,234),(0.617556,2.3783,234),(0.604175,2.3751,234),(0.623189,2.43577,234),(0.580904,2.34136,234),(0.657698,2.42921,234),(0.667297,2.43444,234),(0.610262,2.36848,234),(0.646935,2.42397,234),(0.627194,2.43132,234),(0.612029,2.37336,234),(0.606211,2.36608,234),(0.607956,2.40739,234),(0.617265,2.39546,234),(0.61232,2.39226,234),(0.607375,2.31867,234),(0.620174,2.35939,234),(0.556954,2.29378,234),(0.553851,2.28754,234),(0.588467,2.28056,234),(0.65508,2.42484,234),(0.628609,2.44317,234),(0.618137,2.39343,234),(0.622795,2.43578,234),(0.612902,2.42455,234),(0.607844,2.36441,234),(0.620174,2.38965,234),(0.619301,2.43386,234),(0.562287,2.27591,234),(0.610283,2.37656,234),(0.632107,2.3763,234),(0.607375,2.3559,234),(0.600393,2.32274,234),(0.635591,2.43997,234),(0.6321,2.4327,234),(0.637336,2.38354,234),(0.603302,2.38296,234),(0.632391,2.40797,234),(0.619107,2.32217,234),(0.624537,2.44172,234),(0.56985,2.28056,234),(0.603302,2.36579,234),(0.605048,2.30122,234),(0.630996,2.37837,234),(0.633845,2.41321,234),(0.598357,2.33496,234),(0.545706,2.27446,234),(0.658862,2.42397,234),(0.618719,2.36201,234),(0.635145,2.42707,234),(0.585558,2.27242,234),(0.620295,2.43388,234),(0.611233,2.36935,234),(0.612029,2.38586,234),(0.55356,2.27358,234),(0.611156,2.37307,234),(0.581486,2.27795,234),(0.616974,2.38732,234),(0.630646,2.43823,234),(0.597484,2.31372,234),(0.618428,2.33554,234),(0.603593,2.33467,234),(0.572289,2.28187,234),(0.630646,2.4327,234),(0.629482,2.43764,234),(0.593412,2.30151,234),(0.607375,2.39736,234),(0.640827,2.39285,234),(0.626282,2.43968,234),(0.60595,2.40038,234),(0.629191,2.43503,234),(0.616654,2.38884,234),(0.633845,2.41612,234),(0.610865,2.38267,234),(0.593412,2.34892,234),(0.635346,2.38152,234),(0.61581,2.38965,234),(0.623121,2.43431,234),(0.553851,2.28231,234),(0.622932,2.43475,234),(0.631518,2.43852,234),(0.588758,2.27707,234),(0.622452,2.41847,234),(0.631518,2.42833,234),(0.623543,2.43445,234),(0.585728,2.33056,234),(0.605477,2.35939,234),(0.558214,2.28609,234),(0.583231,2.29714,234),(0.590503,2.28347,234),(0.657116,2.44113,234),(0.613774,2.37219,234),(0.601557,2.36259,234),(0.617405,2.44211,234),(0.630064,2.43619,234),(0.6353,2.43183,234),(0.575668,2.28318,234),(0.630355,2.43648,234),(0.619951,2.43853,234),(0.586429,2.28315,234),(0.607666,2.36347,234),(0.624915,2.43858,234),(0.626723,2.43448,234),(0.629396,2.38239,234),(0.627906,2.43916,234),(0.615187,2.39062,234),(0.652171,2.41815,234),(0.625778,2.44292,234),(0.577811,2.27051,234),(0.602295,2.37003,234),(0.603593,2.36696,234),(0.548324,2.27446,234),(0.602139,2.33001,234),(0.617265,2.38703,234),(0.610574,2.39081,234),(0.583682,2.2684,234),(0.581195,2.27533,234),(0.637918,2.43881,234),(0.547742,2.28376,234),(0.595448,2.33263,234),(0.60272,2.32798,234),(0.613192,2.38761,234),(0.6353,2.42601,234),(0.58963,2.28609,234),(0.638693,2.38457,234),(0.607666,2.41088,234),(0.594576,2.34485,234),(0.60272,2.33147,234),(0.657116,2.42688,234),(0.622792,2.43561,234),(0.635882,2.44201,234),(0.640536,2.3975,234),(0.608247,2.3815,234),(0.610865,2.36638,234),(0.660898,2.42804,234),(0.616256,2.43561,234),(0.606793,2.35358,234),(0.606793,2.40885,234),(0.618137,2.38877,234),(0.627714,2.45471,234),(0.553851,2.28056,234),(0.601266,2.3623,234),(0.59603,2.35969,234),(0.550829,2.27867,234),(0.606211,2.36638,234),(0.617265,2.31722,234),(0.602139,2.36318,234),(0.601848,2.36376,234),(0.55996,2.27533,234),(0.62732,2.43808,234),(0.605629,2.40594,234),(0.61581,2.38877,234),(0.59603,2.30703,234),(0.629191,2.44172,234),(0.597775,2.36172,234),(0.623524,2.42981,234),(0.455962,2.22825,234),(0.646354,2.40594,234),(0.610283,2.42746,234),(0.6071,2.3632,234),(0.607375,2.39139,234),(0.461174,2.2309,234),(0.594576,2.3463,234),(0.630355,2.44288,234),(0.424897,2.16695,234),(0.633845,2.4295,234),(0.617682,2.43138,234),(0.601848,2.38586,234),(0.62221,2.41961,234),(0.573186,2.26968,234),(0.617497,2.39011,234),(0.585558,2.32885,234),(0.598357,2.32449,234),(0.615229,2.38732,234),(0.625309,2.40775,234),(0.580613,2.26689,234),(0.640827,2.43793,234),(0.605338,2.36841,234),(0.60776,2.3637,234),(0.593703,2.33525,234),(0.551815,2.27591,234),(0.587012,2.28085,234),(0.643154,2.41495,234),(0.619935,2.40543,234),(0.606826,2.37592,234),(0.616101,2.38761,234),(0.623427,2.44215,234),(0.545124,2.28027,234),(0.607661,2.36611,234),(0.603884,2.32943,234),(0.634246,2.4065,234),(0.632391,2.42921,234),(0.566359,2.27242,234),(0.594285,2.29627,234),(0.562287,2.28202,234),(0.581566,2.28535,234),(0.605048,2.38179,234),(0.600328,2.31185,234),(0.616504,2.43198,234),(0.618428,2.31809,234),(0.432908,2.18694,234),(0.607611,2.36752,234),(0.582237,2.26113,234),(0.622612,2.43299,234),(0.610865,2.37801,234),(0.643154,2.39081,234),(0.607666,2.35096,234),(0.615229,2.37801,234),(0.582358,2.29569,234),(0.608829,2.39081,234),(0.61552,2.43619,234),(0.599521,2.30965,234),(0.625424,2.43886,234),(0.598939,2.36696,234),(0.631227,2.43532,234),(0.625734,2.43156,234),(0.608829,2.38994,234),(0.55356,2.28173,234),(0.605629,2.4039,234),(0.607375,2.40477,234),(0.608829,2.30529,234),(0.643736,2.38732,234),(0.60272,2.37278,234),(0.600393,2.29365,234),(0.459666,2.23179,234),(0.617342,2.42991,234),(0.622312,2.43166,234),(0.61311,2.37535,234),(0.630646,2.43386,234),(0.459972,2.23173,234),(0.610865,2.30762,234),(0.616101,2.42484,234),(0.658571,2.42892,234),(0.601266,2.36899,234),(0.599521,2.36841,234),(0.618137,2.38412,234),(0.591376,2.35881,234),(0.45837,2.22986,234),(0.618246,2.38692,234),(0.607956,2.39517,234),(0.616193,2.44029,234),(0.622961,2.44317,234),(0.601848,2.32769,234),(0.606502,2.4071,234),(0.597775,2.35125,234),(0.586542,2.27622,234),(0.637918,2.38877,234),(0.58934,2.27707,234),(0.629443,2.37753,234),(0.570514,2.24872,234),(0.616101,2.35823,234),(0.630064,2.43386,234),(0.631809,2.43095,234),(0.616833,2.43421,234),(0.632682,2.43735,234),(0.632682,2.42746,234),(0.614647,2.41932,234),(0.608538,2.41321,234),(0.613774,2.42048,234),(0.622501,2.43444,234),(0.603302,2.32536,234),(0.623083,2.42135,234),(0.605629,2.36696,234),(0.622307,2.43565,234),(0.610865,2.39168,234),(0.628221,2.41125,234),(0.584621,2.27793,234),(0.616557,2.43306,234),(0.628149,2.42734,234),(0.459186,2.23001,234),(0.580734,2.29497,234),(0.616101,2.36056,234),(0.612426,2.42721,234),(0.606119,2.36148,234),(0.634136,2.43386,234),(0.646063,2.41292,234),(0.633845,2.42426,234),(0.610137,2.39251,234),(0.591958,2.35009,234),(0.583231,2.28027,234),(0.60592,2.36347,234),(0.558796,2.27242,234),(0.606502,2.34572,234),(0.584685,2.337,234),(0.607438,2.34691,234),(0.62779,2.43628,234),(0.459647,2.23056,234),(0.549051,2.29045,234),(0.592627,2.30296,234),(0.599812,2.31343,234),(0.600102,2.28987,234),(0.627892,2.43737,234),(0.626093,2.4349,234),(0.625752,2.4332,234),(0.623723,2.43166,234),(0.622636,2.4336,234),(0.62491,2.43651,234),(0.624644,2.43689,234),(0.624993,2.43809,234),(0.621972,2.43603,234),(0.616542,2.44156,234),(0.613309,2.43681,234),(0.597358,2.35912,234),(0.589073,2.31608,234),(0.579864,2.31361,234),(0.591958,2.32449,234),(0.584685,2.31343,234),(0.590605,2.3172,234),(0.589704,2.31625,234),(0.593703,2.33118,234),(0.593004,2.31741,234),(0.683587,2.45219,234),(0.62221,2.44637,234),(0.661771,2.4455,234),(0.685914,2.45335,234),(0.623083,2.45306,234),(0.660607,2.45393,234),(0.670684,2.46466,234),(0.667424,2.4498,234),(0.688823,2.47749,234),(0.62221,2.44899,234),(0.663836,2.45832,234),(0.672533,2.46324,234),(0.627737,2.44579,234),(0.631809,2.44521,234),(0.626573,2.44492,234),(0.686205,2.47022,234),(0.634427,2.4487,234),(0.670085,2.45893,234),(0.620465,2.44986,234),(0.669397,2.44991,234),(0.663269,2.4468,234),(0.640827,2.45597,234),(0.650717,2.45015,234),(0.692605,2.46062,234),(0.623374,2.44812,234),(0.663283,2.45425,234),(0.624828,2.44462,234),(0.668752,2.4615,234),(0.676465,2.44871,234),(0.667918,2.45868,234),(0.626282,2.45219,234),(0.623374,2.44753,234),(0.669726,2.44822,234),(0.626573,2.44666,234),(0.668873,2.46047,234),(0.687078,2.47662,234),(0.643445,2.44404,234),(0.637918,2.45073,234),(0.625701,2.45422,234),(0.688532,2.4519,234),(0.633264,2.45073,234),(0.664098,2.45626,234),(0.615229,2.45015,234),(0.681929,2.47342,234),(0.673755,2.45048,234),(0.633845,2.45393,234),(0.619883,2.44899,234),(0.655953,2.45102,234),(0.621337,2.45073,234),(0.624537,2.44899,234),(0.622792,2.44404,234),(0.654208,2.46091,234),(0.629191,2.44637,234),(0.665033,2.44407,234),(0.654789,2.45044,234),(0.637336,2.44666,234),(0.627155,2.44346,234),(0.692959,2.46358,234),(0.635882,2.44375,234),(0.618137,2.4487,234),(0.683005,2.46324,234),(0.69179,2.47754,234),(0.634277,2.45126,234),(0.653335,2.4519,234),(0.669745,2.46198,234),(0.636463,2.44521,234),(0.661771,2.45684,234),(0.632973,2.44521,234),(0.64519,2.44433,234),(0.652753,2.45015,234),(0.672824,2.46179,234),(0.685623,2.46295,234),(0.64199,2.45655,234),(0.612611,2.44521,234),(0.613192,2.4487,234),(0.635009,2.45277,234),(0.626533,2.45218,234),(0.635009,2.44812,234),(0.639663,2.44608,234),(0.665911,2.44824,234),(0.685333,2.47633,234),(0.662643,2.45713,234),(0.634427,2.44521,234),(0.665053,2.45846,234),(0.646644,2.45888,234),(0.627155,2.45306,234),(0.631518,2.44812,234),(0.670497,2.46615,234),(0.64839,2.45131,234),(0.655662,2.4455,234),(0.679224,2.46324,234),(0.619883,2.44492,234),(0.660025,2.45306,234),(0.63879,2.45481,234),(0.670885,2.45045,234),(0.623664,2.45801,234),(0.687369,2.46295,234),(0.673203,2.46014,234),(0.653335,2.45364,234),(0.636463,2.45335,234),(0.658862,2.45163,234),(0.626864,2.4455,234),(0.627446,2.44899,234),(0.641699,2.44957,234),(0.62142,2.44561,234),(0.623374,2.45481,234),(0.6289,2.44695,234),(0.693187,2.4455,234),(0.625991,2.44375,234),(0.693211,2.44526,234),(0.764852,2.5151,234),(0.792544,2.47268,234),(0.744155,2.47144,234),(0.754278,2.46994,234),(0.720637,2.4647,234),(0.760139,2.47673,234),(0.702005,2.44991,234),(0.758981,2.47672,234),(0.738866,2.48477,234),(0.742638,2.46702,234),(0.7566,2.48506,234),(0.761993,2.53303,234),(0.751612,2.46697,234),(0.766801,2.47213,234),(0.750346,2.49932,234),(0.753798,2.46095,234),(0.70282,2.45338,234),(0.749047,2.49939,234),(0.70169,2.44388,234),(0.75614,2.54076,234),(0.774063,2.48636,234),(0.731002,2.45539,234),(0.710475,2.45375,234),(0.738575,2.46071,234),(0.774097,2.50197,234),(0.710063,2.46719,234),(0.75405,2.4569,234),(0.79188,2.47525,234),(0.750055,2.51981,234),(0.709282,2.4538,234),(0.712201,2.4502,234),(0.764508,2.51137,234),(0.729839,2.45481,234),(0.750045,2.45234,234),(0.753987,2.47417,234),(0.754676,2.46709,234),(0.701743,2.46618,234),(0.75007,2.47081,234),(0.708483,2.45171,234),(0.701336,2.4572,234),(0.729126,2.45632,234),(0.706858,2.46964,234),(0.76285,2.47905,234),(0.752378,2.47052,234),(0.741207,2.45861,234),(0.74734,2.4723,234),(0.756159,2.4759,234),(0.759388,2.48161,234),(0.763892,2.48483,234),(0.712521,2.45638,234),(0.768316,2.51798,234),(0.712172,2.45116,234),(0.638253,2.38956,234),(0.607453,2.38319,234),(0.606784,2.36715,234),(0.63524,2.45279,234),(0.627556,2.44911,234),(0.623585,2.43114,234),(0.585308,2.27728,234),(0.624422,2.44347,234),(0.619278,2.39148,234),(0.623727,2.39038,234),(0.64836,2.41268,234),(0.626714,2.43747,234),(0.624035,2.43418,234),(0.585827,2.29915,234),(0.619406,2.42057,234),(0.611381,2.3694,234),(0.586632,2.28865,234),(0.010603,0.606845,43),(0.0304926,0.699132,43),(-0.0592723,0.672931,43),(-0.0180338,0.646982,43),(-0.00302518,0.625942,43),(-0.00733265,0.644857,43),(0.000734784,0.63473,43),(-0.0188197,0.625877,43),(0.000290946,0.647043,43),(-0.00494504,0.629482,43),(-0.0125083,0.635927,43),(-0.0223983,0.642572,43),(0.00584877,0.601901,43),(-0.00268885,0.614335,43),(0.0614635,0.681633,43),(-0.0707672,0.69226,43),(-0.00432667,0.623736,43),(-0.0185605,0.60167,43),(0.000807389,0.657219,43),(0.0406381,0.663048,43),(0.0191426,0.640501,43),(0.0687072,0.730717,43),(-0.0561645,0.700172,43),(-0.0314873,0.656599,43),(-0.0264709,0.650426,43),(0.00686979,0.59874,43),(0.0544387,0.62129,43),(-0.0396485,0.713875,43),(-0.023858,0.663409,43),(0.0177277,0.610974,43),(-0.0017839,0.606706,43),(-0.0118986,0.606793,43),(-0.0633633,0.695512,43),(-0.0203622,0.642863,43),(-0.00870675,0.650664,43),(-0.00641827,0.615807,43),(-0.0122173,0.648972,43),(0.00496057,0.606542,43),(0.00618929,0.655933,43),(-0.0092033,0.601391,43),(-0.00790198,0.691953,43),(-0.00926979,0.653636,43),(0.009082,0.615576,43),(0.00983493,0.603195,43),(-0.0254172,0.645392,43),(0.00106744,0.598442,43),(0.696975,1.21423,177),(0.695314,1.21354,177),(0.74107,1.32972,177),(0.747733,1.31426,177),(0.721626,1.26043,177),(0.742162,1.26087,177),(0.739009,1.36147,177),(0.71157,1.27934,177),(0.707121,1.27074,177),(0.723067,1.3263,177),(0.702614,1.25887,177),(0.710429,1.27176,177),(0.741602,1.36823,177),(0.747249,1.28889,177),(0.74859,1.30639,177),(0.714421,1.27409,177),(0.744373,1.34534,177),(0.748223,1.30184,177),(0.716241,1.26965,177),(0.718555,1.32314,177),(0.730783,1.27305,177),(0.201803,1.83113,217),(0.200422,1.83172,217),(0.236071,1.8495,217),(0.237118,1.79723,217),(0.233292,1.81252,217),(0.218843,1.81373,217),(0.191651,1.82873,217),(0.241146,1.83201,217),(0.238344,1.79005,217),(0.224256,1.79087,217),(0.235407,1.86718,217),(0.202764,1.79735,217),(0.217959,1.85038,217),(0.185296,1.81834,217),(0.221851,1.83065,217),(0.19984,1.82445,217),(0.185168,1.80693,217),(0.213803,1.82678,217),(0.209324,1.84069,217),(0.228685,1.80115,217),(0.0231745,3.01902,345),(-0.212349,0.774916,318),(-0.204241,0.754943,318),(0.301852,-1.09478,152),(0.661635,2.20193,219),(0.683345,2.22431,219),(0.679874,2.23213,219),(0.680528,2.19873,219),(0.68414,2.1937,219),(0.676388,2.19292,219),(0.689313,2.18993,219),(0.670497,2.20319,219),(0.691117,2.1923,219),(0.672078,2.19485,219),(0.697215,2.23177,219),(0.681269,2.19483,219),(0.662086,2.18798,219),(0.676097,2.18878,219),(0.697802,2.18593,219),(0.695814,2.19964,219),(0.688324,2.22081,219),(0.678162,2.22386,219),(0.683165,2.20079,219),(0.662716,2.20879,219),(0.674924,2.19521,219),(0.695194,2.22737,219),(0.677163,2.19548,219),(0.675622,2.22701,219),(0.696706,2.22593,219),(0.663933,2.19414,219),(0.678303,2.19562,219),(0.692779,2.18533,219),(0.667603,2.18334,219),(0.670192,2.19241,219),(0.667467,2.19528,219),(0.691461,2.19326,219),(0.68142,2.22571,219),(0.672141,2.19029,219),(0.698563,2.23681,219),(0.701613,2.17349,219),(0.739011,2.27585,219),(0.699887,2.17116,219),(0.704929,2.18248,219),(0.698452,2.2245,219),(0.749745,2.26881,219),(0.72804,2.26342,219),(0.749619,2.2666,219),(0.737382,2.27417,219),(0.736984,2.2551,219),(0.725844,2.26205,219),(0.71496,2.2572,219),(0.717161,2.23914,219),(0.715052,2.20933,219),(0.70377,2.24546,219),(0.722524,2.23714,219),(0.698573,2.23325,219),(0.740766,2.26458,219),(0.72947,2.26502,219),(0.742124,2.27583,219),(0.630282,2.25762,226),(0.6064,2.22944,226),(0.628217,2.2575,226),(0.648991,2.24219,226),(0.642659,2.24503,226),(0.615665,2.20801,226),(0.631373,2.23012,226),(0.627751,2.25027,226),(0.664866,2.21789,226),(0.650935,2.22763,226),(0.640144,2.21382,226),(0.616775,2.25215,226),(0.654319,2.22513,226),(0.660312,2.21764,226),(0.665072,2.23384,226),(0.651905,2.23307,226),(0.625615,2.21914,226),(0.628175,2.24096,226),(0.620242,2.257,226),(0.658713,2.2174,226),(0.643929,2.21011,226),(0.645273,2.20704,226),(0.633928,2.22389,226),(0.626054,2.24434,226),(0.634415,2.20955,226),(0.648842,2.25128,226),(0.650853,2.21672,226),(0.609959,2.22511,226),(0.65569,2.21618,226),(0.641961,2.20701,226),(0.632522,2.23921,226),(0.644298,2.21886,226),(0.666861,2.24434,226),(0.635567,2.23682,226),(0.653461,2.25446,226),(0.633239,2.21504,226),(0.612659,2.25218,226),(0.654479,2.21278,226),(0.623572,2.21189,226),(0.608159,2.22255,226),(0.628881,2.25785,226),(0.648429,2.2178,226),(0.641995,2.21664,226),(0.633575,2.22648,226),(0.669837,2.24218,226),(0.631877,2.21805,226),(0.618021,2.2233,226),(0.61136,2.21164,226),(0.660772,2.21282,226),(0.638696,2.2375,226),(0.607263,2.2059,226),(0.619475,2.24709,226),(0.614497,2.24401,226),(0.625235,2.2469,226),(0.625575,2.25517,226),(0.610434,2.22685,226),(0.652928,2.22106,226),(0.613566,2.21509,226),(0.614521,2.22467,226),(0.656219,2.219,226),(0.632415,2.24402,226),(0.627945,2.21153,226),(0.630117,2.2251,226),(0.630301,2.23989,226),(0.657228,2.21369,226),(0.610452,2.23967,226),(0.63627,2.21874,226),(0.608252,2.24429,226),(0.64247,2.23044,226),(0.618428,2.21133,226),(0.624857,2.21463,226),(0.614952,2.2494,226),(0.630444,2.23611,226),(0.615127,2.25521,226),(0.660276,2.22548,226),(0.658959,2.24966,226),(0.658813,2.20759,226),(0.627339,2.21577,226),(0.653689,2.21188,226),(0.621565,2.22145,226),(0.650644,2.22429,226),(0.611903,2.21631,226),(0.649382,2.21337,226),(0.665077,2.2289,226),(0.638806,2.21072,226),(0.657846,2.23203,226),(0.626806,2.24833,226),(0.60338,2.20957,226),(0.661039,2.22938,226),(0.625211,2.21917,226),(0.635885,2.25247,226),(0.63944,2.22512,226),(0.642395,2.21922,226),(0.61423,2.2355,226),(0.613473,2.24554,226),(0.64327,2.22431,226),(0.624682,2.22399,226),(0.584855,2.20822,226),(0.614846,2.24591,226),(0.622182,2.22556,226),(0.652622,2.21529,226),(0.645961,2.22129,226),(0.65142,2.21346,226),(0.638189,2.24668,226),(0.584065,2.20467,226),(0.608814,2.24496,226),(0.630578,2.21831,226),(0.655264,2.25334,226),(0.650862,2.22543,226),(0.653427,2.21897,226),(0.655197,2.22016,226),(0.65716,2.22194,226),(0.656884,2.22031,226),(0.617953,2.25442,226),(0.656064,2.22041,226),(0.615224,2.2431,226),(0.624857,2.24276,226),(0.654101,2.21424,226),(0.607832,2.20101,226),(0.620315,2.24266,226),(0.510843,0.837375,206),(0.511437,0.83861,206),(0.511973,0.839086,206),(0.508691,0.839411,206),(0.507823,0.840075,206),(0.508676,0.840032,206),(0.512598,0.83738,206),(0.512036,0.83179,206),(0.507585,0.840032,206),(0.50918,0.839872,206),(0.510989,0.837036,206),(0.512516,0.837782,206),(0.511309,0.83913,206),(0.511294,0.83659,206),(0.510635,0.838757,206),(0.33662,-1.42012,82),(0.83834,0.853466,216),(0.89419,0.896518,216),(0.863399,1.00215,170),(0.819486,0.942823,216),(0.877048,1.01997,170),(0.869756,1.27698,167),(0.852241,1.01492,170),(0.821468,0.905244,216),(0.822341,0.905535,216),(0.877546,0.998454,170),(0.761802,0.893124,169),(0.893052,0.924986,216),(0.867892,1.47084,167),(0.793912,1.11837,221),(0.833976,1.18275,167),(0.910891,1.06812,221),(0.760382,1.21737,167),(0.800165,1.08477,221),(0.748746,1.24558,167),(0.82847,1.48145,167),(0.766461,1.1737,221),(0.742347,1.22755,167),(0.789797,1.36101,167),(0.756309,1.19119,167),(0.873623,1.27347,167),(0.782063,1.37649,167),(0.781451,1.1441,221),(0.755788,1.34811,167),(0.78567,1.36788,167),(0.785398,1.3599,167),(0.738274,1.21475,167),(0.760934,1.28738,167),(0.883627,1.42964,167),(0.923946,1.22504,167),(0.880113,1.40092,167),(0.723439,1.20719,167),(0.792576,1.39479,167),(0.869013,1.27125,167),(0.924552,1.1016,221),(0.782829,1.14335,221),(0.928766,1.11046,221),(0.753401,1.22988,167),(0.76562,1.345,167),(0.957711,1.20677,167),(0.912354,1.34398,167),(0.770853,1.39638,167),(0.872048,1.4418,167),(0.750492,1.24791,167),(0.748183,1.27717,167),(0.918632,1.22902,167),(0.917119,1.09083,221),(0.796161,1.10508,167),(0.878671,1.45757,167),(0.736232,1.2197,167),(0.929954,1.2112,167),(0.759578,1.19571,167),(0.756691,1.3518,167),(0.860914,1.42373,167),(0.908263,1.3427,167),(0.757941,1.34424,167),(0.902749,1.31463,167),(0.770891,1.16481,221),(0.720155,1.18655,167),(0.75678,1.34142,167),(0.740402,1.21873,167),(0.817653,1.30891,167),(0.837138,1.40384,167),(0.904194,1.19311,167),(0.740537,1.20087,167),(0.877013,1.16798,167),(0.816814,1.07629,221),(0.893261,1.24697,167),(0.754969,1.34266,167),(0.930194,1.21475,167),(0.866307,1.27168,167),(0.913773,1.25465,167),(0.313578,1.79071,237),(0.356391,1.81591,237),(0.289131,1.82825,237),(0.263836,1.84627,237),(0.361283,1.77994,237),(0.330449,1.78809,237),(0.320753,1.80921,237),(0.303867,1.82964,237),(0.347068,1.78259,237),(0.353347,1.75327,237),(0.339625,1.80083,237),(0.590789,0.626646,176),(0.601033,0.625696,176),(0.580729,0.614249,176),(0.585786,0.617304,176),(0.591667,0.619301,176),(0.593077,0.621648,176),(0.595526,0.622176,176),(0.583071,0.619291,176),(0.59779,0.628503,176),(0.591474,0.619494,176),(0.593514,0.632124,176),(0.582572,0.619311,176),(0.244271,-1.06476,153),(0.822775,0.166182,306),(0.122663,1.39454,181),(0.104138,1.40354,181),(0.121787,1.39434,181),(0.152741,1.40494,181),(0.171333,1.39917,181),(0.149594,1.41779,181),(0.116637,1.40323,181),(0.140258,1.39327,181),(0.171333,1.40034,181),(0.120262,1.39454,181),(0.121623,1.39423,181),(0.117167,1.39456,181),(0.121663,1.40993,181),(0.125809,1.3934,181),(0.121004,1.39504,181),(0.118211,1.3942,181),(0.103821,1.40561,181),(0.11952,1.39498,181),(0.130661,1.40259,181),(0.120476,1.39466,181),(0.120897,1.39468,181),(0.121002,1.39425,181),(0.121393,1.3949,181),(0.125041,1.39409,181),(0.12733,1.40736,181),(0.123011,1.39441,181),(0.114897,1.39555,181),(0.129445,1.42797,181),(0.168746,1.39639,181),(0.123472,1.39438,181),(0.11945,1.39631,181),(0.122014,1.39422,181),(0.120281,1.40666,181),(0.120449,1.39775,181),(0.125041,1.4062,181),(0.10536,1.40005,181),(0.119194,1.39387,181),(0.135755,1.42426,181),(0.137183,1.40764,181),(0.120985,1.39361,181),(0.132223,1.39269,181),(0.113076,1.39596,181),(0.112144,1.39617,181),(0.134568,1.4258,181),(0.120365,1.39483,181),(0.12199,1.41469,181),(0.145848,1.40355,181),(0.127118,1.42535,181),(0.10883,1.3972,181),(0.128843,1.42841,181),(0.105883,-0.141861,42),(0.132286,-0.149012,42),(0.146991,-0.170131,42),(0.109965,-0.188441,42),(0.11397,-0.180671,42),(0.0763582,-0.134686,42),(0.0874604,-0.157758,42),(0.122096,-0.165321,42),(0.10264,-0.175347,42),(0.112506,-0.185223,42),(-0.53058,0.483461,39),(-0.525612,0.500724,39),(-0.526241,0.479563,39),(-0.511672,0.479675,39),(-0.504166,0.486932,39),(-0.52051,0.475383,39),(-0.503909,0.489478,39),(-0.502072,0.493044,39),(0.970403,0.461058,309),(0.954506,0.441216,309),(0.968658,0.446804,309),(0.964294,0.431969,309),(0.97706,0.388287,309),(0.964333,0.389029,309),(0.96602,0.37495,309),(0.976221,0.406953,309),(0.976803,0.446513,309),(0.974185,0.410734,309),(0.975838,0.381253,309),(0.97273,0.424988,309),(0.975944,0.367717,309),(0.982911,0.38979,309),(0.952368,0.407534,309),(0.975217,0.370897,309),(0.972449,0.36857,309),(0.964963,0.418438,309),(0.958186,0.417134,309),(0.961385,0.423824,309),(0.972371,0.373559,309),(0.942769,0.418297,309),(0.949459,0.419752,309),(0.958452,0.418326,309),(0.865887,0.106989,283),(0.863865,0.10438,283),(0.863599,0.106247,283),(1.00428,0.443794,294),(1.00163,0.376303,294),(0.986693,0.36681,294),(0.994261,0.404136,294),(0.992397,0.425257,294),(0.993895,0.420727,294),(0.986111,0.476766,294),(0.99163,0.429596,294),(0.986402,0.36681,294),(0.994279,0.414871,294),(0.988729,0.413866,294),(0.986094,0.451296,294),(0.975348,0.463094,294),(1.00028,0.441124,294),(0.559965,0.418467,50),(0.552714,0.353465,50),(0.571893,0.395085,50),(0.560542,0.350229,50),(0.540218,0.351164,50),(0.422455,0.406412,50),(0.567828,0.359173,50),(0.571798,0.388203,50),(0.567022,0.363582,50),(0.42235,0.406503,50),(0.571817,0.379697,50),(0.561821,0.359477,50),(0.536784,0.353015,50),(0.574758,0.210871,50),(0.566663,0.254272,50),(0.575034,0.207109,50),(0.55961,0.218665,50),(0.508962,0.281679,50),(0.566098,0.237944,50),(0.57378,0.230165,50),(0.573893,0.233011,50),(0.544698,0.289527,50),(0.571712,0.219416,50),(0.572352,0.217965,50),(0.471896,0.251822,50),(0.55621,0.191658,50),(0.452311,0.242922,50),(0.548821,0.226546,50),(0.565056,0.263415,50),(0.569268,0.244346,50),(0.508359,0.27834,50),(0.571634,0.222142,50),(0.435717,0.177548,50),(0.561511,0.227247,50),(0.480831,0.249083,50),(0.554258,0.244245,50),(0.557149,0.213837,50),(0.464119,0.223062,50),(0.569826,0.248917,50),(0.472112,0.251327,50),(0.609867,-0.0476981,14),(0.5294,-0.101899,14),(0.562805,-0.148866,14),(0.518318,-0.169849,14),(0.614988,-0.0690196,14),(0.550053,-0.0965914,14),(0.591574,-0.110069,14),(0.620961,-0.0936957,14),(0.597077,-0.0699877,14),(0.531807,-0.154932,14),(0.600521,-0.0505678,14),(0.602778,-0.0809848,14),(0.496337,-0.193788,14),(0.624257,-0.101225,14),(0.594258,-0.0772823,14),(0.605396,-0.104767,14),(0.598762,-0.110064,14),(0.598033,-0.103428,14),(0.597278,-0.099619,14),(0.512773,-0.177552,14),(0.569891,-0.147091,14),(0.575977,-0.132935,14),(0.590477,-0.0842645,14),(0.594091,-0.118972,14),(0.563731,-0.161219,14),(0.593643,-0.11925,14),(0.530487,-0.160727,14),(0.605289,-0.0332946,14),(0.573562,-0.114731,14),(0.607324,-0.0974285,14),(0.539637,-0.120313,14),(0.6138,-0.0511996,14),(0.587933,-0.128857,14),(0.570464,-0.082818,14),(0.591554,-0.0968181,14),(0.603429,-0.103912,14),(0.621627,-0.09207,14),(0.55212,-0.139625,14),(0.614237,-0.107438,14),(0.610896,-0.103068,14),(0.573883,-0.120538,14),(0.574896,-0.0989357,14),(0.597967,-0.114846,14),(0.568937,-0.109405,14),(0.598822,-0.0376991,14),(0.613483,-0.0673697,14),(0.597351,-0.0585315,14),(0.505918,-0.175534,14),(0.567248,-0.116773,14),(0.59406,-0.087263,14),(0.549997,-0.170519,14),(0.580408,-0.148458,14),(0.587964,-0.0937416,14),(0.603591,-0.04374,14),(0.613811,-0.0918671,14),(0.586227,-0.132844,14),(0.589737,-0.12496,14),(0.609469,-0.0404916,14),(0.564391,-0.110826,14),(0.580593,-0.132428,14),(0.583541,-0.0911282,14),(0.581012,-0.145604,14),(0.618981,-0.105327,14),(0.590341,-0.105876,14),(0.610057,-0.0366566,14),(0.530932,-0.167519,14),(0.590791,-0.122878,14),(0.574221,-0.11824,14),(0.763575,0.1298,288),(0.763291,0.129445,288),(0.840691,0.476562,269),(0.823868,0.485129,269),(0.817517,0.517374,269),(0.822772,0.499344,269),(0.831761,0.489516,269),(0.840478,0.493885,269),(0.815558,0.518499,269),(0.833681,0.506165,269),(0.82699,0.503057,269),(0.814094,0.513369,269),(0.835896,0.493952,269),(0.824896,0.508952,269),(0.838369,0.485483,269),(0.808092,0.500163,269),(0.820402,0.503658,269),(0.803811,0.503183,269),(0.801237,0.492086,269),(0.817347,0.514368,269),(0.833598,0.487451,269),(0.740737,0.336213,292),(0.746531,0.330643,292),(0.739856,0.330115,292),(0.315323,-1.10101,119),(-0.316763,0.862234,315),(-0.398226,0.82525,315),(-0.302815,0.855793,315),(-0.304851,0.858702,315),(-0.407534,0.830777,315),(-0.327582,0.803725,315),(-0.441568,0.793834,315),(-0.293164,0.831678,315),(-0.407534,0.762127,315),(-0.436899,0.820013,315),(-0.334522,0.81565,315),(-0.295252,0.865392,315),(-0.249,0.875574,315),(-0.39968,0.777253,315),(-0.359247,0.847066,315),(-0.354022,0.773489,315),(-0.330731,0.841774,315),(-0.340846,0.79335,315),(-0.281184,0.814088,315),(-0.349939,0.839794,315),(-0.269425,0.868104,315),(-0.330158,0.834267,315),(-0.370539,0.843722,315),(-0.282162,0.868592,315),(-0.386511,0.838031,315),(-0.347321,0.851721,315),(-0.274308,0.808378,315),(-0.381936,0.827868,315),(-0.369137,0.813033,315),(-0.391005,0.805046,315),(-0.371755,0.831358,315),(-0.37442,0.8218,315),(-0.321722,0.812742,315),(-0.303355,0.862337,315),(-0.338594,0.819432,315),(-0.398323,0.834724,315),(-0.353138,0.826995,315),(-0.413934,0.774635,315),(-0.346157,0.817687,315),(-0.378155,0.788307,315),(-0.34383,0.777544,315),(-0.439241,0.786271,315),(-0.253945,0.850557,315),(-0.331904,0.823504,315),(-0.259698,0.83754,315),(-0.214304,0.860303,315),(-0.342957,0.825832,315),(-0.330106,0.829662,315),(-0.26006,0.87753,315),(-0.319686,0.822341,315),(-0.388917,0.776962,315),(-0.321141,0.835431,315),(-0.233874,0.842412,315),(-0.296882,0.847761,315),(-0.255691,0.866556,315),(-0.306887,0.84154,315),(-0.431096,0.781035,315),(-0.439446,0.804374,315),(-0.358322,0.824554,315),(-0.436914,0.809542,315),(-0.31125,0.84503,315),(-0.338303,0.827577,315),(-0.358715,0.816878,315),(-0.287398,0.81536,315),(-0.238819,0.845612,315),(-0.381063,0.819141,315),(0.123739,2.99115,333),(0.123732,2.99115,333),(0.732694,0.367639,300),(0.730992,0.392859,300),(0.728074,0.380055,300),(0.733223,0.36602,300),(0.734338,0.367435,300),(0.731569,0.375779,300),(0.723221,0.395201,300),(0.718693,0.360866,300),(0.728602,0.38739,300),(0.733038,0.374082,300),(0.733038,0.37224,300),(0.717136,0.366732,300),(0.726726,0.392083,300),(0.721631,0.376196,300),(0.717631,0.363062,300),(0.73092,0.364493,300),(0.72403,0.385529,300),(0.735768,0.376734,300),(0.735346,0.378988,300),(0.736563,0.389766,300),(0.731579,0.391177,300),(0.724564,0.365879,300),(0.723143,0.384181,300),(0.732069,0.365239,300),(0.729499,0.364919,300),(0.718014,0.392743,300),(0.732466,0.397402,300),(0.724748,0.358272,300),(0.732466,0.366185,300),(0.731705,0.365011,300),(0.716128,0.372458,300),(0.73297,0.376681,300),(0.215611,-0.0833587,6),(0.292752,-0.0524894,6),(0.197529,-0.0988998,6),(0.234427,-0.108484,6),(0.232187,-0.0854447,6),(0.252799,-0.0730064,6),(0.239147,-0.10587,6),(0.216276,-0.0953685,6),(0.224497,-0.131944,6),(0.23689,-0.140218,6),(0.25235,-0.199582,6),(0.252055,-0.199563,6),(0.222426,-0.140893,6),(0.208276,-0.146899,6),(0.283994,-0.000780511,6),(0.242707,-0.0794704,6),(0.199276,-0.130607,6),(0.236492,-0.130027,6),(0.220784,-0.139626,6),(0.240969,-0.189056,6),(0.357211,1.65603,222),(0.297288,1.66941,222),(0.356629,1.67813,222),(0.289725,1.66126,222),(0.291761,1.67435,222),(0.330449,1.68308,222),(0.292551,1.68473,222),(0.337139,1.66126,222),(0.295319,1.69945,222),(0.308051,1.67203,222),(0.301942,1.6857,222),(0.300405,1.68081,222),(0.2458,1.71391,222),(0.362738,1.69355,222),(0.349357,1.66766,222),(0.29273,1.67967,222),(0.351684,1.62141,222),(0.393863,1.67028,222),(0.381855,1.67516,222),(0.293307,1.67824,222),(0.322595,1.68308,222),(0.344412,1.6793,222),(0.328413,1.66184,222),(0.284198,1.66999,222),(0.302582,1.68389,222),(0.322595,1.66679,222),(0.372337,1.65981,222),(0.313287,1.68832,222),(0.443023,1.69995,222),(0.374664,1.66475,222),(0.319104,1.66359,222),(0.283752,1.70547,222),(0.285943,1.66272,222),(0.287829,1.70389,222),(0.386009,1.66039,222),(0.399971,1.68424,222),(0.352266,1.65603,222),(0.217003,1.72089,222),(0.364192,1.67319,222),(0.384554,1.68366,222),(0.412479,1.64788,222),(0.292052,1.66941,222),(0.288527,1.70364,222),(0.383531,1.67698,222),(0.351684,1.65661,222),(0.343379,1.69662,222),(0.310378,1.67115,222),(0.400262,1.70606,222),(0.376991,1.67784,222),(0.301942,1.69326,222),(0.286816,1.67086,222),(0.280649,1.70287,222),(0.295058,1.68534,222),(0.291562,1.67555,222),(0.30776,1.66621,222),(0.364483,1.65486,222),(0.284198,1.66504,222),(0.423533,1.69704,222),(0.292924,1.65341,222),(0.338012,1.66184,222),(0.344615,1.67778,222),(0.872335,1.60687,191),(0.854659,1.57014,191),(0.837855,1.59945,191),(0.836147,1.86546,235),(0.876703,1.85368,235),(0.86628,1.74817,235),(0.798706,1.85478,235),(0.779643,1.78329,235),(0.855793,1.8166,235),(0.852633,1.85804,235),(0.863705,1.8487,235),(0.760454,1.82256,235),(0.783345,1.92189,235),(0.851939,1.80702,235),(0.81536,1.74737,235),(0.814729,1.97709,179),(0.832643,1.86668,235),(0.387473,1.98175,207),(0.265505,2.5439,343),(0.256003,-1.06545,120),(0.258028,-1.06452,120),(0.257436,-1.06407,120),(0.256171,-1.06364,120),(0.254958,-1.06481,120),(0.25509,-1.06296,120),(0.257219,-1.064,120),(0.254974,-1.06593,120),(0.254387,-1.06421,120),(0.315657,-0.278877,46),(0.365315,-0.297311,46),(0.291567,-1.08582,130),(0.293073,-1.08578,130),(0.626156,0.253684,285),(0.626568,0.25333,285),(0.626154,0.252584,285),(0.626733,0.251774,285),(0.626525,0.252394,285),(-0.354268,1.00319,322),(-0.350021,1.00435,322),(-0.352862,1.00393,322),(-0.35367,1.0032,322),(-0.351892,1.00354,322),(-0.356188,1.00705,322),(-0.349677,1.00606,322),(-0.354559,1.00392,322),(-0.352377,1.00731,322),(-0.353502,1.00785,322),(-0.351422,1.00393,322),(0.072864,1.28297,321),(-0.173369,0.592248,10),(-0.268536,0.616429,10),(-0.240513,0.601418,10),(-0.192311,0.590924,10),(-0.295309,0.615438,10),(-0.225626,0.598581,10),(-0.207694,0.586431,10),(-0.279805,0.619592,10),(-0.240828,0.573868,10),(-0.252691,0.615481,10),(-0.262941,0.614939,10),(-0.243769,0.589699,10),(-0.227475,0.584394,10),(-0.250942,0.599228,10),(-0.2755,0.611014,10),(-0.261438,0.610093,10),(0.398517,-1.7238,127),(0.433714,-1.71304,127),(0.345536,-1.72965,124),(0.308051,-1.7366,124),(0.36041,-1.72089,124),(0.347902,-1.70984,124),(0.325504,-1.73137,124),(0.329551,-1.72905,124),(0.326086,-1.73224,124),(0.338633,-1.73717,124),(0.327831,-1.73195,124),(0.336189,-1.72975,124),(0.354302,-1.70984,124),(0.338885,-1.69297,124),(0.336267,-1.72671,124),(0.338128,-1.7318,124),(0.313868,-1.6217,124),(0.339966,-1.72955,124),(0.338861,-1.73768,124),(0.335103,-1.67784,124),(0.285361,-1.6153,124),(0.447968,-1.70751,127),(0.361076,-1.53937,123),(0.364483,-1.56643,123),(0.292343,-1.62519,124),(0.365646,-1.69995,124),(0.342909,-1.73086,124),(0.343563,-1.73013,124),(0.35052,-1.71682,124),(0.349939,-1.73398,124),(0.336645,-1.73952,124),(0.332194,-1.71508,124),(0.325213,-1.73078,124),(0.306305,-1.72002,124),(0.348484,-1.69675,124),(0.336558,-1.73078,124),(0.340809,-1.73174,124),(0.336529,-1.72793,124),(0.369012,-1.53853,123),(0.346157,-1.72758,124),(0.306608,-1.73482,124),(0.356047,-1.56265,123),(0.334749,-1.73609,124),(0.352556,-1.73253,124),(0.345866,-1.69908,124),(0.34063,-1.72584,124),(0.347461,-1.73045,124),(0.358083,-1.743,124),(0.342904,-1.73218,124),(0.331322,-1.72962,124),(0.344072,-1.73179,124),(0.347413,-1.73388,124),(0.331031,-1.70868,124),(0.33279,-1.70983,124),(0.344625,-1.73108,124),(0.305142,-1.59581,124),(0.333387,-1.73823,124),(0.331031,-1.73835,124),(0.328995,-1.73195,124),(0.367683,-1.70402,124),(0.320268,-1.74271,124),(0.352556,-1.55829,123),(0.322013,-1.69966,124),(0.329576,-1.70577,124),(0.306305,-1.62228,124),(0.323759,-1.73835,124),(0.260054,-1.61065,124),(0.372628,-1.7145,124),(0.387754,-1.7078,127),(0.371173,-1.72409,124),(0.28507,-1.66214,124),(0.322304,-1.6633,124),(0.28478,-1.71071,124),(0.349648,-1.71653,124),(0.335976,-1.7174,124),(0.338885,-1.72613,124),(0.348693,-1.7287,124),(0.296997,-1.68832,124),(0.344412,-1.72729,124),(0.337139,-1.71362,124),(0.33394,-1.70431,124),(0.34063,-1.72642,124),(0.343233,-1.72956,124),(0.337828,-1.73944,124),(0.336533,-1.74077,124),(0.339467,-1.72555,124),(0.33618,-1.73722,124),(0.336558,-1.71799,124),(0.335976,-1.71362,124),(0.343539,-1.72555,124),(0.355756,-1.74533,124),(0.315905,-1.67755,124),(0.33743,-1.72526,124),(0.333358,-1.71479,124),(0.292343,-1.61676,124),(0.322013,-1.66184,124),(0.282162,-1.66155,124),(0.382809,-1.74504,124),(0.453495,-1.71217,127),(0.328704,-1.69559,124),(0.45524,-1.71537,121),(0.276635,-1.69413,124),(0.324888,-1.73343,124),(0.332485,-1.71391,124),(0.353429,-1.73137,124),(0.371464,-1.56498,123),(0.358371,-1.70099,124),(0.338885,-1.73137,124),(0.360016,-1.51983,79),(0.273775,-1.62681,124),(0.351271,-1.55201,123),(0.341503,-1.69704,124),(0.321141,-1.62723,124),(0.35692,-1.6985,124),(0.384845,-1.71333,124),(0.329867,-1.70373,124),(0.305724,-1.60512,124),(0.351107,-1.72322,124),(0.332485,-1.72439,124),(0.354302,-1.56062,123),(0.328995,-1.69471,124),(0.291179,-1.71769,124),(0.292634,-1.62956,124),(0.336359,-1.73589,124),(0.29787,-1.61007,124),(0.297579,-1.68802,124),(0.479552,-1.73689,121),(0.328413,-1.69588,124),(0.342467,-1.73334,124),(0.339964,-1.73206,124),(0.372628,-1.7049,124),(0.315323,-1.64759,124),(0.368264,-1.55829,123),(0.268199,-1.60978,124),(0.439823,-1.74213,127),(0.332776,-1.7145,124),(0.353138,-1.73166,124),(0.347902,-1.69006,124),(0.38979,-1.7081,127),(0.313868,-1.64963,124),(0.334963,-1.72829,124),(0.28507,-1.68599,124),(0.336039,-1.73848,124),(0.365937,-1.56411,123),(0.29467,-1.65864,124),(0.451749,-1.7017,121),(0.350229,-1.69384,124),(0.269362,-1.62141,124),(0.336558,-1.73195,124),(0.310087,-1.61617,124),(0.344993,-1.72758,124),(0.337721,-1.72729,124),(0.43385,-1.73779,127),(0.336587,-1.73687,124),(0.324922,-1.66708,124),(0.28478,-1.60541,124),(0.312996,-1.64206,124),(0.351102,-1.69239,124),(0.324631,-1.67813,124),(0.365356,-1.56323,123),(0.286816,-1.65835,124),(0.324922,-1.73108,124),(0.329286,-1.73108,124),(0.316486,-1.62461,124),(0.340921,-1.69151,124),(0.324631,-1.71857,124),(0.28935,-1.65985,124),(0.328704,-1.7398,124),(0.337139,-1.72584,124),(0.337741,-1.72878,124),(0.328995,-1.69413,124),(0.338536,-1.72935,124),(0.357502,-1.73195,124),(0.320268,-1.73718,124),(0.36681,-1.56847,123),(0.264417,-1.61385,124),(0.319395,-1.73398,124),(0.311541,-1.62985,124),(0.368846,-1.71769,124),(0.334231,-1.7174,124),(0.352266,-1.7113,124),(0.334231,-1.6921,124),(0.310669,-1.70635,124),(0.323641,-1.61697,124),(0.329867,-1.69297,124),(0.341794,-1.53676,79),(0.324787,-1.58381,123),(0.328704,-1.73108,124),(0.309796,-1.60163,124),(0.396771,-1.72729,127),(0.342104,-1.72879,124),(0.315323,-1.62607,124),(0.3306,-1.73183,124),(0.333067,-1.71508,124),(0.328122,-1.727,124),(0.343326,-1.73107,124),(0.349648,-1.71566,124),(0.337823,-1.73313,124),(0.35781,-1.51749,79),(0.345139,-1.73149,124),(0.337353,-1.73067,124),(0.314159,-1.65137,124),(0.320559,-1.67203,124),(0.329576,-1.69181,124),(0.33743,-1.71333,124),(0.283616,-1.60803,124),(0.318814,-1.62694,124),(0.357502,-1.70082,124),(0.316777,-1.64788,124),(0.339467,-1.69239,124),(0.342637,-1.7298,124),(0.414225,-1.7302,127),(0.383681,-1.72817,124),(0.331322,-1.70082,124),(0.344993,-1.7206,124),(0.338831,-1.72845,124),(0.459894,-1.72962,127),(0.328122,-1.69617,124),(0.388627,-1.70751,127),(0.3831,-1.74533,124),(0.339091,-1.7301,124),(0.325213,-1.60279,123),(0.292052,-1.63566,124),(0.332731,-1.71572,124),(0.306305,-1.7366,124),(0.307178,-1.73078,124),(0.346157,-1.711,124),(0.341212,-1.72613,124),(0.338885,-1.72613,124),(0.360701,-1.54578,123),(0.341194,-1.72582,124),(0.29147,-1.62316,124),(0.322886,-1.54113,79),(0.337721,-1.5833,123),(0.336267,-1.72613,124),(0.37001,-1.70577,124),(0.321432,-1.6601,124),(0.320559,-1.67115,124),(0.383972,-1.73951,124),(0.313868,-1.62956,124),(0.334953,-1.73603,124),(0.369561,-1.51576,79),(0.346448,-1.5801,123),(0.341794,-1.7206,124),(0.446513,-1.74504,127),(0.293215,-1.62781,124),(0.341794,-1.69181,124),(0.340145,-1.73108,124),(0.322886,-1.7238,124),(0.330009,-1.71803,124),(0.345556,-1.74314,124),(0.341357,-1.73244,124),(0.338885,-1.71304,124),(0.344121,-1.71769,124),(0.332194,-1.7113,124),(0.333649,-1.7238,124),(0.32754,-1.67144,124),(0.344993,-1.69704,124),(0.320268,-1.6985,124),(0.390954,-1.70897,127),(0.316777,-1.64759,124),(0.365065,-1.7049,124),(0.320559,-1.69733,124),(0.316486,-1.64294,124),(0.35372,-1.72671,124),(0.313287,-1.65661,124),(0.331322,-1.70664,124),(0.31765,-1.7113,124),(0.294321,-1.74341,124),(0.333358,-1.70955,124),(0.297244,-1.68769,124),(0.451037,-1.73863,127),(0.31045,-1.62134,124),(0.337115,-1.70911,124),(0.33537,-1.71459,124),(0.337091,-1.71464,124),(0.334449,-1.71399,124),(0.333697,-1.7134,124),(0.280707,-1.63625,124),(0.283325,-1.63886,124),(0.337324,-1.73846,124),(0.336936,-1.73822,124),(0.338332,-1.73076,124),(0.339117,-1.72961,124),(0.338987,-1.73142,124),(0.338894,-1.73062,124),(0.337901,-1.73401,124),(0.343825,-1.73045,124),(0.343602,-1.73224,124),(0.343112,-1.73009,124),(0.447923,-1.89603,122),(0.335742,-1.82501,124),(0.563554,-2.00897,158),(0.30776,-1.77238,124),(0.36012,-1.79885,124),(0.342375,-1.80525,124),(0.361574,-1.80467,124),(0.348775,-1.78489,124),(0.353138,-1.80787,124),(0.397384,-1.79038,124),(0.346157,-1.77529,124),(0.352556,-1.7654,124),(0.354884,-1.78547,124),(0.358083,-1.76249,124),(0.470075,-1.77064,127),(0.450586,-1.75551,127),(0.335976,-1.81049,124),(0.355756,-1.76627,124),(0.334812,-1.74766,124),(0.338885,-1.7814,124),(0.351684,-1.76598,124),(0.341212,-1.80467,124),(0.445932,-1.80525,127),(0.359829,-1.80176,124),(0.36041,-1.80322,124);
/*&*/
INSERT INTO `x2_timezone_points` VALUES (0.357211,-1.80554,124),(0.567279,-2.0421,158),(0.362738,-1.80612,124),(0.364483,-1.81223,124),(0.375246,-1.83085,122),(0.363319,-1.79303,124),(0.334812,-1.79507,124),(0.374082,-1.79042,124),(0.329867,-1.74795,124),(0.330158,-1.81311,124),(0.568404,-2.03549,158),(0.347321,-1.78256,124),(0.342666,-1.80205,124),(0.360701,-1.80991,124),(0.335685,-1.77093,124),(0.412479,-1.80903,124),(0.387463,-1.76191,124),(0.365356,-1.77035,124),(0.346739,-1.80845,124),(0.380773,-1.83638,122),(0.443605,-1.74795,127),(0.361865,-1.75318,124),(0.493946,-1.97955,146),(0.448083,-1.75333,127),(0.358083,-1.80496,124),(0.443895,-1.80147,127),(0.449422,-1.75057,127),(0.36681,-1.78634,124),(0.43337,-1.83848,127),(0.365065,-1.75842,124),(0.566466,-2.00315,106),(0.38659,-1.76249,124),(0.371755,-1.75435,124),(0.371755,-1.75435,124),(0.399521,-1.91833,122),(0.370882,-1.78547,124),(0.366519,-1.75202,124),(0.402453,-1.91459,122),(0.36681,-1.77762,124),(0.541521,-2.00432,158),(0.374955,-1.76656,124),(0.472693,-1.77209,127),(0.358374,-1.80583,124),(0.352847,-1.76075,124),(0.443605,-1.76278,127),(0.358956,-1.76627,124),(0.350229,-1.79274,124),(0.462512,-1.74824,127),(0.486074,-1.76482,127),(0.564796,-2.04285,158),(0.364192,-1.7718,124),(0.41597,-1.79827,124),(0.388045,-1.78547,124),(0.445932,-1.7622,127),(0.359538,-1.75202,124),(0.35052,-1.77151,124),(0.359894,-1.83662,124),(0.546662,-1.98154,106),(0.50091,-1.75435,121),(0.305724,-1.76744,124),(0.356629,-1.77558,124),(0.34063,-1.77325,124),(0.443605,-1.78344,127),(0.342957,-1.7814,124),(0.487238,-1.77005,127),(0.51604,-1.82465,134),(0.355175,-1.79362,124),(0.362156,-1.80525,124),(0.530981,-1.88338,84),(0.48782,-1.76656,127),(0.331904,-1.78198,124),(0.372919,-1.79507,124),(0.43227,-1.87962,122),(0.495964,-1.75871,127),(0.351393,-1.76627,124),(0.343843,-1.766,124),(0.447968,-1.75086,127),(0.469494,-1.77005,127),(0.569884,-2.0153,158),(0.493637,-1.84103,84),(0.486656,-1.7718,127),(0.405207,-1.85732,122),(0.41277,-1.75667,124),(0.445641,-1.80205,127),(0.366519,-1.76773,124),(0.347321,-1.75318,124),(0.332487,-1.82071,124),(0.553709,-2.03457,158),(0.534652,-1.93644,106),(0.509535,-1.88754,84),(0.344412,-1.74998,124),(0.450141,-1.90232,122),(0.388627,-1.77965,124),(0.368555,-1.77442,124),(0.358956,-1.80322,124),(0.355175,-1.78024,124),(0.421788,-1.9251,122),(0.313868,-1.78431,124),(0.372628,-1.77878,124),(0.354011,-1.79013,124),(0.36041,-1.76278,124),(0.354302,-1.80525,124),(0.348775,-1.79274,124),(0.49451,-1.83958,84),(0.395317,-1.79769,124),(0.355465,-1.76395,124),(0.354302,-1.79274,124),(0.37001,-1.78838,124),(0.367101,-1.82154,122),(0.361283,-1.83609,124),(0.360992,-1.76889,124),(0.32434,-1.76075,124),(0.468204,-1.91362,106),(0.470075,-1.84423,84),(0.338594,-1.75173,124),(0.546439,-1.93631,106),(0.536173,-1.95753,106),(0.507309,-1.93673,106),(0.487264,-1.93557,106),(0.446219,-1.89314,122),(0.366843,-1.7673,124),(0.444477,-1.8867,122),(0.448259,-1.74969,127),(0.397062,-1.78925,124),(0.360701,-1.80351,124),(0.446223,-1.80642,127),(0.449542,-1.89937,122),(0.450586,-1.75115,127),(0.447968,-1.75231,127),(0.404335,-1.79565,124),(0.398808,-1.84656,122),(0.556169,-2.03505,158),(0.375537,-1.78431,124),(0.488085,-1.93401,106),(0.408116,-1.83929,127),(0.354884,-1.82387,124),(0.358374,-1.75318,124),(0.345575,-1.81892,124),(0.419461,-1.82678,127),(0.432832,-1.8743,122),(0.495828,-1.86511,84),(0.429133,-1.87427,122),(0.357502,-1.76162,124),(0.370592,-1.83114,122),(0.361574,-1.75871,124),(0.335685,-1.8102,124),(0.479675,-1.9187,106),(0.445641,-1.807,127),(0.553851,-1.85848,134),(0.343539,-1.75522,124),(0.343539,-1.80612,124),(0.492011,-1.8408,84),(0.436921,-1.94883,122),(0.482874,-1.8355,84),(0.475311,-1.74795,121),(0.319686,-1.75667,124),(0.511787,-1.76195,121),(0.499746,-1.8515,84),(0.354302,-1.80118,124),(0.358083,-1.75958,124),(0.467457,-1.77005,127),(0.540179,-1.9251,106),(0.430287,-1.87695,122),(0.381354,-1.79274,124),(0.400553,-1.79245,124),(0.344993,-1.82154,124),(0.300197,-1.75289,124),(0.358665,-1.78925,124),(0.330449,-1.81456,124),(0.319104,-1.74998,124),(0.361283,-1.78634,124),(0.449713,-1.74882,127),(0.333067,-1.78634,124),(0.358956,-1.75755,124),(0.35692,-1.75609,124),(0.358665,-1.81572,124),(0.49451,-1.76016,127),(0.441277,-1.74562,127),(0.381936,-1.78547,124),(0.546288,-1.9123,106),(0.392636,-1.83887,122),(0.349648,-1.75813,124),(0.35692,-1.7718,124),(0.369244,-1.76158,124),(0.31445,-1.78402,124),(0.313432,-1.78373,124),(0.338351,-1.7307,124),(0.340192,-1.73005,124),(0.338266,-1.73026,124),(0.110418,1.74259,204),(0.0686962,1.78656,204),(0.0661462,1.77774,204),(0.0323724,1.79651,204),(0.0326045,1.79965,204),(0.0263545,1.80666,204),(0.0259461,1.80449,204),(0.0257017,1.81301,204),(0.0303356,1.8134,204),(0.0279357,1.80889,204),(0.0289044,1.80822,204),(0.026833,1.80917,204),(0.0255778,1.81092,204),(0.0353447,1.8035,204),(0.0351439,1.79884,204),(0.0424324,1.81236,204),(0.0438915,1.79447,204),(0.0395719,1.78975,204),(0.035678,1.79017,204),(0.0356763,1.79163,204),(0.0416261,1.79806,204),(0.0584685,1.76715,204),(0.0590502,1.77005,204),(0.0578868,1.77093,204),(0.0538446,1.77208,204),(0.0529416,1.77064,204),(0.0741765,1.80496,204),(0.0730281,1.78105,204),(0.100065,2.02342,205),(0.104282,2.02585,205),(0.103097,2.02635,205),(0.103425,2.02565,205),(0.101632,2.0254,205),(0.103913,2.03617,205),(0.0782218,2.07016,205),(0.0920953,2.01135,205),(0.093328,2.02014,205),(0.0877342,2.0652,205),(0.101931,2.06155,205),(0.0931622,2.02738,205),(0.074173,2.05752,205),(0.0809379,1.80531,204),(0.0787859,1.80551,204),(0.0936367,1.75513,204),(0.087455,1.75477,204),(0.0999627,1.75421,204),(0.0863938,1.75638,204),(0.0846485,1.75813,204),(0.0831941,1.76162,204),(0.0800076,1.76423,204),(0.0852122,1.77961,204),(0.0930295,1.80015,204),(0.0908549,1.80128,204),(0.0431114,1.78425,204),(0.0415458,1.78388,204),(0.0395387,1.78512,204),(0.0396015,1.78273,204),(0.0383274,1.78443,204),(0.0491602,1.77151,204),(0.0503236,1.77151,204),(0.0515151,1.7775,204),(0.0476423,1.77916,204),(0.0440312,1.77667,204),(0.0490071,1.7873,204),(0.0478028,1.78458,204),(0.0608003,1.80466,204),(0.0608317,1.78632,204),(0.0602243,1.78752,204),(0.0942321,1.75168,204),(0.0939568,1.75202,204),(0.0936022,1.75347,204),(0.0901613,1.75367,204),(0.089478,1.75394,204),(0.0956496,1.75403,204),(0.0944438,1.75118,204),(0.0587233,1.77333,204),(0.0579676,1.77285,204),(0.0542319,1.77337,204),(0.0548243,1.77476,204),(0.0657954,1.76257,204),(0.0641339,1.76255,204),(0.0664569,1.80338,204),(0.0780016,1.7635,204),(0.0750492,1.7654,204),(0.0727221,1.76627,204),(0.0718494,1.76773,204),(0.0738676,1.75632,204),(0.0702652,1.76315,204),(0.101529,1.7536,204),(0.0985587,1.75384,204),(0.096291,1.75277,204),(0.101229,1.78285,204),(0.0270526,1.92568,205),(0.0217681,1.94522,205),(0.0369429,1.94633,205),(0.0401426,1.95157,205),(0.112424,1.7488,204),(0.109399,1.75269,204),(0.106465,1.75057,204),(0.106832,1.75161,204),(0.105581,1.78268,204),(0.107046,1.7844,204),(0.120143,2.03938,205),(0.0351975,1.97106,205),(0.0552688,1.9728,205),(0.0829031,2.00713,205),(0.0770528,1.98983,205),(0.0279253,1.81194,204),(0.0953056,1.75069,204),(0.0463891,1.77261,204),(0.0953541,1.75199,204),(0.105301,1.78518,204),(0.0573445,1.77184,204),(0.0777666,1.7563,204),(0.0568873,1.77245,204),(0.0387219,1.78372,204),(0.0597636,1.76601,204),(0.0929735,1.7501,204),(0.0319011,1.80293,204),(0.103265,1.78402,204),(0.0410152,1.78227,204),(0.10472,1.7846,204),(0.0561415,1.76831,204),(0.0386625,1.78521,204),(0.0549779,1.77209,204),(0.0489268,1.7767,204),(0.0529416,1.77587,204),(0.0386398,1.78596,204),(0.039434,1.78344,204),(0.0613775,1.77849,204),(0.0392472,1.78453,204),(0.0512301,1.77484,204),(0.0923075,2.01183,205),(-0.437239,0.587202,38),(-0.342249,0.606381,38),(-0.436803,0.577685,38),(-0.281982,0.586198,38),(-0.312041,0.643823,38),(-0.226438,0.707168,38),(-0.263832,0.685331,38),(-0.253819,0.709874,38),(-0.229084,0.680674,38),(-0.197513,0.70424,38),(-0.262396,0.710974,38),(-0.416431,0.616925,38),(-0.453126,0.566514,38),(-0.453184,0.568684,38),(-0.4313,0.591366,38),(-0.232352,0.615064,38),(-0.416523,0.617556,38),(-0.258362,0.637695,38),(-0.428187,0.575668,38),(-0.333644,0.584394,38),(-0.430864,0.585219,38),(-0.346336,0.608053,38),(-0.283311,0.696537,38),(-0.25954,0.645849,38),(-0.305433,0.423533,52),(-0.393736,0.298159,52),(-0.395899,0.253654,52),(-0.312996,0.344993,52),(-0.406953,0.29816,52),(-0.357159,0.290558,52),(-0.310378,0.273726,52),(-0.383681,0.295252,52),(-0.465096,0.264582,52),(-0.463967,0.316486,52),(-0.341503,0.316196,52),(-0.391826,0.331031,52),(-0.400684,0.253165,52),(-0.388795,2.90523,336),(-0.388917,2.90743,336),(-0.38659,2.9051,336),(0.240779,0.0917223,45),(0.24098,0.156872,45),(0.24804,0.0253607,45),(0.236714,0.123019,45),(0.240111,0.139406,45),(0.244482,0.0131434,45),(0.261291,0.155122,45),(0.259859,0.0919649,45),(0.235858,0.036823,45),(0.248701,0.228799,45),(0.239237,0.1597,45),(0.243566,0.133888,45),(0.234277,0.147914,45),(0.235619,0.123949,45),(0.226862,0.155507,45),(0.24562,0.104022,45),(0.252383,0.0915198,45),(0.207421,0.0601997,45),(0.227748,0.0557406,45),(0.238051,0.070315,45),(0.232397,0.220109,45),(0.253257,0.118072,45),(0.2571,0.0160113,45),(0.297032,0.13992,45),(-0.507098,2.93156,335),(0.199387,0.0912596,31),(0.171265,0.10744,31),(0.193928,0.134787,31),(0.16057,0.217875,31),(0.0859526,0.10933,31),(0.137008,0.170751,31),(0.206135,0.154375,31),(0.0962841,0.100356,31),(0.155916,0.150098,31),(0.116937,0.110537,31),(0.0964516,0.130718,31),(0.0958161,0.104849,31),(0.101379,0.141044,31),(0.103599,0.123557,31),(0.116152,0.111472,31),(0.175765,0.108046,31),(0.216488,0.0811041,31),(0.219443,0.105762,31),(0.126827,0.174242,31),(0.16023,0.125303,31),(0.227956,0.0914382,31),(0.191661,0.14063,31),(0.151262,0.0590502,31),(0.119437,0.0636654,31),(0.102871,0.0990764,31),(0.193784,0.0916417,31),(0.20157,0.149656,31),(0.204362,0.193197,31),(0.0833817,0.122407,31),(0.174242,0.190823,31),(0.152425,0.100356,31),(0.162897,0.164934,31),(0.103963,0.119538,31),(0.137008,0.0686496,31),(0.140499,0.0831941,31),(0.125597,0.0975082,31),(0.0957022,0.122704,31),(0.12373,0.133516,31),(0.131772,0.0599229,31),(0.107258,0.118481,31),(0.123918,0.0843575,31),(0.132645,0.0730129,31),(0.160861,0.0555596,31),(0.0827564,0.123654,31),(0.101844,0.128454,31),(0.136427,0.0858121,31),(0.0979924,0.136344,31),(0.10783,0.11387,31),(0.0996391,0.118861,31),(0.116147,0.153548,31),(0.132551,0.108643,31),(0.142244,0.0823214,31),(0.135959,0.099688,31),(0.116368,0.160074,31),(0.0821778,0.118561,31),(0.165225,0.210021,31),(0.119692,0.129081,31),(0.105066,0.120686,31),(0.100453,0.124028,31),(0.107366,0.11946,31),(0.224783,0.182432,31),(0.148867,0.134812,31),(0.193655,0.197793,31),(0.179204,0.231507,31),(0.224695,0.113229,31),(0.221284,0.237503,31),(0.162025,0.0881391,31),(0.128863,0.0744674,31),(0.167794,0.11444,31),(0.215742,0.241285,31),(0.205692,0.133025,31),(0.135108,0.148564,31),(0.206759,0.22969,31),(0.211413,0.22388,31),(0.136177,0.117688,31),(0.181287,0.14962,31),(0.157952,0.11461,31),(0.130318,0.0709768,31),(0.112627,0.0592684,31),(0.154753,0.0945387,31),(0.148062,0.148644,31),(0.0995941,0.112354,31),(0.175313,0.195689,31),(0.229601,0.185602,31),(0.225556,0.236677,31),(0.181512,0.0954606,31),(0.158534,0.0671952,31),(0.154437,0.13742,31),(0.219733,0.114806,31),(0.125082,0.162025,31),(0.226708,0.132656,31),(0.196299,0.184324,31),(0.209442,0.148645,31),(0.206798,0.0638373,31),(0.167944,0.0689066,31),(0.167552,0.146317,31),(0.167261,0.144862,31),(0.183648,0.129822,31),(0.172206,0.138754,31),(0.136637,0.105996,31),(0.173079,0.155334,31),(0.162025,0.217584,31),(0.213236,0.0764309,31),(0.159407,0.0843575,31),(0.155043,0.198386,31),(0.133227,0.0730129,31),(0.0907641,0.13936,31),(0.111323,0.140241,31),(0.130257,0.0947382,31),(0.144281,0.101811,31),(0.137423,0.088609,31),(0.120603,0.0639763,31),(0.137008,0.0756309,31),(0.148353,0.0794125,31),(0.136717,0.0782489,31),(0.239619,0.0924592,31),(0.132936,0.0826122,31),(0.120193,0.0527177,31),(0.139917,0.0855211,31),(0.0903972,0.134579,31),(0.104138,0.151954,31),(0.138172,0.0814488,31),(0.128282,0.0730129,31),(0.130748,0.09132,31),(0.136378,0.0885615,31),(0.118963,0.068345,31),(0.134099,0.0840667,31),(0.12182,0.0698706,31),(0.102168,0.119734,31),(0.13381,0.0895712,31),(0.105011,0.122636,31),(0.130074,0.150269,31),(0.129736,0.0573049,31),(0.154171,0.0654498,31),(0.152716,0.0721402,31),(0.130944,0.0883587,31),(0.118933,0.0557764,31),(0.12414,0.0892893,31),(0.124032,0.117533,31),(0.142826,0.17017,31),(0.183004,0.0897975,31),(0.128941,0.0680048,31),(0.21729,0.175308,31),(0.193794,0.239337,31),(0.20796,0.138485,31),(0.19681,0.17254,31),(0.233108,0.0913966,31),(0.212281,0.116262,31),(0.211945,0.089153,31),(0.220399,0.163907,31),(0.17735,0.222353,31),(0.179589,0.194906,31),(0.116937,0.19664,31),(0.225095,0.208225,31),(0.130318,0.0759218,31),(0.20702,0.15703,31),(0.224641,0.192827,31),(0.177588,0.194859,31),(0.147189,0.210603,31),(0.215909,0.248139,31),(0.201119,0.127551,31),(0.134628,0.0683684,31),(0.112352,0.141131,31),(0.0838269,0.144049,31),(0.114915,0.0695227,31),(0.107835,0.122375,31),(0.121868,0.130149,31),(0.112403,0.1308,31),(0.129785,0.0952831,31),(0.0890275,0.118929,31),(0.117671,0.107146,31),(0.0810046,0.138246,31),(0.137881,0.0753401,31),(0.116224,0.135431,31),(0.143408,0.0962841,31),(0.133518,0.0858121,31),(0.115701,0.14066,31),(0.115207,0.0608802,31),(0.18937,0.1431,31),(0.20524,0.163,31),(0.188898,0.188001,31),(0.146317,0.145735,31),(0.209858,0.242888,31),(0.178174,0.198721,31),(0.22752,0.145147,31),(0.201652,0.199116,31),(0.191877,0.18172,31),(0.19471,0.222662,31),(0.205024,0.208755,31),(0.0864235,0.145246,31),(0.093391,0.0961254,31),(0.171042,0.154753,31),(0.0826251,0.11979,31),(0.0777055,0.125107,31),(0.155916,0.0834849,31),(0.185229,0.212836,31),(0.199768,0.165778,31),(0.217361,0.0732602,31),(0.192254,0.11834,31),(0.172172,0.195918,31),(0.158534,0.105011,31),(0.110567,0.0982182,31),(0.0969911,0.133287,31),(0.13716,0.191495,31),(0.180003,0.171797,31),(0.150098,0.111992,31),(0.201099,0.238858,31),(0.111992,0.0503236,31),(0.182029,0.0665834,31),(0.203793,0.177933,31),(0.108387,0.123467,31),(0.106015,0.130526,31),(0.123337,0.109374,31),(0.108222,0.117528,31),(0.222413,0.0790088,31),(0.134552,0.0880473,31),(0.127991,0.0730129,31),(0.191282,0.14646,31),(0.10104,0.136804,31),(0.155625,0.146317,31),(0.126581,0.090637,31),(0.117078,0.127701,31),(0.131987,0.116151,31),(0.10664,0.123437,31),(0.109115,0.108095,31),(0.102854,0.138533,31),(0.115192,0.0511963,31),(0.158276,0.130616,31),(0.124791,0.0584685,31),(0.110239,0.141667,31),(0.0891266,0.128573,31),(0.083122,0.117845,31),(0.212883,-1.50268,117),(0.235285,-1.51114,117),(0.227648,-1.5168,117),(0.23969,-1.47964,117),(0.206796,-1.50863,117),(0.20786,-1.50454,117),(0.199616,-1.49795,117),(0.225747,-1.48743,117),(0.212226,-1.46991,117),(0.244958,-1.45541,117),(0.237925,-1.50928,117),(0.203987,-1.47404,117),(0.205198,-1.50191,117),(0.214081,-1.51084,117),(0.225594,-1.49954,117),(0.208993,-1.50263,117),(0.208015,-1.50351,117),(0.211758,-1.50535,117),(0.217082,-1.51631,117),(0.215374,-1.51277,117),(0.211295,-1.48989,117),(0.206815,-1.50446,117),(0.228493,-1.50101,117),(0.242989,-1.50314,117),(0.208216,-1.50022,117),(0.228496,-1.50716,117),(0.221016,-1.52136,117),(0.209266,-1.50639,117),(0.206968,-1.50515,117),(0.217852,-1.52146,117),(0.220424,-1.52072,117),(0.21952,-1.51891,117),(0.216139,-1.49246,117),(0.217682,-1.49502,117),(0.209678,-1.46195,117),(0.212213,-1.50699,117),(0.916516,0.106368,260),(0.904386,0.0808669,260),(0.909986,0.108235,260),(0.89835,0.0812548,260),(0.908575,0.0784187,260),(0.906349,0.105956,260),(0.909142,0.0913388,260),(0.913331,0.0967204,260),(0.914114,0.0791348,260),(0.904255,0.0915327,260),(0.91548,0.0840125,260),(0.915225,0.0842371,260),(0.922851,0.104666,260),(0.909055,0.0852302,260),(0.897605,0.0751111,260),(0.906288,0.111999,260),(0.907091,0.117276,260),(0.927541,0.122779,260),(0.90712,0.0932297,260),(0.904241,0.0999201,260),(0.91384,0.115071,260),(0.9068,0.104235,260),(0.904255,0.0854241,260),(0.912938,0.0879937,260),(0.89451,0.0996049,260),(0.910116,0.076843,260),(0.907048,0.098902,260),(0.908357,0.0811821,260),(0.90203,0.0885027,260),(0.896867,0.0950234,260),(0.901521,0.0922843,260),(0.910538,0.107192,260),(0.909796,0.0776429,260),(0.91144,0.0782731,260),(0.908866,0.0760915,260),(0.916211,0.0885027,260),(0.897841,0.0623713,260),(0.925504,0.124064,260),(0.906044,0.0757764,260),(0.90744,0.0888664,260),(0.899281,0.104283,260),(0.896576,0.107653,260),(0.9156,0.0811578,260),(0.907484,0.104259,260),(0.897419,0.0942963,260),(0.900881,0.0968415,260),(0.899688,0.0639955,260),(0.908071,0.0970213,260),(0.926886,0.120064,260),(0.896241,0.0952901,260),(0.909157,0.0893996,260),(0.919134,0.0977627,260),(0.911716,0.0842364,260),(0.901652,0.0980777,260),(0.914683,0.118416,260),(0.897953,0.0963383,260),(0.899813,0.0888599,260),(0.905593,0.0947569,260),(0.895979,0.0668074,260),(0.896125,0.107095,260),(0.921316,0.106829,260),(0.900314,0.0753884,260),(0.918829,0.108404,260),(0.924841,0.121307,260),(0.904866,0.0755583,260),(0.896837,0.0996777,260),(0.910596,0.0923571,260),(0.9256,0.0987664,260),(0.904444,0.0833637,260),(0.890089,0.102441,260),(0.900023,0.0952901,260),(0.902321,0.0925752,260),(0.9076,0.0726978,260),(0.908909,0.0750249,260),(0.900983,0.0948052,260),(0.90616,0.0766006,260),(0.909397,0.0746228,260),(0.921316,0.0837515,260),(0.899397,0.0795579,260),(0.906219,0.0781763,260),(0.899383,0.0779338,260),(0.893507,0.104502,260),(0.908205,0.0754857,260),(0.905346,0.0803337,260),(0.905084,0.0771823,260),(0.906859,0.097181,260),(0.914305,0.109519,260),(0.912095,0.0978596,260),(0.916385,0.0865634,260),(0.907912,0.0773087,260),(0.904633,0.0818123,260),(0.904502,0.0770127,260),(0.90347,0.0963083,260),(0.901375,0.0848181,260),(0.91304,0.120937,260),(0.915338,0.102999,260),(0.900226,0.0905632,260),(0.910713,0.0780064,260),(0.888678,0.102732,260),(0.914189,0.100987,260),(0.898321,0.0969143,260),(0.912138,0.0784187,260),(0.911655,0.0775753,260),(0.904822,0.10215,260),(0.911411,0.0957507,260),(0.90808,0.0886725,260),(0.895107,0.100332,260),(0.912734,0.0901026,260),(0.907469,0.0734735,260),(0.911178,0.0848666,260),(0.903339,0.0726978,260),(0.898845,0.0630743,260),(0.919716,0.108113,260),(0.888154,0.100356,260),(0.887471,0.0992899,260),(0.906233,0.0741765,260),(0.91,0.0879937,260),(0.912124,0.122246,260),(0.90107,0.0885755,260),(0.912109,0.0795336,260),(0.904651,0.101114,260),(0.907339,0.11461,260),(0.909884,0.0948052,260),(0.916443,0.0955568,260),(0.910335,0.0790489,260),(0.910335,0.0784187,260),(0.928539,0.101379,260),(0.905709,0.0888664,260),(0.927861,0.111289,260),(0.906117,0.0803337,260),(0.92908,0.114634,260),(0.887776,0.105811,260),(0.91112,0.0767702,260),(0.917258,0.103168,260),(0.90792,0.088018,260),(0.912793,0.0914844,260),(0.908066,0.0901997,260),(0.912953,0.0974232,260),(0.918785,0.0883088,260),(0.927846,0.118004,260),(0.920181,0.113034,260),(0.912851,0.0818366,260),(0.888789,0.103416,260),(0.911469,0.090345,260),(0.898597,0.0896663,260),(0.912647,0.0799942,260),(0.912211,0.118561,260),(0.904851,0.0809639,260),(0.898525,0.098805,260),(0.904662,0.0721402,260),(0.918087,0.0818237,260),(0.902922,0.0964595,260),(0.888087,0.104398,260),(0.91929,0.0846244,260),(0.924314,0.103298,260),(0.91433,0.105421,260),(0.913678,0.0806867,260),(0.916491,0.0815357,260),(0.928075,0.0946394,260),(0.920385,0.0833712,260),(0.928028,0.115354,260),(0.913534,0.098102,260),(0.917621,0.115531,260),(0.914218,0.080928,260),(0.910306,0.117616,260),(0.92885,0.11461,260),(0.903673,0.103605,260),(0.907862,0.0821759,260),(0.904718,0.0867853,260),(0.899208,0.0884301,260),(0.898917,0.0678739,260),(0.902306,0.104259,260),(0.90536,0.111289,260),(0.897477,0.0970354,260),(0.905491,0.0923085,260),(0.902364,0.0847696,260),(0.912778,0.0981262,260),(0.913636,0.104429,260),(0.911382,0.120355,260),(0.919847,0.0923571,260),(0.92117,0.120549,260),(0.919978,0.100332,260),(0.90616,0.101956,260),(0.915382,0.101981,260),(0.897812,0.0956053,260),(0.909317,0.11604,260),(0.896357,0.0928177,260),(0.908153,0.0987565,260),(0.90664,0.104962,260),(0.905622,0.0978355,260),(0.916734,0.099799,260),(0.902452,0.0838486,260),(0.908502,0.0921632,260),(0.926989,0.106446,260),(0.904255,0.0815699,260),(0.901055,0.0861999,260),(0.90696,0.109762,260),(0.913499,0.086613,260),(0.912022,0.10758,260),(0.924324,0.083066,260),(0.930784,0.120743,260),(0.907688,0.0760189,260),(0.905911,0.0777221,260),(0.909491,0.0904178,260),(0.916502,0.109204,260),(0.906786,0.091242,260),(0.902873,0.102611,260),(0.895427,0.0975445,260),(0.917141,0.0814971,260),(0.906117,0.0797034,260),(0.906335,0.0798973,260),(0.912342,0.0900784,260),(0.911813,0.0938785,260),(0.889187,0.104211,260),(0.909142,0.107435,260),(0.919338,0.0838728,260),(0.915149,0.0871937,260),(0.900355,0.0833562,260),(0.90043,0.0930116,260),(0.90888,0.0812548,260),(0.897506,0.0651832,260),(0.912831,0.117778,260),(0.890671,0.101399,260),(0.923686,0.118561,260),(0.909011,0.0829031,260),(0.914596,0.080673,260),(0.896546,0.0911207,260),(0.916007,0.0812789,260),(0.905142,0.100647,260),(0.898975,0.0940781,260),(0.907397,0.0785156,260),(0.895688,0.0935205,260),(0.898757,0.0749038,260),(0.908924,0.0793154,260),(0.889085,0.101181,260),(0.910015,0.0974718,260),(0.90507,0.0791458,260),(0.911266,0.0922843,260),(0.897172,0.100332,260),(0.924966,0.114537,260),(0.907222,0.103168,260),(0.911236,0.104186,260),(0.925795,0.116961,260),(0.914099,0.0853412,260),(0.912822,0.0848909,260),(0.910276,0.0940296,260),(0.909826,0.0812531,260),(0.914033,0.0910037,260),(0.913796,0.116283,260),(0.918596,0.0828789,260),(0.90523,0.0813517,260),(0.906262,0.114852,260),(0.912095,0.0830728,260),(0.912938,0.0867816,260),(0.907451,0.0781672,260),(0.908286,0.0762676,260),(1.10707,0.181428,290),(1.2156,0.330829,290),(1.03441,0.181647,290),(1.11727,0.200632,290),(1.02922,0.100065,290),(1.0334,0.167708,290),(1.0347,0.193899,290),(1.02717,0.100098,290),(1.03203,0.178314,290),(1.0322,0.168531,290),(1.04567,0.187555,290),(1.03732,0.186012,290),(1.09498,0.12495,290),(1.15738,0.246838,290),(1.06666,0.182671,290),(1.03067,0.175147,290),(1.10149,0.134878,290),(1.01485,0.13955,290),(1.04141,0.168427,290),(1.03703,0.18297,290),(1.03697,0.0919439,290),(1.20076,0.288706,290),(1.06106,0.193173,290),(1.03192,0.19875,290),(1.06109,0.186603,290),(1.03355,0.190761,290),(1.04273,0.178102,290),(1.17426,0.251415,290),(1.05406,0.0929239,290),(1.02035,0.15311,290),(1.09035,0.107424,290),(1.05418,0.0904662,290),(1.05252,0.0921946,290),(0.488401,1.462,201),(0.490978,1.43636,201),(0.497419,1.41604,201),(0.486376,1.45817,201),(0.465202,1.50463,201),(0.463094,1.51407,201),(0.49335,1.46553,201),(0.483047,1.48901,201),(0.481386,1.49247,201),(0.468739,1.49327,201),(0.504691,1.40208,201),(0.466519,1.50963,201),(0.483105,1.48834,201),(0.477778,1.522,201),(0.483486,1.48913,201),(0.466322,1.49935,201),(0.46508,1.49751,201),(0.465421,1.52338,201),(0.469658,1.53464,201),(0.478716,1.48409,201),(0.492765,1.41953,201),(0.467167,1.48818,201),(0.467966,1.52339,201),(0.470948,1.52425,201),(0.501048,1.40667,201),(0.520827,1.40549,201),(0.503429,1.42611,201),(0.511354,1.4064,201),(0.483466,1.45645,201),(0.471421,1.48139,201),(0.462217,1.52338,201),(0.483165,1.47364,201),(0.479966,1.45648,201),(0.463281,1.53754,201),(0.482231,1.49263,201),(0.493438,1.45892,201),(0.499198,1.42478,201),(0.489565,1.42448,201),(-0.332651,-2.96564,334),(-0.720588,3.05041,326),(-0.696968,3.0552,326),(-0.774926,2.98888,326),(-0.675151,3.07323,326),(-0.649262,3.05345,326),(-0.717912,3.05171,326),(-0.714131,3.05462,326),(-0.70424,3.06509,326),(-0.642281,3.04996,326),(-0.681842,3.03833,326),(-0.72053,3.02436,326),(-0.689114,3.08778,326),(-0.645647,3.05223,326),(-0.645215,3.05081,326),(-0.719367,3.05287,326),(-0.809833,2.93826,326),(-0.691815,3.0866,326),(-0.659443,3.05927,326),(-0.800655,2.97585,326),(-0.7598,3.01302,326),(-0.643445,3.05025,326),(-0.709185,3.05913,326),(-0.674628,3.10676,326),(-0.714882,3.0658,326),(-0.657747,3.07469,326),(-0.646919,3.05335,326),(-0.662502,3.08898,326),(-0.766171,2.99726,326),(-0.623635,3.04253,326),(-0.6611,3.06201,326),(-0.665647,3.07606,326),(-0.724591,3.03605,326),(-0.717998,3.0552,326),(-0.689987,3.08661,326),(-0.644333,3.04835,326),(0.393863,1.03898,211),(0.425237,0.990419,211),(0.406953,1.01258,211),(0.431853,0.985515,211),(0.296969,0.94409,211),(0.421885,0.992894,211),(0.400262,1.00415,211),(0.41214,1.02263,211),(0.456926,0.981708,211),(0.400262,1.00822,211),(0.405365,0.986385,211),(0.396025,1.0216,211),(0.408544,1.01453,211),(0.411123,1.01925,211),(0.413772,1.01035,211),(0.400961,1.00007,211),(0.391826,1.02625,211),(0.416251,1.00249,211),(0.413124,1.01559,211),(0.408247,1.00225,211),(0.428236,0.987255,211),(0.418681,0.996555,211),(0.423258,0.973774,211),(0.390528,1.00397,211),(0.411732,0.986985,211),(0.155916,-1.39103,135),(0.155043,-1.38986,135),(0.158534,-1.3855,135),(0.141372,-1.41343,135),(0.157661,-1.38754,135),(0.144571,-1.4463,135),(0.146026,-1.43873,135),(0.156968,-1.38788,135),(0.158534,-1.38376,135),(0.155625,-1.39132,135),(0.158534,-1.38812,135),(0.148644,-1.44193,135),(0.15499,-1.39248,135),(0.159407,-1.38812,135),(0.147084,-1.43869,135),(0.163348,-1.39454,135),(0.139045,-1.40383,135),(0.159698,-1.38957,135),(0.159989,-1.38056,135),(0.164643,-1.44019,135),(0.163373,-1.39353,135),(0.156207,-1.39015,135),(0.159116,-1.38841,135),(0.14399,-1.40586,135),(-0.102974,-1.3279,113),(-0.146899,-1.37445,113),(-0.14764,-1.33454,113),(-0.0622501,-1.40397,113),(-0.141651,-1.37933,113),(-0.142841,-1.3354,113),(-0.162133,-1.3266,113),(-0.0859913,-1.40228,113),(-0.0798876,-1.41846,113),(-0.085589,-1.40822,113),(-0.0969869,-1.41061,113),(-0.138909,-1.38298,113),(-0.129726,-1.38764,113),(-0.120816,-1.38901,113),(-0.105743,-1.34678,113),(-0.0844352,-1.40753,113),(-0.146244,-1.30121,113),(-0.0907571,-1.40732,113),(-0.119322,-1.39511,113),(-0.117247,-1.39224,113),(-0.0888228,-1.41571,113),(-0.134972,-1.38408,113),(-0.129164,-1.38878,113),(-0.105592,-1.34332,113),(-0.120045,-1.39403,113),(-0.142613,-1.37897,113),(-0.0851333,-1.40857,113),(-0.0942478,-1.40935,113),(-0.141191,-1.37812,113),(-0.0979323,-1.36895,113),(-0.116956,-1.39462,113),(-0.125277,-1.33921,113),(-0.0996244,-1.3754,113),(-0.065416,-1.27841,113),(-0.166388,-1.35321,113),(-0.173362,-1.33067,113),(-0.136136,-1.36252,113),(-0.126536,-1.38725,113),(-0.11587,-1.39258,113),(-0.157482,-1.3721,113),(-0.0888809,-1.3991,113),(-0.1159,-1.3856,113),(-0.135985,-1.38268,113),(-0.158568,-1.37145,113),(-0.118222,-1.3935,113),(-0.125955,-1.38666,113),(-0.108764,-1.35907,113),(-0.0919207,-1.40819,113),(-0.125032,-1.37009,113),(-0.123153,-1.33677,113),(-0.100463,-1.36906,113),(-0.0743655,-1.41175,113),(-0.0611399,-1.40103,113),(-0.283616,-1.20573,113),(-0.178741,-1.33772,113),(-0.199312,-1.32105,113),(-0.222239,-1.20748,113),(-0.314256,-1.22606,113),(-0.212058,-1.34419,113),(-0.249049,-1.24313,113),(-0.196388,-1.30269,113),(-0.228204,-1.33314,113),(-0.224566,-1.26915,113),(-0.211476,-1.34478,113),(-0.238528,-1.32907,113),(-0.276344,-1.22231,113),(-0.219911,-1.20748,113),(-0.23911,-1.33023,113),(-0.186169,-1.35845,113),(-0.228209,-1.33199,113),(-0.25889,-1.30812,113),(-0.300119,-1.23805,113),(-0.297108,-1.25689,113),(-0.265498,-1.31092,113),(-0.220925,-1.33746,113),(-0.210193,-1.3444,113),(-0.201043,-1.32469,113),(-0.194759,-1.32633,113),(-0.270526,-1.22406,113),(-0.205527,-1.31766,113),(-0.227927,-1.33261,113),(-0.307866,-1.24507,113),(-0.280707,-1.21591,113),(-0.245485,-1.32175,113),(-0.193208,-1.35437,113),(-0.175721,-1.36401,113),(-0.200626,-1.34753,113),(-0.225729,-1.29591,113),(-0.210603,-1.31307,113),(-0.22282,-1.30871,113),(-0.193669,-1.35462,113),(-0.193848,-1.35446,113),(-0.235939,-1.25625,113),(-0.208446,-1.33883,113),(-0.234046,-1.32876,113),(-0.182096,-1.33576,113),(-0.201959,-1.34857,113),(-0.186459,-1.3311,113),(-0.290122,-1.26905,113),(-0.210603,-1.34652,113),(-0.187623,-1.35728,113),(-0.259817,-1.23201,113),(-0.229656,-1.29545,113),(-0.286215,-1.24852,113),(-0.238334,-1.28085,113),(-0.237956,-1.27202,113),(-0.255364,-1.21207,113),(-0.30776,-2.61101,344),(-0.306014,-2.61043,344),(-0.306305,-2.61101,344),(-0.0620189,2.50676,341),(-0.164814,2.56877,341),(-0.15278,2.58751,341),(-0.102243,2.51724,341),(-0.107793,2.50719,341),(-0.0911873,2.54463,341),(-0.117322,2.56537,341),(-0.0759571,2.6575,341),(-0.0968694,2.62049,341),(-0.106175,2.53749,341),(-0.158411,2.49947,341),(-0.125664,2.55953,341),(-0.108441,2.71463,341),(0.120607,2.13059,210),(0.134099,2.17584,210),(0.237099,2.16835,210),(0.306737,2.10115,210),(0.190241,2.14811,210),(0.24832,2.11759,210),(0.140902,2.19834,210),(0.137993,2.18331,210),(0.278836,2.10436,210),(0.18455,2.15362,210),(0.110557,2.18084,210),(0.307406,2.12454,210),(0.140426,2.20023,210),(0.181151,2.15796,210),(0.234895,2.15863,210),(0.249402,2.10691,210),(0.254141,2.11568,210),(0.263836,2.10516,210),(0.254256,2.11428,210),(0.244798,2.1222,210),(0.270332,2.10484,210),(0.256132,2.11078,210),(0.166073,2.14952,210),(0.140674,2.15984,210),(0.158447,2.20258,210),(0.253017,2.11682,210),(0.245852,2.11446,210),(0.193896,2.18193,210),(0.184562,2.14493,210),(0.245961,2.11223,210),(0.1874,2.14617,210),(0.178804,2.16158,210),(0.272067,2.11044,210),(0.147587,2.19535,210),(0.129988,2.19576,210),(0.253497,2.11323,210),(0.29558,2.10215,210),(0.149032,2.17742,210),(0.168381,2.16169,210),(0.229802,2.15926,210),(0.116806,2.17601,210),(0.304017,2.1196,210),(0.233152,2.15956,210),(0.24225,2.11051,210),(0.170761,2.19019,210),(0.111119,2.17701,210),(0.259705,2.09848,210),(0.175463,2.144,210),(0.226437,2.16409,210),(0.288314,2.11501,210),(0.308099,2.12391,210),(0.0813524,2.08386,210),(0.170203,2.13636,210),(0.24811,2.11135,210),(0.163335,2.15173,210),(0.260819,2.10527,210),(0.108559,2.17631,210),(0.24369,2.12104,210),(0.266956,2.10568,210),(0.261665,2.10671,210),(0.246229,2.11432,210),(0.264631,2.1043,210),(0.291262,2.12142,210),(0.249795,2.11379,210),(0.261754,2.10519,210),(0.295865,2.10215,210),(0.114382,2.18988,210),(0.275158,2.09281,210),(0.260284,2.10421,210),(0.249257,2.11911,210),(0.162904,2.14438,210),(0.279268,2.10142,210),(0.263466,2.10778,210),(0.261792,2.10802,210),(0.250621,2.11267,210),(0.240812,2.11244,210),(0.245514,2.11754,210),(0.31717,2.10478,210),(0.262049,2.0958,210),(0.269164,2.10488,210),(0.264337,2.11148,210),(0.294648,2.12209,210),(0.256532,2.11401,210),(0.1309,2.19911,210),(0.261349,2.09714,210),(0.262499,2.10815,210),(0.268135,2.11122,210),(0.258551,2.11264,210),(0.233001,2.15635,210),(0.215596,2.11303,210),(0.263211,2.11082,210),(0.267952,2.10893,210),(0.23296,2.13837,210),(0.148974,2.19824,210),(0.290002,2.09992,210),(0.262299,2.10643,210),(0.177367,2.1591,210),(0.267144,2.10934,210),(0.266096,2.10922,210),(0.260752,2.09696,210),(0.253774,2.11813,210),(0.257746,2.10387,210),(0.123472,2.19402,210),(0.191021,2.15416,210),(0.224006,2.10782,210),(0.298782,2.12267,210),(0.202201,2.14241,210),(0.180144,2.08296,210),(0.219477,2.13403,210),(0.274223,2.1137,210),(0.121334,2.12867,210),(0.273411,2.10558,210),(0.292939,2.12119,210),(0.254818,2.11156,210),(0.25567,2.11274,210),(0.27142,2.10861,210),(0.134919,2.18339,210),(0.183614,2.14329,210),(0.249219,2.11334,210),(0.260083,2.10922,210),(0.169981,2.07232,210),(0.254527,2.11127,210),(0.26304,2.10386,210),(0.108589,2.18278,210),(0.231994,2.15523,210),(0.259831,2.10936,210),(0.262613,2.10344,210),(0.179259,2.15695,210),(0.227516,2.12037,210),(0.252818,2.11719,210),(0.236618,2.15153,210),(0.255865,2.10426,210),(0.248404,2.11822,210),(0.267928,2.11192,210),(0.246382,2.11127,210),(0.193867,2.14051,210),(0.128637,2.16892,210),(0.18995,2.15315,210),(0.267397,2.109,210),(0.258852,2.10817,210),(0.124534,2.19719,210),(0.261242,2.11106,210),(0.273474,2.10453,210),(0.251341,2.12003,210),(0.259443,2.1111,210),(0.265002,2.10566,210),(0.196369,2.18177,210),(0.12755,2.1936,210),(0.194735,2.1815,210),(0.271248,2.11335,210),(0.243843,2.12385,210),(0.124646,2.17085,210),(0.250711,2.12028,210),(0.182387,2.14356,210),(0.142211,2.16142,210),(0.148107,2.1608,210),(0.192098,2.17481,210),(0.255177,2.10455,210),(0.258319,2.10377,210),(0.258818,2.09933,210),(0.256734,2.11073,210),(0.251837,2.10975,210),(0.260244,2.11271,210),(0.132411,2.19604,210),(0.245606,2.10545,210),(0.161771,2.06654,210),(0.249898,2.10777,210),(0.246727,2.11912,210),(0.237699,2.14992,210),(0.17818,2.15998,210),(0.132781,2.19853,210),(0.234005,2.15325,210),(0.136616,2.1551,210),(0.185095,2.14748,210),(0.274298,2.11016,210),(0.256195,2.09904,210),(0.253273,2.11602,210),(0.257111,2.11432,210),(0.136402,2.20006,210),(0.141099,2.15532,210),(0.178809,2.16065,210),(0.125504,2.17346,210),(0.257208,2.11116,210),(0.262927,2.10696,210),(0.246254,2.14695,210),(0.246591,2.1102,210),(0.24768,2.1246,210),(0.121389,2.20289,210),(0.27116,2.09353,210),(0.215839,2.15752,210),(0.259984,2.10677,210),(0.251957,2.10287,210),(0.257572,2.11095,210),(0.154171,2.1837,210),(0.139686,2.16916,210),(0.139602,2.16932,210),(0.135496,2.18175,210),(0.249116,2.10727,210),(0.142535,2.16799,210),(0.185548,2.14639,210),(0.218523,2.1195,210),(0.146079,2.1793,210),(0.254891,2.11154,210),(0.263566,2.10418,210),(0.280474,2.10142,210),(0.180181,2.16285,210),(0.254525,2.11256,210),(0.294318,2.10806,210),(0.125926,2.20853,210),(0.191254,2.1489,210),(0.280017,2.10288,210),(0.23079,2.1048,210),(0.248454,2.11451,210),(0.245127,2.11462,210),(0.114197,2.12713,210),(0.109592,2.18658,210),(0.259082,2.10854,210),(0.111963,2.19234,210),(0.232457,2.15964,210),(0.142244,2.18312,210),(0.104182,2.18671,210),(0.256684,2.11413,210),(0.24339,2.11936,210),(0.25395,2.11242,210),(0.141691,2.15453,210),(0.118101,2.18486,210),(0.238419,2.15002,210),(0.119812,2.17192,210),(0.265554,2.10591,210),(0.265667,2.10441,210),(0.176865,2.17895,210),(0.183078,2.14659,210),(0.120395,2.19928,210),(0.249535,2.11987,210),(0.243149,2.12262,210),(0.24635,2.12153,210),(0.260761,2.10489,210),(0.247484,2.11575,210),(0.242322,2.13385,210),(0.258111,2.11183,210),(0.243318,2.1147,210),(0.279634,2.09844,210),(0.254154,2.10484,210),(0.181499,2.16419,210),(0.246638,2.11946,210),(0.232124,2.15441,210),(0.156105,2.19042,210),(0.229288,2.15957,210),(0.272036,2.11505,210),(0.287194,2.10465,210),(0.179948,2.16333,210),(0.269501,2.10711,210),(0.219384,2.18191,210),(0.317612,2.10479,210),(0.139181,2.15977,210),(0.116108,2.1733,210),(0.180186,2.14713,210),(0.181937,2.14538,210),(0.24702,2.14379,210),(0.1135,2.17899,210),(0.122318,2.18322,210),(0.2521,2.11013,210),(0.20431,2.13566,210),(0.174362,2.14351,210),(0.124035,2.17868,210),(0.249418,2.14137,210),(0.105631,2.11189,210),(0.151044,2.1774,210),(0.250507,2.11748,210),(0.267515,2.11044,210),(0.285604,2.10621,210),(0.115706,2.17477,210),(0.178107,2.14656,210),(0.117008,2.1288,210),(0.221702,2.16484,210),(0.23444,2.15394,210),(0.135864,2.13953,210),(0.247754,2.1097,210),(0.251846,2.11074,210),(0.186697,2.13915,210),(0.14399,2.17119,210),(0.299298,2.12737,210),(0.267517,2.09401,210),(0.179256,2.14415,210),(0.176259,2.1445,210),(0.258857,2.10326,210),(0.258869,2.1072,210),(0.259005,2.1115,210),(0.242967,2.13105,210),(0.280416,2.10632,210),(0.273327,2.1078,210),(0.176652,2.15154,210),(0.25889,2.10981,210),(0.239072,2.15529,210),(0.101651,2.18521,210),(0.272385,2.10483,210),(0.251099,2.10978,210),(0.267921,2.11268,210),(0.106688,2.18466,210),(0.272315,2.11275,210),(0.267161,2.11091,210),(0.189199,2.15547,210),(0.189849,2.14619,210),(0.162438,2.15212,210),(0.134041,2.18175,210),(0.279304,2.09809,210),(0.136848,2.18244,210),(0.149894,2.1527,210),(0.259586,2.10251,210),(0.117805,2.1879,210),(0.262381,2.10661,210),(0.123448,2.19236,210),(0.250096,2.11074,210),(0.151077,2.15413,210),(0.183623,2.16468,210),(0.166752,2.15996,210),(0.246304,2.14597,210),(0.242636,2.11276,210),(0.126076,2.16851,210),(0.17893,2.16333,210),(0.181106,2.16346,210),(0.26748,2.10587,210),(0.243004,2.11989,210),(0.182474,2.16439,210),(0.13392,2.20067,210),(0.180061,2.1623,210),(0.252686,2.10998,210),(0.205517,2.17967,210),(0.218147,2.17534,210),(0.237236,2.13491,210),(0.260584,2.09791,210),(0.249812,2.11285,210),(0.184884,2.16452,210),(0.197208,2.176,210),(0.252828,2.11584,210),(0.176385,2.15793,210),(0.267548,2.10471,210),(0.181287,2.15064,210),(0.243144,2.11924,210),(0.263468,2.10882,210),(0.273783,2.1016,210),(0.26034,2.10776,210),(0.255216,2.11341,210),(0.210605,2.17461,210),(0.246872,2.11735,210),(0.243604,2.13433,210),(0.241418,2.10543,210),(0.279446,2.10068,210),(0.234078,2.115,210),(0.24804,2.11473,210),(0.243167,2.10859,210),(0.239229,2.1504,210),(0.254445,2.11398,210),(0.148043,2.1755,210),(0.191052,2.15178,210),(0.266142,2.10931,210),(0.12928,2.19446,210),(0.270294,2.11128,210),(0.304173,2.12528,210),(0.159237,2.19099,210),(0.261067,2.11041,210),(0.142904,2.1673,210),(0.274598,2.10458,210),(0.142545,2.19895,210),(0.117291,2.1782,210),(0.263341,2.10604,210),(0.221157,2.16203,210),(0.258183,2.10973,210),(0.234436,2.15578,210),(0.148498,2.17746,210),(0.156677,2.1888,210),(0.125736,2.17188,210),(0.266854,2.09482,210),(0.202599,2.1892,210),(0.0877756,2.09043,210),(0.272832,2.11438,210),(0.192889,2.1643,210),(0.25828,2.11056,210),(0.143384,2.20464,210),(0.188025,2.14645,210),(0.279788,2.09913,210),(0.252455,2.11522,210),(0.177933,2.14428,210),(0.24198,2.12036,210),(0.152823,2.19506,210),(0.287651,2.11446,210),(0.186375,2.17818,210),(0.163448,2.14333,210),(0.275984,2.10235,210),(0.247542,2.11682,210),(0.288517,2.10021,210),(0.240711,2.112,210),(0.23305,2.15317,210),(0.2401,2.11287,210),(0.315126,2.10425,210),(0.253481,2.11648,210),(0.194924,2.15936,210),(0.11844,2.18538,210),(0.112118,2.17779,210),(0.241728,2.11534,210),(0.285998,2.11371,210),(0.261009,2.11005,210),(0.243249,2.10718,210),(0.256146,2.10375,210),(0.183328,2.15924,210),(0.2586,2.10952,210),(0.167396,2.1489,210),(0.150224,2.19762,210),(0.28652,2.10475,210),(0.183841,2.14385,210),(0.288082,2.11517,210),(0.252358,2.11061,210),(0.186169,2.14588,210),(0.263254,2.10341,210),(0.234832,2.15313,210),(0.244393,2.12792,210),(0.166689,2.13831,210),(0.286129,2.10058,210),(0.264426,2.10783,210),(0.320383,2.12303,210),(0.260985,2.10783,210),(0.254581,2.11491,210),(0.253537,2.11453,210),(0.264417,2.10458,210),(0.260551,2.11237,210),(0.247323,2.11052,210),(0.292855,2.12402,210),(0.270526,2.10911,210),(0.245462,2.11615,210),(0.106496,2.18673,210),(0.280707,2.09614,210),(0.187571,2.18185,210),(0.256951,2.10379,210),(0.255912,2.11242,210),(0.12498,2.1725,210),(0.25459,2.11292,210),(0.204985,2.13105,210),(0.425678,1.18669,199),(0.59093,1.28736,199),(0.481554,1.19761,199),(0.48048,1.20012,199),(0.547006,1.2121,199),(0.594464,1.2648,199),(0.502871,1.23088,199),(0.56455,1.30725,199),(0.508261,1.25218,199),(0.566287,1.29357,199),(0.550651,1.28863,199),(0.479059,1.18329,199),(0.52418,1.26275,199),(0.596693,1.2525,199),(0.450421,1.16277,199),(0.491824,1.1876,199),(0.442643,1.21713,199),(0.491576,1.217,199),(0.453825,1.10033,199),(0.594641,1.26752,199),(0.540604,1.26506,199),(0.492887,1.20037,199),(0.431924,1.18549,199),(0.470266,1.18885,199),(0.535901,1.23308,199),(0.562374,1.22835,199),(0.598658,1.25059,199),(0.438479,1.19617,199),(0.443788,1.19618,199),(0.444407,1.19938,199),(0.449662,1.19836,199),(0.541634,1.27642,199),(0.434296,1.20108,199),(0.532798,1.26083,199),(0.574732,1.26389,199),(0.619227,1.26089,199),(0.595504,1.26484,199),(0.483546,1.20179,199),(0.55613,1.28301,199),(0.566562,1.29473,199),(0.471821,1.18421,199),(0.454315,1.20094,199),(0.55547,1.26606,199),(0.515654,1.18467,199),(0.567408,1.30102,199),(0.521499,1.2443,199),(0.556933,1.23704,199),(0.487943,1.19796,199),(0.553497,1.29117,199),(0.549139,1.29329,199),(0.563084,1.31191,199),(0.516207,1.23955,199),(0.45649,1.19818,199),(0.551016,1.28256,199),(0.45246,1.19764,199),(0.486034,1.18517,199),(0.597145,1.24887,199),(0.461255,1.18443,199),(0.559965,1.26835,199),(0.533982,1.25611,199),(0.57292,1.23537,199),(0.574235,1.28728,199),(0.55356,1.28078,199),(0.454598,1.20337,199),(0.566788,1.29769,199),(0.456201,1.1916,199),(0.55806,1.26241,199),(0.535234,1.27584,199),(0.494037,1.22401,199),(0.483321,1.20245,199),(0.539016,1.28456,199),(0.586443,1.27528,199),(0.485253,1.19183,199),(0.476264,1.19564,199),(0.507952,1.2274,199),(0.544906,1.29594,199),(0.545493,1.29534,199),(0.474439,1.18595,199),(0.527072,1.16954,199),(0.48148,1.18684,199),(0.528702,1.2509,199),(0.533727,1.1693,199),(0.53698,1.2642,199),(0.580152,1.26128,199),(0.556722,1.27886,199),(0.568766,1.27489,199),(0.566006,1.28417,199),(0.593552,1.24928,199),(0.541343,1.28893,199),(0.563115,1.30312,199),(0.440924,1.10778,199),(0.486194,1.20622,199),(0.529551,1.28084,199),(0.560318,1.2387,199),(0.467308,1.19209,199),(0.593596,1.25313,199),(0.537702,1.28187,199),(0.515819,1.15229,199),(0.45812,1.19397,199),(0.468488,1.18897,199),(0.557857,1.29106,199),(0.482841,1.19314,199),(0.477887,1.18537,199),(0.560251,1.30696,199),(0.55699,1.30058,199),(0.433866,1.2113,199),(0.548862,1.28626,199),(0.524914,1.24254,199),(0.59987,1.28231,199),(0.539171,1.2828,199),(0.591793,1.28095,199),(0.555058,1.29611,199),(0.527012,1.24748,199),(0.465385,1.18685,199),(0.431652,1.21821,199),(0.562844,1.25857,199),(0.489089,1.21386,199),(0.445497,1.20455,199),(0.606953,1.26296,199),(0.526444,1.28401,199),(0.568525,1.24837,199),(0.531279,1.26282,199),(0.490586,1.18727,199),(0.474392,1.18373,199),(0.437085,1.19827,199),(0.446736,1.19462,199),(0.520097,1.16667,199),(0.596937,1.25755,199),(0.59923,1.27758,199),(0.556639,1.2633,199),(0.568687,1.28254,199),(0.551248,1.28609,199),(0.538143,1.2706,199),(0.435327,1.17298,199),(0.568168,1.2778,199),(0.520113,1.25971,199),(0.52122,1.17513,199),(0.530066,1.19726,199),(0.515579,1.25024,199),(0.540376,1.23812,199),(0.480927,1.19056,199),(0.555436,1.27059,199),(0.570764,1.29085,199),(0.569116,1.23764,199),(0.550646,1.29754,199),(0.561238,1.29359,199),(0.582648,1.24509,199),(0.439447,1.21421,199),(0.567729,1.29108,199),(0.566512,1.24752,199),(0.557259,1.22974,199),(0.49833,1.22991,199),(0.44272,1.19227,199),(0.544063,1.29328,199),(0.561813,1.27458,199),(0.526991,1.16925,199),(0.568773,1.30015,199),(0.584976,1.29009,199),(0.564317,1.30111,199),(0.47722,1.19919,199),(0.531788,1.23861,199),(0.586116,1.24703,199),(0.563683,1.26279,199),(0.549788,1.27874,199),(0.450792,1.21086,199),(0.569814,1.27428,199),(0.572729,1.28916,199),(0.498873,1.14174,199),(0.499956,1.23319,199),(0.485962,1.2115,199),(0.522155,1.24201,199),(0.555567,1.28496,199),(0.594459,1.27216,199),(0.472872,1.18218,199),(0.516288,1.26076,199),(0.489831,1.21651,199),(0.543069,1.29934,199),(0.496255,1.21446,199),(0.545021,1.2383,199),(0.434685,1.17081,199),(0.536973,1.29369,199),(0.472288,1.19047,199),(0.49295,1.20746,199),(0.589002,1.28301,199),(0.558059,1.29546,199),(0.531162,1.27496,199),(0.573234,1.24559,199),(0.536398,1.26798,199),(0.561235,1.24371,199),(0.572177,1.26885,199),(0.558107,1.28461,199),(0.506539,1.16224,199),(0.575348,1.2489,199),(0.586279,1.28084,199),(0.517033,1.25518,199),(0.547495,1.29792,199),(0.530698,1.25431,199),(0.465864,1.18007,199),(0.437204,1.07768,199),(0.550962,1.27729,199),(0.453001,1.20233,199),(0.574792,1.28677,199),(0.564813,1.26751,199),(0.545791,1.26237,199),(0.563563,1.26155,199),(0.515161,1.23657,199),(0.54687,1.28165,199),(0.583461,1.25697,199),(0.517388,1.23212,199),(0.514992,1.24301,199),(0.569631,1.29535,199),(0.555111,1.26147,199),(0.493597,1.19448,199),(0.588551,1.27485,199),(0.443181,1.19335,199),(0.536545,1.28846,199),(0.474919,1.19408,199),(0.591826,1.26523,199),(0.594347,1.27698,199),(0.531456,1.28629,199),(0.518576,1.26633,199),(0.531162,1.26885,199),(0.51685,1.27651,199),(0.563378,1.24885,199),(0.593411,1.27294,199),(0.585228,1.24022,199),(0.450523,1.1942,199),(0.55969,1.28605,199),(0.569699,1.30148,199),(0.438455,1.08778,199),(0.568503,1.29292,199),(0.561327,1.29483,199),(0.580423,1.27937,199),(0.543648,1.26862,199),(0.488798,1.20979,199),(0.491119,1.20573,199),(0.431837,1.17959,199),(0.538153,1.25498,199),(0.477373,1.19591,199),(0.509505,1.27154,199),(0.561705,1.31016,199),(0.544187,1.24284,199),(0.556537,1.26387,199),(0.514284,1.27468,199),(0.548324,1.27554,199),(0.559242,1.29607,199),(0.520099,1.25174,199),(0.519223,1.27834,199),(0.555641,1.2468,199),(0.614458,1.25447,199),(0.535308,1.28549,199),(0.569671,1.28669,199),(0.544834,1.2738,199),(0.439051,1.20622,199),(0.445059,1.21417,199),(0.516267,1.25231,199),(0.555585,1.23748,199),(0.524579,1.23281,199),(0.506681,1.20691,199),(0.461785,1.19239,199),(0.573777,1.24913,199),(0.564165,1.29765,199),(0.554862,1.241,199),(0.515879,1.2283,199),(0.466576,1.18292,199),(0.514441,1.18074,199),(0.540423,1.2912,199),(0.554142,1.28805,199),(0.44535,1.21766,199),(0.571073,1.27383,199),(0.520108,1.27176,199),(0.553618,1.27372,199),(0.532907,1.26885,199),(0.56456,1.30387,199),(0.595916,1.25195,199),(0.539719,1.15979,199),(0.574796,1.27162,199),(0.536689,1.27467,199),(0.526508,1.26798,199),(0.565991,1.29788,199),(0.450371,1.19542,199),(0.575534,1.29293,199),(0.566938,1.27251,199),(0.550986,1.26796,199),(0.46353,1.18196,199),(0.563253,1.27242,199),(0.551965,1.24033,199),(0.544543,1.29067,199),(0.457749,1.15735,199),(0.604175,1.25614,199),(0.533777,1.28856,199),(0.575704,1.23225,199),(0.513127,1.25111,199),(0.523575,1.27852,199),(0.430328,1.20146,199),(0.55838,1.30321,199),(0.589452,1.26317,199),(0.52873,1.27537,199),(0.593514,1.25542,199),(0.512859,1.23764,199),(0.593475,1.25884,199),(0.508643,1.24372,199),(0.595975,1.27783,199),(0.533213,1.28091,199),(0.593382,1.25661,199),(0.535387,1.25224,199),(0.477202,1.18738,199),(0.438621,1.20197,199),(0.474951,1.19501,199),(0.594492,1.25649,199),(0.568191,1.27779,199),(0.908423,0.35685,311),(0.912265,0.366282,311),(0.912873,0.369315,311),(0.885286,0.405823,311),(0.924771,0.388217,311),(0.91268,0.368359,311),(0.917917,0.37452,311),(0.913506,0.370744,311),(0.911762,0.366322,311),(0.910703,0.365579,311),(0.872444,0.350196,311),(0.911002,0.369617,311),(0.911581,0.366725,311),(0.910978,0.364498,311),(0.899391,0.349215,311),(0.880478,0.408689,311),(0.872906,0.366292,311),(0.882666,0.378376,311),(0.912665,0.367365,311),(0.934844,0.3663,311),(0.89394,0.396124,311),(0.944428,0.400219,311),(0.911973,0.371214,311),(0.882492,0.369415,311),(0.890771,0.367763,311),(0.882837,0.384903,311),(0.911569,0.366806,311),(0.914671,0.388389,311),(0.932131,0.410192,311),(0.911576,0.353226,311),(0.906783,0.35183,311),(0.892092,0.364278,311),(0.915027,0.399023,311),(0.910498,0.389035,311),(0.864911,0.387561,311),(0.884579,0.379591,311),(0.873386,0.383955,311),(0.873577,0.377147,311),(0.912119,0.369374,311),(0.903459,0.353515,311),(0.90379,0.394735,311),(0.897143,0.369087,311),(0.919832,0.367964,311),(0.897388,0.383438,311),(0.873696,0.392596,311),(0.868912,0.397364,311),(0.925357,0.36443,311),(0.910551,0.36324,311),(0.918453,0.35562,311),(0.935975,0.3807,311),(0.898426,0.374372,311),(0.910789,0.363718,311),(0.908992,0.366937,311),(0.909417,0.37108,311),(0.921577,0.382141,311),(0.888885,0.373243,311),(0.926529,0.376566,311),(0.896675,0.353923,311),(0.938637,0.357691,311),(0.943067,0.392822,311),(0.911428,0.366262,311),(0.863551,0.349629,311),(0.866063,0.361232,311),(0.91508,0.361571,311),(0.881738,0.38641,311),(0.940111,0.371844,311),(0.910947,0.367128,311),(0.926993,0.35577,311),(0.910701,0.376511,311),(0.909644,0.360787,311),(0.877675,0.373918,311),(0.907334,0.397629,311),(0.913168,0.368347,311),(0.906332,0.390597,311),(0.894481,0.393863,311),(0.898151,0.394611,311),(0.928132,0.385008,311),(0.913403,0.36453,311),(0.944675,0.359181,311),(0.914579,0.365239,311),(0.895375,0.399355,311),(0.924869,0.399405,311),(0.873864,0.387971,311),(0.867231,0.379968,311),(0.88985,0.404466,311),(0.888784,0.387935,311),(0.900292,0.37608,311),(0.909208,0.368572,311),(0.893463,0.356153,311),(0.913497,0.369938,311),(0.887855,0.360018,311),(0.943817,0.373069,311),(0.909842,0.367941,311),(0.909964,0.370636,311),(0.883825,0.354381,311),(0.868215,0.374766,311),(0.872948,0.395802,311),(0.886715,0.417003,311),(0.920544,0.41157,311),(0.909384,0.360126,311),(0.936322,0.39192,311),(0.866654,0.369318,311),(0.943143,0.379861,311),(0.943897,0.375167,311);
/*&*/
INSERT INTO `x2_timezone_points` VALUES (0.905782,0.377247,311),(0.93948,0.390337,311),(0.929206,0.352034,311),(0.899876,0.381325,311),(0.873563,0.3737,311),(0.922955,0.359886,311),(0.892616,0.409657,311),(0.880881,0.361612,311),(0.872126,0.359644,311),(0.872124,0.356576,311),(0.882109,0.396574,311),(0.920925,0.40468,311),(0.912675,0.36539,311),(0.927352,0.404044,311),(0.913178,0.366031,311),(0.908136,0.403459,311),(0.912015,0.364921,311),(0.946903,0.363171,311),(0.939741,0.401073,311),(0.867172,0.334971,311),(0.873454,0.326387,311),(0.931368,0.297418,311),(0.892323,0.277853,311),(0.906445,0.270638,311),(0.892726,0.261945,311),(0.905051,0.338703,311),(0.900575,0.330561,311),(0.881176,0.338887,311),(0.901324,0.264195,311),(0.86043,0.348173,311),(0.900897,0.267295,311),(0.878336,0.327873,311),(0.882957,0.293432,311),(0.913246,0.30657,311),(0.891863,0.297288,311),(0.87273,0.322398,311),(0.918884,0.332796,311),(0.893975,0.324101,311),(0.953049,0.318271,311),(0.929874,0.287477,311),(0.886128,0.284215,311),(0.921681,0.30019,311),(0.870629,0.340216,311),(0.867804,0.328156,311),(0.952609,0.294296,311),(0.875059,0.331026,311),(0.907841,0.322895,311),(0.875445,0.33981,311),(0.925734,0.287216,311),(0.925264,0.324599,311),(0.944091,0.327736,311),(0.88044,0.329195,311),(0.93738,0.291459,311),(0.932511,0.253998,311),(0.918253,0.28934,311),(0.940916,0.248659,311),(0.877837,0.330168,311),(0.911891,0.271112,311),(0.932172,0.321968,311),(0.88767,0.284981,311),(0.938545,0.275356,311),(0.887391,0.28778,311),(0.914778,0.29819,311),(0.909031,0.27271,311),(0.881578,0.319405,311),(0.889466,0.285362,311),(0.941849,0.323346,311),(0.930901,0.26267,311),(0.911558,0.301526,311),(0.909119,0.296969,311),(0.877671,0.333425,311),(0.950189,0.323934,311),(0.926486,0.318099,311),(0.950577,0.297207,311),(0.913695,0.254131,311),(0.872232,0.346076,311),(0.922525,0.343291,311),(0.900517,0.326904,311),(0.878379,0.332119,311),(0.926177,0.338758,311),(0.873687,0.321438,311),(0.87436,0.323615,311),(0.952442,0.320931,311),(0.877175,0.329105,311),(0.953042,0.320219,311),(0.900755,0.294237,311),(0.87965,0.329908,311),(0.89129,0.339375,311),(0.873541,0.322472,311),(0.874269,0.317986,311),(0.879646,0.325213,311),(0.872322,0.330807,311),(0.947054,0.325264,311),(0.878271,0.306735,311),(0.914673,0.295483,311),(0.898913,0.28052,311),(0.934661,0.254326,311),(0.917115,0.343941,311),(0.905762,0.310415,311),(0.897195,0.343886,311),(0.927668,0.29213,311),(0.8793,0.33033,311),(0.901715,0.337804,311),(0.906932,0.336698,311),(0.873264,0.335284,311),(0.90155,0.310788,311),(0.937184,0.348453,311),(0.875386,0.32776,311),(0.8843,0.313287,311),(0.877574,0.341474,311),(0.893842,0.30351,311),(0.889186,0.301813,311),(0.91887,0.293461,311),(0.88065,0.30217,311),(0.880934,0.302542,311),(0.913148,0.281494,311),(0.936794,0.263829,311),(0.904139,0.274314,311),(0.882789,0.288008,311),(0.891443,0.309322,311),(0.927505,0.30721,311),(0.882704,0.337278,311),(0.876285,0.334522,311),(0.869764,0.347989,311),(0.87565,0.329939,311),(0.915331,0.271888,311),(0.943105,0.332077,311),(0.913628,0.294833,311),(0.88434,0.326104,311),(0.897115,0.282769,311),(0.892215,0.26682,311),(0.909441,0.34811,311),(0.903208,0.339757,311),(0.874479,0.337122,311),(0.904785,0.289287,311),(0.893784,0.282078,311),(0.875154,0.333907,311),(0.908611,0.335098,311),(0.951889,0.309798,311),(0.875274,0.328858,311),(0.900425,0.33393,311),(0.937677,0.330411,311),(0.911597,0.337967,311),(0.902312,0.30434,311),(0.880958,0.313555,311),(0.874119,0.347611,311),(0.94587,0.282258,311),(0.917819,0.255683,311),(0.944612,0.313831,311),(0.909112,0.290574,311),(0.903169,0.337296,311),(0.91147,0.318544,311),(0.945543,0.271982,311),(0.911066,0.325306,311),(0.876499,0.325516,311),(0.889643,0.317967,311),(0.880255,0.290797,311),(0.870608,0.33551,311),(0.87877,0.318105,311),(0.877175,0.332093,311),(0.948311,0.317604,311),(0.886333,0.279783,311),(0.903401,0.315748,311),(0.888368,0.274523,311),(0.890485,0.302308,311),(0.876247,0.336412,311),(0.891014,0.282629,311),(0.871887,0.324191,311),(0.907094,0.305477,311),(0.921514,0.318765,311),(0.935427,0.341535,311),(0.906691,0.257059,311),(0.92943,0.252869,311),(0.94102,0.265295,311),(0.933474,0.327313,311),(0.915065,0.339675,311),(0.90552,0.29692,311),(0.920431,0.265792,311),(0.934867,0.258807,311),(0.916905,0.306874,311),(0.878163,0.3034,311),(0.906954,0.344103,311),(0.9017,0.280727,311),(0.877859,0.325968,311),(0.951534,0.323442,311),(0.948622,0.325441,311),(0.927611,0.317133,311),(0.945134,0.338748,311),(0.885374,0.290622,311),(0.878218,0.335756,311),(0.886565,0.333778,311),(0.875284,0.325986,311),(0.87817,0.332978,311),(0.871154,0.331696,311),(0.868325,0.325192,311),(0.875029,0.338629,311),(0.927975,0.269139,311),(0.878002,0.331162,311),(0.937164,0.306428,311),(0.924938,0.295306,311),(0.928247,0.324713,311),(0.931108,0.321579,311),(0.945455,0.305291,311),(0.878739,0.33044,311),(0.92718,0.314292,311),(0.887688,0.304864,311),(0.929557,0.338533,311),(0.949105,0.345917,311),(0.894729,0.271743,311),(0.885844,0.28283,311),(0.888503,0.261037,311),(0.874235,0.333234,311),(0.869566,0.33243,311),(0.884721,0.290126,311),(0.942599,0.279035,311),(0.896555,0.337838,311),(0.878356,0.333806,311),(0.870133,0.337518,311),(0.904424,0.336916,311),(0.910198,0.367399,311),(0.912012,0.367125,311),(0.911834,0.368011,311),(0.89049,0.30223,311),(0.816481,-0.980386,125),(-0.437484,-2.2707,339),(0.32162,-1.17206,141),(0.322405,-1.16441,141),(0.322022,-1.16132,141),(0.321115,-1.15464,141),(0.318245,-1.15276,141),(0.321212,-1.15556,141),(0.320805,-1.15117,141),(0.321862,-1.15398,141),(0.316112,-1.15481,141),(0.319845,-1.14585,141),(0.313882,-1.1539,141),(0.320398,-1.15385,141),(0.316772,-1.1489,141),(0.322012,-1.15509,141),(0.32162,-1.16051,141),(0.317669,-1.17181,141),(0.314353,-1.16263,141),(0.322298,-1.15376,141),(0.320349,-1.15205,141),(0.321915,-1.15868,141),(0.314769,-1.16675,141),(0.546061,0.597941,187),(0.548882,0.600262,187),(0.546989,0.598757,187),(0.550253,0.60185,187),(0.549779,0.601557,187),(0.548345,0.599526,187),(0.550589,0.602054,187),(0.550395,0.602763,187),(0.547045,0.599056,187),(0.548722,0.600447,187),(0.546622,0.599347,187),(0.548835,0.612513,189),(0.563922,0.611365,189),(0.564106,0.617321,189),(0.55115,0.613312,189),(0.556805,0.614278,189),(0.561816,0.610353,189),(0.565667,0.615767,189),(0.562364,0.615306,189),(0.566524,0.616116,189),(0.550804,0.610418,189),(0.55118,0.612642,189),(0.549914,0.611376,189),(0.553354,0.614422,189),(0.553539,0.614144,189),(0.550056,0.61373,189),(0.562207,0.61585,189),(0.548202,0.610399,189),(0.547976,0.612019,189),(0.555878,0.614953,189),(0.556178,0.618719,189),(0.566981,0.614881,189),(0.550291,0.612502,189),(0.556935,0.614643,189),(0.554505,0.615563,189),(0.547578,0.599361,187),(0.548723,0.600053,187),(0.554724,0.614947,189),(0.679897,-0.156899,280),(0.678426,-0.15827,280),(0.682268,-0.161593,280),(0.691185,-0.146769,280),(0.677205,-0.163682,280),(0.670983,-0.158851,280),(0.672378,-0.155128,280),(0.677569,-0.158664,280),(0.675464,-0.162797,280),(0.684751,-0.151553,280),(0.677996,-0.158606,280),(0.677048,-0.158965,280),(0.676744,-0.162797,280),(0.677229,-0.160433,280),(0.67643,-0.161522,280),(0.646984,-0.141383,280),(0.678253,-0.158206,280),(0.64819,-0.149012,280),(0.685806,-0.129699,280),(0.676624,-0.160559,280),(0.696679,-0.150595,280),(0.674239,-0.155574,280),(0.674861,-0.159698,280),(0.686888,-0.163731,280),(0.675317,-0.16326,280),(0.673156,-0.155356,280),(0.675367,-0.162166,280),(0.646271,-0.136853,280),(0.67706,-0.160288,280),(0.67556,-0.156624,280),(0.675491,-0.164341,280),(0.688742,-0.15205,280),(0.674583,-0.156912,280),(0.693728,-0.155898,280),(0.677727,-0.16002,280),(0.648175,-0.13997,280),(0.675733,-0.159407,280),(0.675695,-0.161307,280),(0.693657,-0.153712,280),(0.646964,-0.136026,280),(0.647552,-0.151394,280),(0.569559,-0.294961,247),(0.64611,-0.138444,280),(0.673115,-0.137881,280),(0.675542,-0.164021,280),(0.688823,-0.147771,280),(0.674483,-0.15967,280),(0.674056,-0.160422,280),(0.695028,-0.13074,280),(0.675406,-0.164435,280),(0.675915,-0.161386,280),(0.675286,-0.162702,280),(0.674861,-0.16057,280),(0.67725,-0.159315,280),(0.569559,-0.296124,247),(0.687717,-0.159495,280),(0.676611,-0.162279,280),(0.67679,-0.161631,280),(0.674799,-0.158343,280),(0.673988,-0.158825,280),(0.674214,-0.159097,280),(0.676382,-0.161108,280),(0.675076,-0.159818,280),(0.675485,-0.161083,280),(0.67603,-0.164223,280),(0.647311,-0.143995,280),(0.709669,-0.13805,280),(0.720832,-0.135161,280),(0.717461,-0.150034,280),(0.717917,-0.150402,280),(0.721778,-0.152601,280),(0.727684,-0.154163,280),(0.718989,-0.148532,280),(0.707795,-0.126116,280),(0.718838,-0.151001,280),(0.718292,-0.148425,280),(0.719083,-0.150142,280),(0.71388,-0.148173,280),(0.718772,-0.149367,280),(0.722277,-0.152954,280),(0.718196,-0.15029,280),(0.728975,-0.149818,280),(0.722759,-0.152698,280),(0.713117,-0.150537,280),(0.717761,-0.14983,280),(0.734416,-0.148017,284),(0.718763,-0.151653,280),(0.719699,-0.150446,280),(0.71933,-0.150334,280),(0.718919,-0.151848,280),(0.708602,-0.151273,280),(0.723342,-0.144796,280),(0.718108,-0.148915,280),(0.714282,-0.149099,280),(0.718567,-0.148802,280),(0.723513,-0.142559,280),(0.724942,-0.153275,280),(0.724893,-0.153298,280),(0.719455,-0.149306,280),(0.717423,-0.127775,280),(0.703124,-0.130969,280),(0.701721,-0.146949,280),(0.71775,-0.150989,280),(0.729649,-0.117935,280),(0.72519,-0.146958,280),(0.721515,-0.149257,280),(0.724988,-0.150361,280),(0.71897,-0.149074,280),(0.709376,-0.150893,280),(0.719261,-0.149864,280),(0.658571,-0.447968,242),(0.130907,2.34962,338),(-0.449956,-0.985214,70),(-0.442748,-1.00518,70),(-0.442261,-1.00372,70),(-0.443685,-1.00439,70),(-0.445641,-0.953241,70),(-0.468949,-1.01741,70),(-0.443225,-1.00419,70),(-0.439231,-1.00331,70),(-0.442385,-1.00542,70),(-0.443023,-1.00066,70),(-0.444768,-1.00095,70),(-0.441971,-1.00427,70),(-0.477008,-0.975057,70),(-0.444089,-0.985069,70),(-0.408504,-1.00252,70),(-0.439241,-1.00444,70),(-0.442532,-1.00261,70),(-0.444186,-0.977675,70),(-0.443071,-0.997286,70),(-0.44158,-1.00594,70),(0.443609,0.897167,220),(0.441428,0.897526,220),(0.439326,0.900649,220),(0.448268,0.898946,220),(0.441207,0.899236,220),(-0.372441,0.968276,324),(-0.366687,0.964656,324),(-0.371508,0.967109,324),(-0.369496,0.964962,324),(-0.373123,0.970738,324),(-0.364881,0.970558,324),(-0.364719,0.969523,324),(-0.364465,0.967792,324),(-0.367183,0.972486,324),(-0.365879,0.971281,324),(-0.37146,0.968972,324),(-0.365425,0.965026,324),(-0.365279,0.96578,324),(-0.370352,0.965431,324),(0.762127,0.442732,267),(0.823795,0.402298,267),(0.792089,0.40608,267),(0.77609,0.456113,267),(0.832813,0.426442,267),(0.826413,0.442732,267),(0.813905,0.484038,267),(0.780453,0.464839,267),(0.763582,0.434005,267),(0.812742,0.415097,267),(0.788307,0.502655,267),(0.802851,0.456113,267),(0.823795,0.460185,267),(0.812319,0.428609,267),(0.786271,0.406371,267),(0.784097,0.444303,267),(0.798553,0.370459,267),(0.800229,0.478821,267),(0.831358,0.458149,267),(0.775508,0.425279,267),(0.824377,0.397935,267),(0.83657,0.41689,267),(0.799361,0.421497,267),(0.800524,0.450004,267),(0.802092,0.411392,267),(0.834267,0.399389,267),(0.816814,0.377864,267),(0.796174,0.44845,267),(0.769981,0.436041,267),(0.81885,0.469785,267),(0.795579,0.444186,267),(0.787143,0.425279,267),(0.792089,0.472112,267),(0.790649,0.382038,267),(0.816523,0.431387,267),(0.83514,0.452331,267),(0.774635,0.456695,267),(0.784526,0.454077,267),(0.78278,0.434005,267),(0.81885,0.459603,267),(0.79267,0.407825,267),(0.793252,0.408698,267),(0.775799,0.457276,267),(0.799942,0.404916,267),(0.821468,0.382809,267),(0.769399,0.464839,267),(0.808087,0.441568,267),(0.809542,0.416261,267),(0.773472,0.499164,267),(0.781966,0.400936,267),(0.785102,0.447575,267),(0.811146,0.462321,267),(0.785689,0.46164,267),(0.80896,0.450295,267),(0.80576,0.424988,267),(0.772308,0.493637,267),(0.826413,0.38979,267),(0.764454,0.498873,267),(0.791686,0.405585,267),(0.797417,0.38228,267),(0.811287,0.420624,267),(0.823214,0.481711,267),(0.814608,0.48973,267),(0.798488,0.39968,267),(0.829904,0.45204,267),(0.765909,0.453204,267),(0.820886,0.417425,267),(0.815469,0.446814,267),(0.793252,0.489565,267),(0.780453,0.441859,267),(0.797615,0.474439,267),(0.777544,0.410443,267),(0.774635,0.485783,267),(0.828159,0.459022,267),(0.800233,0.435751,267),(0.778974,0.395424,267),(0.779289,0.423533,267),(0.836885,0.460767,267),(0.800815,0.39968,267),(0.822923,0.416552,267),(0.787741,0.430644,267),(0.799998,0.407883,267),(0.773472,0.415388,267),(0.764163,0.427606,267),(0.771145,0.500037,267),(0.810205,0.461403,267),(0.797615,0.444186,267),(0.816232,0.411898,267),(0.797906,0.421497,267),(0.829613,0.446223,267),(0.812451,0.416843,267),(0.774344,0.488983,267),(0.832231,0.392117,267),(0.79267,0.387754,267),(0.769981,0.424988,267),(0.76779,0.400253,267),(0.788016,0.46833,267),(0.81536,0.466003,267),(0.777743,0.452894,267),(0.775489,0.45564,267),(0.788598,0.447968,267),(0.796719,0.446911,267),(0.790052,0.488401,267),(0.805179,0.397644,267),(0.833395,0.465421,267),(0.831741,0.430455,267),(0.791914,0.378897,267),(0.805907,0.417409,267),(0.822629,0.427608,267),(0.806924,0.482874,267),(0.774054,0.420624,267),(0.768236,0.407534,267),(0.78598,0.451168,267),(0.831857,0.413506,267),(0.831777,0.411341,267),(0.812742,0.469494,267),(0.806051,0.372046,267),(0.767654,0.44215,267),(0.804015,0.411607,267),(0.808263,0.414014,267),(0.804597,0.474148,267),(0.831707,0.41154,267),(0.824614,0.466403,267),(0.792093,0.355732,263),(0.782659,0.356067,263),(0.766262,0.388581,263),(0.787434,0.371818,263),(0.742662,0.382232,263),(0.761259,0.366563,263),(0.785136,0.351873,263),(0.779753,0.355913,263),(0.774324,0.365801,263),(0.779513,0.365297,263),(0.801586,0.350414,263),(0.754579,0.376783,263),(0.778789,0.369797,263),(0.753163,0.394202,263),(0.783144,0.360241,263),(0.779374,0.352559,263),(0.752877,0.358006,263),(0.784415,0.352894,263),(0.756159,0.382285,263),(0.771896,0.393237,263),(0.750458,0.383032,263),(0.77467,0.353529,263),(0.760615,0.372347,263),(0.76316,0.361099,263),(0.768236,0.365065,263),(0.799879,0.357187,263),(0.767546,0.371078,263),(0.786239,0.350491,263),(0.768399,0.357121,263),(0.768638,0.372041,263),(0.76668,0.372977,263),(0.766049,0.35517,263),(0.769252,0.385646,263),(0.781977,0.357184,263),(0.796155,0.349647,263),(0.773302,0.35884,263),(0.795371,0.342797,263),(0.772747,0.347289,263),(0.765477,0.346427,263),(0.804597,0.343248,263),(0.784986,0.342298,263),(0.79891,0.333571,263),(0.780977,0.343655,263),(0.785539,0.345963,263),(0.789791,0.34622,263),(0.799625,0.34264,263),(0.789776,0.338453,263),(0.797111,0.331346,263),(0.760376,0.388458,263),(1.01019,0.610734,289),(0.948651,0.73164,289),(0.838126,0.700275,289),(0.972742,0.643314,289),(0.962918,1.0411,240),(0.822877,0.741278,289),(0.970321,0.665324,289),(0.934344,0.588664,289),(0.889847,0.781444,310),(0.932001,0.863856,296),(0.904929,0.723623,289),(0.770379,0.750836,289),(0.913348,0.617342,289),(0.972916,0.663519,289),(0.817603,0.703513,289),(0.775047,0.76586,289),(0.977079,0.648938,289),(0.974657,0.846796,289),(0.765467,0.725872,289),(0.988563,0.757376,289),(0.928577,0.788754,289),(0.955751,0.678556,289),(1.21153,0.537798,289),(0.965507,0.908783,289),(0.98617,0.692531,289),(0.988533,0.835852,289),(0.815165,0.668006,289),(0.768517,0.74842,289),(0.768721,0.748058,289),(0.896249,0.842586,310),(1.0924,0.887664,289),(0.786174,0.677114,289),(0.918456,0.671981,289),(0.889228,0.763369,310),(0.973218,0.908704,289),(0.966613,0.681243,289),(0.812724,0.709585,289),(0.927609,0.664957,289),(0.890699,1.045,240),(0.95087,0.657964,289),(0.961095,0.57066,289),(1.00583,0.695927,289),(1.00013,0.83577,310),(0.982186,0.958776,240),(0.785206,0.679688,289),(1.00516,0.603265,289),(0.795543,0.692269,289),(0.965473,0.736083,289),(1.05955,0.501832,289),(0.981583,0.735755,289),(0.963603,0.598562,289),(0.981329,0.891262,310),(1.04755,0.534719,289),(0.995687,0.942254,296),(0.966901,0.659879,289),(0.96547,0.674616,289),(0.901847,0.683895,289),(0.851473,0.781554,310),(0.975052,0.844031,289),(0.908364,0.826936,310),(0.977971,0.627785,289),(1.03356,0.696187,289),(1.0459,0.564408,289),(1.00251,0.7183,289),(0.850314,0.776704,310),(0.829269,0.735681,289),(0.970403,0.649553,289),(0.979768,0.705053,289),(0.751132,0.7796,289),(0.969572,0.658158,289),(0.998551,0.731819,289),(1.01367,0.953922,240),(0.948679,0.66791,289),(1.06587,0.734754,289),(1.06049,0.808323,289),(0.983319,0.533114,289),(0.876216,0.665087,289),(1.01185,0.580366,289),(0.94216,0.666213,289),(0.907307,0.737602,289),(0.994677,0.910803,296),(0.789139,0.692727,289),(0.958825,1.01536,240),(0.7694,0.732625,289),(0.908385,0.693398,289),(0.886709,0.733279,310),(0.752736,0.794876,289),(0.922335,0.570268,289),(0.948207,0.844505,289),(1.10945,0.936953,289),(1.00404,0.669014,289),(0.956182,0.978181,240),(0.766859,0.741969,289),(0.947707,1.03763,240),(0.757172,0.749066,289),(0.992403,0.626155,289),(0.953066,0.937411,240),(1.01029,0.690114,289),(0.946006,0.657017,289),(0.970422,0.636488,289),(0.769783,0.682078,289),(0.831581,0.734817,289),(0.917691,0.5893,289),(0.755825,0.78503,289),(0.968396,0.651136,289),(1.03917,0.538914,289),(0.995599,0.610206,289),(0.971384,0.662302,289),(0.93428,0.861252,296),(0.796166,0.679723,289),(1.041,0.585198,289),(0.800316,0.700318,289),(0.992359,0.707503,289),(0.758927,0.77032,289),(0.79012,0.652529,289),(0.791739,0.701448,289),(0.920342,0.723321,289),(0.975773,0.941352,240),(0.824427,0.678879,289),(0.927791,0.845928,296),(1.07646,0.886801,289),(0.768391,0.751369,289),(1.06661,0.503758,289),(0.954259,0.351417,278),(0.79125,0.747956,289),(0.771263,0.744549,289),(0.944612,0.636985,289),(0.848358,0.747807,310),(0.753764,0.783687,289),(0.944221,0.616844,289),(0.9582,0.664461,289),(0.984075,0.673115,289),(0.886373,0.63675,289),(0.935926,0.976514,240),(0.786145,0.732574,289),(0.895296,0.660462,289),(0.813866,0.674992,289),(0.812102,0.681546,289),(0.917772,0.571828,289),(1.01219,0.547349,289),(0.974033,0.666375,289),(1.00504,0.854486,310),(0.961396,0.381852,278),(1.04545,0.507642,289),(1.11007,0.940414,289),(1.07696,0.535673,289),(0.915142,0.927787,240),(0.980584,0.645481,289),(0.892965,0.959787,240),(1.04077,0.990797,240),(1.0378,0.700236,289),(0.980002,0.662643,289),(0.760949,0.693344,289),(0.977132,0.698326,289),(0.956123,0.559205,289),(1.02507,0.875758,310),(0.789863,0.665417,289),(1.03181,0.490287,289),(0.939421,0.690287,289),(0.976478,0.650969,289),(0.959809,1.00702,240),(0.920104,1.02391,240),(0.992196,0.722363,289),(1.04387,0.53026,289),(0.968666,0.810058,289),(0.787638,0.733484,289),(0.94807,0.713386,289),(1.03341,0.672138,289),(0.879815,0.644264,289),(0.905399,0.644102,289),(0.968653,0.655541,289),(0.975517,0.664248,289),(0.942567,0.654881,289),(0.969924,0.690048,289),(1.01873,0.794397,289),(1.00663,0.813522,289),(0.832681,0.701874,289),(0.782851,0.675039,289),(0.943085,0.670236,289),(1.04987,1.04636,240),(1.20548,0.583223,289),(1.12685,0.695168,289),(1.04891,0.522967,289),(1.04972,0.527118,289),(0.958461,0.652948,289),(0.98262,0.665552,289),(0.969195,0.793533,289),(0.915575,0.77173,289),(0.902078,0.681165,289),(0.82937,0.71229,289),(0.991129,0.776549,289),(0.931453,0.595215,289),(1.1125,0.599035,289),(0.960673,1.03044,240),(0.958811,0.756138,289),(0.899552,0.803002,310),(0.985698,0.938949,296),(0.945686,0.788451,289),(0.903847,0.903847,240),(1.04536,0.528209,289),(0.928516,0.875283,296),(0.811137,0.72503,289),(0.93172,0.975774,240),(0.962549,0.57974,289),(0.981964,0.59914,289),(0.955179,0.689707,289),(1.01307,0.677931,289),(0.937308,0.700067,289),(0.953419,0.692749,289),(0.943593,0.784541,289),(0.973634,0.651964,289),(0.912116,0.764235,310),(0.824343,0.693302,289),(0.998178,0.687903,289),(0.892228,0.672154,289),(0.876125,0.690579,289),(0.941654,0.573583,289),(0.971599,0.695948,289),(0.996673,0.728334,289),(0.991364,1.04598,240),(0.973215,0.660738,289),(0.881992,0.640267,289),(0.943626,0.959003,240),(0.91902,0.731024,289),(0.768793,0.751529,289),(0.977685,0.660898,289),(1.04174,0.529541,289),(0.957029,0.656442,289),(1.00904,0.494794,289),(0.957631,0.649539,289),(0.815119,0.728276,289),(0.763711,0.768463,289),(0.940732,0.941314,240),(0.897264,0.803695,310),(1.00159,0.720588,289),(1.06534,0.525851,289),(0.803719,0.666274,289),(0.902057,0.681947,289),(0.893513,0.737327,289),(1.17576,0.567198,289),(1.20775,0.583774,289),(0.975953,0.683688,289),(0.93641,0.909794,296),(1.0631,0.59639,289),(0.967334,0.655454,289),(0.923866,0.58375,289),(0.937407,0.650867,289),(1.03879,0.596316,289),(0.9761,0.688725,289),(1.07835,0.599467,289),(0.912919,0.792234,310),(1.0451,0.521898,289),(1.04516,0.521853,289),(1.02266,0.62487,289),(0.993185,1.04621,240),(1.01259,0.982368,240),(0.990288,0.67817,289),(0.928527,0.785479,289),(1.13703,0.998754,289),(0.973557,0.674648,289),(0.805255,0.694348,289),(0.880654,0.700018,289),(0.785824,0.682542,289),(0.873537,0.818268,310),(0.957487,0.672835,289),(0.931586,0.896143,296),(1.04331,0.537877,289),(0.77481,0.72467,289),(1.00084,0.494865,289),(0.887786,0.681998,289),(0.997398,0.577835,289),(0.999777,0.96794,240),(0.893694,1.02218,240),(0.81806,0.734071,289),(0.903604,0.961655,240),(0.924415,0.629689,289),(0.974011,0.680011,289),(0.756096,0.78631,289),(1.11537,0.665675,289),(1.02398,0.910943,310),(1.18932,0.580372,289),(0.754646,0.802881,289),(0.950881,0.933246,240),(0.971764,0.650619,289),(1.01038,0.955048,240),(0.961621,0.638966,289),(1.01131,0.965858,240),(1.07627,0.701645,289),(0.949942,0.886716,289),(0.885987,0.660852,289),(0.916989,0.55724,289),(0.895479,0.684471,289),(0.880679,0.840255,310),(0.945089,0.844549,289),(0.893661,1.01799,240),(0.789544,0.68034,289),(0.833576,0.696968,289),(0.780588,0.659168,289),(0.802003,0.710359,289),(0.767285,0.76156,289),(0.942661,0.668192,289),(0.943148,0.693732,289),(0.926698,0.871726,296),(0.78744,0.716051,289),(1.12428,0.712307,289),(0.827638,0.699726,289),(0.979321,0.82864,289),(0.881892,0.744814,310),(0.794034,0.719438,289),(1.02131,0.545997,289),(0.901319,0.68781,289),(0.975054,0.670971,289),(1.02327,1.04391,240),(1.01088,1.04659,240),(0.983121,0.767981,289),(0.934282,0.762301,289),(0.971041,0.904508,289),(0.937571,0.804094,289),(0.873158,0.793418,310),(1.21148,0.527473,289),(0.770005,0.757521,289),(0.778998,0.732068,289),(0.97775,0.52235,289),(0.754656,0.786276,289),(1.00285,0.708162,289),(0.981243,0.572073,289),(0.97899,0.947122,240),(0.921569,0.893015,296),(0.754438,0.781297,289),(0.969427,0.736473,289),(1.18109,0.926542,289),(0.760222,0.765341,289),(0.966695,0.641113,289),(0.759184,0.761293,289),(0.974741,0.648876,289),(0.972593,0.914748,289),(0.975842,0.658526,289),(0.969967,0.733782,289),(1.20391,0.577573,289),(0.929852,0.638325,289),(0.985146,0.911544,296),(0.968692,0.628794,289),(0.76347,0.77932,289),(0.775139,0.711983,289),(0.97306,0.656515,289),(0.932766,0.729734,289),(0.843954,0.730006,289),(0.974634,0.666604,289),(1.18577,0.573758,289),(1.07046,0.777299,289),(0.771615,0.752853,289),(0.853861,0.705056,289),(0.873712,0.754644,310),(0.923241,0.706696,289),(1.04372,0.533159,289),(0.972621,0.926815,289),(0.975782,0.912641,289),(0.924443,0.97593,240),(0.965766,0.726572,289),(1.09811,0.601386,289),(0.793279,0.681112,289),(0.988448,0.834338,289),(0.897323,1.00522,240),(0.778553,0.699979,289),(0.902529,0.815917,310),(1.01803,0.78128,289),(0.960185,0.636554,289),(0.759378,0.778296,289),(0.971237,0.663659,289),(0.750079,0.829073,289),(0.932331,1.03057,240),(0.940146,0.601227,289),(0.97175,0.661361,289),(0.970101,0.66157,289),(1.01419,1.00889,240),(0.977957,0.786135,289),(0.959523,0.681453,289),(1.02516,0.520898,289),(0.975108,0.666727,289),(1.04556,0.519629,289),(1.05987,0.585611,289),(0.977554,0.654183,289),(0.914995,0.656364,289),(0.88984,0.689675,289),(0.918097,0.69064,289),(0.972293,0.679879,289),(0.901126,0.615709,289),(0.769807,0.750026,289),(0.850016,0.788854,310),(0.952994,0.915615,289),(0.808461,0.687445,289),(0.976221,0.660316,289),(0.925363,0.683582,289),(0.766354,0.686462,289),(0.977721,0.697232,289),(0.779013,0.71097,289),(0.762054,0.759863,289),(0.927062,0.81333,289),(0.898462,1.00104,240),(1.01736,1.04299,240),(0.812624,0.691711,289),(0.965836,1.03743,240),(0.902987,0.631588,289),(0.970086,0.679281,289),(0.783304,0.708579,289),(0.901639,0.622247,289),(0.754014,0.804389,289),(1.00246,0.994127,240),(0.920952,0.973603,240),(0.967145,0.742332,289),(0.980622,0.888275,289),(1.02997,0.953919,240),(0.759139,0.696263,289),(0.970047,0.640604,289),(0.979956,0.771398,289),(0.784165,0.663071,289),(0.793034,0.708177,289),(1.04712,0.519527,289),(0.835877,0.69936,289),(1.04263,0.52516,289),(1.05432,0.996269,240),(0.987958,1.00822,240),(1.01368,0.973112,240),(0.800164,0.724641,289),(0.974249,0.651534,289),(0.78625,0.680198,289),(0.791789,0.66692,289),(0.97913,0.665552,289),(0.890535,0.797562,310),(0.983352,0.812687,289),(0.943132,0.624332,289),(0.943154,0.766441,289),(0.983619,0.721156,289),(1.17925,0.531902,289),(0.91781,0.724348,289),(0.878269,0.781928,310),(1.06914,0.81419,289),(0.831302,0.752947,310),(0.971022,0.660511,289),(1.01768,0.843832,310),(1.00822,0.714308,289),(1.12698,0.533664,289),(0.944554,0.655277,289),(1.07014,0.823257,289),(0.793584,0.688556,289),(0.830476,0.717195,289),(0.956552,0.627058,289),(1.08569,0.597974,289),(0.989602,0.641699,289),(1.04058,0.530406,289),(1.04285,0.533871,289),(0.961318,0.67681,289),(0.982608,0.687364,289),(0.993701,0.717182,289),(0.920839,0.562683,289),(0.983202,0.641118,289),(0.966276,0.655019,289),(0.765277,0.815321,289),(0.754104,0.817999,289),(1.03057,1.00614,240),(0.766432,0.745619,289),(0.98005,0.678149,289),(0.919002,0.745646,289),(1.1801,0.5877,289),(1.04512,0.540966,289),(1.02196,0.87336,310),(1.0227,0.866732,310),(0.943645,0.59864,289),(1.03755,0.558863,289),(0.941319,0.661967,289),(1.03626,0.499399,289),(1.0025,0.735289,289),(0.933238,0.898396,296),(0.928964,0.883644,296),(0.992511,0.651881,289),(0.941983,0.672508,289),(0.98187,0.663146,289),(0.759477,0.695832,289),(0.782727,0.669945,289),(0.975587,0.653271,289),(0.754871,0.813108,289),(0.827628,0.824786,310),(0.775376,0.690037,289),(0.973697,0.857343,289),(0.955621,1.0157,240),(0.748426,0.831461,289),(0.958903,0.722484,289),(0.957216,0.666139,289),(1.00111,0.656384,289),(0.92717,0.610606,289),(0.764,0.731541,289),(0.755791,0.78359,289),(0.982911,0.675442,289),(0.754443,0.779081,289),(0.804333,0.679973,289),(1.1722,0.565701,289),(0.968826,0.828879,289),(0.80477,0.839043,310),(0.874381,0.792659,310),(0.843305,0.702661,289),(0.951716,0.633126,289),(0.898845,0.776249,310),(0.975886,0.660181,289),(0.954808,0.357984,278),(0.849818,0.759679,310),(0.880096,0.716041,289),(1.02451,1.03819,240),(0.992216,0.928593,296),(0.742979,0.835393,289),(0.97688,0.661843,289),(0.994789,0.715086,289),(0.975988,0.64348,289),(0.932956,0.978109,240),(0.797931,0.748809,289),(0.939977,0.809069,289),(0.769562,0.752082,289),(0.782644,0.673119,289),(1.00452,0.925974,296),(0.970597,0.709509,289),(0.952814,0.387458,278),(0.791574,0.710256,289),(0.838684,0.696929,289),(0.756721,0.804689,289),(0.895034,0.655298,289),(1.02693,1.00449,240),(1.02765,0.702539,289),(0.916238,0.697013,289),(0.755873,0.79762,289),(0.89811,0.732626,289),(0.778955,0.682947,289),(0.768357,0.752101,289),(0.8518,0.776225,310),(0.988815,0.758742,289),(0.970565,0.64546,289),(1.01472,0.919055,296),(0.782991,0.699387,289),(0.770597,0.75869,289),(0.777757,0.664705,289),(0.898262,1.02024,240),(1.00011,0.695571,289),(1.0398,0.525839,289),(1.0189,0.739083,289),(0.969581,0.610784,289),(0.999264,0.717479,289),(0.976696,0.66402,289),(0.972728,0.671334,289),(0.868674,0.762049,310),(1.07884,0.885377,289),(0.898563,0.804689,310),(0.784126,0.679082,289),(0.808223,0.77241,289),(0.972575,0.666874,289),(0.973712,0.671022,289),(0.975365,0.67695,289),(0.754196,0.78231,289),(0.970917,0.660721,289),(0.981598,0.75844,289),(0.968502,0.957642,240),(0.935458,0.599316,289),(0.856228,0.782414,310),(0.990183,0.648681,289),(0.793343,0.732586,289),(0.941973,0.669094,289),(0.843583,0.69722,289),(0.967633,0.658926,289),(0.975711,0.655557,289),(1.0204,0.984587,240),(0.983493,0.654789,289),(0.801261,0.756683,289),(0.7892,0.684664,289),(0.94621,0.866004,289),(0.945109,0.580872,289),(0.734222,0.842817,289),(0.975091,0.647905,289),(0.946343,0.96053,240),(0.929415,0.683393,289),(1.01562,0.701129,289),(0.735061,0.84111,289),(1.01755,1.00903,240),(1.03178,0.552978,289),(0.966269,0.883877,289),(0.952539,0.966501,240),(0.889087,0.659855,289),(0.953534,0.380754,278),(0.986237,0.978721,240),(0.977384,0.669625,289),(0.771843,0.734047,289),(1.03207,0.66148,289),(0.962509,0.654102,289),(0.755437,0.752819,289),(0.979692,0.824702,289),(0.9908,0.944482,240),(0.924625,0.867579,296),(0.921197,0.91217,240),(0.747333,0.822385,289),(1.02068,0.724957,289),(0.887044,0.708764,289),(0.959428,0.842852,289),(0.936463,0.915286,240),(0.951864,0.921508,289),(0.781626,0.770839,289),(0.799466,0.680671,289),(0.929424,0.599899,289),(0.967281,0.667796,289),(1.01906,0.591936,289),(0.896526,0.734521,289),(0.983634,0.76925,289),(1.01019,0.595276,289),(1.03802,0.590768,289),(0.871544,0.707644,289),(0.979219,0.759444,289),(0.938493,0.665391,289),(0.891795,0.698713,289),(0.960542,0.977001,240),(0.787105,0.758108,289),(0.967281,0.969404,240),(1.00854,0.640475,289),(0.92471,0.862774,296),(0.753846,0.777424,289),(1.03688,0.991703,240),(0.941833,1.01924,240),(0.781337,0.695937,289),(0.967956,0.670967,289),(0.883324,0.638444,289),(0.939196,0.630621,289),(0.944514,0.944514,240),(0.841002,0.711645,289),(0.804213,0.713255,289),(0.917927,1.01792,240),(0.949338,0.929566,289),(0.822744,0.6938,289),(0.936462,0.822265,289),(1.01192,0.925265,296),(0.899721,0.753401,310),(0.974059,0.662493,289),(0.908057,0.83428,310),(0.985935,0.760983,289),(0.963101,0.639848,289),(0.7625,0.759863,289),(0.958914,1.0264,240),(0.825962,0.704902,289),(0.822186,0.687947,289),(0.753284,0.802851,289),(0.905335,0.785533,310),(0.808955,0.838469,310),(0.959884,0.999588,240),(0.791904,0.771794,289),(0.966823,0.765151,289),(0.978982,0.870532,289),(0.78521,0.717739,289),(1.12644,0.707614,289),(0.755553,0.800583,289),(0.753584,0.773129,289),(0.776056,0.693492,289),(0.969564,0.64717,289),(1.17922,0.582994,289),(0.898569,0.705635,289),(0.783493,0.651425,289),(0.958263,0.913076,289),(0.951292,0.646948,289),(0.883676,0.675273,289),(0.984366,0.675733,289),(0.78041,0.750506,289),(1.0325,1.00478,240),(0.984281,0.675655,289),(0.957175,0.812997,289),(0.824814,0.695806,289),(0.78286,0.668515,289),(0.842637,0.805856,310),(0.986466,0.924924,289),(0.78369,0.677954,289),(0.757978,0.696804,289),(0.753808,0.790285,289),(0.783174,0.666037,289),(0.937242,0.93666,240),(0.974521,0.849246,289),(0.899988,0.605319,289),(0.781137,0.785267,289),(0.751228,0.771823,289),(0.82955,0.68798,289),(0.762181,0.692348,289),(0.883112,0.638664,289),(0.976836,0.752083,289),(0.731151,0.844957,289),(1.0234,1.04375,240),(0.956702,1.02031,240),(1.09544,0.704022,289),(0.847954,0.798205,310),(0.927352,0.813033,289),(0.779188,0.730338,289),(0.970611,0.65094,289),(0.970388,0.651967,289),(1.15181,1.00405,289),(0.759989,0.778233,289),(0.986184,1.16154,240),(0.937371,1.48265,215),(0.991539,1.07033,240),(0.929461,1.46073,215),(0.950189,1.06908,240),(0.972551,1.48154,213),(1.02014,1.60867,203),(0.95565,1.07025,240),(0.992351,1.05789,240),(0.975178,1.49097,213),(0.923756,1.37148,215),(0.988792,1.15716,240),(1.1781,1.11701,289),(1.17955,1.11614,289),(1.01314,1.05696,240),(0.994322,1.05736,240),(0.978355,1.05138,240),(0.96523,1.5679,203),(0.979387,1.65084,203),(1.04937,1.13055,240),(0.997494,1.14367,240),(1.01309,1.11171,240),(0.944186,1.07473,240),(0.964764,1.49429,213),(0.986009,1.48308,214),(0.964037,1.47281,214),(1.01578,1.19148,240),(0.976236,1.7105,193),(0.978432,1.49435,213),(1.01303,1.13922,240),(0.963754,1.32615,214),(0.920935,1.53396,213),(1.13311,1.3576,240),(0.992994,1.29802,215),(1.21277,1.54282,203),(0.939307,1.45853,215),(0.99275,1.04757,240),(0.995029,1.11234,240),(0.986153,1.06149,240),(0.93871,1.43661,214),(1.06901,1.28136,240),(0.993256,1.08262,240),(1.06,1.35418,214),(0.994649,1.05534,240),(1.07096,1.10975,240),(0.979697,1.62942,203),(0.924986,1.37261,215),(0.930697,1.60458,203),(0.963877,1.10473,240),(0.969361,1.55685,203),(0.978871,1.11061,240),(1.04027,1.0573,240),(0.926552,1.59523,203),(1.16117,1.16242,240),(0.898845,1.41808,215),(1.0013,1.07171,240),(0.996411,1.07647,240),(0.958463,1.49467,213),(0.940835,1.51353,213),(1.06872,1.27991,240),(0.952971,1.50527,213),(0.985103,1.05047,240),(0.94892,1.0614,240),(0.935914,1.52472,213),(0.959931,1.28107,215),(0.959708,1.44368,214),(1.08456,1.14133,240),(1.10304,1.31686,240),(1.15337,1.3375,240),(0.93043,1.45951,215),(0.960655,1.44748,214),(0.938214,1.52035,213),(0.931861,1.46496,215),(1.21045,1.53943,203),(1.01364,1.05977,240),(1.06351,1.3361,240),(0.958318,1.72836,193),(1.00348,1.05088,240),(1.06639,1.26717,240),(0.977496,1.57763,203),(1.14377,1.26565,240),(0.937399,1.53242,213),(0.937421,1.60025,203),(0.960716,1.04909,240),(0.93714,1.53694,213),(1.06517,1.32843,240),(0.907915,1.49944,215),(0.981117,1.53148,213),(0.950487,1.45519,214),(1.01641,1.61413,203),(0.953939,1.50401,213),(1.16339,1.15922,240),(0.902335,1.64846,203),(0.972393,1.05685,240),(0.967742,1.36697,214),(0.958365,1.12455,240),(0.967785,1.14028,240),(0.948872,1.34911,214),(0.91745,1.37774,215),(0.977554,1.61952,203),(1.01864,1.04791,240),(1.04312,1.05084,240),(0.958531,1.44846,214),(0.958034,1.07158,240),(0.962217,1.07651,240),(1.07012,1.10535,240),(1.01775,1.44703,214),(1.0243,1.7311,203),(0.960312,1.4347,214),(0.942303,1.51254,213),(1.00234,1.04824,240),(1.06472,1.20431,240),(0.965749,1.50244,213),(0.969239,1.50186,213),(1.21089,1.53142,203),(0.982428,1.0923,240),(0.97548,1.06049,240),(0.925947,1.05853,240),(1.04319,1.04713,240),(0.9379,1.36206,214),(0.968323,1.05096,240),(0.980904,1.67059,203),(0.992094,1.09452,240),(0.984689,1.08093,240),(0.938785,1.41969,215),(0.934357,1.52272,213),(0.960854,1.30158,215),(1.05926,1.05454,240),(0.953589,1.45394,214),(0.979353,1.21283,240),(1.00654,1.1008,240),(0.9815,1.67665,203),(0.947423,1.49982,213),(0.890016,1.42185,215),(0.906805,1.5002,215),(1.21136,1.50409,203),(0.976676,1.61202,203),(0.989672,1.04873,240),(0.978807,1.73894,193),(0.939399,1.59321,203),(0.946356,1.45527,214),(0.962627,1.07215,240),(0.959493,1.05354,240),(0.995553,1.14703,240),(0.975823,1.65629,203),(0.971654,1.47302,214),(0.981011,1.56267,203),(0.991003,1.08297,240),(0.916933,1.48715,215),(0.993237,1.06119,240),(0.970403,1.50447,213),(0.955657,1.45031,214),(1.11198,1.16365,240),(0.949747,1.50618,213),(0.931317,1.46195,215),(0.966163,1.36759,214),(0.994801,1.50352,214),(0.995011,1.07264,240),(1.00104,1.07981,240),(0.989562,1.0618,240),(0.978798,1.50148,213),(0.916169,1.44482,215),(1.0097,1.0768,240),(0.957353,1.45047,214),(0.982086,1.57951,203),(0.919003,1.57242,203),(0.937513,1.59574,203),(0.978868,1.05996,240),(0.973118,1.05946,240),(0.981767,1.63244,203),(0.999094,1.04866,240),(0.987866,1.48155,214),(1.12459,1.33522,240),(1.08378,1.35219,240),(1.11334,1.30067,240),(1.07546,1.25935,240),(0.941085,1.78101,193),(0.987451,1.81727,193),(0.938114,2.22122,239),(1.0827,2.26427,239),(0.829691,2.35187,238),(0.745774,2.32275,238),(0.752335,2.30163,238),(0.979481,1.76564,193),(0.991239,1.84599,193),(1.0123,1.79179,193),(0.764557,2.3034,238),(0.920695,1.80895,193),(0.904535,1.87815,193),(1.15919,1.96175,239),(0.96284,2.17672,239),(0.95218,1.75564,193),(0.755696,2.30524,238),(0.750081,2.31088,238),(0.896779,2.23615,239),(0.778378,2.31816,238),(0.901627,1.81001,193),(0.907571,2.22879,239),(0.911304,1.81689,193),(0.971276,1.90794,193),(0.868891,2.25867,239),(0.894883,1.89967,239),(0.752688,2.32362,238),(0.989094,2.17554,239),(0.90728,2.03476,239),(0.747207,2.31971,238),(1.09145,1.989,239),(0.811166,2.34323,238),(0.793766,2.3287,238),(1.05986,2.00587,239),(0.878788,1.85789,193),(0.874373,2.06013,239),(0.882299,2.39137,238),(0.84615,2.35781,238),(0.772495,2.35713,238),(0.912768,1.82032,193),(0.895063,1.85878,193),(0.801698,2.3339,238),(0.908125,1.98096,239),(0.927749,1.79887,193),(0.879355,2.0336,239),(0.75263,2.31009,238),(1.00968,1.99305,193),(0.877319,2.22588,239),(0.851574,2.31997,238),(0.817095,2.34328,238),(0.888649,2.24207,239),(0.899108,1.81759,193),(1.15192,1.94604,239),(0.75675,2.30716,238),(0.770765,2.32612,238),(0.916938,1.81316,193),(0.876611,2.38935,238),(1.02282,2.18846,239),(0.777726,2.36614,238),(0.979697,1.7735,193),(0.944377,1.78311,193),(0.845525,2.3586,238),(0.923813,2.76465,198),(0.819574,2.49117,224),(0.928294,2.76426,198),(0.856727,2.4479,238),(0.854728,2.44848,238),(0.858993,2.49786,224),(0.925813,2.76894,198),(0.935041,2.49491,224),(0.927478,2.4562,238),(0.814603,2.47598,224),(1.03963,2.63196,208),(0.813895,2.492,224),(0.821197,2.47936,224),(0.953889,0.347513,278),(0.970393,0.646446,289),(1.08674,1.2999,240),(1.06028,1.27162,240),(1.06909,1.3127,240),(1.00566,1.10093,240),(0.973114,0.664897,289),(0.977451,0.704049,289),(1.08978,1.25245,240),(1.07721,1.31542,240),(1.06429,1.34258,240),(-0.0340112,0.531186,29),(-0.0261771,0.517228,29),(-0.0432667,0.515857,29),(-0.034033,0.524626,29),(-0.0359485,0.512223,29),(-0.0376939,0.533071,29),(-0.0362058,0.519352,29),(-0.0433645,0.504531,29),(-0.0297191,0.51062,29),(-0.0275116,0.524777,29),(-0.0453204,0.519051,29),(0.420434,0.664338,223),(0.436703,0.650458,223),(0.55279,0.67481,223),(0.370255,0.726635,223),(0.463792,0.873309,223),(0.495383,0.6385,223),(0.532323,0.666996,223),(0.427476,0.690901,223),(0.462254,0.873371,223),(0.289655,0.74952,223),(0.523071,0.701734,223),(0.465128,0.871831,223),(0.299315,0.743953,223),(0.466141,0.873746,223),(0.39791,0.681288,223),(0.349075,0.743601,223),(0.3053,0.770173,223),(0.373966,0.695097,223),(0.319507,0.745765,223),(0.294772,0.742657,223),(0.375541,0.684504,223),(0.480347,0.727641,223),(0.477371,0.62291,223),(0.459475,0.767508,223),(0.452688,0.867038,223),(0.41509,0.677021,223),(0.459012,0.782177,223),(0.459078,0.875026,223),(0.442664,0.867866,223),(0.371236,0.705389,223),(0.357106,0.795485,223),(0.430882,0.81545,223),(0.451507,0.759171,223),(0.540621,0.71625,223),(0.334151,0.735134,223),(0.546842,0.651755,223),(0.458071,0.636216,223),(0.494123,0.805073,223),(0.462875,0.873093,223),(0.443023,0.866847,223),(0.443488,0.865349,223),(0.427058,0.691398,223),(0.458663,0.876301,223),(0.496355,0.846333,223),(0.377287,0.692862,223),(0.471435,0.8667,223),(0.442695,0.865078,223),(0.456303,0.761999,223),(0.443895,0.866265,223),(0.349291,0.723747,223),(0.417247,0.749047,223),(0.41873,0.823144,223),(0.42774,0.774793,223),(0.461368,0.874467,223),(0.296163,0.747568,223),(0.317936,0.741857,223),(-0.164643,2.79165,330),(-0.0805761,0.967785,320),(0.225315,0.4097,28),(0.251348,0.585032,28),(0.225254,0.544818,28),(0.273049,0.566843,28),(0.321584,0.658495,28),(0.227184,0.556178,28),(0.229511,0.592248,28),(0.291322,0.583535,28),(0.333461,0.651568,28),(0.236825,0.585858,28),(0.23005,0.571421,28),(0.234165,0.587594,28),(0.229736,0.570085,28),(0.323759,0.555887,28),(0.244976,0.578947,28),(0.269671,0.6353,28),(0.192277,0.518654,28),(0.23591,0.624246,28),(0.210312,0.51749,28),(0.342389,0.649549,28),(0.314536,0.593115,28),(0.23911,0.529998,28),(0.308961,0.593174,28),(0.23242,0.591376,28),(0.207099,0.600165,28),(0.221948,0.534943,28),(0.221657,0.496255,28),(0.230108,0.527381,28),(0.25944,0.564907,28),(0.192568,0.484038,28),(0.248638,0.575768,28),(0.27143,0.567798,28),(0.234747,0.391826,28),(0.260749,0.580043,28),(0.234165,0.604466,28),(0.257482,0.581166,28),(0.237852,0.44243,28),(0.318731,0.591808,28),(0.244367,0.563944,28),(0.230383,0.596321,28),(0.307052,0.592699,28),(0.205759,0.599681,28),(0.215548,0.510509,28),(0.199948,0.54504,28),(1.11402,0.353599,302),(1.13011,0.365695,302),(1.14,0.374887,302),(1.14466,0.386672,302),(1.18431,0.352995,302),(1.14887,0.378538,302),(0.96743,0.241212,302),(1.00602,0.319326,302),(0.992703,0.258467,302),(1.00807,0.290376,302),(1.0405,0.2889,302),(0.998085,0.245044,302),(0.99668,0.213816,302),(1.01894,0.215084,302),(1.03907,0.315513,302),(1.04473,0.307971,302),(1.03879,0.312611,302),(1.01836,0.208434,302),(1.03321,0.311248,302),(1.03323,0.312414,302),(1.01724,0.214477,302),(0.966479,0.229631,302),(1.03749,0.315359,302),(1.08893,0.302052,302),(1.03605,0.313656,302),(1.03555,0.315292,302),(1.03603,0.314174,302),(1.03721,0.313303,302),(1.03316,0.307619,302),(1.01912,0.241642,302),(1.05796,0.292634,302),(1.00774,0.211297,302),(1.10269,0.25544,302),(1.03566,0.315641,302),(0.999455,0.287078,302),(1.10463,0.326643,302),(1.03453,0.265405,302),(1.02543,0.296843,302),(1.04297,0.326463,302),(1.02266,0.28244,302),(1.00624,0.256507,302),(1.03516,0.317017,302),(1.02166,0.262436,302),(1.00628,0.20968,302),(1.04059,0.311624,302),(0.970506,0.226906,302),(0.97225,0.230265,302),(1.01946,0.272648,302),(1.02111,0.229644,302),(1.03614,0.316486,302),(1.00829,0.214135,302),(0.975129,0.223929,302),(1.00334,0.210768,302),(1.01004,0.2091,302),(1.03515,0.246232,302),(0.97793,0.247006,302),(1.03872,0.279123,302),(1.03678,0.313196,302),(1.02967,0.282869,302),(1.03636,0.235682,302),(0.980204,0.272038,302),(1.03545,0.253489,302),(0.980362,0.259389,302),(0.988931,0.285564,302),(1.00848,0.247072,302),(1.03712,0.311281,302),(1.00856,0.249619,302),(1.03388,0.313844,302),(0.9782,0.221559,302),(0.98016,0.240269,302),(1.09314,0.313076,302),(1.03267,0.316686,302),(0.989156,0.224393,302),(1.00718,0.20886,302),(1.05897,0.29918,302),(1.05773,0.272725,302),(1.01532,0.236504,302),(0.993189,0.218012,302),(0.974579,0.232197,302),(1.03614,0.288114,302),(1.04085,0.298062,302),(1.03568,0.313112,302),(1.05568,0.269429,302),(1.00742,0.225847,302),(1.03556,0.319104,302),(1.03494,0.315056,302),(0.981622,0.224488,302),(1.01108,0.21875,302),(1.03811,0.319389,302),(1.00691,0.207974,302),(0.022509,1.81253,228),(-0.278183,-0.0997761,251),(0.805557,0.26273,281),(0.80912,0.263724,281),(0.810183,0.276987,281),(0.79943,0.264747,281),(0.812533,0.273086,281),(0.803743,0.253162,281),(0.807021,0.250553,281),(0.794944,0.239624,281),(0.806882,0.266345,281),(1.36517,0.272971,165),(0.853263,0.378471,265),(0.848729,0.379077,265),(0.860423,0.361042,265),(0.854245,0.358867,265),(0.855012,0.386608,265),(0.849279,0.358448,265),(0.84444,0.349457,265),(0.855183,0.370602,265),(0.856284,0.354267,265),(0.850924,0.382567,265),(0.850219,0.371023,265),(0.85758,0.356632,265),(0.854113,0.382511,265),(0.860303,0.371279,265),(0.847784,0.334287,265),(0.844487,0.321152,265),(0.859106,0.327064,265),(0.848088,0.328987,265),(0.844345,0.306955,265),(0.85337,0.314933,265),(0.852504,0.300657,265),(0.849613,0.303111,265),(0.840398,0.312076,265),(0.856517,0.33698,265),(0.857392,0.319848,265),(0.851275,0.325111,265),(0.857332,0.321519,265),(0.848139,0.311121,265),(0.842817,0.30136,265),(0.848729,0.320871,265),(0.837504,0.316986,265),(0.850981,0.311208,265),(0.843127,0.315635,265),(0.856372,0.330286,265),(0.845368,0.297088,265),(0.843561,0.343255,265),(0.856618,0.342472,265),(0.841522,0.324754,265),(0.860447,0.327831,265),(0.833631,0.3163,265),(0.845293,0.310723,265),(0.850457,0.327426,265),(0.841074,0.309403,265),(0.83763,0.307389,265),(0.85451,0.317062,265),(0.858874,0.336908,265),(0.847546,0.338935,265),(0.862804,0.327929,265),(0.851796,0.342718,265),(0.840344,0.298569,265),(0.850664,0.334291,265),(0.850347,0.318654,265),(0.145531,-0.228148,22),(0.153007,-0.223111,22),(0.155043,-0.210312,22),(0.151553,-0.218748,22),(0.146899,-0.189077,22),(0.137474,-0.195259,22),(0.167261,-0.201586,22),(0.148074,-0.230906,22),(0.139011,-0.204873,22),(0.76684,0.21723,297),(0.219621,-0.283999,17),(0.229511,-0.246382,17),(0.259181,-0.277216,17),(0.2554,-0.283325,17),(0.258018,-0.296124,17),(0.240345,-0.23854,17),(0.221797,-0.27152,17),(0.279566,-0.287798,17),(0.287325,-0.274031,17),(0.257853,-0.297758,17),(0.250455,-0.286525,17),(0.257436,-0.303687,17),(0.239983,-0.275762,17),(0.253296,-0.296793,17),(0.267625,-0.270118,17),(0.263714,-0.290105,17),(0.25814,-0.277647,17),(0.224857,-0.260927,17),(0.219177,-0.212482,17),(0.260389,-0.29882,17),(0.247531,-0.283674,17),(0.247255,-0.293797,17),(0.249,-0.27838,17),(0.256719,-0.304652,17),(0.267881,-0.270176,17),(0.256453,-0.304456,17),(0.223582,-0.283204,17),(0.0457014,0.783545,41),(0.0312037,0.777195,41),(0.200224,0.870445,41),(0.0355543,0.791398,41),(0.0662136,0.742542,41),(-0.00625125,0.742557,41),(0.00852227,0.746745,41),(0.0485353,0.794133,41),(0.00121615,0.74604,41),(0.166853,0.769079,41),(0.118154,0.827824,41),(0.139283,0.86946,41),(0.185287,0.826727,41),(0.0671739,0.823458,41),(0.0489141,0.769307,41),(0.0672606,0.795302,41),(0.166192,0.794712,41),(0.196947,0.85838,41),(0.182205,0.785648,41),(0.0826558,0.788952,41),(0.0543466,0.761833,41),(0.0409217,0.737863,41),(0.0373169,0.787513,41),(0.147958,0.826583,41),(0.102388,-0.962843,136),(0.0994838,-0.964003,136),(0.0714719,0.535431,26),(0.0797987,0.495595,26),(0.13444,0.48861,26),(0.153033,0.478224,26),(0.0770271,0.568415,26),(0.12695,0.500599,26),(0.118717,0.51821,26),(0.16639,0.55258,26),(0.0846773,0.551218,26),(0.148933,0.490444,26),(0.0674591,0.56692,26),(0.108314,0.550762,26),(0.0657576,0.567534,26),(0.00587373,0.117414,49),(0.235619,-1.55102,94),(0.233001,-1.54374,94),(0.239716,-1.55599,94),(0.239706,-1.56582,94),(0.23944,-1.56598,94),(0.242019,-1.54694,94),(0.237946,-1.54985,94),(0.235328,-1.54403,94),(0.244244,-1.56311,94),(0.238924,-1.55661,94),(0.233583,-1.542,94),(0.235328,-1.53909,94),(0.240564,-1.55189,94),(0.238393,-1.55654,94),(0.23911,-1.53764,94),(0.241466,-1.55813,94),(0.231838,-1.54549,94),(0.238708,-1.55823,94),(0.250164,-1.5612,94),(0.239813,-1.55706,94),(0.232774,-1.53317,94),(0.235416,-1.55897,94),(0.239891,-1.56509,94),(0.239139,-1.55525,94),(0.239532,-1.55631,94),(0.23974,-1.55651,94),(0.239401,-1.55218,94),(0.244113,-1.56523,94),(0.244928,-1.55218,94),(0.239905,-1.55695,94),(0.240981,-1.55647,94),(0.23864,-1.55755,94),(0.242974,-1.56809,94),(0.243599,-1.55665,94),(0.237239,-1.56779,94),(0.314613,-1.10036,115),(0.592842,0.639793,182),(0.615506,0.640749,182),(0.608928,0.626339,182),(0.636585,0.64746,182),(0.605078,0.632856,182),(0.608084,0.641076,182),(0.571345,0.629487,182),(0.603199,0.668122,182),(0.634395,0.655038,182),(0.61596,0.641382,182),(0.608325,0.708749,182),(0.572982,0.631099,182),(0.625953,0.642384,182),(0.630753,0.636245,182),(0.611062,0.646701,182),(0.607695,0.630304,182),(0.583558,0.629741,182),(0.575825,0.629369,182),(0.596077,0.641261,182),(0.634928,0.645649,182),(0.612005,0.634263,182),(0.637536,0.662439,182),(0.62852,0.640044,182),(0.618581,0.63968,182),(0.617397,0.638848,182),(0.630357,0.637311,182),(0.621577,0.638171,182),(0.609027,0.636972,182),(0.625077,0.633914,182),(0.59005,0.64124,182),(0.642587,0.663419,182),(0.617172,0.62702,182),(0.585382,0.634727,182),(0.576272,0.630554,182),(0.627108,0.639383,182),(0.606097,0.640944,182),(0.585715,0.634677,182),(0.613165,0.641545,182),(0.615406,0.638892,182),(0.631831,0.648585,182),(0.585938,0.635347,182),(0.584863,0.633402,182),(0.631058,0.658125,182),(0.616727,0.70059,182),(0.647042,0.709511,182),(0.583969,0.632462,182),(0.627562,0.640777,182),(0.61404,0.627423,182),(0.58861,0.630073,182),(0.638557,0.64658,182),(0.586611,0.633741,182),(0.625431,0.672765,182),(0.570879,0.638258,182),(0.57722,0.631527,182),(0.629662,0.652273,182),(0.609583,0.641101,182),(0.627446,0.680969,182),(0.593856,0.641031,182),(0.588848,0.638803,182),(0.602298,0.638437,182),(0.578157,0.625257,182),(0.597419,0.649972,182),(0.61123,0.706046,182),(0.619851,0.624424,182),(0.582193,0.632556,182),(0.637087,0.711182,182),(0.571583,0.633728,182),(0.634775,0.654811,182),(0.637254,0.643495,182),(0.632028,0.641754,182),(0.601266,0.714164,182),(0.605502,0.712566,182),(-0.459313,0.543379,40),(-0.462221,0.547452,40),(-0.461931,0.544543,40),(0.374569,-1.24166,98),(0.192505,0.354,44),(0.241364,0.363594,44),(0.159574,0.321006,44),(0.163436,0.260134,44),(0.232049,0.343771,44),(0.211302,0.262574,44),(0.238078,0.287806,44),(0.149517,0.280707,44),(0.212658,0.326255,44),(0.170412,0.247032,44),(0.226823,0.274528,44),(0.217739,0.269417,44),(0.246461,0.267215,44),(0.163977,0.284469,44),(0.16496,0.330651,44),(0.155554,0.306374,44);
/*&*/
INSERT INTO `x2_timezone_points` VALUES (0.162466,0.275877,44),(0.206107,0.276866,44),(0.150971,0.294088,44),(0.17943,0.268296,44),(0.209092,0.317891,44),(0.156788,0.284836,44),(0.230652,0.320011,44),(-0.86132,1.22551,319),(0.110537,0.0267617,33),(0.112157,0.0211766,33),(0.157661,0.0247256,33),(0.149517,0.0171623,33),(0.156789,0.0197803,33),(0.1213,0.0203622,33),(0.170485,0.0192908,33),(0.180802,0.00821753,33),(0.107119,0.0211581,33),(0.120428,0.0110537,33),(0.166698,0.0207015,33),(0.189611,0.00357793,33),(0.161443,0.0136717,33),(0.163188,0.0221076,33),(0.132354,0.010472,33),(0.131481,0.0197803,33),(0.108792,0.0279253,33),(0.137616,1.71741,175),(0.137617,1.71715,175),(0.214166,1.7431,175),(0.228846,1.74436,175),(0.131883,1.73855,175),(0.142498,1.73975,175),(0.307403,1.73165,175),(0.269839,1.74344,175),(0.243669,1.73907,175),(0.242601,1.74126,175),(0.294431,1.73013,175),(0.159525,1.73369,175),(0.296842,1.74224,175),(0.305728,1.74114,175),(0.302221,1.74239,175),(0.325125,1.72606,175),(0.32716,1.72996,175),(0.142752,1.74279,175),(0.23626,1.74214,175),(0.173937,1.7215,175),(0.216157,1.74361,175),(0.206315,1.74156,175),(0.159012,1.73193,175),(0.137717,1.71737,175),(0.238976,1.74271,175),(0.334964,1.74321,175),(0.323343,1.72682,175),(0.147189,1.74475,175),(0.291761,1.72031,175),(0.356632,1.74317,175),(0.296427,1.71944,175),(0.351627,1.74276,175),(0.274907,1.74165,175),(0.173584,1.72925,175),(0.324292,1.72801,175),(0.319261,1.73648,175),(0.210885,1.74279,175),(0.140893,1.72631,175),(0.231086,1.74226,175),(0.28033,1.7429,175),(0.138192,1.71624,175),(0.244418,1.73745,175),(0.28769,1.73698,175),(0.13595,1.73895,175),(0.219399,1.74461,175),(0.32615,1.72647,175),(0.334447,1.74521,175),(0.235938,1.74454,175),(0.183185,1.73101,175),(0.237714,1.7382,175),(0.34747,1.74241,175),(0.327954,1.72761,175),(0.223402,1.74475,175),(0.249994,1.73688,175),(0.297461,1.72929,175),(0.166429,1.74421,175),(0.24114,1.74319,175),(0.153595,1.73422,175),(0.297239,1.74101,175),(0.195697,1.73681,175),(0.238963,1.7441,175),(0.290597,1.80293,175),(0.301375,1.80161,175),(0.125735,1.75484,175),(0.261508,1.79158,175),(0.238093,1.75986,175),(0.302068,1.78353,175),(0.275659,1.81767,175),(0.119837,1.76922,175),(0.114144,1.76769,175),(0.254722,1.75123,175),(0.27328,1.76463,175),(0.265171,1.8302,175),(0.301959,1.7762,175),(0.248306,1.75782,175),(0.235676,1.7834,175),(0.307624,1.74697,175),(0.268421,1.74576,175),(0.303961,1.79395,175),(0.265961,1.82995,175),(0.213692,1.78923,175),(0.226155,1.74368,175),(0.254249,1.758,175),(0.282046,1.75574,175),(0.220284,1.78032,175),(0.311542,1.79038,175),(0.283109,1.75266,175),(0.109248,1.78119,175),(0.259737,1.8063,175),(0.252622,1.74746,175),(0.105239,1.77964,175),(0.125643,1.75572,175),(0.263803,1.82089,175),(0.229925,1.76158,175),(0.259842,1.75239,175),(0.312912,1.81436,175),(0.305002,1.80567,175),(0.115596,1.74649,175),(0.221071,1.76105,175),(0.253654,1.76133,175),(0.234128,1.74538,175),(0.236449,1.7501,175),(0.237353,1.75574,175),(0.239581,1.74909,175),(0.299519,1.81771,175),(0.241102,1.7815,175),(0.115869,1.75272,175),(0.280242,1.80909,175),(0.221324,1.76729,175),(0.135746,1.75094,175),(0.1099,1.7755,175),(0.254921,1.7998,175),(0.245217,1.76922,175),(0.294686,1.77822,175),(0.285824,1.78248,175),(0.238386,1.75464,175),(0.257004,1.75921,175),(0.250484,1.75541,175),(0.316706,1.74779,175),(0.314741,1.8006,175),(0.293648,1.74984,175),(0.286964,1.75142,175),(0.26607,1.83659,175),(0.286566,1.76558,175),(0.132957,1.74669,175),(0.235062,1.76445,175),(0.239946,1.76898,175),(0.234674,1.766,175),(0.252329,1.75179,175),(0.119872,1.76715,175),(0.244581,1.75459,175),(0.145754,1.74885,175),(0.242828,1.75404,175),(0.256703,1.77005,175),(0.241916,1.75431,175),(0.264943,1.78472,175),(0.279083,1.76386,175),(0.312038,1.79319,175),(0.250291,1.76047,175),(0.300267,1.78793,175),(0.112162,1.77715,175),(0.255476,1.79405,175),(0.327839,1.75893,175),(0.310151,1.78354,175),(0.274099,1.74772,175),(0.261287,1.78202,175),(0.303876,1.82873,175),(0.241198,1.7461,175),(0.247918,1.7665,175),(0.252424,1.75595,175),(0.28877,1.82777,175),(0.282479,1.80294,175),(0.258275,1.75674,175),(0.292863,1.76701,175),(0.305267,1.77548,175),(0.217846,1.78152,175),(0.304136,1.79013,175),(0.288695,1.81602,175),(0.240052,1.75408,175),(0.238295,1.74986,175),(0.223048,1.7741,175),(0.287049,1.79477,175),(0.253516,1.78453,175),(0.245475,1.7566,175),(0.291471,1.81672,175),(0.273241,1.80788,175),(0.284149,1.77944,175),(0.255526,1.82649,175),(0.285159,1.80774,175),(0.286807,1.80653,175),(0.254577,1.76274,175),(0.281149,1.78474,175),(0.243493,1.77531,175),(0.122319,1.75365,175),(0.260158,1.83396,175),(0.313875,1.74624,175),(0.265438,1.77625,175),(0.288752,1.78197,175),(0.282561,1.76033,175),(0.233214,1.76249,175),(0.25706,1.78312,175),(0.220079,1.78206,175),(0.275945,1.78074,175),(0.265052,1.74749,175),(0.26529,1.76511,175),(0.238904,1.76403,175),(0.272019,1.78767,175),(0.100781,1.76404,175),(0.279544,1.81427,175),(0.24483,1.75852,175),(0.225729,1.76075,175),(0.299197,1.79721,175),(0.280299,1.79299,175),(0.237203,1.74721,175),(0.255088,1.75802,175),(0.243951,1.7589,175),(0.29249,1.74738,175),(0.259914,1.75087,175),(0.236369,1.76267,175),(0.248322,1.75538,175),(0.279738,1.75195,175),(0.244728,1.74833,175),(0.227714,1.76154,175),(0.240943,1.75358,175),(0.289346,1.75057,175),(0.242912,1.75273,175),(0.250873,1.7538,175),(0.308906,1.80222,175),(0.222101,1.76375,175),(0.22814,1.76284,175),(0.244329,1.75492,175),(0.237074,1.75958,175),(0.238984,1.78898,175),(0.276783,1.82612,175),(0.260044,1.77515,175),(0.137696,1.71715,175),(0.136915,1.71634,175),(0.138049,1.71745,175),(0.668707,1.20494,186),(0.659804,1.21552,186),(0.658248,1.20139,186),(0.696634,1.20433,186),(0.672203,1.1909,186),(0.660328,1.20047,186),(0.689322,1.18001,186),(0.654362,1.21132,186),(0.672935,1.20451,186),(0.670017,1.20991,186),(0.661734,1.21797,186),(0.656038,1.19832,186),(0.654319,1.24884,186),(0.640969,1.24989,186),(0.672389,1.19644,186),(0.672576,1.20042,186),(0.664897,1.21021,186),(0.656482,1.2166,186),(0.671361,1.20088,186),(0.701049,1.21303,186),(0.703063,1.21514,186),(0.703265,1.22926,186),(0.700339,1.23264,186),(0.702219,1.2164,186),(-0.149376,2.19167,184),(0.689593,0.948885,171),(0.651849,1.04047,171),(0.684276,0.952785,171),(0.684948,0.968926,171),(0.664109,1.01588,171),(0.670839,1.00237,171),(0.662352,1.01898,171),(0.661263,1.0213,171),(0.726937,1.04574,171),(0.698518,0.924242,171),(0.738758,1.03244,171),(0.735277,1.04146,171),(0.73018,1.04662,171),(0.650988,1.08838,171),(0.652463,1.05602,171),(0.689084,1.09805,171),(0.676907,1.11492,171),(0.656135,1.07914,171),(0.660358,1.13814,171),(0.659952,1.15273,171),(0.681957,1.10966,171),(0.656567,1.08502,171),(0.718857,1.07169,171),(0.635351,0.177027,51),(0.642876,0.175241,51),(0.642612,0.177427,51),(0.59201,0.141957,51),(0.574731,0.182418,51),(0.620856,0.151325,51),(0.64199,0.185587,51),(0.626429,0.149274,51),(0.625271,0.18565,51),(0.629802,0.163552,51),(0.611532,0.165543,51),(0.624537,0.188496,51),(0.606337,0.187802,51),(0.640175,0.179628,51),(0.641724,0.179337,51),(0.618162,0.191895,51),(0.638417,0.189518,51),(0.643111,0.193624,51),(0.588253,0.156539,51),(0.62217,0.190074,51),(0.643347,0.180321,51),(0.634849,0.172901,51),(0.64687,0.176597,51),(0.60083,0.153313,51),(0.591343,0.176247,51),(0.591197,0.137491,51),(0.636278,0.187407,51),(0.590063,0.191851,51),(0.646478,0.168696,51),(0.623592,0.18467,51),(0.649894,0.17304,51),(0.640241,0.184731,51),(0.648454,0.170797,51),(0.649915,0.172144,51),(0.642421,0.176229,51),(0.639657,0.167766,51),(0.637065,0.153244,51),(0.584755,0.193944,51),(0.621727,0.187744,51),(0.591244,0.189498,51),(0.625891,0.18506,51),(0.641036,0.180496,51),(0.642596,0.179856,51),(0.584097,0.157434,51),(0.648681,0.17017,51),(0.636486,0.187652,51),(0.650561,0.172332,51),(0.636507,0.188185,51),(0.640983,0.160251,51),(0.619602,0.193043,51),(0.615005,0.193993,51),(0.600091,0.14234,51),(0.623242,0.186296,51),(0.6227,0.176214,51),(0.61379,0.154226,51),(0.606502,0.188205,51),(0.624444,0.188952,51),(0.64009,0.177261,51),(0.599011,0.146635,51),(0.643646,0.180199,51),(0.619674,0.193072,51),(0.63136,0.151928,51),(0.616101,0.187041,51),(0.6353,0.185296,51),(0.591519,0.170978,51),(0.621641,0.191893,51),(0.648723,0.17514,51),(0.626034,0.184399,51),(0.636132,0.187722,51),(-0.368846,-3.05782,346),(0.655783,0.772957,276),(0.69499,0.607452,276),(0.651715,0.712541,276),(0.645002,0.631809,276),(0.691815,0.601566,276),(0.652327,0.475913,276),(0.651711,0.491184,276),(0.668384,0.544155,276),(0.66501,0.617097,276),(0.649878,0.693996,276),(0.683702,0.723542,276),(0.671819,0.757178,276),(0.693072,0.692933,276),(0.67498,0.513228,276),(0.668861,0.46712,276),(0.674214,0.609329,276),(0.648688,0.677082,276),(0.67187,0.483451,276),(0.682568,0.690227,276),(0.665876,0.477561,276),(0.664774,0.484068,276),(0.637075,0.532801,276),(0.690145,0.514849,276),(0.672068,0.737954,276),(0.644354,0.608743,276),(0.675282,0.620531,276),(0.696624,0.491446,276),(0.645355,0.670642,276),(0.694818,0.614111,276),(0.683917,0.481876,276),(0.680039,0.716097,276),(0.65883,0.478327,276),(0.658949,0.686205,276),(0.693739,0.646053,276),(0.654896,0.741057,276),(0.682218,0.505756,276),(0.665702,0.715726,276),(0.65013,0.741232,276),(0.634912,0.592268,276),(0.662049,0.731995,276),(0.653089,0.555805,276),(0.644322,0.542778,276),(0.679618,0.585359,276),(0.665048,0.533174,276),(0.651098,0.777967,276),(0.662376,0.47767,276),(0.666661,0.468429,276),(0.68682,0.63547,276),(0.664612,0.547447,276),(0.661907,0.504839,276),(0.671336,0.528302,276),(0.671648,0.491271,276),(0.633016,0.638218,276),(0.690752,0.560972,276),(0.654269,0.651001,276),(0.684756,0.748108,276),(0.697788,0.72739,276),(0.647066,0.632643,276),(0.676093,0.594087,276),(0.642795,0.502146,276),(0.667201,0.488161,276),(0.64713,0.719386,276),(0.645941,0.659633,276),(0.662629,0.605269,276),(0.674133,0.605843,276),(0.661764,0.494317,276),(0.639557,0.583618,276),(0.676232,0.724433,276),(0.649578,0.495089,276),(0.681751,0.600094,276),(0.651294,0.48492,276),(0.653184,0.721508,276),(0.642198,0.604197,276),(0.673829,0.47245,276),(0.643241,0.493477,276),(0.651236,0.711109,276),(0.673907,0.478682,276),(0.642049,0.548785,276),(0.683168,0.742464,276),(0.669337,0.668752,276),(0.671239,0.709433,276),(0.688082,0.523308,276),(0.660705,0.475717,276),(0.661954,0.727852,276),(0.634004,0.528887,276),(0.682339,0.577353,276),(0.671903,0.715798,276),(0.672777,0.500033,276),(0.666608,0.724111,276),(0.653716,0.625102,276),(0.675816,0.695829,276),(0.646906,0.527014,276),(0.66098,0.566964,276),(0.649144,0.708394,276),(0.655913,0.510795,276),(0.683224,0.596272,276),(0.682535,0.48292,276),(0.695431,0.584797,276),(0.637035,0.634559,276),(0.640817,0.647779,276),(0.692426,0.586668,276),(0.638752,0.533382,276),(0.670664,0.478522,276),(0.676005,0.619335,276),(0.658268,0.585569,276),(0.648933,0.579711,276),(0.693235,0.751388,276),(0.679908,0.698806,276),(0.686773,0.735,276),(0.686918,0.588593,276),(0.659482,0.674111,276),(0.655977,0.644487,276),(0.652297,0.629996,276),(0.667409,0.562195,276),(0.670429,0.473654,276),(0.659114,0.533237,276),(0.638567,0.631346,276),(0.660646,0.483868,276),(0.650398,0.622335,276),(0.668098,0.557002,276),(0.6968,0.76873,276),(0.651726,0.73111,276),(0.667165,0.740504,276),(0.686972,0.727841,276),(0.656014,0.679894,276),(0.645558,0.566477,276),(0.674505,0.618708,276),(0.673302,0.733529,276),(0.659448,0.656884,276),(0.663591,0.636998,276),(0.676327,0.707912,276),(0.68388,0.629573,276),(0.681406,0.513301,276),(0.633021,0.564054,276),(0.646809,0.652448,276),(0.674924,0.46699,276),(0.639169,0.508177,276),(0.69439,0.459734,276),(0.694234,0.532684,276),(0.696537,0.720419,276),(0.693807,0.689279,276),(0.639496,0.57407,276),(0.667856,0.69398,276),(0.654731,0.594227,276),(0.638877,0.598794,276),(0.681179,0.756751,276),(0.681023,0.54367,276),(0.686665,0.510657,276),(0.641161,0.522163,276),(0.69675,0.579987,276),(0.694699,0.744795,276),(0.666819,0.649233,276),(0.674994,0.684574,276),(0.661037,0.538441,276),(0.691082,0.471665,276),(0.690905,0.499612,276),(0.643356,0.632313,276),(0.690224,0.769414,276),(0.661756,0.701952,276),(0.690113,0.762209,276),(0.66436,0.526489,276),(0.670042,0.619456,276),(0.659284,0.507673,276),(0.681482,0.500192,276),(0.655292,0.728145,276),(0.672752,0.6546,276),(0.655776,0.572022,276),(0.667582,0.473583,276),(0.655798,0.763421,276),(0.651483,0.736359,276),(0.656447,0.489764,276),(0.643105,0.699004,276),(0.646203,0.625133,276),(0.668859,0.459133,276),(0.665601,0.68852,276),(0.673552,0.541551,276),(0.658855,0.650942,276),(0.689412,0.470762,276),(0.658343,0.528675,276),(0.6823,0.737756,276),(0.653786,0.533983,276),(0.630207,0.57528,276),(0.696522,0.524239,276),(0.652099,0.672417,276),(0.661315,0.603166,276),(0.675636,0.5419,276),(0.646441,0.478729,276),(0.660583,0.709753,276),(0.646286,0.663055,276),(0.678666,0.706752,276),(0.687529,0.490981,276),(0.657594,0.553698,276),(0.657863,0.660801,276),(0.682786,0.47439,276),(0.636855,0.632216,276),(0.643377,0.542022,276),(0.66702,0.482539,276),(0.66126,0.717892,276),(0.673137,0.677603,276),(0.676089,0.519269,276),(0.692009,0.486704,276),(0.649214,0.638382,276),(0.686247,0.465923,276),(0.66052,0.485893,276),(0.69675,0.710262,276),(0.644168,0.535739,276),(0.631923,0.631063,276),(0.696733,0.573415,276),(0.629629,0.573112,276),(0.677183,0.470751,276),(0.669348,0.497719,276),(0.637809,0.558502,276),(0.669465,0.548319,276),(0.669727,0.593855,276),(0.679256,0.485901,276),(0.692202,0.626287,276),(0.64073,0.679762,276),(0.676346,0.741439,276),(0.676431,0.533082,276),(0.667548,0.644271,276),(0.659113,0.668047,276),(0.677256,0.745853,276),(0.645801,0.616605,276),(0.639655,0.632325,276),(0.697579,0.571261,276),(0.641686,0.502704,276),(0.723463,0.554893,276),(0.703421,0.626336,276),(0.715487,0.504473,276),(0.714784,0.695759,276),(0.702747,0.517544,276),(0.711687,0.518881,276),(0.709564,0.510979,276),(0.715392,0.500487,276),(0.718091,0.618802,276),(0.716385,0.685502,276),(0.720227,0.465802,276),(0.717878,0.650702,276),(0.715872,0.508323,276),(0.704895,0.629734,276),(0.715672,0.693366,276),(0.715855,0.594112,276),(0.70361,0.637995,276),(0.715706,0.67743,276),(0.719236,0.645316,276),(0.716097,0.498288,276),(0.719279,0.636347,276),(0.715201,0.480114,276),(0.711391,0.633947,276),(0.724483,0.597149,276),(0.701002,0.664738,276),(0.714059,0.70017,276),(0.701055,0.599938,276),(0.71264,0.622173,276),(0.71664,0.505922,276),(0.733507,0.613702,276),(0.716985,0.492638,276),(0.703164,0.670619,276),(0.704032,0.74304,276),(0.710199,0.528265,276),(0.720588,0.634078,276),(0.719963,0.570621,276),(0.715949,0.707241,276),(0.704366,0.523846,276),(0.715204,0.607457,276),(0.706669,0.511537,276),(0.715318,0.661111,276),(0.707728,0.73306,276),(0.714618,0.7028,276),(0.708458,0.644928,276),(0.701377,0.547192,276),(0.704682,0.50409,276),(0.71564,0.498076,276),(0.713374,0.618947,276),(0.714462,0.508852,276),(0.713665,0.469513,276),(0.722633,0.477508,276),(0.713394,0.650378,276),(0.712526,0.651822,276),(0.716516,0.538483,276),(0.70633,0.56986,276),(0.728415,0.47517,276),(0.701592,0.509852,276),(0.713069,0.464786,276),(0.700397,0.688289,276),(0.702175,0.570441,276),(0.717201,0.494482,276),(0.722183,0.58949,276),(0.708638,0.752149,276),(0.716823,0.537307,276),(0.7102,0.516891,276),(0.701889,0.495739,276),(0.719161,0.56946,276),(0.700866,0.752834,276),(0.705612,0.518731,276),(0.711517,0.522149,276),(0.715827,0.505267,276),(0.710965,0.601683,276),(0.699494,0.515105,276),(0.698932,0.736054,276),(0.72267,0.723227,276),(0.712085,0.536655,276),(0.719304,0.473104,276),(0.715071,0.622423,276),(0.70195,0.509547,276),(0.715415,0.499431,276),(0.711891,0.656273,276),(0.706165,0.68908,276),(0.716123,0.680732,276),(0.699963,0.482653,276),(0.71064,0.520607,276),(0.714136,0.669987,276),(0.706989,0.528704,276),(0.712109,0.561943,276),(0.705653,0.508933,276),(0.705292,0.465494,276),(0.712143,0.513662,276),(0.714552,0.532078,276),(0.71607,0.654523,276),(0.716167,0.500478,276),(0.716344,0.503985,276),(0.720518,0.548349,276),(0.705106,0.485088,276),(0.709806,0.638223,276),(0.727404,0.463489,276),(0.712773,0.543912,276),(0.71941,0.557734,276),(0.702296,0.576521,276),(0.707712,0.610051,276),(0.718363,0.485202,276),(0.720559,0.488697,276),(0.712297,0.574101,276),(0.717196,0.710859,276),(0.723027,0.559824,276),(0.718085,0.496748,276),(0.719056,0.640919,276),(0.708603,0.586698,276),(0.700672,0.460878,276),(0.698713,0.472153,276),(0.701477,0.507212,276),(0.714488,0.667223,276),(0.723769,0.606793,276),(0.710974,0.551631,276),(0.700609,0.523238,276),(0.702112,0.475466,276),(0.701055,0.557128,276),(0.716492,0.684665,276),(0.70265,0.702107,276),(0.726682,0.564396,276),(0.704279,0.488285,276),(0.716266,0.503645,276),(0.725495,0.626694,276),(0.723134,0.472863,276),(0.718765,0.729887,276),(0.714705,0.696867,276),(0.721679,0.720942,276),(0.71892,0.715367,276),(0.717482,0.745294,276),(0.714512,0.699151,276),(0.709534,0.625405,276),(0.718542,0.54767,276),(0.70107,0.608116,276),(0.710087,0.534459,276),(0.717097,0.543081,276),(0.715955,0.690652,276),(0.711755,0.530638,276),(0.714676,0.675643,276),(0.715811,0.504155,276),(0.715709,0.50419,276),(0.640806,0.500986,276),(0.715294,0.508182,276),(0.717209,0.50269,276),(0.715271,0.499861,276),(0.715947,0.498903,276),(0.696699,0.573562,276),(0.715625,0.503699,276),(0.717444,0.50385,276),(0.714899,0.51087,276),(0.715628,0.510192,276),(0.669752,0.473599,276),(0.185587,-1.07134,140),(0.185611,-1.07105,140),(0.195186,-1.06,140),(0.184714,-1.06669,140),(0.179478,-1.0728,140),(0.18616,-1.07367,140),(0.177733,-1.07658,140),(0.179472,-1.07244,140),(0.179877,-1.07245,140),(0.183551,-1.07192,140),(0.185587,-1.0696,140),(-0.148776,3.12753,329),(0.413808,2.10388,229),(0.403606,2.10245,229),(0.437166,2.12113,229),(0.401266,2.09812,229),(0.421443,2.10633,229),(0.434303,2.11692,229),(0.436581,2.12,229),(0.418292,2.11132,229),(0.417407,2.10598,229),(0.411294,2.08717,229),(0.414453,2.10753,229),(0.394728,2.09986,229),(0.432091,2.12499,229),(0.418477,2.1224,229),(0.432905,2.1113,229),(0.384045,2.10738,229),(0.438571,2.1248,229),(0.436222,2.11703,229),(0.397207,2.11437,229),(0.418165,2.10635,229),(-0.107581,0.684133,18),(-0.0882419,0.693408,18),(-0.159116,0.574795,18),(-0.122289,0.685888,18),(-0.0573049,0.55023,18),(-0.0890748,0.530425,18),(-0.0609458,0.557875,18),(-0.123918,0.545124,18),(-0.0468329,0.575959,18),(-0.0587595,0.643154,18),(-0.0884301,0.559378,18),(-0.162316,0.571886,18),(-0.0884301,0.571304,18),(-0.161443,0.587303,18),(-0.0677769,0.579449,18),(-0.0235619,0.599812,18),(-0.0884695,0.682402,18),(-0.0875496,0.572933,18),(-0.139045,0.551815,18),(-0.0613775,0.584976,18),(-0.0587595,0.592539,18),(-0.112283,0.690278,18),(-0.0215257,0.600975,18),(-0.0840601,0.60639,18),(-0.0983202,0.571886,18),(-0.0639476,0.58331,18),(-0.0762128,0.596903,18),(-0.0829031,0.60272,18),(-0.0709768,0.658571,18),(-0.0474293,0.534638,18),(-0.151844,0.600102,18),(-0.0872665,0.606211,18),(-0.0619592,0.58294,18),(-0.0735948,0.579158,18),(-0.0331613,0.593703,18),(-0.0555596,0.58963,18),(-0.0459603,0.593121,18),(-0.0199646,0.547941,18),(-0.0313868,0.550671,18),(-0.162897,0.606793,18),(-0.0891718,0.541784,18),(-0.0517782,0.581776,18),(-0.11781,0.665261,18),(-0.0438465,0.535045,18),(-0.0779581,0.618719,18),(-0.131191,0.541925,18),(-0.0439242,0.574213,18),(-0.0619592,0.586431,18),(-0.109083,0.674861,18),(-0.0261799,0.589921,18),(-0.0346156,0.574504,18),(-0.0866847,0.608829,18),(-0.0901754,0.676897,18),(-0.0322886,0.605629,18),(-0.157371,0.607375,18),(-0.0584685,0.625701,18),(-0.0794125,0.608247,18),(-0.114028,0.649262,18),(-0.110828,0.636754,18),(-0.11072,0.542265,18),(-0.0584685,0.65159,18),(-0.119049,0.657312,18),(-0.15708,0.575668,18),(-0.153589,0.625119,18),(-0.170751,0.60243,18),(-0.116937,0.676024,18),(-0.0861029,0.679515,18),(-0.124232,0.684306,18),(-0.0842994,0.517631,18),(-0.0497419,0.577413,18),(-0.129226,0.645477,18),(-0.0573049,0.573341,18),(-0.103847,0.595739,18),(-0.0622501,0.644899,18),(-0.155334,0.583813,18),(-0.0837758,0.667007,18),(-0.0837758,0.667588,18),(-0.144862,0.55007,18),(-0.0468329,0.593121,18),(-0.0634136,0.561705,18),(-0.0881391,0.673988,18),(-0.155916,0.630646,18),(-0.0546869,0.585267,18),(-0.0826122,0.66497,18),(-0.154462,0.607956,18),(-0.173369,0.616683,18),(-0.0450876,0.582067,18),(-0.0701041,0.624246,18),(-0.118682,0.685042,18),(-0.111119,0.652171,18),(-0.126536,0.612029,18),(-0.0895935,0.567814,18),(-0.0834849,0.66817,18),(-0.112574,0.669043,18),(-0.170461,0.662062,18),(-0.0660316,0.656535,18),(-0.0602139,0.592539,18),(-0.149517,0.559378,18),(-0.167261,0.590794,18),(-0.0855211,0.624537,18),(-0.159989,0.585267,18),(-0.0631228,0.591085,18),(-0.0538143,0.59603,18),(-0.129445,0.534071,18),(-0.0744674,0.599812,18),(-0.0573049,0.645481,18),(-0.119264,0.645481,18),(-0.0851187,0.517083,18),(-0.132708,0.645848,18),(-0.134376,0.645025,18),(-0.0625943,0.53617,18),(-0.13477,0.679587,18),(-0.0375246,0.583813,18),(-0.117228,0.634718,18),(-0.118101,0.679224,18),(-0.161152,0.586722,18),(-0.0527138,0.556687,18),(-0.0244346,0.553851,18),(-0.079878,0.525388,18),(-0.0497419,0.566068,18),(-0.0581776,0.622501,18),(-0.0282501,0.551873,18),(-0.0572953,0.540427,18),(-0.0669042,0.568977,18),(-0.0460524,0.531763,18),(-0.125664,0.623664,18),(-0.0994838,0.601848,18),(-0.0680678,0.574795,18),(-0.135554,0.623083,18),(-0.165515,0.591667,18),(-0.133982,0.628957,18),(-0.0814488,0.608538,18),(-0.155334,0.603593,18),(-0.0895935,0.606793,18),(-0.154462,0.590794,18),(-0.0747582,0.591376,18),(-0.0797034,0.604466,18),(-0.141953,0.640245,18),(-0.0785398,0.66148,18),(-0.107338,0.643445,18),(-0.0744674,0.625701,18),(-0.0709768,0.617556,18),(-0.107725,0.623771,18),(-0.119092,0.685382,18),(-0.0735948,0.620465,18),(-0.154462,0.593703,18),(-0.0460379,0.554438,18),(-0.0945387,0.663516,18),(-0.115852,0.669403,18),(-0.132354,0.545706,18),(-0.0915575,0.694058,18),(-0.0308342,0.59283,18),(-0.0527719,0.556319,18),(-0.133233,0.681694,18),(-0.0357792,0.591085,18),(-0.023242,0.555228,18),(-0.0501007,0.532815,18),(-0.045936,0.546443,18),(-0.0762128,0.61232,18),(-0.0738855,0.618137,18),(-0.0488692,0.593121,18),(-0.112283,0.678933,18),(-0.0735948,0.623955,18),(-0.0587595,0.640245,18),(-0.197222,0.611447,18),(-0.187623,0.691732,18),(-0.186459,0.62221,18),(-0.180351,0.685623,18),(-0.191114,0.685623,18),(-0.186459,0.695223,18),(-0.190241,0.671952,18),(-0.181223,0.683296,18),(-0.181223,0.676606,18),(-0.179187,0.701331,18),(-0.190823,0.611156,18),(-0.187623,0.60912,18),(-0.187041,0.677188,18),(-0.184714,0.617847,18),(-0.184423,0.677188,18),(-0.190241,0.686496,18),(-0.174533,0.693187,18),(-0.187041,0.693477,18),(-0.188496,0.611738,18),(-0.0621655,0.645404,18),(0.882878,0.601875,279),(0.848756,0.655416,279),(0.827931,0.61565,313),(0.856584,0.540486,279),(0.837957,0.66784,279),(0.866885,0.559164,279),(0.869278,0.434489,279),(0.850198,0.570107,279),(0.86737,0.634621,279),(0.877288,0.500503,279),(0.855858,0.490647,279),(0.84382,0.584691,279),(0.859495,0.525522,279),(0.881751,0.458018,279),(0.834667,0.614187,313),(0.813709,0.54282,279),(0.788905,0.582356,299),(0.84183,0.666914,279),(0.840023,0.660771,279),(0.776674,0.59623,299),(0.877547,0.554359,279),(0.882871,0.532147,279),(0.840225,0.401891,305),(0.830165,0.546825,279),(0.830795,0.654442,279),(0.87774,0.644744,279),(0.887544,0.424528,279),(0.879456,0.530065,279),(0.859274,0.497087,279),(0.855473,0.542136,279),(0.875927,0.52907,279),(0.848521,0.389208,305),(0.85082,0.527471,279),(0.84953,0.503465,279),(0.813645,0.571053,279),(0.86007,0.41026,279),(0.838435,0.673642,279),(0.824759,0.623299,313),(0.864913,0.446901,279),(0.854309,0.671806,313),(0.856066,0.580166,279),(0.839323,0.692065,313),(0.862372,0.665849,313),(0.847332,0.401352,305),(0.88875,0.60738,279),(0.859788,0.416367,279),(0.860345,0.411262,279),(0.868435,0.474789,279),(0.860069,0.67912,313),(0.847675,0.674457,313),(0.880944,0.423816,279),(0.838214,0.676703,279),(0.859093,0.556536,279),(0.852884,0.656535,279),(0.877928,0.468884,279),(0.867983,0.517764,279),(0.804878,0.574409,279),(0.843351,0.619905,279),(0.784651,0.595346,299),(0.855331,0.547941,279),(0.905179,0.584158,279),(0.875901,0.47235,279),(0.838849,0.672242,279),(0.778222,0.585076,299),(0.896016,0.464291,279),(0.864257,0.404873,279),(0.787741,0.58643,299),(0.855426,0.669852,313),(0.817571,0.524981,279),(0.839212,0.687269,313),(0.885773,0.584244,279),(0.883539,0.457755,279),(0.793379,0.493809,279),(0.881324,0.510144,279),(0.844972,0.58836,279),(0.896008,0.591155,279),(0.883019,0.56527,279),(0.848811,0.669823,313),(0.865574,0.602849,279),(0.874833,0.480155,279),(0.82876,0.632745,313),(0.847799,0.612729,279),(0.876932,0.567419,279),(0.848752,0.672791,313),(0.838532,0.538447,279),(0.874195,0.549421,279),(0.845399,0.677953,313),(0.847068,0.626058,279),(0.895783,0.502716,279),(0.830206,0.624579,313),(0.849445,0.577982,279),(0.811185,0.536385,279),(0.813547,0.550648,279),(0.874584,0.534467,279),(0.832401,0.567609,279),(0.885332,0.421718,279),(0.843454,0.550276,279),(0.848893,0.61515,279),(0.883034,0.481999,279),(0.81602,0.582044,279),(0.888923,0.551224,279),(0.890956,0.556531,279),(0.793215,0.606299,299),(0.830274,0.60033,279),(0.878599,0.464986,279),(0.848837,0.428816,279),(0.81971,0.55846,279),(0.845423,0.3965,305),(0.843793,0.692167,313),(0.845542,0.48517,279),(0.775508,0.594866,299),(0.872116,0.586585,279),(0.869576,0.629203,279),(0.817668,0.617241,313),(0.821468,0.654498,279),(0.831395,0.604367,279),(0.886144,0.510305,279),(0.838593,0.661929,279),(0.871738,0.627081,279),(0.869842,0.419285,279),(0.844828,0.684636,313),(0.885917,0.442309,279),(0.847655,0.686212,313),(0.872948,0.575905,279),(0.85328,0.633861,279),(0.853551,0.670941,313),(0.849713,0.510278,279),(0.8806,0.532741,279),(0.902044,0.451459,279),(0.8375,0.650695,279),(0.836181,0.582599,279),(0.899678,0.582674,279),(0.856075,0.667029,313),(0.874356,0.448979,279),(0.856909,0.583284,279),(0.840193,0.679581,313),(0.855008,0.659774,279),(0.802104,0.58986,299),(0.861868,0.618548,279),(0.842859,0.693547,313),(0.84268,0.648841,279),(0.866588,0.470759,279),(0.850378,0.655481,279),(0.866054,0.658051,279),(0.893875,0.431248,279),(0.833448,0.515432,279),(0.862523,0.545566,279),(0.878201,0.507128,279),(0.889409,0.499837,279),(0.846968,0.65811,279),(0.894312,0.579495,279),(0.865631,0.637502,279),(0.847028,0.436969,279),(0.887225,0.44433,279),(0.848885,0.674444,313),(0.846715,0.563038,279),(0.793343,0.510747,279),(0.840887,0.406646,305),(0.86257,0.471178,279),(0.864982,0.487951,279),(0.814297,0.569288,279),(0.838499,0.665796,279),(0.87233,0.632729,279),(0.791694,0.636532,299),(0.867678,0.503246,279),(0.863182,0.613125,279),(0.868333,0.549081,279),(0.849705,0.464006,279),(0.855419,0.42539,279),(0.863133,0.497874,279),(0.817053,0.584458,279),(0.858855,0.650109,279),(0.87475,0.468119,279),(0.791494,0.503367,279),(0.853841,0.431266,279),(0.881771,0.527972,279),(0.836449,0.666757,279),(0.808174,0.535027,279),(0.858069,0.463977,279),(0.843814,0.664171,279),(0.901955,0.591949,279),(0.831892,0.632792,313),(0.868906,0.412737,279),(0.860184,0.548821,279),(0.812053,0.567654,279),(0.805922,0.607434,279),(0.843685,0.521293,279),(0.85192,0.512948,279),(0.879142,0.593255,279),(0.78604,0.617461,299),(0.874003,0.522162,279),(0.829008,0.604886,313),(0.797819,0.600267,299),(0.844716,0.66057,279),(0.853276,0.468732,279),(0.879942,0.449149,279),(0.861318,0.41025,279),(0.838159,0.659774,279),(0.854745,0.419044,279),(0.839685,0.571848,279),(0.833355,0.657533,279),(0.845812,0.64726,279),(0.845612,0.610574,279),(0.846683,0.603921,279),(0.826967,0.610455,313),(0.874525,0.630432,279),(0.843705,0.670292,279),(0.8698,0.640327,279),(0.85551,0.450261,279),(0.839087,0.694574,313),(0.87949,0.422983,279),(0.842845,0.452744,279),(0.898941,0.546024,279),(0.862691,0.559589,279),(0.88215,0.527299,279),(0.846677,0.674958,313),(0.881707,0.537679,279),(0.874199,0.438955,279),(0.878234,0.528787,279),(0.87882,0.540267,279),(0.860216,0.408972,279),(0.797312,0.499424,279),(0.8648,0.53886,279),(0.875538,0.620074,279),(0.806258,0.529697,279),(0.869338,0.525555,279),(0.863065,0.435169,279),(0.841346,0.395216,305),(0.870907,0.499205,279),(0.816226,0.642261,313),(0.892739,0.598873,279),(0.786351,0.603916,299),(0.856558,0.483152,279),(0.836632,0.516963,279),(0.863287,0.64332,279),(0.776921,0.586433,299),(0.893273,0.571716,279),(0.781126,0.59093,299),(0.8402,0.658732,279),(0.802711,0.513445,279),(0.848153,0.663223,279),(0.804757,0.588037,299),(0.831824,0.588415,279),(0.839766,0.682272,313),(0.834154,0.671562,279),(0.779749,0.600529,299),(0.845942,0.677479,313),(0.878081,0.609099,279),(0.855381,0.587224,279),(0.899187,0.536415,279),(0.834578,0.54424,279),(0.0604767,0.545361,27),(0.0127118,0.567445,27),(0.00705881,0.566524,27),(0.012095,0.596568,27),(0.0299261,0.586625,27),(0.019984,0.588341,27),(0.0421792,0.540799,27),(-0.015417,0.51749,27),(-0.0153491,0.528209,27),(0.00730612,0.578979,27),(0.0432538,0.542604,27),(0.012033,0.56586,27),(0.00616677,0.571687,27),(0.00974749,0.547944,27),(0.0638944,0.553701,27),(0.00728675,0.558903,27),(-0.0105535,0.534917,27),(0.018886,0.596467,27),(0.0292245,0.553531,27),(-0.00582573,0.553864,27),(0.0148208,0.566762,27),(0.00658373,0.574557,27),(0.0392682,0.574211,27),(0.0110441,0.534444,27),(0.0520206,0.595734,27),(0.0572177,0.573981,27),(0.00606502,0.569836,27),(0.0122609,0.574015,27),(0.00319971,0.525053,27),(0.00325678,0.531521,27),(0.00552013,0.568667,27),(-0.0217917,0.523423,27),(0.00766234,0.579505,27),(0.010632,0.584137,27),(0.025013,0.547203,27),(0.0484254,0.563724,27),(0.0115495,0.528395,27),(0.00112469,0.566306,27),(-0.0103266,0.53457,27),(0.0112089,0.579003,27),(0.00813114,0.595021,27),(0.0134341,0.586659,27),(0.0124123,0.524728,27),(0.00997264,0.588903,27),(0.0527112,0.5395,27),(0.0589548,0.554856,27),(0.676016,-1.34492,132),(0.582971,-1.51764,83),(0.647227,-1.54636,83),(0.585046,-1.51499,83),(0.587228,-1.51291,83),(0.534132,-1.53421,83),(0.603987,-1.51815,83),(0.544948,-1.49035,83),(0.607541,-1.52977,83),(0.546553,-1.49846,83),(0.532726,-1.5342,83),(0.607371,-1.53026,83),(0.593661,-1.5011,83),(0.581129,-1.51571,83),(0.584193,-1.51496,83),(0.583034,-1.51514,83),(0.583834,-1.51838,83),(0.606159,-1.51121,83),(0.605616,-1.51404,83),(0.535718,-1.53664,83),(0.564907,-1.50622,83),(0.584702,-1.51411,83),(0.579956,-1.52851,83),(0.56977,-1.49013,83),(0.58668,-1.4981,83),(0.580945,-1.51512,83),(0.566725,-1.48354,132),(0.566604,-1.50901,83),(0.536493,-1.53727,83),(0.565615,-1.5188,83),(0.583567,-1.50283,83),(0.5339,-1.53887,83),(0.555168,-1.50046,83),(0.586777,-1.51161,83),(0.579621,-1.52837,83),(0.58379,-1.51473,83),(0.635815,-1.64465,83),(0.636722,-1.64538,83),(0.603265,-1.61594,83),(0.634826,-1.64425,83),(0.62705,-1.56938,83),(0.603813,-1.61424,83),(0.610421,-1.60599,83),(0.612413,-1.61342,83),(0.579582,-1.61733,83),(0.629411,-1.64336,83),(0.611008,-1.58458,83),(0.617601,-1.64757,83),(0.602203,-1.62412,83),(0.60853,-1.60763,83),(0.625566,-1.58309,83),(0.60644,-1.61076,83),(0.60854,-1.61276,83),(0.606843,-1.61036,83),(0.629338,-1.57948,83),(0.597399,-1.60576,83),(0.634113,-1.64268,83),(0.615725,-1.62549,83),(0.61524,-1.6011,83),(0.631602,-1.65004,83),(0.631578,-1.64286,83),(0.583669,-1.64127,83),(0.618488,-1.64669,83),(0.613422,-1.57402,83),(0.678848,-1.34454,132),(0.691661,-1.32049,132),(0.683439,-1.31815,132),(0.688525,-1.3215,132),(0.692612,-1.32208,132),(0.693698,-1.31854,132),(0.500231,-1.4201,132),(0.50057,-1.42261,132),(0.453026,-1.39869,132),(0.486884,-1.42843,132),(0.494394,-1.4431,132),(0.478662,-1.44147,132),(0.465733,-1.40791,132),(0.531655,-1.52393,83),(0.486836,-1.43537,132),(0.459808,-1.39882,132),(0.460046,-1.39771,132),(0.459716,-1.42731,132),(0.462955,-1.39742,132),(0.479947,-1.4412,132),(0.487607,-1.43616,132),(0.531781,-1.52256,83),(0.450675,-1.40047,132),(0.494554,-1.41988,132),(0.53422,-1.52437,83),(0.463609,-1.43029,132),(0.45275,-1.40055,132),(0.489565,-1.43977,132),(0.489871,-1.44026,132),(0.500522,-1.41944,132),(0.49006,-1.44112,132),(0.488096,-1.44513,132),(0.498282,-1.42721,132),(0.495431,-1.40921,132),(0.458179,-1.39939,132),(0.44877,-1.40075,132),(0.454786,-1.40101,132),(0.448925,-1.40095,132),(0.458519,-1.40099,132),(0.449351,-1.40158,132),(0.447398,-1.40381,132),(0.452881,-1.4018,132),(0.5369,-1.51094,83),(0.447068,-1.40168,132),(0.446467,-1.40231,132),(0.454699,-1.39878,132),(0.454883,-1.40033,132),(0.509825,-1.41412,132),(0.50664,-1.41901,132),(0.504104,-1.4191,132),(0.459343,-1.398,132),(0.46184,-1.39753,132),(0.50441,-1.41832,132),(0.450636,-1.40247,132),(0.489037,-1.44464,132),(0.490627,-1.4433,132),(0.531083,-1.52158,83),(0.505951,-1.41201,132),(0.489001,-1.44,132),(0.532654,-1.5232,83),(0.461433,-1.4278,132),(0.503576,-1.42568,132),(0.532503,-1.52214,83),(0.481367,-1.40301,132),(0.45592,-1.39877,132),(0.464636,-1.42839,132),(0.479035,-1.40195,132),(0.530681,-1.51178,83),(0.449822,-1.40233,132),(0.525537,-1.42492,132),(0.517519,-1.43684,132),(0.448682,-1.40195,132),(0.457065,-1.42585,132),(0.452246,-1.39976,132),(0.464671,-1.39845,132),(0.490685,-1.4245,132),(0.453457,-1.39885,132),(0.4513,-1.40112,132),(0.451431,-1.40193,132),(0.49197,-1.44408,132),(0.453981,-1.39887,132),(0.444513,-1.4046,132),(0.461093,-1.421,132),(0.462868,-1.43054,132),(0.453128,-1.39935,132),(0.529396,-1.42516,132),(0.528742,-1.42058,132),(0.493807,-1.44321,132),(0.470091,-1.39791,132),(0.448692,-1.40337,132),(0.448188,-1.4018,132),(0.428578,-1.42738,132),(0.491412,-1.44201,132),(0.49401,-1.42099,132),(0.497448,-1.42316,132),(0.489987,-1.4394,132),(0.464535,-1.39726,132),(0.464545,-1.39803,132),(0.489381,-1.43029,132),(0.525867,-1.42712,132),(0.492513,-1.43916,132),(0.487112,-1.44491,132),(0.456691,-1.3999,132),(0.456235,-1.39999,132),(0.48557,-1.44303,132),(0.502844,-1.42904,132),(0.4647,-1.42462,132),(0.444979,-1.40375,132),(0.49133,-1.43922,132),(0.527883,-1.49484,83),(0.499649,-1.42005,132),(0.458053,-1.39987,132),(0.495421,-1.42011,132),(0.490152,-1.40688,132),(0.498102,-1.40799,132),(0.449846,-1.39964,132),(0.450132,-1.39853,132),(0.452774,-1.40055,132),(0.452192,-1.40165,132),(0.453564,-1.40032,132),(0.530947,-1.5238,83),(0.456265,-1.42759,132),(0.530608,-1.51606,83),(0.506596,-1.41244,132),(0.452895,-1.39997,132),(0.465432,-1.42908,132),(0.457578,-1.40021,132),(0.451867,-1.39952,132),(0.452619,-1.3991,132),(0.472011,-1.43529,132),(0.496915,-1.42113,132),(0.456793,-1.39857,132),(0.509413,-1.43361,132),(0.498626,-1.42321,132),(0.452886,-1.39889,132),(0.452081,-1.40063,132),(0.498088,-1.42034,132),(0.511134,-1.41469,132),(0.500386,-1.41735,132),(0.53406,-1.52125,83),(0.489294,-1.40654,132),(0.468156,-1.39868,132),(0.474168,-1.40091,132),(0.516355,-1.41734,132),(0.490055,-1.4445,132),(0.464884,-1.39794,132),(0.526696,-1.42048,132),(0.447184,-1.40193,132),(0.526382,-1.49505,83),(0.459198,-1.4004,132),(0.453841,-1.40017,132),(0.530952,-1.52222,83),(0.498427,-1.42163,132),(0.447975,-1.40164,132),(0.485949,-1.44338,132),(0.451499,-1.40005,132),(0.489017,-1.43314,132),(0.456128,-1.40031,132),(0.491141,-1.42172,132),(0.457937,-1.39844,132),(0.527782,-1.42045,132),(0.470823,-1.43275,132),(0.50856,-1.41364,132),(0.476369,-1.40238,132),(0.44573,-1.4034,132),(0.470013,-1.43196,132),(0.4698,-1.43254,132),(0.446988,-1.40376,132),(0.486356,-1.43687,132),(0.467318,-1.39728,132),(0.494815,-1.40892,132),(0.46615,-1.40029,132),(0.48382,-1.43873,132),(0.488532,-1.44327,132),(0.493036,-1.41862,132),(0.484693,-1.44303,132),(0.461942,-1.4277,132),(0.459706,-1.39954,132),(0.502664,-1.41848,132),(0.477111,-1.44043,132),(0.485488,-1.40448,132),(0.485895,-1.44498,132),(0.479322,-1.44132,132),(0.446763,-1.40291,132),(0.495552,-1.42041,132),(0.497015,-1.44034,132),(0.474687,-1.40068,132),(0.483772,-1.43731,132),(0.452924,-1.39841,132),(0.456537,-1.40126,132),(0.448653,-1.40241,132),(0.531248,-1.47098,132),(0.457501,-1.40062,132),(0.449574,-1.40322,132),(0.487776,-1.43917,132),(0.491242,-1.44438,132),(0.489308,-1.43796,132),(0.448038,-1.40327,132),(0.448052,-1.40402,132),(0.504995,-1.43047,132),(0.447538,-1.40322,132),(0.499377,-1.41036,132),(0.488877,-1.44125,132),(0.449361,-1.40268,132),(0.487608,-1.4353,132),(0.47298,-1.4391,132),(0.482385,-1.4032,132),(0.500885,-1.42115,132),(0.500885,-1.42115,132),(0.465282,-1.40048,132),(0.492876,-1.43689,132),(0.489652,-1.44181,132),(0.45129,-1.4004,132),(0.489943,-1.40767,132),(0.466271,-1.39719,132),(0.531044,-1.52332,83),(0.485549,-1.4432,132),(0.449506,-1.40198,132),(0.455537,-1.40324,132),(0.498558,-1.42395,132),(0.48908,-1.42651,132),(0.499164,-1.41964,132),(0.50089,-1.41909,132),(0.531553,-1.51212,83),(0.594563,-1.47789,132),(0.551149,-1.46879,132),(0.594728,-1.47121,132),(0.559769,-1.47014,132),(0.59273,-1.45522,132),(0.589031,-1.47285,132),(0.584179,-1.43073,132),(0.589133,-1.47074,132),(0.543669,-1.42229,132),(0.602184,-1.48268,132),(0.597544,-1.47464,132),(0.586083,-1.48487,132),(0.596294,-1.48004,132),(0.566551,-1.48332,132),(0.587611,-1.46639,132),(0.606847,-1.48301,132),(0.589482,-1.47125,132),(0.589075,-1.47913,132),(0.567938,-1.44694,132),(0.593462,-1.4686,132),(0.592473,-1.47192,132),(0.587819,-1.47374,132),(0.585274,-1.43345,132),(0.58379,-1.47402,132),(0.586815,-1.47252,132),(0.598611,-1.46301,132),(0.580266,-1.47069,132),(0.555833,-1.42412,132),(0.593821,-1.47682,132),(0.537561,-1.42576,132),(0.576644,-1.48408,132),(0.592648,-1.46587,132),(0.589817,-1.4776,132),(0.590196,-1.47588,132),(0.573178,-1.45966,132),(0.592585,-1.47567,132),(0.584988,-1.43249,132),(0.583766,-1.46864,132),(0.577357,-1.45267,132),(0.582603,-1.48003,132),(0.591057,-1.47195,132),(0.589753,-1.47142,132),(0.590214,-1.47154,132),(0.582884,-1.47647,132),(0.560521,-1.41803,132),(0.588968,-1.46837,132),(0.585953,-1.47329,132),(0.597898,-1.4864,132),(0.593816,-1.47239,132),(0.536349,-1.42325,132),(0.59209,-1.47268,132),(0.559963,-1.41546,132),(0.591387,-1.47505,132),(0.590922,-1.46642,132),(0.566338,-1.42739,132),(0.585458,-1.47016,132),(0.595271,-1.46666,132),(0.594311,-1.46732,132),(0.5382,-1.46571,132),(0.548914,-1.4575,132),(0.590873,-1.46987,132),(0.586205,-1.47554,132),(0.538132,-1.45348,132),(0.569344,-1.45909,132),(0.558567,-1.41326,132),(0.595183,-1.47514,132),(0.678769,-1.57401,83),(0.672302,-1.57052,83),(0.673189,-1.57411,83),(0.658465,-1.55713,83),(0.689338,-1.53896,83),(0.674925,-1.57053,83),(0.695345,-1.55255,83),(0.674125,-1.57343,83),(0.677387,-1.56998,83),(0.673504,-1.57063,83),(0.679904,-1.57406,83),(0.675468,-1.57339,83),(0.693488,-1.57479,83),(0.658523,-1.55218,83),(0.68911,-1.5424,83),(0.668763,-1.55165,83),(0.673562,-1.56925,83),(0.697008,-1.5954,83),(0.694671,-1.56458,83),(0.679133,-1.57343,83),(0.683564,-1.51017,107),(0.695398,-1.50793,107),(0.697754,-1.50304,107),(0.668404,-1.49679,111),(0.684194,-1.49961,107),(0.662785,-1.52814,83),(0.697357,-1.50123,107),(0.69438,-1.49696,107),(0.691389,-1.50284,107),(0.694089,-1.50374,107),(0.670057,-1.51723,108),(0.66807,-1.4964,111),(0.695316,-1.50142,107),(0.66821,-1.49791,111),(0.696891,-1.48999,107),(0.692969,-1.50795,107),(0.695146,-1.48161,107),(0.679967,-1.49907,107),(0.689779,-1.49709,107),(0.688824,-1.52566,107),(0.675046,-1.52766,108),(0.655294,-1.69766,83),(0.670274,-1.67869,83),(0.677377,-1.65679,83),(0.669586,-1.72377,83),(0.67857,-1.73358,83),(0.664287,-1.7092,83),(0.681178,-1.69003,83),(0.682671,-1.65156,83),(0.680184,-1.66217,83),(0.686108,-1.65671,83),(0.680097,-1.65138,83),(0.679869,-1.65341,83),(0.683883,-1.68549,83),(0.66404,-1.69899,83),(0.678608,-1.65491,83),(0.680368,-1.65232,83),(0.652943,-1.65291,83),(0.680533,-1.65167,83),(0.677891,-1.70364,83),(0.681406,-1.65318,83),(0.681522,-1.6699,83),(0.657854,-1.69886,83),(0.671575,-1.4423,132),(0.645603,-1.50873,83),(0.681159,-1.47871,132),(0.682139,-1.47495,132),(0.65704,-1.47955,132),(0.657884,-1.49852,132),(0.68097,-1.47656,132),(0.666014,-1.49379,111),(0.68066,-1.47701,132),(0.681988,-1.47388,132),(0.666732,-1.48132,132),(0.666887,-1.47583,132),(0.660365,-1.52873,83),(0.665718,-1.49442,111),(0.643426,-1.52696,83),(0.679686,-1.47557,132),(0.671192,-1.44325,132),(0.666615,-1.49338,111),(0.663028,-1.47441,132),(0.664094,-1.47408,132),(0.667662,-1.49678,111),(0.651498,-1.52714,83),(0.670426,-1.44355,132),(0.638971,-1.54138,83),(0.666019,-1.49504,111),(0.682275,-1.47473,132),(0.661142,-1.47608,132),(0.665689,-1.49553,111),(0.659285,-1.52041,83),(0.665762,-1.49851,111),(0.660439,-1.5001,132),(0.658824,-1.47122,132),(0.667638,-1.49498,111),(0.666717,-1.49789,111),(0.665166,-1.49872,111),(0.663052,-1.46921,132),(0.546485,-1.61347,83),(0.531466,-1.59095,83),(0.517038,-1.58391,83),(0.567511,-1.63593,83),(0.533274,-1.58889,83),(0.522599,-1.57016,83),(0.520907,-1.57266,83),(0.522109,-1.57174,83),(0.532402,-1.57885,83),(0.521915,-1.57215,83),(0.516544,-1.58335,83),(0.523496,-1.57502,83),(0.52751,-1.60605,83),(0.527318,-1.62672,83),(0.524761,-1.57918,83),(0.521842,-1.57255,83),(0.523321,-1.57346,83),(0.523224,-1.57366,83),(0.567394,-1.60779,83),(0.554329,-1.62466,83),(0.523661,-1.60254,83),(0.522807,-1.57211,83),(0.532911,-1.60713,83),(0.528887,-1.58776,83),(0.567637,-1.61684,83),(0.530603,-1.58827,83),(0.567671,-1.63625,83),(0.528402,-1.56698,83),(0.527728,-1.62974,83),(0.522031,-1.57136,83),(0.680734,-1.34341,132),(0.680302,-1.33504,132),(0.685121,-1.33867,132),(0.681238,-1.33522,132),(0.682067,-1.34518,132),(0.685746,-1.33713,132),(0.687182,-1.3515,132),(0.681286,-1.34229,132),(0.680341,-1.34565,132),(0.67968,-1.3392,132),(0.681684,-1.34278,132),(0.677258,-1.34227,132),(0.68756,-1.33559,132),(0.685427,-1.33922,132),(0.680045,-1.34374,132),(0.682566,-1.34386,132),(0.676579,-1.34213,132),(0.689077,-1.33769,132),(0.680341,-1.3428,132),(0.684874,-1.3411,132),(0.680709,-1.33845,132),(0.692073,-1.37467,132),(0.685713,-1.34746,132),(0.685053,-1.33554,132),(0.680016,-1.34254,132),(0.676739,-1.32778,132),(0.687986,-1.33159,132),(0.687724,-1.34304,132),(0.691269,-1.32354,132),(0.684389,-1.3389,132),(0.685344,-1.34038,132),(0.686076,-1.33474,132),(0.682009,-1.34317,132),(0.683875,-1.33762,132),(0.675571,-1.34431,132),(0.687909,-1.35107,132),(0.683182,-1.34742,132),(0.683701,-1.34864,132),(0.677519,-1.34388,132),(0.683517,-1.33735,132),(0.683114,-1.33601,132),(0.680758,-1.34173,132),(0.691879,-1.35647,132),(0.684045,-1.33909,132),(0.677762,-1.3432,132),(0.689402,-1.33764,132),(0.679909,-1.34295,132),(0.685058,-1.3398,132),(0.682547,-1.33491,132),(0.679527,-1.3421,132),(0.680482,-1.34358,132),(0.682411,-1.34126,132),(0.686624,-1.33905,132),(0.682285,-1.34072,132),(0.686513,-1.33412,132),(0.68675,-1.33989,132),(0.683764,-1.34731,132),(0.6901,-1.33265,132),(0.681456,-1.34598,132),(0.682125,-1.34853,132),(0.682144,-1.33867,132),(0.683352,-1.34507,132),(0.688001,-1.34007,132),(0.677248,-1.34372,132),(0.687264,-1.33587,132),(0.680322,-1.33571,132),(0.682552,-1.33642,132),(0.68788,-1.33454,132),(0.687211,-1.33906,132),(0.680996,-1.34754,132),(0.68709,-1.34033,132),(0.683216,-1.34642,132),(0.688874,-1.34093,132),(0.682144,-1.34657,132),(0.686265,-1.33545,132),(0.686585,-1.33482,132),(0.673752,-1.34283,132),(0.66952,-1.31946,132),(0.680118,-1.3412,132),(0.68307,-1.33864,132),(0.681907,-1.33597,132),(0.680516,-1.34436,132),(0.689984,-1.33234,132),(0.68293,-1.33737,132),(0.681897,-1.34129,132),(0.678038,-1.34257,132),(0.680292,-1.34403,132),(0.687686,-1.33696,132),(0.674126,-1.34284,132),(0.684292,-1.33914,132),(0.690721,-1.34383,132),(0.681374,-1.34487,132),(0.681374,-1.34378,132),(0.686314,-1.33916,132),(0.672835,-1.57661,83),(0.670779,-1.57739,83),(0.673611,-1.58033,83),(0.677396,-1.64989,83),(0.680974,-1.64552,83),(0.65111,-1.56239,83),(0.674799,-1.58087,83),(0.67444,-1.57645,83),(0.679836,-1.61153,83),(0.672379,-1.57703,83),(0.67476,-1.57817,83),(0.682346,-1.64681,83),(0.659401,-1.57816,83),(0.676214,-1.57613,83),(0.677,-1.57643,83),(0.684237,-1.65029,83),(0.678686,-1.64991,83),(0.693042,-1.59451,83),(0.676689,-1.57727,83),(0.682269,-1.64786,83),(0.67329,-1.60873,83),(0.647242,-1.64957,83),(0.682419,-1.65071,83),(0.673407,-1.5779,83),(0.679122,-1.64728,83),(0.672535,-1.57567,83),(0.684974,-1.64792,83),(0.673645,-1.57969,83),(0.675671,-1.5783,83),(0.672098,-1.57643,83),(0.646529,-1.62829,83),(0.677373,-1.58301,83),(0.671429,-1.57611,83),(0.675463,-1.57712,83),(0.646136,-1.62675,83),(0.641531,-1.57765,83),(0.677222,-1.64851,83),(0.680829,-1.6487,83),(0.662377,-1.60171,83),(0.676907,-1.5792,83),(0.694093,-1.65539,83),(0.674173,-1.57425,83),(0.677194,-1.58173,83),(0.67552,-1.62714,83),(0.64362,-1.5636,83),(0.676975,-1.57457,83),(0.64953,-1.62836,83),(0.674672,-1.57619,83),(0.676538,-1.636,83),(0.673567,-1.57703,83),(0.677387,-1.58568,83),(0.673397,-1.58237,83),(0.530511,-1.55134,83),(0.563274,-1.57055,83),(0.596905,-1.58076,83),(0.564466,-1.57641,83),(0.58461,-1.54335,83),(0.530332,-1.54657,83),(0.583117,-1.58933,83),(0.584969,-1.57393,83),(0.530011,-1.55496,83),(0.546761,-1.55841,83),(0.610086,-1.5714,83),(0.56372,-1.57402,83),(0.553166,-1.55562,83),(0.566565,-1.57281,83),(0.564864,-1.54817,83),(0.550834,-1.59529,83),(0.530778,-1.55034,83),(0.610198,-1.56782,83),(0.599809,-1.56241,83),(0.529983,-1.5456,83),(0.563298,-1.5731,83),(0.565984,-1.57311,83),(0.610673,-1.57102,83),(0.58382,-1.55017,83),(0.597908,-1.54817,83),(0.56466,-1.58612,83),(0.530651,-1.55499,83),(0.616976,-1.39976,132),(0.623652,-1.3762,132),(0.623221,-1.39301,132),(0.621354,-1.44084,132),(0.632102,-1.42549,132),(0.629989,-1.38645,132),(0.62675,-1.38012,132),(0.62468,-1.37499,132),(0.626804,-1.37978,132),(0.614829,-1.41098,132),(0.622222,-1.36932,132),(0.628694,-1.40293,132),(0.617999,-1.40638,132),(0.619362,-1.41127,132),(0.628214,-1.37704,132),(0.636844,-1.39219,132),(0.63346,-1.33083,132),(0.611784,-1.37669,132),(0.621064,-1.37532,132),(0.623279,-1.37208,132),(0.615439,-1.41699,132),(0.617583,-1.36123,132),(0.629586,-1.39263,132),(0.621558,-1.3503,132),(0.608754,-1.34218,132),(0.634071,-1.36832,132),(0.623662,-1.41967,132),(0.627545,-1.39636,132),(0.622232,-1.37591,132),(0.610349,-1.37786,132),(0.618033,-1.41097,132),(0.612206,-1.40794,132),(0.606573,-1.35141,132),(0.619371,-1.40711,132),(0.63041,-1.39755,132),(0.61545,-1.35406,132),(0.606922,-1.38689,132),(0.626818,-1.42312,132),(0.625247,-1.40069,132),(0.604202,-1.37896,132),(0.612904,-1.40889,132),(0.614,-1.40756,132),(0.610611,-1.40585,132),(0.621073,-1.4104,132),(0.623875,-1.42567,132),(0.625238,-1.37577,132),(0.612759,-1.34467,132),(0.624341,-1.3725,132),(0.636374,-1.35532,132),(0.62724,-1.3577,132),(0.622576,-1.40454,132),(0.619241,-1.38196,132),(0.615968,-1.42307,132),(0.624525,-1.41175,132),(0.62627,-1.39769,132),(0.627967,-1.37025,132),(0.624598,-1.37294,132),(0.597352,-1.36039,132),(0.623454,-1.35988,132),(0.630061,-1.40053,132),(0.687036,-1.29893,132),(0.688137,-1.31308,132),(0.696839,-1.31108,132),(0.696994,-1.30953,132),(0.692946,-1.31095,132),(0.694231,-1.30659,132),(0.695065,-1.30896,132),(0.697305,-1.30886,132),(0.687696,-1.30968,132),(0.69698,-1.30709,132),(0.693654,-1.29645,132),(0.697368,-1.31001,132),(0.687482,-1.30069,132),(0.688462,-1.3095,132),(0.697324,-1.295,132),(0.689165,-1.30945,132),(0.692655,-1.30891,132),(0.686425,-1.43294,132),(0.693057,-1.46718,132),(0.691646,-1.46886,132),(0.683506,-1.47405,132),(0.697454,-1.4486,132),(0.693925,-1.46942,132),(0.695006,-1.46641,132),(0.686715,-1.47586,132),(0.685746,-1.47487,132),(0.696063,-1.45025,132),(0.687651,-1.47587,132),(0.695408,-1.46825,132),(0.692712,-1.46902,132),(0.693134,-1.44163,132),(0.688277,-1.46962,132),(0.686963,-1.47149,132),(0.691898,-1.47108,132),(0.689668,-1.47303,132),(0.683394,-1.4741,132),(0.689527,-1.47908,132),(0.696111,-1.44432,132),(0.675996,-1.44858,132),(0.697343,-1.44534,132),(0.694288,-1.46824,132),(0.690318,-1.47015,132),(0.696809,-1.46274,132),(0.694594,-1.47151,132),(0.698036,-1.44971,132),(0.696222,-1.46955,132),(0.684398,-1.47654,132),(0.697551,-1.44662,132),(0.69263,-1.46485,132),(0.697091,-1.4314,132),(0.60693,-1.68736,83),(0.604549,-1.73371,83),(0.596453,-1.69548,83),(0.641362,-1.67518,83),(0.619918,-1.704,83),(0.627307,-1.67348,83),(0.629237,-1.67187,83),(0.611783,-1.70931,83),(0.633774,-1.66882,83),(0.61858,-1.70066,83),(0.602179,-1.70969,83),(0.593307,-1.68199,83),(0.622259,-1.70131,83);
/*&*/
INSERT INTO `x2_timezone_points` VALUES (0.620155,-1.70964,83),(0.635223,-1.7083,83),(0.628718,-1.67496,83),(0.604036,-1.71724,83),(0.609703,-1.6715,83),(0.618711,-1.69989,83),(0.616791,-1.70146,83),(0.623918,-1.66452,83),(0.617571,-1.70561,83),(0.61475,-1.70064,83),(0.619026,-1.70198,83),(0.633023,-1.67298,83),(0.640658,-1.69446,83),(0.630759,-1.67742,83),(0.628296,-1.67751,83),(0.616578,-1.69167,83),(0.630336,-1.69399,83),(0.626841,-1.65754,83),(0.631006,-1.67539,83),(0.619709,-1.70628,83),(0.697042,-1.35544,132),(0.695506,-1.31521,132),(0.697208,-1.3141,132),(0.694653,-1.34361,132),(0.6973,-1.31186,132),(0.696922,-1.31459,132),(0.697445,-1.31956,132),(0.697479,-1.33915,132),(0.58574,-1.42628,132),(0.602199,-1.44252,132),(0.572059,-1.39506,132),(0.593424,-1.41432,132),(0.59055,-1.37964,132),(0.607895,-1.44167,132),(0.596823,-1.39212,132),(0.575627,-1.39683,132),(0.608293,-1.43805,132),(0.596822,-1.43399,132),(0.609796,-1.43513,132),(0.574536,-1.39665,132),(0.562281,-1.4094,132),(0.59309,-1.41784,132),(0.607003,-1.43658,132),(0.572365,-1.39387,132),(0.587985,-1.37683,132),(0.584717,-1.43056,132),(0.574014,-1.39639,132),(0.609554,-1.41415,132),(0.594205,-1.41597,132),(0.594263,-1.41627,132),(0.606276,-1.43561,132),(0.587888,-1.37878,132),(0.609985,-1.42998,132),(0.594263,-1.41552,132),(0.576282,-1.39933,132),(0.592023,-1.40222,132),(0.609476,-1.43634,132),(0.609185,-1.43698,132),(0.614435,-1.5686,83),(0.628897,-1.51465,83),(0.628756,-1.51458,83),(0.638705,-1.43446,132),(0.611662,-1.48893,132),(0.637565,-1.52471,83),(0.613649,-1.48138,132),(0.611599,-1.56494,83),(0.6216,-1.51905,83),(0.631161,-1.49229,83),(0.628921,-1.56007,83),(0.610794,-1.48615,132),(0.612006,-1.48788,132),(0.611114,-1.48793,132),(0.626303,-1.46876,132),(0.627011,-1.51615,83),(0.635097,-1.50878,83),(0.612379,-1.56748,83),(0.633958,-1.51343,83),(0.631166,-1.44567,132),(0.633638,-1.5118,83),(0.621591,-1.5501,83),(0.633789,-1.43734,132),(0.63789,-1.44098,132),(0.627632,-1.46469,132),(0.628591,-1.51114,83),(0.631951,-1.50606,83),(0.624068,-1.46556,132),(0.613475,-1.57165,83),(0.632053,-1.45377,132),(0.63181,-1.51003,83),(0.625624,-1.50779,83),(0.631214,-1.51467,83),(0.612379,-1.57179,83),(0.628499,-1.47078,132),(0.619302,-1.50902,83),(0.628019,-1.51003,83),(0.623976,-1.51721,83),(0.637206,-1.51643,83),(0.617184,-1.50464,83),(0.566337,-1.74067,83),(0.456992,-1.71257,83),(0.52242,-1.6647,83),(0.484368,-1.71164,83),(0.577759,-1.68722,83),(0.513543,-1.66232,83),(0.509102,-1.6656,83),(0.571346,-1.69486,83),(0.523578,-1.66115,83),(0.528261,-1.70594,83),(0.571224,-1.68639,83),(0.518982,-1.65767,83),(0.525101,-1.64239,83),(0.573236,-1.69547,83),(0.518464,-1.66607,83),(0.54203,-1.70108,83),(0.570255,-1.70101,83),(0.526511,-1.68246,83),(0.452071,-1.70165,83),(0.553432,-1.72772,83),(0.532562,-1.70588,83),(0.535369,-1.68197,83),(0.567966,-1.69857,83),(0.521421,-1.715,83),(0.575151,-1.69105,83),(0.568776,-1.6922,83),(0.532416,-1.70729,83),(0.51969,-1.66006,83),(0.515948,-1.71438,83),(0.519041,-1.67129,83),(0.564573,-1.69972,83),(0.519729,-1.66106,83),(0.534559,-1.68135,83),(0.573881,-1.69567,83),(0.529042,-1.66602,83),(0.515186,-1.71594,83),(0.575166,-1.69323,83),(0.543217,-1.70873,83),(0.578647,-1.6941,83),(0.485212,-1.69989,83),(0.560171,-1.6837,83),(0.52306,-1.67023,83),(0.572172,-1.6896,83),(0.5688,-1.69047,83),(0.518454,-1.66022,83),(0.589147,-1.68488,83),(0.579708,-1.69529,83),(0.514188,-1.65896,83),(0.456759,-1.71133,83),(0.569881,-1.69137,83),(0.459052,-1.71327,83),(0.564253,-1.68643,83),(0.573115,-1.6944,83),(0.574676,-1.69116,83),(0.576213,-1.69466,83),(0.571166,-1.69857,83),(0.51555,-1.66587,83),(0.515385,-1.66157,83),(0.578588,-1.68989,83),(0.586883,-1.6953,83),(0.511405,-1.65453,83),(0.574434,-1.68667,83),(0.548647,-1.70595,83),(0.534641,-1.70479,83),(0.571525,-1.69293,83),(0.574812,-1.69433,83),(0.578375,-1.67745,83),(0.522696,-1.63916,83),(0.57246,-1.69767,83),(0.54251,-1.70448,83),(0.457113,-1.70512,83),(0.577561,-1.69378,83),(0.519467,-1.6644,83),(0.523578,-1.66264,83),(0.536227,-1.66768,83),(0.572877,-1.69595,83),(0.572713,-1.69208,83),(0.531325,-1.7065,83),(0.574817,-1.69736,83),(0.524427,-1.73032,83),(0.543096,-1.70567,83),(0.480243,-1.70791,83),(0.52357,-1.70818,83),(0.517766,-1.6584,83),(0.506736,-1.66564,83),(0.568839,-1.68871,83),(0.480077,-1.73673,83),(0.515002,-1.65972,83),(0.533701,-1.70786,83),(0.576766,-1.69287,83),(0.578797,-1.69188,83),(0.567244,-1.65353,83),(0.546955,-1.65333,83),(0.568335,-1.69544,83),(0.568015,-1.64702,83),(0.457336,-1.71444,83),(0.579408,-1.68625,83),(0.4564,-1.70891,83),(0.571889,-1.68597,83),(0.566924,-1.69287,83),(0.572616,-1.71239,83),(0.457554,-1.7161,83),(0.518255,-1.66967,83),(0.516942,-1.66745,83),(0.578695,-1.65751,83),(0.576223,-1.68622,83),(0.551585,-1.65205,83),(0.523152,-1.64048,83),(0.518415,-1.71259,83),(0.516515,-1.66994,83),(0.573067,-1.69696,83),(0.525222,-1.63601,83),(0.554354,-1.66907,83),(0.587494,-1.66776,83),(0.518207,-1.66171,83),(0.515982,-1.66306,83),(0.517072,-1.67083,83),(0.531267,-1.70379,83),(0.457186,-1.71363,83),(0.576305,-1.68771,83),(0.521833,-1.63937,83),(0.48655,-1.69862,83),(0.575054,-1.68825,83),(0.574758,-1.68354,83),(0.51587,-1.67217,83),(0.53247,-1.70482,83),(0.574264,-1.68536,83),(0.575544,-1.68591,83),(0.573517,-1.69932,83),(0.513548,-1.71904,83),(0.4561,-1.70398,83),(0.457088,-1.71313,83),(0.521561,-1.7094,83),(0.515783,-1.71513,83),(0.516074,-1.70981,83),(0.587053,-1.68614,83),(0.517717,-1.66217,83),(0.574933,-1.69531,83),(0.524994,-1.66534,83),(0.516898,-1.6678,83),(0.562357,-1.71395,83),(0.516961,-1.66914,83),(0.578375,-1.66855,83),(0.53356,-1.70012,83),(0.542767,-1.69895,83),(0.57135,-1.68032,83),(0.583378,-1.64144,83),(0.512845,-1.65636,83),(0.577512,-1.69099,83),(0.526356,-1.6666,83),(0.564636,-1.66332,83),(0.51571,-1.7155,83),(0.573343,-1.68948,83),(0.509805,-1.7416,83),(0.502747,-1.69303,83),(0.55064,-1.69553,83),(0.573479,-1.69742,83),(0.565252,-1.69032,83),(0.571758,-1.70688,83),(0.45657,-1.71026,83),(0.571762,-1.70097,83),(0.591906,-1.71903,83),(0.576223,-1.68492,83),(0.677272,-1.34472,132),(0.677718,-1.34733,132),(0.678602,-1.34572,132),(0.681441,-1.35241,132),(0.678067,-1.34617,132),(0.649779,-1.40349,132),(0.654933,-1.35364,132),(0.638729,-1.43446,132),(0.675997,-1.35143,132),(0.677073,-1.34864,132),(0.649745,-1.39649,132),(0.677893,-1.35139,132),(0.678833,-1.35143,132),(0.663737,-1.36968,132),(0.673171,-1.34856,132),(0.642613,-1.33125,132),(0.652,-1.35161,132),(0.648038,-1.4034,132),(0.65045,-1.35101,132),(0.671484,-1.3613,132),(0.674344,-1.34933,132),(0.638546,-1.3857,132),(0.646424,-1.33224,132),(0.677994,-1.34925,132),(0.676875,-1.34646,132),(0.668517,-1.35194,132),(0.680646,-1.34894,132),(0.646293,-1.33248,132),(0.671072,-1.37652,132),(0.680147,-1.35064,132),(0.655301,-1.34962,132),(0.651083,-1.34892,132),(0.676273,-1.34535,132),(0.678848,-1.3476,132),(0.678315,-1.34718,132),(0.675231,-1.3491,132),(0.656993,-1.35278,132),(0.682697,-1.35374,132),(0.67751,-1.3464,132),(0.676487,-1.35394,132),(0.675517,-1.34788,132),(0.652993,-1.38129,132),(0.676332,-1.3522,132),(0.679531,-1.347,132),(0.656397,-1.35042,132),(0.678484,-1.34786,132),(0.673888,-1.34983,132),(0.645401,-1.33392,132),(0.643098,-1.33143,132),(0.678601,-1.34915,132),(0.64975,-1.35092,132),(0.6429,-1.33166,132),(0.642647,-1.33289,132),(0.648072,-1.40632,132),(0.680132,-1.34986,132),(0.655437,-1.35194,132),(0.650501,-1.39524,132),(0.676991,-1.34587,132),(0.650894,-1.39722,132),(0.657124,-1.35459,132),(0.679299,-1.3527,132),(0.640834,-1.33675,132),(0.677001,-1.34717,132),(0.665836,-1.38006,132),(0.680787,-1.35138,132),(0.677064,-1.35259,132),(0.641028,-1.33664,132),(0.656072,-1.35361,132),(0.67926,-1.34794,132),(0.678954,-1.34853,132),(0.643205,-1.32607,132),(0.66442,-1.37688,132),(0.652809,-1.38192,132),(0.67671,-1.34776,132),(0.683919,-1.36421,132),(0.679628,-1.3489,132),(0.675735,-1.34622,132),(0.659353,-1.417,132),(0.669331,-1.42476,132),(0.685577,-1.40228,132),(0.689145,-1.39875,132),(0.670542,-1.43894,132),(0.688641,-1.36073,132),(0.691666,-1.39549,132),(0.685334,-1.42352,132),(0.607638,-1.60962,83),(0.689067,-1.50194,107),(0.686492,-1.44832,132),(0.505845,-1.67498,83),(0.580222,-1.51523,83),(0.598082,-1.50463,83),(0.587475,-1.49804,83),(0.607425,-1.51794,83),(0.569149,-1.49192,83),(0.731473,-1.53714,83),(0.745233,-1.24154,132),(0.740167,-1.23939,132),(0.722476,-1.28201,132),(0.716959,-1.28228,132),(0.738173,-1.45403,90),(0.724662,-1.42342,132),(0.729239,-1.26732,132),(0.720406,-1.27179,132),(0.717429,-1.28104,132),(0.732623,-1.26697,132),(0.71805,-1.27869,132),(0.728148,-1.27116,132),(0.728017,-1.26725,132),(0.720629,-1.26854,132),(0.722495,-1.27229,132),(0.728914,-1.26859,132),(0.730223,-1.25435,132),(0.723261,-1.25689,132),(0.720464,-1.26708,132),(0.729128,-1.26574,132),(0.728953,-1.26072,132),(0.724977,-1.27072,132),(0.725399,-1.26799,132),(0.719465,-1.27508,132),(0.723945,-1.25928,132),(0.724066,-1.27497,132),(0.727125,-1.27024,132),(0.720963,-1.27284,132),(0.721792,-1.25837,132),(0.727765,-1.26927,132),(0.722408,-1.27164,132),(0.717996,-1.28358,132),(0.717637,-1.28121,132),(0.724735,-1.25796,132),(0.727392,-1.25515,132),(0.727358,-1.27161,132),(0.72251,-1.27542,132),(0.721109,-1.27572,132),(0.729961,-1.26748,132),(0.723988,-1.27781,132),(0.716518,-1.28349,132),(0.729695,-1.26099,132),(0.718806,-1.27641,132),(0.729559,-1.27621,132),(0.719824,-1.27759,132),(0.723562,-1.271,132),(0.725327,-1.27499,132),(0.728885,-1.26959,132),(0.720309,-1.27317,132),(0.729869,-1.2766,132),(0.718054,-1.28034,132),(0.728051,-1.26803,132),(0.727988,-1.26027,132),(0.718995,-1.28173,132),(0.727799,-1.25938,132),(0.730466,-1.26787,132),(0.726097,-1.27386,132),(0.733644,-1.63398,83),(0.728321,-1.63373,83),(0.724739,-1.5798,83),(0.712226,-1.59022,83),(0.742249,-1.61348,83),(0.733184,-1.59949,83),(0.730324,-1.57409,83),(0.729839,-1.57468,83),(0.72611,-1.63579,83),(0.72739,-1.59838,83),(0.720157,-1.67309,83),(0.724724,-1.58088,83),(0.726066,-1.63379,83),(0.741775,-1.5824,83),(0.741721,-1.64354,83),(0.727124,-1.5975,83),(0.727332,-1.63533,83),(0.733635,-1.59868,83),(0.733901,-1.62155,83),(0.753172,-1.62666,83),(0.722993,-1.589,83),(0.727797,-1.62399,83),(0.715934,-1.61288,83),(0.741765,-1.6825,83),(0.726522,-1.63559,83),(0.741639,-1.61169,83),(0.725568,-1.63616,83),(0.731846,-1.5357,83),(0.735928,-1.54103,83),(0.72726,-1.53133,83),(0.73458,-1.53555,83),(0.72886,-1.54148,83),(0.732952,-1.53913,83),(0.730421,-1.54135,83),(0.730969,-1.53385,83),(0.737644,-1.55063,83),(0.732253,-1.53484,83),(0.730431,-1.53229,83),(0.732297,-1.5373,83),(0.706583,-1.55323,83),(0.727056,-1.53031,83),(0.727779,-1.53708,83),(0.718058,-1.53371,83),(0.718063,-1.53347,83),(0.728675,-1.53247,83),(0.729965,-1.5333,83),(0.735681,-1.53519,83),(0.728394,-1.53204,83),(0.726329,-1.52768,83),(0.731512,-1.53824,83),(0.735153,-1.54039,83),(0.736738,-1.54005,83),(0.700164,-1.54014,83),(0.730421,-1.52978,83),(0.724419,-1.52953,83),(0.730343,-1.5316,83),(0.7255,-1.53101,83),(0.725267,-1.53761,83),(0.737247,-1.54141,83),(0.700304,-1.52943,83),(0.72871,-1.53544,83),(0.731807,-1.54899,83),(0.736025,-1.53318,83),(0.733621,-1.53385,83),(0.730227,-1.56171,83),(0.726736,-1.52904,83),(0.729703,-1.53608,83),(0.724327,-1.57855,83),(0.709758,-1.56347,83),(0.733688,-1.5408,83),(0.733107,-1.53537,83),(0.731284,-1.53485,83),(0.731662,-1.53256,83),(0.733756,-1.53048,83),(0.728162,-1.53068,83),(0.72424,-1.53325,83),(0.731909,-1.53354,83),(0.738217,-1.56419,83),(0.714674,-1.57728,83),(0.731075,-1.54122,83),(0.730901,-1.53706,83),(0.734256,-1.53219,83),(0.726567,-1.53468,83),(0.73905,-1.53662,83),(0.739501,-1.53418,83),(0.733029,-1.53842,83),(0.726232,-1.52972,83),(0.736209,-1.53241,83),(0.729563,-1.53479,83),(0.733785,-1.53728,83),(0.726057,-1.53481,83),(0.725311,-1.53005,83),(0.735972,-1.54336,83),(0.724748,-1.53732,83),(0.71768,-1.53347,83),(0.729635,-1.53361,83),(0.737552,-1.53311,83),(0.736476,-1.53752,83),(0.736209,-1.54166,83),(0.725442,-1.52784,83),(0.727342,-1.53592,83),(0.737979,-1.53507,83),(0.729568,-1.5372,83),(0.725873,-1.5369,83),(0.730944,-1.53603,83),(0.738624,-1.55436,83),(0.739099,-1.55402,83),(0.706146,-1.58252,83),(0.72438,-1.53088,83),(0.73093,-1.53315,83),(0.738856,-1.54055,83),(0.731303,-1.53339,83),(0.724768,-1.53396,83),(0.724429,-1.57979,83),(0.728336,-1.54193,83),(0.708827,-1.56136,83),(0.733747,-1.53209,83),(0.734198,-1.5348,83),(0.73763,-1.53596,83),(0.729301,-1.53846,83),(0.724521,-1.53529,83),(0.733369,-1.53245,83),(0.707106,-1.55318,83),(0.729655,-1.5416,83),(0.738721,-1.53312,83),(0.710655,-1.56354,83),(0.735264,-1.5329,83),(0.726106,-1.53142,83),(0.727992,-1.53167,83),(0.731032,-1.53213,83),(0.726586,-1.53334,83),(0.727502,-1.54202,83),(0.721617,-1.5506,83),(0.734963,-1.53649,83),(0.727745,-1.5327,83),(0.724162,-1.53021,83),(0.733233,-1.53311,83),(0.708037,-1.56452,83),(0.710238,-1.56362,83),(0.726528,-1.53945,83),(0.734702,-1.5348,83),(0.724477,-1.5809,83),(0.73777,-1.55498,83),(0.734508,-1.53612,83),(0.726887,-1.53745,83),(0.732772,-1.53728,83),(0.739206,-1.53752,83),(0.739525,-1.53746,83),(0.731541,-1.54128,83),(0.733621,-1.53735,83),(0.724661,-1.53941,83),(0.733621,-1.53124,83),(0.732937,-1.54099,83),(0.726072,-1.52903,83),(0.729349,-1.56549,83),(0.733485,-1.539,83),(0.732845,-1.54788,83),(0.725592,-1.53213,83),(0.700062,-1.53951,83),(0.736845,-1.53528,83),(0.731114,-1.5357,83),(0.731958,-1.54295,83),(0.710413,-1.56045,83),(0.739385,-1.53318,83),(0.731027,-1.53945,83),(0.730431,-1.53383,83),(0.729475,-1.53546,83),(0.730702,-1.53776,83),(0.735468,-1.53465,83),(0.734299,-1.53105,83),(0.728622,-1.53677,83),(0.738532,-1.54372,83),(0.726775,-1.5437,83),(0.740825,-1.53297,83),(0.69997,-1.4954,107),(0.69885,-1.51625,107),(0.722863,-1.52481,83),(0.72421,-1.52754,83),(0.726741,-1.52637,83),(0.727488,-1.50058,107),(0.717864,-1.48578,107),(0.70301,-1.5099,107),(0.725941,-1.52448,83),(0.725748,-1.49809,107),(0.728642,-1.50318,107),(0.724807,-1.52583,83),(0.725767,-1.52716,83),(0.725248,-1.52632,83),(0.724875,-1.52289,83),(0.713545,-1.49221,107),(0.706622,-1.50331,107),(0.726242,-1.51359,83),(0.705404,-1.51626,107),(0.698976,-1.50917,107),(0.7113,-1.50721,107),(0.707877,-1.49503,107),(0.724012,-1.52425,83),(0.727934,-1.5166,83),(0.727139,-1.50375,107),(0.701507,-1.49027,107),(0.725437,-1.52738,83),(0.698927,-1.50113,107),(0.725636,-1.52151,83),(0.723944,-1.52637,83),(0.727512,-1.50535,107),(0.723842,-1.5195,83),(0.705565,-1.51683,107),(0.698879,-1.50321,107),(0.734868,-1.23823,132),(0.741505,-1.24674,132),(0.734252,-1.26737,132),(0.748021,-1.23796,132),(0.73959,-1.2657,132),(0.740288,-1.24191,132),(0.737597,-1.24727,132),(0.73207,-1.24417,132),(0.736434,-1.25377,132),(0.727804,-1.22696,132),(0.739949,-1.2423,132),(0.742785,-1.23709,132),(0.742697,-1.23663,132),(0.742785,-1.24388,132),(0.739294,-1.24023,132),(0.736919,-1.23917,132),(0.734494,-1.2395,132),(0.738829,-1.2413,132),(0.741849,-1.2426,132),(0.739585,-1.24103,132),(0.735803,-1.24171,132),(0.743507,-1.24559,132),(0.739876,-1.23976,132),(0.73605,-1.26702,132),(0.741073,-1.24527,132),(0.743075,-1.23796,132),(0.737258,-1.24208,132),(0.744738,-1.24445,132),(0.734165,-1.26558,132),(0.737694,-1.26831,132),(0.733467,-1.24143,132),(0.740167,-1.24012,132),(0.726713,-1.2375,132),(0.727828,-1.24189,132),(0.743221,-1.25319,132),(0.737912,-1.24645,132),(0.738227,-1.24681,132),(0.734494,-1.24611,132),(0.743075,-1.2566,132),(0.743788,-1.23328,132),(0.736652,-1.25115,132),(0.743294,-1.2671,132),(0.735013,-1.2359,132),(0.746586,-1.24053,132),(0.739178,-1.25425,132),(0.736603,-1.26739,132),(0.738446,-1.24128,132),(0.745378,-1.24203,132),(0.742203,-1.25244,132),(0.740846,-1.2431,132),(0.733913,-1.26681,132),(0.744094,-1.2447,132),(0.735832,-1.26494,132),(0.741185,-1.2383,132),(0.740458,-1.24034,132),(0.733622,-1.24301,132),(0.741767,-1.2367,132),(0.739131,-1.2487,132),(0.740341,-1.24104,132),(0.741039,-1.24034,132),(0.745713,-1.24252,132),(0.735479,-1.24819,132),(0.737394,-1.24034,132),(0.737985,-1.24528,132),(0.737985,-1.24325,132),(0.726689,-1.23804,132),(0.747221,-1.23704,132),(0.738921,-1.24284,132),(0.73624,-1.2671,132),(0.738712,-1.26783,132),(0.732458,-1.24245,132),(0.736434,-1.24267,132),(0.735803,-1.26237,132),(0.742251,-1.23794,132),(0.740894,-1.27837,132),(0.737452,-1.23922,132),(0.735876,-1.2399,132),(0.742213,-1.24085,132),(0.735319,-1.23772,132),(0.742106,-1.23738,132),(0.741151,-1.23936,132),(0.738203,-1.25163,132),(0.729016,-1.24143,132),(0.739803,-1.24092,132),(0.738858,-1.24005,132),(0.737549,-1.26666,132),(0.741936,-1.2383,132),(0.734349,-1.25722,132),(0.734809,-1.26693,132),(0.741418,-1.24092,132),(0.735222,-1.24097,132),(0.73973,-1.24645,132),(0.728643,-1.2425,132),(0.731295,-1.24075,132),(0.743696,-1.24327,132),(0.741878,-1.24045,132),(0.739609,-1.2433,132),(0.739512,-1.24237,132),(0.738213,-1.24429,132),(0.734906,-1.26746,132),(0.735222,-1.26972,132),(0.743148,-1.24683,132),(0.736894,-1.23813,132),(0.742576,-1.24221,132),(0.740933,-1.24157,132),(0.739585,-1.23888,132),(0.741403,-1.24184,132),(0.737621,-1.25319,132),(0.727901,-1.22572,132),(0.769653,-1.22577,132),(0.773366,-1.21788,132),(0.781928,-1.2004,132),(0.759089,-1.22964,132),(0.766453,-1.22113,132),(0.769696,-1.22548,132),(0.762036,-1.22619,132),(0.759234,-1.22946,132),(0.761687,-1.22593,132),(0.761644,-1.22723,132),(0.777579,-1.2153,132),(0.760446,-1.2285,132),(0.762308,-1.22821,132),(0.73125,-1.46673,90),(0.737533,-1.45231,90),(0.750007,-1.50017,90),(0.737883,-1.46155,90),(0.745038,-1.45271,90),(0.738643,-1.48667,90),(0.760867,-1.46414,90),(0.74258,-1.45231,90),(0.750482,-1.45938,90),(0.738425,-1.45704,90),(0.743283,-1.44723,90),(0.738663,-1.4517,90),(0.73892,-1.45339,90),(0.738823,-1.44942,90),(0.745901,-1.47452,90),(0.741213,-1.44785,90),(0.741509,-1.45521,90),(0.741077,-1.45097,90),(0.75071,-1.46062,90),(0.749784,-1.49208,90),(0.738721,-1.4544,90),(0.749852,-1.49519,90),(0.748916,-1.49685,90),(0.740781,-1.447,90),(0.739894,-1.44949,90),(0.746076,-1.47308,90),(0.741111,-1.45044,90),(0.746783,-1.50288,90),(0.744219,-1.47507,90),(0.73733,-1.47308,90),(0.748873,-1.49735,90),(0.73813,-1.49378,90),(0.748213,-1.49478,90),(0.745824,-1.47577,90),(0.737412,-1.45174,90),(0.739468,-1.45478,90),(0.741518,-1.45046,90),(0.812338,-1.52534,90),(0.761235,-1.47039,90),(0.73158,-1.45556,90),(0.743462,-1.44649,90),(0.760925,-1.47947,90),(0.754579,-1.50532,90),(0.753439,-1.50559,90),(0.741426,-1.45692,90),(0.741058,-1.45181,90),(0.745644,-1.47354,90),(0.750453,-1.46916,90),(0.74419,-1.4537,90),(0.749983,-1.43859,90),(0.736549,-1.49365,90),(0.739729,-1.4538,90),(0.744529,-1.45124,90),(0.736917,-1.45555,90),(0.741717,-1.44753,90),(0.741581,-1.45115,90),(0.757813,-1.46522,90),(0.744747,-1.4492,90),(0.7413,-1.4525,90),(0.736772,-1.45201,90),(0.741712,-1.44668,90),(0.743167,-1.44915,90),(0.737242,-1.45333,90),(0.735473,-1.45173,90),(0.743608,-1.45124,90),(0.750516,-1.49694,90),(0.741373,-1.44911,90),(0.745295,-1.45565,90),(0.74594,-1.47691,90),(0.73795,-1.45537,90),(0.738697,-1.45561,90),(0.736777,-1.45124,90),(0.748979,-1.49584,90),(0.737247,-1.45932,90),(0.761801,-1.62958,83),(0.78947,-1.62824,83),(0.788849,-1.62991,83),(0.780719,-1.62696,83),(0.762126,-1.62271,83),(0.788205,-1.62726,83),(0.78262,-1.62836,83),(0.786726,-1.62896,83),(0.787041,-1.62938,83),(0.788399,-1.63842,83),(0.781344,-1.628,83),(0.788694,-1.63009,83),(0.782993,-1.63242,83),(0.781723,-1.63367,83),(0.78611,-1.62775,83),(0.787492,-1.62818,83),(0.782392,-1.62218,83),(0.78597,-1.62944,83),(0.816522,-1.60756,83),(0.78198,-1.62607,83),(0.782862,-1.63137,83),(0.783473,-1.62926,83),(0.790701,-1.63306,83),(0.773093,-1.62785,83),(0.779119,-1.62566,83),(0.790265,-1.6229,83),(0.786901,-1.62775,83),(0.785567,-1.62925,83),(0.789766,-1.62752,83),(0.780918,-1.62058,83),(0.82776,-1.62207,83),(0.784088,-1.63123,83),(0.782746,-1.6239,83),(0.779284,-1.62739,83),(0.788195,-1.62471,83),(0.7708,-1.6406,83),(0.786663,-1.63111,83),(0.784578,-1.62307,83),(0.785049,-1.62776,83),(0.783885,-1.63194,83),(0.78437,-1.63087,83),(0.818103,-1.68891,83),(0.786542,-1.62668,83),(0.786062,-1.6299,83),(0.775944,-1.62598,83),(0.784753,-1.62254,83),(0.769408,-1.6271,83),(0.785582,-1.63111,83),(0.780394,-1.63053,83),(0.789955,-1.63101,83),(0.777762,-1.61502,83),(0.783361,-1.6281,83),(0.768322,-1.6139,83),(0.78085,-1.62535,83),(0.785504,-1.62589,83),(0.795186,-1.64345,83),(0.784496,-1.62923,83),(0.789063,-1.63476,83),(0.784428,-1.62478,83),(0.796248,-1.64422,83),(0.781543,-1.62903,83),(0.781873,-1.63235,83),(0.786779,-1.62572,83),(0.783526,-1.62377,83),(0.786382,-1.61977,83),(0.788185,-1.62926,83),(0.783933,-1.62493,83),(0.786876,-1.62333,83),(0.787526,-1.65882,83),(0.768817,-1.59941,83),(0.784069,-1.62245,83),(0.701531,-1.61588,83),(0.818161,-1.6893,83),(0.836454,-1.69354,83),(0.818743,-1.72279,83),(0.818123,-1.69123,83),(0.71797,-1.67361,83),(0.723085,-1.6994,83),(0.723148,-1.68421,83),(0.714276,-1.71639,83),(0.708361,-1.7172,83),(0.71034,-1.7293,83),(0.718794,-1.67606,83),(0.712094,-1.68716,83),(0.733533,-1.70025,83),(0.720099,-1.67443,83),(0.71828,-1.67625,83),(0.749557,-1.24819,132),(0.754124,-1.24857,132),(0.748408,-1.2449,132),(0.748602,-1.24463,132),(0.753945,-1.23698,132),(0.754716,-1.24858,132),(0.749334,-1.26149,132),(0.759704,-1.24739,132),(0.750416,-1.24712,132),(0.748137,-1.2478,132),(0.746397,-1.24734,132),(0.751744,-1.23504,132),(0.755807,-1.23876,132),(0.746799,-1.24269,132),(0.701978,-1.29175,132),(0.708261,-1.29652,132),(0.709803,-1.29354,132),(0.711985,-1.29416,132),(0.714321,-1.2915,132),(0.712213,-1.29478,132),(0.708208,-1.29553,132),(0.712469,-1.29133,132),(0.713114,-1.2944,132),(0.70816,-1.29682,132),(0.709624,-1.29677,132),(0.71356,-1.30135,132),(0.714549,-1.29149,132),(0.7056,-1.2988,132),(0.711524,-1.29512,132),(0.707185,-1.29874,132),(0.70972,-1.29522,132),(0.713909,-1.29361,132),(0.713715,-1.29107,132),(0.702841,-1.3055,132),(0.714544,-1.29384,132),(0.707369,-1.29706,132),(0.712983,-1.29102,132),(0.713517,-1.29352,132),(0.713594,-1.2923,132),(0.714699,-1.29423,132),(0.71037,-1.29556,132),(0.711117,-1.29211,132),(0.714414,-1.30305,132),(0.714607,-1.30325,132),(0.710913,-1.29564,132),(0.708174,-1.29717,132),(0.71084,-1.2929,132),(0.711543,-1.29408,132),(0.69984,-1.29534,132),(0.708989,-1.29581,132),(0.712023,-1.29704,132),(0.713531,-1.293,132),(0.703442,-1.29141,132),(0.712304,-1.29371,132),(0.711393,-1.29882,132),(0.717133,-1.29405,132),(0.710894,-1.29632,132),(0.712547,-1.29519,132),(0.712038,-1.29995,132),(0.706618,-1.29943,132),(0.71441,-1.29186,132),(0.710971,-1.29455,132),(0.711892,-1.29387,132),(0.712169,-1.29175,132),(0.709129,-1.299,132),(0.712484,-1.29433,132),(0.705372,-1.29792,132),(0.711582,-1.2956,132),(0.712935,-1.2915,132),(0.714617,-1.29286,132),(0.713105,-1.29898,132),(0.713085,-1.29379,132),(0.714132,-1.29454,132),(0.706977,-1.29618,132),(0.706846,-1.29851,132),(0.708897,-1.29883,132),(0.699583,-1.29273,132),(0.708746,-1.29639,132),(0.715223,-1.29358,132),(0.709725,-1.29614,132),(0.712557,-1.29341,132),(0.706147,-1.29784,132),(0.706254,-1.29731,132),(0.70957,-1.29835,132),(0.712037,-1.29251,132),(0.706816,-1.30007,132),(0.705255,-1.29773,132),(0.711204,-1.2961,132),(0.708242,-1.29873,132),(0.705925,-1.29828,132),(0.711073,-1.29782,132),(0.713798,-1.29182,132),(0.703442,-1.2933,132),(0.70192,-1.30451,132),(0.710307,-1.29614,132),(0.711737,-1.29196,132),(0.714283,-1.29637,132),(0.717875,-1.29796,132),(0.711883,-1.29179,132),(0.712072,-1.29572,132),(0.709633,-1.29761,132),(0.698618,-1.30671,132),(0.707864,-1.29651,132),(0.715751,-1.29456,132),(0.744428,-1.28729,132),(0.750114,-1.37532,132),(0.749422,-1.29483,132),(0.7493,-1.33633,132),(0.70959,-1.28472,132),(0.750459,-1.36463,132),(0.710787,-1.27837,132),(0.724396,-1.29101,132),(0.709803,-1.28329,132),(0.708635,-1.29144,132),(0.711122,-1.2825,132),(0.734761,-1.32502,132),(0.711766,-1.27839,132),(0.753067,-1.35351,132),(0.712964,-1.28921,132),(0.709478,-1.29066,132),(0.74851,-1.37669,132),(0.713114,-1.27583,132),(0.711931,-1.27761,132),(0.748805,-1.37453,132),(0.746551,-1.28631,132),(0.712843,-1.2792,132),(0.708218,-1.29144,132),(0.710026,-1.28107,132),(0.713294,-1.27412,132),(0.743531,-1.3296,132),(0.711427,-1.27984,132),(0.748815,-1.37344,132),(0.712178,-1.27996,132),(0.710593,-1.28385,132),(0.709885,-1.28171,132),(0.709769,-1.28949,132),(0.713434,-1.27975,132),(0.711519,-1.27402,132),(0.714564,-1.27594,132),(0.713623,-1.28863,132),(0.749853,-1.37539,132),(0.734606,-1.34055,132),(0.710365,-1.28653,132),(0.712639,-1.27461,132),(0.710763,-1.28639,132),(0.710477,-1.28589,132),(0.709609,-1.28427,132),(0.710816,-1.28516,132),(0.713182,-1.28515,132),(0.751414,-1.29754,132),(0.716159,-1.2888,132),(0.715044,-1.28653,132),(0.712542,-1.27763,132),(0.710457,-1.28489,132),(0.711543,-1.28326,132),(0.712309,-1.27546,132),(0.712363,-1.27488,132),(0.713284,-1.28152,132),(0.713027,-1.28127,132),(0.754216,-1.35402,132),(0.710869,-1.27776,132),(0.740729,-1.33512,132),(0.7102,-1.28815,132),(0.734731,-1.38292,132),(0.735056,-1.32573,132),(0.749896,-1.37654,132),(0.713599,-1.27858,132),(0.731765,-1.2915,132),(0.721555,-1.29447,132),(0.747448,-1.37573,132),(0.712707,-1.27638,132),(0.710802,-1.28307,132),(0.710118,-1.28061,132),(0.753469,-1.3734,132),(0.708402,-1.28557,132),(0.711131,-1.29065,132),(0.709561,-1.28582,132),(0.71469,-1.28688,132),(0.711805,-1.29095,132),(0.710011,-1.28237,132),(0.710007,-1.28203,132),(0.71213,-1.27131,132),(0.712402,-1.27409,132),(0.71198,-1.28134,132),(0.709701,-1.28372,132),(0.723368,-1.29893,132),(0.711209,-1.28527,132),(0.717526,-1.29274,132),(0.71406,-1.2887,132),(0.717133,-1.29178,132),(0.718161,-1.29136,132),(0.71404,-1.28774,132),(0.710598,-1.29165,132),(0.724371,-1.29173,132),(0.752141,-1.3798,132),(0.710307,-1.28151,132),(0.710637,-1.27971,132),(0.710981,-1.27867,132),(0.7102,-1.2834,132),(0.710365,-1.28216,132),(0.751167,-1.37644,132),(0.710089,-1.28634,132),(0.709279,-1.28526,132),(0.718428,-1.28913,132),(0.758439,-1.33536,132),(0.716615,-1.29192,132),(0.720648,-1.29015,132),(0.711684,-1.28225,132),(0.780153,-1.282,132),(0.715616,-1.28571,132),(0.712542,-1.28628,132),(0.727809,-1.29016,132),(0.753193,-1.35465,132),(0.709628,-1.28528,132),(0.754207,-1.31695,132),(0.712363,-1.27605,132),(0.709977,-1.28437,132),(0.746774,-1.29104,132),(0.715247,-1.28602,132),(0.751942,-1.28778,132),(0.710976,-1.27552,132),(0.715674,-1.28778,132),(0.747249,-1.29049,132),(0.709754,-1.28261,132),(0.713255,-1.27471,132),(0.71212,-1.27178,132),(0.713071,-1.27759,132),(0.71756,-1.29231,132),(0.707946,-1.29398,132),(0.712552,-1.28285,132),(0.751331,-1.32902,132),(0.750846,-1.37672,132),(0.745751,-1.28616,132),(0.710356,-1.28444,132),(0.752253,-1.31306,132),(0.709725,-1.28646,132),(0.710065,-1.28299,132),(0.767505,-1.32489,132),(0.744961,-1.28768,132),(0.710666,-1.28027,132),(0.710433,-1.28544,132),(0.710457,-1.27944,132),(0.747875,-1.37532,132),(0.71132,-1.28435,132),(0.716178,-1.28741,132),(0.709163,-1.28653,132),(0.714384,-1.28978,132),(0.717006,-1.42278,132),(0.714107,-1.41557,132),(0.713293,-1.43672,132),(0.730683,-1.41005,132),(0.721127,-1.41974,132),(0.71736,-1.40961,132),(0.723469,-1.43179,132),(0.723609,-1.43151,132),(0.724405,-1.43166,132),(0.715809,-1.42428,132),(0.724046,-1.42981,132),(0.721976,-1.42863,132),(0.716008,-1.40783,132),(0.722126,-1.45999,132),(0.721064,-1.42567,132),(0.722538,-1.42776,132),(0.719741,-1.42841,132),(0.712076,-1.42032,132),(0.724303,-1.42585,132),(0.717923,-1.42217,132),(0.72055,-1.47229,132),(0.703344,-1.44981,132),(0.699864,-1.45061,132),(0.72489,-1.42382,132),(0.726998,-1.42158,132),(0.722014,-1.43305,132),(0.725937,-1.42291,132),(0.72329,-1.4288,132),(0.716357,-1.45997,132),(0.721699,-1.45075,132),(0.698467,-1.44652,132),(0.722863,-1.42429,132),(0.714641,-1.42215,132),(0.698715,-1.45139,132),(0.719775,-1.42141,132),(0.718267,-1.41996,132),(0.723997,-1.42765,132),(0.711092,-1.46791,132),(0.723488,-1.43435,132),(0.711368,-1.44017,132),(0.722834,-1.42359,132),(0.708406,-1.45087,132),(0.702259,-1.45503,132),(0.712037,-1.42282,132),(0.724647,-1.42171,132),(0.718,-1.42879,132),(0.727212,-1.41964,132),(0.721893,-1.4279,132),(0.704998,-1.43965,132),(0.70668,-1.4215,132),(0.699146,-1.43817,132),(0.718776,-1.40962,132),(0.713419,-1.42074,132),(0.722839,-1.42983,132),(0.722383,-1.4315,132),(0.721059,-1.42636,132),(0.719818,-1.44192,132),(0.726819,-1.45712,132),(0.72823,-1.418,132),(0.72265,-1.42633,132),(0.722393,-1.42697,132),(0.725306,-1.45957,132),(0.700658,-1.47031,132),(0.723886,-1.42837,132),(0.723421,-1.44353,132),(0.723857,-1.42309,132),(0.703092,-1.46879,132),(0.722388,-1.42142,132),(0.724715,-1.42277,132),(0.704586,-1.40733,132),(0.718369,-1.4214,132),(0.71976,-1.41975,132),(0.721074,-1.4283,132),(0.728133,-1.46107,132),(0.717356,-1.42143,132),(0.717583,-1.45173,132),(0.727173,-1.45831,132),(0.698821,-1.46962,132),(0.72104,-1.4214,132),(0.716032,-1.42646,132),(0.719731,-1.41055,132),(0.700334,-1.44739,132),(0.723532,-1.42974,132),(0.726751,-1.42081,132),(0.712183,-1.43004,132),(0.717326,-1.4076,132),(0.708751,-1.31755,132),(0.707897,-1.39554,132),(0.707184,-1.36825,132),(0.721448,-1.32639,132),(0.704033,-1.3959,132),(0.703849,-1.39695,132),(0.709056,-1.31546,132),(0.701648,-1.3472,132),(0.710147,-1.31285,132),(0.735294,-1.39775,132),(0.702909,-1.34189,132),(0.714859,-1.32601,132),(0.719658,-1.40409,132),(0.703834,-1.37745,132),(0.69969,-1.31591,132),(0.698793,-1.33178,132),(0.702347,-1.31395,132),(0.704082,-1.33363,132),(0.700839,-1.30601,132),(0.702162,-1.31811,132),(0.704203,-1.39389,132),(0.705483,-1.39257,132),(0.704334,-1.39713,132),(0.699995,-1.32563,132),(0.705609,-1.39098,132),(0.715649,-1.40232,132),(0.700252,-1.31493,132),(0.706879,-1.39346,132),(0.700407,-1.31798,132),(0.705822,-1.39619,132),(0.706864,-1.39189,132),(0.702414,-1.32034,132),(0.698938,-1.31528,132),(0.70399,-1.32517,132),(0.722723,-1.32056,132),(0.711979,-1.35891,132),(0.703994,-1.39772,132),(0.6989,-1.31576,132),(0.704474,-1.39393,132),(0.709769,-1.31772,132),(0.719877,-1.32438,132),(0.705842,-1.3942,132),(0.719795,-1.34392,132),(0.700645,-1.31102,132),(0.728512,-1.24457,132),(0.727402,-1.24383,132),(0.73113,-1.24603,132),(0.727804,-1.2511,132),(0.729195,-1.24682,132),(0.732458,-1.24674,132),(0.729787,-1.24564,132),(0.725109,-1.24427,132),(0.724139,-1.24464,132),(0.725186,-1.24732,132),(0.730422,-1.24732,132),(0.730921,-1.24586,132),(0.726097,-1.24355,132),(0.729966,-1.24639,132),(0.731678,-1.24877,132),(0.727804,-1.24645,132),(0.727748,-1.24829,132),(0.722175,-1.25362,132),(0.733089,-1.24817,132),(0.793509,-1.71891,83),(0.773379,-1.68945,83),(0.762873,-1.71094,83),(0.76009,-1.68774,83),(0.783643,-1.69498,83),(0.776251,-1.27779,132),(0.777438,-1.27667,132),(0.761149,-1.27361,132),(0.776095,-1.27707,132),(0.772516,-1.54314,83),(0.776361,-1.53711,83),(0.758481,-1.5505,83),(0.741911,-1.5539,83),(0.751549,-1.53775,83),(0.747137,-1.53457,83),(0.749789,-1.53347,83),(0.775779,-1.53694,83),(0.782106,-1.59695,83),(0.749808,-1.56154,83),(0.764018,-1.54355,83),(0.748548,-1.53656,83),(0.754482,-1.53782,83),(0.777006,-1.53624,83),(0.749818,-1.53611,83),(0.777433,-1.53743,83),(0.744955,-1.55367,83),(0.772798,-1.54064,83),(0.743244,-1.53277,83),(0.764478,-1.59243,83),(0.751767,-1.56035,83),(0.769491,-1.52991,83),(0.779619,-1.57379,83),(0.771474,-1.54368,83),(0.753614,-1.53794,83),(0.783226,-1.6043,83),(0.754618,-1.53562,83),(0.752188,-1.56214,83),(0.751171,-1.53426,83),(0.748848,-1.53832,83),(0.771188,-1.54396,83),(0.75008,-1.53778,83),(0.765263,-1.59258,83),(0.748499,-1.5335,83),(0.752441,-1.5446,83),(0.765927,-1.59235,83),(0.768376,-1.54536,83),(0.742691,-1.53473,83),(0.745712,-1.5321,83),(0.763596,-1.53091,83),(0.748931,-1.53346,83),(0.777083,-1.56337,83),(0.753696,-1.55707,83),(0.815431,-1.60752,83),(0.75389,-1.54861,83),(0.750695,-1.53993,83),(0.784685,-1.56434,83),(0.751355,-1.53602,83),(0.750783,-1.53601,83),(0.757914,-1.53909,83),(0.77464,-1.56761,83),(0.705444,-1.40655,132),(0.70526,-1.40567,132),(0.699248,-1.40885,132),(0.721627,-1.27547,132),(0.7185,-1.27767,132),(0.727309,-1.2732,132),(0.720464,-1.27086,132),(0.724294,-1.27236,132),(0.600379,-2.07551,114),(0.582422,-1.96496,137),(0.613445,-1.99959,137),(0.573856,-1.95053,137),(0.56415,-1.93723,137),(0.563704,-1.9359,137),(0.581302,-1.952,137),(0.547066,-1.91193,137),(0.56097,-1.93781,137),(0.586659,-1.96043,137),(0.571698,-1.947,137),(0.614322,-1.94868,137),(0.576508,-1.94408,137),(0.563636,-1.93749,137),(0.569987,-1.99686,137),(0.586635,-1.94984,137),(0.582117,-1.95109,137),(0.58536,-1.95801,137),(0.583556,-1.96102,137),(0.555962,-1.93721,137),(0.614172,-1.9906,137),(0.601858,-1.9953,137),(0.566128,-1.94125,137),(0.576973,-1.9556,137),(0.583329,-1.95167,137),(0.546993,-1.93617,137),(0.565328,-1.93673,137),(0.597441,-1.94299,137),(0.586092,-1.95891,137),(0.583784,-1.95606,137),(0.602837,-1.96295,137),(0.603699,-1.96045,137),(0.580299,-1.94839,137),(0.549281,-1.93691,137),(0.557765,-1.93654,137),(0.567005,-2.00333,137),(0.584846,-1.95301,137),(0.550731,-1.92516,137),(0.586388,-1.95951,137),(0.587512,-1.96073,137),(0.586965,-1.96058,137),(0.562899,-1.93273,137),(0.583198,-1.95319,137),(0.583188,-1.95378,137),(0.562375,-1.93603,137),(0.571165,-2.00057,137),(0.603583,-2.04918,114),(0.595909,-2.07237,114),(0.595792,-2.07301,114),(0.659127,-2.13352,114),(0.661251,-2.1345,114),(0.595075,-2.06171,114),(0.58582,-2.05473,114),(0.596723,-2.06178,114),(0.652161,-2.12629,114),(0.666278,-2.13385,114),(0.590537,-2.058,114),(0.675586,-2.11761,114),(0.663311,-2.12591,114),(0.602153,-2.04528,114),(0.595851,-2.06011,114),(0.612935,-2.10471,114),(0.591071,-2.06094,114),(0.614515,-2.07395,114),(0.657896,-2.13129,114),(0.619407,-2.1061,114),(0.651841,-2.10503,114),(0.62839,-2.09665,114),(0.594042,-2.05933,114),(0.595744,-2.05788,114),(0.61738,-2.07727,114),(0.594901,-2.05881,114),(0.592113,-2.03988,114),(0.609095,-2.04243,114),(0.608591,-2.04302,114),(0.663733,-2.12863,114),(0.663692,-2.12829,114),(0.592181,-2.04164,114),(0.593019,-2.06275,114),(0.592806,-2.06213,114),(0.591347,-2.06153,114),(0.654851,-2.13412,114),(0.664087,-2.13207,114),(0.660984,-2.13406,114),(0.594697,-2.06648,114),(0.594639,-2.04894,114),(0.58661,-2.00008,114),(0.5726,-2.04093,114),(0.575586,-2.01638,114),(0.591958,-2.05774,114),(0.661949,-2.12452,114),(0.5911,-2.05946,114),(0.596568,-2.06488,114),(0.655966,-2.13569,114),(0.596166,-2.07063,114),(0.570355,-2.01584,114),(0.597189,-2.0776,114),(0.674898,-2.11162,114),(0.650784,-2.12843,114),(0.578718,-2.04815,114),(0.673996,-2.11758,114),(0.590469,-2.06441,114),(0.601945,-2.07036,114),(0.657886,-2.13081,114),(0.589568,-2.0327,114),(0.656155,-2.11111,114),(0.59094,-2.06062,114),(0.597901,-2.06998,114),(0.693393,-2.12647,114),(0.593625,-2.05406,114),(0.593304,-2.05528,114),(0.647919,-2.09894,114),(0.569676,-2.0435,114),(0.675567,-2.11675,114),(0.595099,-2.0546,114),(0.679949,-2.14023,114),(0.642722,-2.08921,114),(0.587832,-2.02762,114),(0.643439,-2.08777,114),(0.594702,-2.04751,114),(0.591594,-2.06333,114),(0.662841,-2.12984,114),(0.630029,-2.08672,114),(0.591235,-2.05192,114),(0.570476,-2.04523,114),(0.587148,-2.05807,114),(0.594983,-2.05757,114),(0.592724,-2.06272,114),(0.593781,-2.06641,114),(0.651409,-2.12986,114),(0.590217,-2.06014,114),(0.65809,-2.13736,114),(0.584109,-2.05422,114),(0.660111,-2.1293,114),(0.672736,-2.12477,114),(0.624284,-2.08125,114),(0.592733,-2.03334,114),(0.593911,-2.05618,114),(0.637801,-2.0837,114),(0.671,-2.12622,114),(0.592365,-2.0618,114),(0.595846,-2.05909,114),(0.658027,-2.12818,114),(0.591633,-2.0629,114),(0.588874,-2.04097,114),(0.593829,-2.06249,114),(0.653954,-2.13176,114),(0.572377,-2.04138,114),(0.572328,-2.01696,114),(0.661755,-2.13474,114),(0.675194,-2.11328,114),(0.59461,-2.05997,114),(0.592001,-2.06676,114),(0.67036,-2.11833,114),(0.576604,-2.04713,114),(0.578039,-2.04354,114),(0.674476,-2.1166,114),(0.667577,-2.13,114),(0.582528,-2.04642,114),(0.671882,-2.11898,114),(0.675058,-2.11492,114),(0.595022,-2.04963,114),(0.675072,-2.11798,114),(0.65552,-2.13403,114),(0.588336,-2.05868,114),(0.655341,-2.1291,114),(0.641369,-2.09042,114),(0.591148,-2.05819,114),(0.667669,-2.11708,114),(0.589466,-2.05847,114),(0.591463,-2.06488,114),(0.645873,-2.12177,114),(0.593616,-2.0505,114),(0.595899,-2.06394,114),(0.595788,-2.05714,114),(0.601019,-2.09139,114),(0.676546,-2.11471,114),(0.633918,-2.1161,114),(0.593291,-2.05894,114),(0.634034,-2.08821,114),(0.591953,-2.06564,114),(0.657445,-2.13071,114),(0.589005,-2.04155,114),(0.663524,-2.13434,114),(0.591008,-2.06646,114),(0.600854,-2.04729,114),(0.595652,-2.04568,114),(0.643197,-2.11886,114),(0.595128,-2.06519,114),(0.587483,-2.05948,114),(0.593092,-2.06342,114),(0.568697,-2.04401,114),(0.588535,-2.02834,114),(0.592743,-2.06565,114),(0.657673,-2.12525,114),(0.665498,-2.1166,114),(0.594256,-2.04659,114),(0.589786,-2.06499,114),(0.604567,-2.10239,114),(0.589345,-2.06279,114),(0.652495,-2.13129,114),(0.594324,-2.06374,114),(0.646789,-2.10923,114),(0.649727,-2.12886,114),(0.592195,-2.06318,114),(0.645097,-2.09545,114),(0.5914,-2.06666,114),(0.65969,-2.11562,114),(0.640264,-2.12585,114),(0.663563,-2.13164,114),(0.593179,-2.06272,114),(0.590503,-2.0472,114),(0.588671,-2.04459,114),(0.653693,-2.13248,114),(0.651046,-2.10282,114),(0.656218,-2.13606,114),(0.653247,-2.12767,114),(0.593281,-2.05105,114),(0.586431,-2.05376,114),(0.656926,-2.11179,114),(0.595996,-2.05947,114),(0.594765,-2.05407,114),(0.593577,-2.06133,114),(0.638795,-2.12746,114),(0.594503,-2.06163,114),(0.598396,-2.07488,114),(0.660344,-2.13157,114),(0.592321,-2.04606,114),(0.648049,-2.12327,114),(0.65251,-2.13077,114),(0.585626,-2.04577,114),(0.668411,-2.13429,114),(0.570341,-2.04377,114),(0.655016,-2.13,114),(0.586761,-2.05825,114),(0.611611,-2.1027,114),(0.59221,-2.05161,114),(0.596214,-2.06411,114),(0.675194,-2.11834,114),(0.596418,-2.0661,114),(0.591706,-2.06091,114),(0.6651,-2.13924,114),(0.659151,-2.10918,114),(0.659811,-2.13403,114),(0.66318,-2.12428,114),(0.579377,-2.04866,114),(0.61819,-2.07728,114),(0.594517,-2.0534,114),(0.589708,-2.05692,114),(0.675067,-2.11579,114),(0.608514,-2.102,114),(0.661081,-2.13244,114),(0.689646,-2.12156,114),(0.596859,-2.08003,114),(0.596743,-2.08116,114),(0.656485,-2.1378,114),(0.6391,-2.12785,114),(0.588564,-2.03112,114),(0.59045,-2.0341,114),(0.603525,-2.06152,114),(0.653484,-2.1318,114),(0.693936,-2.1227,114),(0.591483,-2.06228,114),(0.595991,-2.06201,114),(0.621802,-2.10646,114),(0.654003,-2.11411,114),(0.589616,-2.04603,114),(0.667282,-2.14041,114),(0.593116,-2.06118,114),(0.663301,-2.13452,114),(0.663713,-2.12729,114),(0.591182,-2.05723,114),(0.662317,-2.13036,114),(0.657333,-2.12711,114),(0.594377,-2.05517,114),(0.595991,-2.08035,114),(0.629457,-2.07723,114),(0.57531,-2.04266,114),(0.641859,-2.12354,114),(0.576687,-2.03973,114),(0.673506,-2.11713,114),(0.595269,-2.05239,114),(0.58887,-2.03179,114),(0.588952,-2.06624,114),(0.571548,-2.04091,114),(0.587144,-2.05256,114),(0.594382,-2.04522,114),(0.59078,-2.06627,114),(0.65424,-2.13343,114),(0.638727,-2.0848,114),(0.595269,-2.0485,114),(0.662104,-2.13537,114),(0.621729,-2.05374,114),(0.675286,-2.11968,114),(0.658618,-2.11072,114),(0.592598,-2.04895,114),(0.677026,-2.11596,114),(0.669153,-2.14154,114),(0.608494,-2.06234,114),(0.594818,-2.06076,114),(0.672857,-2.11821,114),(0.676352,-2.11688,114),(0.592995,-2.05784,114),(0.593344,-2.04911,114),(0.673375,-2.12048,114),(0.640147,-2.12329,114),(0.595303,-2.04709,114),(0.656776,-2.13648,114),(0.654623,-2.13385,114),(0.583411,-2.05272,114),(0.57099,-2.04478,114),(0.595274,-2.05612,114),(0.598333,-2.06715,114),(0.659297,-2.13662,114),(0.595089,-2.06134,114),(0.58964,-2.04131,114),(0.651695,-2.12747,114),(0.584715,-2.0536,114),(0.658424,-2.13203,114),(0.657658,-2.13147,114),(0.6158,-2.10591,114),(0.578461,-2.04493,114),(0.655598,-2.13498,114),(0.662565,-2.13533,114),(0.588802,-2.06459,114),(0.662763,-2.13857,114),(0.659384,-2.12892,114),(0.640676,-2.08665,114),(0.588971,-2.05718,114),(0.600757,-2.08913,114),(0.651952,-2.12852,114),(0.600248,-2.06896,114),(0.64532,-2.12984,114),(0.592491,-2.06098,114),(0.610045,-2.102,114),(0.593751,-2.06806,114),(0.599593,-2.07798,114),(0.670913,-2.14177,114),(0.573138,-2.04158,114),(0.650376,-2.1297,114),(0.588899,-2.06132,114),(0.638984,-2.12671,114),(0.638281,-2.08762,114),(0.619601,-2.08169,114),(0.596049,-2.06733,114),(0.598115,-2.07313,114),(0.635731,-2.11754,114),(0.594319,-2.0603,114),(0.592622,-2.06319,114),(0.679513,-2.09412,114),(0.595439,-2.06211,114),(0.657198,-2.13642,114),(0.593635,-2.05783,114),(0.592729,-2.06022,114),(0.682713,-2.123,114),(0.571504,-2.04202,114),(0.589965,-2.05937,114),(0.662487,-2.11692,114),(0.667383,-2.13,114),(0.588336,-2.04548,114),(0.652209,-2.12994,114),(0.584574,-2.04462,114),(0.595283,-2.0605,114),(0.596389,-2.07411,114),(0.590547,-2.06543,114),(0.658681,-2.11927,114),(0.686402,-2.09759,114),(0.631944,-2.083,114),(0.654405,-2.10917,114),(0.588976,-2.05645,114),(0.589301,-2.05589,114),(0.595778,-2.02553,114),(0.683299,-2.15038,114),(0.656171,-2.12964,114),(0.65617,-2.12964,114),(0.595836,-2.06566,114),(0.595114,-2.05335,114),(0.669449,-2.12909,114),(0.601154,-2.07013,114),(0.594202,-2.05851,114),(0.665042,-2.13378,114),(0.59667,-2.06732,114),(0.59827,-2.08206,114),(0.602769,-2.04712,114),(0.602148,-2.06152,114),(0.634082,-2.08204,114),(0.57945,-2.04627,114),(0.593766,-2.05714,114),(0.66159,-2.13044,114),(0.592855,-2.06342,114),(0.644205,-2.12506,114),(0.5903,-2.06459,114),(0.59461,-2.05842,114),(0.594983,-2.0658,114),(0.594314,-2.05894,114),(0.673356,-2.1211,114),(0.589209,-2.05961,114),(0.592389,-2.06476,114),(0.593049,-2.06006,114),(0.586412,-2.04692,114),(0.591963,-2.06394,114),(0.672774,-2.14355,114),(0.573012,-2.04087,114),(0.675068,-2.12534,114),(0.59635,-2.07006,114),(0.591468,-2.05623,114),(0.68313,-2.12262,114),(0.593999,-2.04279,114),(0.595405,-2.03213,114),(0.694689,-1.83412,89),(0.693409,-1.82966,89),(0.697874,-1.82946,89),(0.696745,-1.83411,89),(0.670922,-1.83683,89),(0.687175,-1.83008,89),(0.690884,-1.83087,89),(0.690787,-1.83045,89),(0.678211,-1.82734,89),(0.682283,-1.89279,89),(0.677779,-1.82948,89),(0.690937,-1.83381,89),(0.694786,-1.83144,89),(0.693579,-1.83233,89),(0.650576,-1.88286,89),(0.691984,-1.83238,89),(0.675132,-1.82737,89),(0.693865,-1.83645,89),(0.681793,-1.89457,89),(0.690345,-1.83206,89),(0.690754,-1.83464,89),(0.69802,-1.83416,89),(0.692978,-1.83402,89),(0.691383,-1.83289,89),(0.697744,-1.8349,89),(0.671573,-1.88279,89),(0.696134,-1.83237,89),(0.68973,-1.82843,89),(0.667666,-1.82577,89),(0.669334,-1.82776,89),(0.6953,-1.83262,89),(0.690927,-1.83177,89),(0.695829,-1.83211,89),(0.695281,-1.83324,89),(0.694049,-1.83394,89),(0.658911,-1.74563,83),(0.662731,-1.76056,83),(0.646524,-1.7614,83),(0.574205,-1.84936,89),(0.61234,-1.86141,89),(0.565847,-1.81914,89),(0.600477,-1.80127,89),(0.641026,-1.88877,89),(0.620082,-1.89792,89),(0.570768,-1.80006,89),(0.563956,-1.86363,89),(0.614938,-1.86165,89),(0.58284,-1.82427,89),(0.622855,-1.84896,89),(0.611041,-1.86188,89),(0.627945,-2.0042,114),(0.683537,-2.09034,114),(0.628759,-2.01135,114),(0.691289,-2.08134,114),(0.629011,-2.00681,114),(0.631372,-2.00952,114),(0.642378,-1.99085,114),(0.631789,-2.00918,114),(0.631954,-2.0243,114),(0.630015,-2.00969,114),(0.689922,-2.09115,114),(0.692007,-2.08929,114),(0.690014,-2.09008,114),(0.630204,-2.0114,114),(0.691086,-2.09049,114),(0.632003,-2.0084,114),(0.629554,-2.0086,114),(0.630587,-2.0092,114),(0.61474,-1.77729,83),(0.562876,-1.77114,83),(0.512476,-1.76098,83),(0.501069,-1.75405,83),(0.554294,-1.85855,89),(0.607637,-1.78718,83),(0.55314,-1.85367,89),(0.586044,-1.77771,83),(0.558459,-1.7816,83),(0.555812,-1.78665,83),(0.620223,-1.76208,83),(0.596637,-1.77512,83),(0.549146,-1.75296,83),(0.552476,-1.85534,89),(0.552156,-1.85512,89),(0.555754,-1.78894,83),(0.657596,-1.9733,89),(0.64759,-1.98242,89),(0.64805,-1.98109,89),(0.621235,-2.08289,114),(0.591095,-1.95733,137),(0.583203,-1.94691,137),(0.583561,-1.96087,137),(1.01756,-2.34607,110),(0.713255,-2.16565,114),(0.712833,-2.16532,114),(0.71213,-2.16706,114),(0.714652,-2.16596,114),(0.708369,-2.13614,114),(0.705397,-2.10579,114),(0.698393,-1.83732,89),(0.699009,-1.83347,89),(0.704701,-1.82722,89),(0.708346,-1.83407,89),(0.70552,-1.82752,89),(0.70105,-1.83437,89),(0.705074,-1.8339,89),(0.706465,-1.83087,89),(0.761199,-2.02813,77),(0.762062,-2.03658,77),(0.832133,-2.0382,114),(0.762629,-2.03076,77),(0.758635,-1.95536,77),(0.759076,-2.03191,77),(0.810122,-2.04234,114),(0.809491,-2.04161,114),(0.761175,-2.03141,77),(0.815634,-2.04204,114),(0.759929,-2.03442,77),(0.748245,-1.96254,77),(0.832835,-2.04119,114),(0.764908,-1.9511,77),(0.742864,-1.99772,77),(0.799069,-1.89369,89),(0.79726,-1.93799,89),(0.802918,-1.9641,89),(0.829036,-1.94257,89),(0.813196,-1.9554,89),(0.841175,-1.99514,89),(0.818073,-1.98957,89),(0.81696,-1.75901,83),(0.818196,-1.79402,89),(0.817279,-1.76086,133),(0.841816,-1.76795,83),(0.717747,-1.75869,83),(0.730711,-1.80933,89),(0.71266,-2.02045,114),(0.779054,-2.1486,114),(0.794025,-2.14443,114),(0.736648,-2.12472,114),(0.736434,-2.14168,114),(0.793899,-2.14333,114),(0.76896,-2.11735,114),(0.795135,-2.14444,114),(0.789987,-2.14139,114),(0.7396,-2.1453,114),(0.756888,-2.16801,114),(0.777798,-2.15133,114),(0.768854,-2.14827,114),(0.794471,-2.14869,114),(0.78414,-2.14647,114),(0.7407,-2.15249,114),(0.794093,-2.13683,114),(0.785153,-2.14646,114),(0.800066,-2.08199,114),(0.794524,-2.14658,114),(0.785226,-2.14721,114),(0.736963,-2.12549,114),(0.79274,-2.14101,114),(0.777309,-2.14513,114),(0.793773,-2.1392,114),(0.789065,-2.15022,114),(0.738737,-2.14458,114),(0.793186,-2.14046,114),(0.790636,-2.14629,114),(0.792673,-2.14047,114),(0.791635,-2.13989,114),(0.797128,-2.07325,114),(0.794534,-2.1411,114),(0.772703,-2.11488,114),(0.75427,-2.15272,114),(0.784402,-2.14737,114),(0.79162,-2.14396,114),(0.768752,-2.14714,114),(0.792925,-2.14277,114),(0.794811,-2.13606,114),(0.7921,-2.14264,114),(0.79178,-2.13999,114),(0.790631,-2.14281,114),(0.787907,-2.14423,114),(0.769351,-1.80172,89),(0.713654,-1.95269,89),(0.72449,-1.95504,89),(0.714154,-1.95254,89),(0.717518,-1.95522,89),(0.718023,-1.95565,89),(0.708947,-1.95146,89),(0.707289,-1.95239,89),(0.703614,-1.95489,89),(0.710348,-1.95146,89),(0.715245,-1.9528,89),(0.707105,-1.95534,89),(0.705985,-1.95076,89),(0.709805,-1.95171,89),(0.7162,-1.9537,89),(0.70965,-1.9547,89),(0.716636,-1.95426,89),(0.704967,-1.95216,89),(0.728422,-1.95188,89),(0.710508,-1.95654,89),(0.708797,-1.95302,89),(0.71012,-1.9526,89),(0.709771,-1.95281,89),(0.720946,-1.95407,89),(0.712942,-1.95314,89),(0.719477,-1.95431,89),(0.703314,-1.94944,89),(0.698907,-1.95009,89),(0.704487,-1.95021,89),(0.702213,-1.94881,89),(0.70724,-1.95371,89),(0.718406,-1.95523,89),(0.71141,-1.95287,89),(0.708116,-1.95234,89),(0.708273,-1.95216,89),(0.704225,-1.9531,89),(0.707973,-1.95389,89),(0.707943,-1.95354,89),(0.718934,-1.95427,89),(0.710678,-1.95282,89),(0.700138,-1.94875,89),(0.701016,-1.94798,89),(0.717145,-1.9559,89),(0.709786,-1.9537,89),(0.707396,-1.95997,89),(0.708772,-1.95371,89),(0.710203,-1.95479,89),(0.819875,-2.16099,114),(0.846705,-2.13999,114),(0.841226,-2.13149,114),(0.825669,-2.13329,114),(0.799028,-2.13861,114),(0.830958,-2.1328,114),(0.851015,-2.13782,114),(0.823395,-2.13256,114),(0.83361,-2.13289,114),(0.830206,-2.14034,114),(0.828514,-2.13535,114),(0.795644,-2.13628,114),(0.815352,-2.14596,114),(0.833295,-2.13065,114),(0.826556,-2.13143,114),(0.827317,-2.13496,114),(0.834453,-2.13589,114),(0.820244,-2.10396,114),(0.837391,-2.13283,114),(0.828131,-2.13205,114),(0.82593,-2.13476,114),(0.797346,-2.13934,114),(0.821984,-2.13556,114),(0.821228,-2.13444,114),(0.797118,-2.14087,114),(0.829557,-2.12987,114),(0.833522,-2.13356,114),(0.806538,-2.07934,114),(0.826953,-2.1334,114),(0.832199,-2.13294,114),(0.820903,-2.14367,114),(0.838022,-2.13041,114),(0.823303,-2.13835,114),(0.805263,-2.14568,114),(0.834633,-2.1348,114),(0.827159,-2.13011,114),(0.835156,-2.13348,114),(0.838661,-2.13239,114),(0.830264,-2.13318,114),(0.835316,-2.13287,114),(0.835234,-2.12879,114),(0.822576,-2.0818,114),(0.84511,-2.13513,114),(0.834061,-2.13469,114),(0.83679,-2.13462,114);
/*&*/
INSERT INTO `x2_timezone_points` VALUES (0.834608,-2.13238,114),(0.842875,-2.14053,114),(0.820966,-2.14502,114),(0.831649,-2.04622,114),(0.797031,-2.13909,114),(0.823017,-2.13688,114),(0.807033,-2.0787,114),(0.83982,-2.15427,114),(0.815615,-2.04517,114),(0.82354,-2.13441,114),(0.832068,-2.13142,114),(0.828733,-2.13309,114),(0.807838,-2.08191,114),(0.797802,-2.14063,114),(0.831506,-2.1307,114),(0.828132,-2.1344,114),(0.830885,-2.1351,114),(0.833493,-2.13526,114),(0.831554,-2.14143,114),(0.822769,-2.13402,114),(0.82212,-2.13689,114),(0.831818,-2.04952,114),(0.832055,-2.04621,114),(0.808502,-2.09455,114),(0.824718,-2.13706,114),(0.828577,-2.13386,114),(0.820432,-2.14517,114),(0.824418,-2.13891,114),(0.796546,-2.14085,114),(0.803979,-2.06548,114),(0.827696,-2.09981,114),(0.830386,-2.13107,114),(0.837643,-2.13108,114),(0.831234,-2.1384,114),(0.81336,-2.10322,114),(0.748164,-1.85551,89),(0.718028,-1.82946,89),(0.773025,-1.84136,89),(0.721019,-1.84291,89),(0.725838,-1.90595,89),(0.781858,-1.86674,89),(0.70471,-1.9512,89),(0.364682,-2.73092,332),(0.373539,-2.75307,332),(0.373816,-2.75419,332),(0.362767,-2.73084,332),(0.372574,-2.75912,332),(0.374373,-2.75764,332),(0.373452,-2.75715,332),(0.375294,-2.75803,332),(0.364619,-2.73152,332),(0.373268,-2.75778,332),(0.372526,-2.75816,332),(0.344349,-2.70683,332),(0.371876,-2.75515,332),(1.13163,-2.57814,53),(1.06846,-2.61625,53),(1.13097,-2.57494,53),(0.595719,-1.47132,132),(0.593917,-1.46954,132),(0.446426,-1.40216,132),(0.498538,-1.41741,132),(0.613291,-1.37892,132),(0.83542,-2.13201,114),(0.671332,-2.1179,114),(0.488544,-1.43907,132),(0.723437,-1.27093,132),(0.690353,-1.33296,132),(0.689493,-1.33203,132),(0.714374,-1.27587,132),(0.75023,-1.37668,132),(0.658089,-1.60845,83),(0.742968,-1.45532,90),(0.48839,-1.43778,132),(0.494502,-1.42502,132),(0.490533,-1.44035,132),(0.588642,-1.47083,132),(0.4899,-1.43878,132),(0.481997,-1.40347,132),(0.448663,-1.40392,132),(0.487363,-1.43779,132),(0.673741,-2.11846,114),(0.828932,-2.13351,114),(0.571839,-2.04149,114),(0.592849,-2.06375,114),(0.543406,-1.70651,83),(0.83288,-2.13335,114),(0.597464,-2.0636,114),(0.82747,-2.13233,114),(0.676268,-1.82761,89),(0.832153,-2.1298,114),(0.592993,-2.06069,114),(0.630111,-2.01378,114),(0.372669,-2.75913,332),(0.375134,-2.75869,332),(0.579294,-1.94653,137),(0.782622,-1.62836,83),(0.616743,-1.8604,89),(0.596856,-2.07073,114),(0.679383,-1.35091,132),(0.708617,-1.30286,132),(0.708747,-1.30059,132),(0.69514,-1.50765,107),(-0.570432,-1.00589,128),(-0.585364,-0.992894,128),(-0.580031,-0.949168,128),(-0.553851,-0.977093,128),(-0.601324,-0.984201,128),(-0.599302,-0.989839,128),(-0.607375,-0.958477,128),(-0.547742,-1.01171,128),(-0.601848,-0.948295,128),(-0.5394,-0.969544,128),(-0.605018,-0.981214,128),(-0.564115,-1.01361,128),(-0.608427,-0.978296,128),(-0.60592,-0.976512,128),(-0.607959,-0.980305,128),(-0.599972,-0.96408,128),(-0.580364,-1.01282,128),(-0.564905,-0.945678,128),(-0.60912,-0.959058,128),(-0.60609,-0.981224,128),(-0.606706,-0.981287,128),(-0.578271,-1.01745,128),(-0.59508,-0.981122,128),(-0.583168,-0.986121,128),(-0.585456,-1.01573,128),(-0.606735,-0.984109,128),(-0.601557,-1.00967,128),(-0.593223,-1.01727,128),(-0.602536,-0.982233,128),(-0.53058,-0.985529,128),(0.740946,1.0404,225),(0.740027,1.03777,225),(0.751691,1.02806,225),(0.697443,1.19373,225),(0.687698,1.17361,225),(0.649684,1.17423,225),(0.663215,1.18312,225),(0.681687,1.16648,225),(0.692096,1.16867,225),(0.678351,1.14843,225),(0.685134,1.13713,225),(0.682149,1.16646,225),(0.696367,1.15639,225),(0.681333,1.14467,225),(0.689987,1.1141,225),(0.693293,1.12664,225),(0.674061,1.15625,225),(0.69565,1.12484,225),(0.693177,1.16351,225),(0.667879,1.18508,225),(0.681265,1.1619,225),(0.69674,1.16695,225),(0.694025,1.17411,225),(0.6942,1.12449,225),(0.677561,1.14586,225),(0.666822,1.17284,225),(0.69676,1.15061,225),(0.715294,1.20253,230),(0.704691,1.23596,230),(0.71754,1.2051,230),(0.702931,1.20118,230),(0.698575,1.15124,225),(0.718853,1.25198,230),(0.717665,1.22337,230),(0.69866,1.126,225),(0.716994,1.2553,230),(0.725184,1.05825,225),(0.700347,1.19545,230),(0.71757,1.25802,230),(0.716145,1.2106,230),(0.715582,1.24811,230),(0.706461,1.25258,230),(0.720204,1.20805,230),(0.714248,1.24917,230),(0.712855,1.19837,230),(0.727031,1.05248,225),(0.700226,1.12576,225),(0.722081,1.21094,230),(0.724922,1.05323,225),(0.707358,1.23818,230),(0.713791,1.2104,230),(0.698267,1.15605,225),(0.720724,1.21608,230),(0.713379,1.24108,230),(0.703634,1.18603,225),(0.712875,1.21472,230),(0.713951,1.21542,230),(0.70793,1.14648,225),(0.725184,1.06494,225),(0.699605,1.14108,225),(0.715555,1.25092,230),(0.706354,1.25183,230),(0.735055,1.04824,225),(0.709329,1.2608,230),(0.703406,1.25619,177),(0.710906,1.26993,230),(0.705738,1.25257,230),(0.722387,1.21239,230),(0.709805,1.26641,230),(0.722188,1.05355,225),(0.714131,1.25867,230),(0.720055,1.2488,230),(0.700153,1.18407,225),(0.725252,1.21651,230),(0.72116,1.06595,225),(0.730328,1.05404,225),(0.706679,1.20051,230),(0.699877,1.12894,225),(0.725325,1.21773,230),(0.709685,1.18983,230),(0.704837,1.25287,230),(0.70729,1.18745,230),(0.715748,1.24318,230),(0.723769,1.21444,230),(0.714475,1.20026,230),(0.716747,1.25411,230),(0.712283,1.20774,230),(0.705738,1.23238,230),(0.727647,1.06033,225),(0.719245,1.21011,230),(0.701986,1.20898,230),(0.715876,1.22424,230),(0.711781,1.26265,230),(0.704972,1.24746,230),(0.707243,1.25791,230),(0.731334,0.217351,307),(0.229663,-1.06857,155),(0.229656,-1.06875,155),(0.192568,-1.11462,80),(0.16474,-1.12526,80),(0.149978,-1.22568,80),(0.163193,-1.14013,80),(0.175929,-1.20648,80),(0.175207,-1.17791,80),(0.162888,-1.20639,80),(0.160842,-1.15205,80),(0.162626,-1.23227,80),(0.177361,-1.18696,80),(0.139777,-1.08907,80),(0.17844,-1.17762,80),(0.158166,-1.08299,80),(0.163552,-1.22932,80),(0.173112,-1.19214,80),(0.136464,-1.26055,80),(0.178619,-1.16349,80),(0.183895,-1.2481,80),(0.178251,-1.17676,80),(0.172989,-1.17555,80),(0.140172,-1.26118,80),(0.155112,-1.11989,80),(0.179123,-1.18309,80),(0.180465,-1.19978,80),(0.135559,-1.26056,80),(0.15708,-1.25513,80),(0.16862,-1.19699,80),(0.136389,-1.26437,80),(0.181314,-1.16853,80),(0.134413,-1.26285,80),(0.180219,-1.26211,80),(0.173288,-1.2151,80),(0.204127,-1.22521,80),(0.203472,-1.22548,80),(0.178315,-1.12777,80),(0.182789,-1.18704,80),(0.0988535,-1.18025,80),(0.191252,-1.11438,80),(0.182775,-1.16591,80),(0.177568,-1.17883,80),(0.176566,-1.16546,80),(0.177243,-1.19671,80),(0.146899,-1.24151,80),(0.183066,-1.19032,80),(0.150015,-1.24169,80),(0.179707,-1.1819,80),(0.178843,-1.17977,80),(0.185558,-1.25036,80),(0.184939,-1.16858,80),(0.175658,-1.26615,80),(0.174985,-1.20849,80),(0.183153,-1.16638,80),(0.178345,-1.17513,80),(0.178938,-1.17259,80),(0.176803,-1.24371,80),(0.184988,-1.16823,80),(0.193412,-1.11641,80),(0.184622,-1.0873,80),(0.176021,-1.18297,80),(0.182844,-1.16139,80),(0.18269,-1.16251,80),(0.15781,-1.21723,80),(0.178479,-1.18468,80),(0.150337,-1.25058,80),(0.170821,-1.21813,80),(0.155116,-1.12129,80),(0.179872,-1.1804,80),(0.182037,-1.16616,80),(0.149167,-1.24339,80),(0.182623,-1.12011,80),(0.177307,-1.16738,80),(0.199046,-1.21603,80),(0.145756,-1.09329,80),(0.141882,-1.109,80),(0.17733,-1.20244,80),(0.178765,-1.16688,80),(0.183189,-1.16681,80),(0.176038,-1.18542,80),(0.183027,-1.1648,80),(0.185072,-1.1699,80),(0.186188,-1.10407,80),(0.180639,-1.16913,80),(0.177597,-1.22317,80),(0.18305,-1.16726,80),(0.1852,-1.16679,80),(0.162415,-1.12327,80),(0.155756,-1.17686,80),(0.177785,-1.17739,80),(0.18131,-1.24686,80),(0.182107,-1.16722,80),(0.175823,-1.20991,80),(0.15293,-1.22891,80),(0.17686,-1.12923,80),(0.166855,-1.20803,80),(0.17209,-1.15857,80),(0.166758,-1.20769,80),(0.17017,-1.10264,80),(0.143471,-1.26089,80),(0.182726,-1.16641,80),(0.180778,-1.16592,80),(0.183055,-1.16564,80),(0.126404,-1.23451,80),(0.137668,-1.17761,80),(0.321432,-1.12777,160),(0.320127,-1.13325,154),(0.325795,1.84423,192),(0.378736,1.83027,192),(0.180572,1.86897,192),(0.37193,1.84301,192),(0.178896,1.84947,192),(0.325795,1.84423,192),(0.371869,1.83991,192),(0.367101,1.86372,192),(0.228347,1.90764,192),(0.380889,1.8364,192),(0.173394,1.85608,192),(0.191754,1.86148,192),(0.187623,1.86168,192),(0.345575,1.84598,192),(0.376865,1.84733,192),(0.35692,1.85587,192),(0.197222,1.85179,192),(0.183841,1.85732,192),(0.27169,1.89339,192),(0.368924,1.84141,192),(0.372046,1.8134,192),(0.234747,1.90619,192),(0.16761,1.8497,192),(0.389911,1.81242,192),(0.179769,1.84598,192),(0.174824,1.83405,192),(0.240274,1.90648,192),(0.263836,1.89892,192),(0.244055,1.88496,192),(0.35851,1.84855,192),(0.196931,1.85238,192),(0.190823,1.8867,192),(0.201876,1.90212,192),(0.353497,1.84961,192),(0.213803,1.90561,192),(0.356338,1.85296,192),(0.180817,1.85633,192),(0.181293,1.84035,192),(0.392408,1.81427,192),(0.381063,1.86285,192),(0.186169,1.88117,192),(0.250455,1.88496,192),(0.36041,1.85121,192),(0.287398,1.87797,192),(0.365666,1.8689,192),(0.277149,1.8908,192),(0.363261,1.8385,192),(0.319977,1.8483,192),(0.181223,1.82358,192),(0.366947,1.84728,192),(0.364008,1.86196,192),(0.365356,1.85558,192),(0.398517,1.8323,192),(0.366039,1.84616,192),(0.201295,1.86605,192),(0.305142,1.86052,192),(0.293499,1.86925,192),(0.37321,1.79798,192),(0.280436,1.88881,192),(0.208505,1.89267,192),(0.191405,1.85819,192),(0.18675,1.83463,192),(0.182387,1.84365,192),(0.395608,1.85441,192),(0.175115,1.84627,192),(0.181805,1.86692,192),(0.185296,1.86168,192),(0.208068,1.90519,192),(0.36681,1.87274,192),(0.160168,1.83521,192),(0.221075,1.88583,192),(0.350428,1.84761,192),(0.191114,1.8643,192),(0.178605,1.85674,192),(0.369767,1.85138,192),(0.162213,1.8453,192),(0.371173,1.85354,192),(0.386299,1.84714,192),(-0.309513,2.93777,327),(-0.231808,-3.07483,347),(-0.241437,-2.99789,325),(0.747403,0.365952,263),(0.739506,0.369229,263),(0.739297,0.363465,263),(0.740597,0.367212,263),(0.736771,0.361976,263),(0.744779,0.369432,263),(0.748931,0.369889,263),(0.744542,0.354097,263),(0.74001,0.360493,263),(0.74273,0.362388,263),(0.752305,0.363077,263),(0.748455,0.364192,263),(0.744626,0.368197,263),(0.746666,0.357574,263),(0.741075,0.37472,263),(0.733501,0.360469,263),(0.742466,0.354091,263),(0.247751,0.755993,166),(0.249548,0.774541,166),(0.237007,0.76831,166),(0.264797,0.773607,166),(0.26799,0.771552,166),(0.267312,0.773331,166),(0.227882,0.783338,166),(0.243764,0.771145,166),(0.273916,0.761065,166),(0.241457,0.769947,166),(0.253358,0.756154,166),(0.262818,0.755467,166),(0.253814,0.85738,166),(0.258271,0.749698,166),(0.244088,0.795394,166),(0.223043,0.786038,166),(-0.223043,0.789364,323),(-0.222243,0.788962,323),(-0.456622,0.486467,25),(-0.445704,0.455097,25),(-0.474684,0.453491,25),(-0.442123,0.541256,25),(-0.45154,0.510216,25),(-0.459354,0.482559,25),(-0.48616,0.460171,25),(-0.488456,0.466118,25),(-0.490681,0.433671,25),(-0.434296,0.493637,25),(-0.48467,0.537416,25),(-0.470481,0.431592,25),(-0.477617,0.521535,25),(-0.490506,0.468899,25),(-0.474876,0.470341,25),(-0.465534,0.487403,25),(-0.466207,0.485864,25),(-0.496507,0.370989,25),(-0.551331,0.502383,25),(-0.527207,0.537522,25),(-0.494543,0.548316,25),(-0.589181,0.443263,25),(-0.415968,0.526453,25),(-0.400477,0.532063,25),(-0.495865,0.466022,25),(-0.509799,0.468429,25),(-0.453722,0.492651,25),(-0.568467,0.478638,25),(-0.468532,0.467195,25),(-0.511873,0.546106,25),(-0.470081,0.510361,25),(-0.458149,0.495674,25),(-0.45846,0.486222,25),(-0.571102,0.446596,25),(-0.438308,0.506923,25),(-0.494272,0.482074,25),(-0.463385,0.509054,25),(-0.528602,0.536744,25),(-0.474533,0.44208,25),(-0.467985,0.485497,25),(-0.447983,0.475464,25),(-0.521364,0.528352,25),(-0.502358,0.559163,25),(-0.485226,0.496149,25),(-0.457004,0.483492,25),(-0.556717,0.469063,25),(-0.556254,0.470866,25),(-0.449333,0.49197,25),(-0.422271,0.506315,25),(-0.466294,0.472984,25),(-0.536538,0.53154,25),(-0.591981,0.446282,25),(-0.586266,0.469337,25),(-0.594332,0.407911,25),(-0.471362,0.537792,25),(-0.417212,0.514328,25),(-0.51691,0.530454,25),(-0.497842,0.502931,25),(-0.417884,0.543514,25),(-0.469551,0.47922,25),(-0.484909,0.430881,25),(-0.586268,0.387488,25),(-0.470894,0.465527,25),(-0.431096,0.495674,25),(-0.416921,0.528609,25),(-0.461315,0.49702,25),(-0.484468,0.522408,25),(-0.444614,0.540534,25),(-0.520334,0.534707,25),(-0.516063,0.526848,25),(-0.488395,0.536125,25),(-0.451168,0.447386,25),(-0.549654,0.436443,25),(-0.44986,0.514258,25),(-0.390104,0.52429,25),(-0.538671,0.530066,25),(-0.445018,0.490449,25),(-0.438039,0.531622,25),(-0.402191,0.521909,25),(-0.456439,0.456573,25),(-0.42237,0.514872,25),(-0.553324,0.475304,25),(-0.50954,0.479222,25),(-0.485783,0.466876,25),(-0.59347,0.431645,25),(-0.455283,0.484768,25),(-0.48259,0.475338,25),(-0.458566,0.510078,25),(-0.443893,0.557716,25),(-0.53315,0.513548,25),(-0.594045,0.402248,25),(-0.468658,0.465422,25),(-0.501473,0.432184,25),(-0.457316,0.489454,25),(-0.514487,0.527623,25),(-0.488283,0.471662,25),(-0.456557,0.518629,25),(-0.476146,0.488184,25),(-0.462595,0.494962,25),(-0.493453,0.508405,25),(-0.581268,0.463084,25),(-0.562906,0.428142,25),(-0.406705,0.536142,25),(-0.592766,0.392031,25),(-0.4471,0.4886,25),(-0.572028,0.464847,25),(-0.462314,0.479859,25),(-0.503893,0.556753,25),(-0.463094,0.523308,25),(-0.501991,0.556643,25),(-0.463094,0.507309,25),(-0.41303,0.484229,25),(-0.576226,0.48715,25),(-0.521119,0.541562,25),(-0.491603,0.527678,25),(-0.413528,0.526043,25),(-0.471548,0.531449,25),(-0.456344,0.500617,25),(-0.534938,0.419094,25),(-0.448041,0.497831,25),(-0.561372,0.447139,25),(-0.487192,0.439144,25),(-0.460085,0.47818,25),(-0.564279,0.491307,25),(-0.450472,0.501651,25),(-0.44741,0.484856,25),(-0.457914,0.495139,25),(-0.510861,0.466094,25),(-0.478023,0.464554,25),(-0.457485,0.493223,25),(-0.482529,0.446926,25),(-0.508258,0.457521,25),(-0.573292,0.478956,25),(-0.49272,0.494052,25),(-0.461778,0.514271,25),(-0.457075,0.494291,25),(-0.564731,0.394147,25),(-0.450093,0.54198,25),(-0.515552,0.544794,25),(-0.465363,0.498992,25),(-0.484404,0.465022,25),(-0.535705,0.466202,25),(-0.448483,0.501768,25),(-0.453603,0.490934,25),(-0.451323,0.491934,25),(-0.587242,0.339441,25),(-0.592271,0.329287,25),(-0.576162,0.313185,25),(-0.588258,0.331011,25),(-0.584001,0.32685,25),(-0.60072,0.335705,25),(-0.596056,0.331876,25),(-0.582397,0.33704,25),(-0.592118,0.321546,25),(-0.585849,0.322595,25),(-0.163102,0.501502,36),(-0.154291,0.547438,36),(-0.170894,0.507527,36),(-0.288646,0.501062,36),(-0.305013,0.42406,36),(-0.198355,0.515859,36),(-0.248581,0.54673,36),(-0.226171,0.499803,36),(-0.261501,0.472319,36),(-0.219036,0.492893,36),(-0.206548,0.548956,36),(-0.284198,0.479675,36),(-0.266134,0.403649,36),(-0.27674,0.484294,36),(-0.195473,0.504301,36),(-0.268897,0.493704,36),(-0.229278,0.495963,36),(-0.311401,0.451242,36),(-0.223445,0.492414,36),(-0.178249,0.544208,36),(-0.243848,0.500383,36),(-0.2111,0.461243,36),(-0.224127,0.490347,36),(-0.275223,0.491858,36),(-0.252146,0.496484,36),(-0.293328,0.47042,36),(-0.237946,0.56985,36),(-0.218672,0.486664,36),(-0.215806,0.485601,36),(-0.354769,0.524759,24),(-0.312825,0.451045,24),(-0.343309,0.523702,24),(-0.323372,0.560747,24),(-0.332194,0.519817,24),(-0.312123,0.535816,24),(-0.331101,0.570214,24),(-0.350178,0.538044,24),(-0.317393,0.550685,24),(-0.330358,0.520367,24),(-0.293389,0.518231,24),(-0.28827,0.502655,24),(-0.319976,0.522121,24),(-0.320604,0.462546,24),(-0.311152,0.541984,24),(-0.339467,0.520399,24),(-0.317733,0.505009,24),(-0.367392,0.552688,24),(-0.352353,0.56939,24),(-0.303106,0.527089,24),(-0.316432,0.526055,24),(-0.351684,0.498873,24),(-0.301975,0.546821,24),(-0.387754,0.523599,24),(-0.312239,0.543626,24),(-0.314382,0.542371,24);
